<div>
    <x-admin.page-header :title="$isEdit ? __('Edit Server') : __('Add Server')" :subtitle="__('Configure server connection details')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.servers.all') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Servers')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <form wire:submit="save" class="space-y-6">
        <!-- Validation Errors -->
        @if ($errors->any())
            <div class="rounded-2xl border border-red-500/20 bg-red-500/10 p-4">
                <div class="flex items-center gap-2 text-sm font-medium text-red-400">
                    <i class="ph-duotone ph-warning-circle"></i>
                    @lang('Please fix the following errors:')
                </div>
                <ul class="mt-2 list-inside list-disc space-y-1 text-sm text-red-300">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- Server Details -->
        <div class="rounded-2xl border border-white/5 bg-[#12121a] p-6">
            <h3 class="mb-4 flex items-center gap-2 text-sm font-medium text-white">
                <i class="ph-duotone ph-hard-drives text-indigo-400"></i>
                @lang('Server Details')
            </h3>
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.select wire:model="server_group_id" :label="__('Server Group')" required>
                    <option value="">@lang('Select a group')</option>
                    @foreach($groups as $group)
                        <option value="{{ $group->id }}">{{ $group->name }} ({{ $group->getType }})</option>
                    @endforeach
                </x-admin.select>

                <x-admin.input wire:model="name" :label="__('Server Name')" :placeholder="__('e.g. US Server 1')" required />
            </div>
        </div>

        <!-- Connection Settings -->
        <div class="rounded-2xl border border-white/5 bg-[#12121a] p-6">
            <h3 class="mb-4 flex items-center gap-2 text-sm font-medium text-white">
                <i class="ph-duotone ph-plugs-connected text-cyan-400"></i>
                @lang('Connection Settings')
            </h3>
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-4">
                <x-admin.select wire:model="protocol" :label="__('Protocol')" required>
                    <option value="https://">HTTPS</option>
                    <option value="http://">HTTP</option>
                </x-admin.select>

                <div class="sm:col-span-2">
                    <x-admin.input wire:model="host" :label="__('Hostname')" placeholder="server.example.com" required />
                </div>

                <x-admin.input wire:model="port" :label="__('Port')" placeholder="2087" required />
            </div>

            <div class="mt-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="username" :label="__('Username')" placeholder="root" required />
                <x-admin.input wire:model="password" type="password" :label="__('Password')" placeholder="••••••••" required />
            </div>

            <div class="mt-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="api_token" :label="__('API Token')" :placeholder="__('Optional API token')" />
                <x-admin.input wire:model="security_token" :label="__('Security Token')" :placeholder="__('Optional security token')" />
            </div>

            <div class="mt-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="ip_address" :label="__('IP Address')" :placeholder="__('Auto-detected on test')" />
                <div class="flex items-end">
                    <x-admin.button type="button" wire:click="testConnection" variant="secondary" icon="ph-plugs-connected" :disabled="$testing">
                        @if($testing)
                            <span wire:loading wire:target="testConnection" class="mr-2">
                                <i class="ph-duotone ph-spinner animate-spin"></i>
                            </span>
                            @lang('Testing...')
                        @else
                            @lang('Test Connection')
                        @endif
                    </x-admin.button>
                </div>
            </div>

            @if($testResult)
                <div class="mt-4 rounded-xl bg-emerald-500/10 p-4 text-sm text-emerald-400 ring-1 ring-emerald-500/20">
                    <i class="ph-duotone ph-check-circle mr-2"></i>
                    {{ $testResult }}
                </div>
            @endif

            @if($testError)
                <div class="mt-4 rounded-xl bg-red-500/10 p-4 text-sm text-red-400 ring-1 ring-red-500/20">
                    <i class="ph-duotone ph-x-circle mr-2"></i>
                    {{ $testError }}
                </div>
            @endif
        </div>

        <!-- Nameservers -->
        <div class="rounded-2xl border border-white/5 bg-[#12121a] p-6">
            <h3 class="mb-4 flex items-center gap-2 text-sm font-medium text-white">
                <i class="ph-duotone ph-globe text-purple-400"></i>
                @lang('Nameservers')
            </h3>
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="ns1" :label="__('Nameserver 1')" placeholder="ns1.example.com" required />
                <x-admin.input wire:model="ns1_ip" :label="__('NS1 IP Address')" :placeholder="__('Optional')" />
            </div>
            <div class="mt-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="ns2" :label="__('Nameserver 2')" placeholder="ns2.example.com" required />
                <x-admin.input wire:model="ns2_ip" :label="__('NS2 IP Address')" :placeholder="__('Optional')" />
            </div>
            <div class="mt-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="ns3" :label="__('Nameserver 3')" :placeholder="__('ns3.example.com (optional)')" />
                <x-admin.input wire:model="ns3_ip" :label="__('NS3 IP Address')" :placeholder="__('Optional')" />
            </div>
            <div class="mt-4 grid grid-cols-1 gap-4 sm:grid-cols-2">
                <x-admin.input wire:model="ns4" :label="__('Nameserver 4')" :placeholder="__('ns4.example.com (optional)')" />
                <x-admin.input wire:model="ns4_ip" :label="__('NS4 IP Address')" :placeholder="__('Optional')" />
            </div>
        </div>

        <!-- Status -->
        <div class="rounded-2xl border border-white/5 bg-[#12121a] p-6">
            <h3 class="mb-4 flex items-center gap-2 text-sm font-medium text-white">
                <i class="ph-duotone ph-toggle-left text-amber-400"></i>
                @lang('Status')
            </h3>
            <x-admin.toggle wire:model="status" :label="__('Server Active')" :description="__('Enable this server for provisioning')" />
        </div>

        <!-- Actions -->
        <div class="flex justify-end gap-3">
            <x-admin.button href="{{ route('admin.servers.all') }}" variant="secondary">
                @lang('Cancel')
            </x-admin.button>
            <x-admin.button type="submit" icon="ph-floppy-disk">
                {{ $isEdit ? __('Update Server') : __('Create Server') }}
            </x-admin.button>
        </div>
    </form>
</div>

