<div>
    <x-admin.page-header :title="__('Server Groups')" :subtitle="__('Manage server groups for hosting services')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.servers.all') }}" variant="secondary" icon="ph-hard-drives">
                @lang('All Servers')
            </x-admin.button>
            <x-admin.button wire:click="openCreateModal" icon="ph-plus">
                @lang('Add Group')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Filters -->
    <div class="mb-6">
        <div class="relative">
            <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('Search server groups...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 py-3 pl-11 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/[0.07] focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            />
        </div>
    </div>

    <!-- Server Groups Table -->
    <div class="overflow-hidden rounded-2xl border border-white/5 bg-[#12121a]">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <x-admin.table-header>@lang('Group Name')</x-admin.table-header>
                        <x-admin.table-header>@lang('Type')</x-admin.table-header>
                        <x-admin.table-header>@lang('Servers')</x-admin.table-header>
                        <x-admin.table-header>@lang('Status')</x-admin.table-header>
                        <x-admin.table-header class="text-right">@lang('Actions')</x-admin.table-header>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($groups as $group)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="px-5 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                                        <i class="ph-duotone ph-stack text-lg text-indigo-400"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-white">{{ $group->name }}</p>
                                        <p class="text-xs text-slate-500">@lang('Created') {{ $group->created_at->diffForHumans() }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-5 py-4">
                                @php
                                    $typeColors = [
                                        1 => 'from-orange-500/20 to-amber-500/20 text-orange-400',
                                        2 => 'from-cyan-500/20 to-teal-500/20 text-cyan-400',
                                        3 => 'from-violet-500/20 to-purple-500/20 text-violet-400',
                                    ];
                                    $typeIcons = [
                                        1 => 'ph-terminal',
                                        2 => 'ph-command',
                                        3 => 'ph-gear-six',
                                    ];
                                @endphp
                                <span class="inline-flex items-center gap-1.5 rounded-lg bg-gradient-to-r {{ $typeColors[$group->type] ?? 'from-slate-500/20 to-slate-500/20 text-slate-400' }} px-2.5 py-1 text-xs font-medium">
                                    <i class="ph-duotone {{ $typeIcons[$group->type] ?? 'ph-gear' }} text-sm"></i>
                                    {{ $group->getType }}
                                </span>
                            </td>
                            <td class="px-5 py-4">
                                <div class="flex items-center gap-2">
                                    <span class="text-sm font-medium text-white">{{ $group->servers_count }}</span>
                                    <span class="text-xs text-slate-500">{{ $group->servers_count !== 1 ? __('servers') : __('server') }}</span>
                                </div>
                            </td>
                            <td class="px-5 py-4">
                                <button wire:click="toggleStatus({{ $group->id }})" class="group cursor-pointer">
                                    @if($group->status)
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400 ring-1 ring-emerald-500/20 transition-all group-hover:bg-emerald-500/20">
                                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                            @lang('Active')
                                        </span>
                                    @else
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-slate-500/10 px-2.5 py-1 text-xs font-medium text-slate-400 ring-1 ring-slate-500/20 transition-all group-hover:bg-slate-500/20">
                                            <span class="h-1.5 w-1.5 rounded-full bg-slate-400"></span>
                                            @lang('Inactive')
                                        </span>
                                    @endif
                                </button>
                            </td>
                            <td class="px-5 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="openEditModal({{ $group->id }})" icon="ph-pencil">
                                        @lang('Edit Group')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item wire:click="confirmDelete({{ $group->id }})" icon="ph-trash" variant="danger">
                                        @lang('Delete')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-5 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="mb-4 flex h-16 w-16 items-center justify-center rounded-2xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                                        <i class="ph-duotone ph-stack text-3xl text-indigo-400"></i>
                                    </div>
                                    <h3 class="mb-1 text-sm font-medium text-white">@lang('No server groups found')</h3>
                                    <p class="text-sm text-slate-500">@lang('Create a server group to get started.')</p>
                                    <x-admin.button wire:click="openCreateModal" class="mt-4" size="sm" icon="ph-plus">
                                        @lang('Add Server Group')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($groups->hasPages())
            <div class="border-t border-white/5 px-5 py-4">
                {{ $groups->links() }}
            </div>
        @endif
    </div>

    <!-- Group Form Modal -->
    <x-admin.modal name="group-form" :title="$editId ? __('Edit Server Group') : __('Add Server Group')" maxWidth="md">
        <form wire:submit="save" class="space-y-4">
            <x-admin.input
                wire:model="name"
                :label="__('Group Name')"
                :placeholder="__('Enter group name')"
                required
            />

            <x-admin.select wire:model="type" :label="__('Server Type')" required>
                @foreach($types as $value => $label)
                    <option value="{{ $value }}">{{ __($label) }}</option>
                @endforeach
            </x-admin.select>

            <x-admin.toggle wire:model="status" :label="__('Active')" />

            <div class="flex justify-end gap-3 border-t border-white/5 pt-4">
                <x-admin.button variant="secondary" x-on:click="$dispatch('close-modal', 'group-form')">
                    @lang('Cancel')
                </x-admin.button>
                <x-admin.button type="submit">
                    {{ $editId ? __('Update Group') : __('Create Group') }}
                </x-admin.button>
            </div>
        </form>
    </x-admin.modal>

    <!-- Delete Confirmation Modal -->
    <x-admin.modal name="confirm-delete" :title="__('Delete Server Group')">
        <p class="text-slate-400">@lang('Are you sure you want to delete this server group? This action cannot be undone.')</p>
        <div class="mt-6 flex justify-end gap-3">
            <x-admin.button variant="secondary" x-on:click="$dispatch('close-modal', 'confirm-delete')">
                @lang('Cancel')
            </x-admin.button>
            <x-admin.button variant="danger" wire:click="delete">
                @lang('Delete Group')
            </x-admin.button>
        </div>
    </x-admin.modal>
</div>

