<div>
    <x-admin.page-header :title="__('Servers')" :subtitle="__('Manage hosting provisioning servers')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.servers.groups') }}" variant="secondary" icon="ph-stack">
                @lang('Server Groups')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.servers.create') }}" icon="ph-plus">
                @lang('Add Server')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Filters -->
    <div class="mb-6 grid grid-cols-1 gap-4 sm:grid-cols-4">
        <div class="sm:col-span-2">
            <div class="relative">
                <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search servers...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-3 pl-11 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/[0.07] focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                />
            </div>
        </div>
        <div>
            <select
                wire:model.live="filterGroup"
                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/[0.07] focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            >
                <option value="">@lang('All Groups')</option>
                @foreach($groups as $group)
                    <option value="{{ $group->id }}">{{ $group->name }}</option>
                @endforeach
            </select>
        </div>
        <div>
            <select
                wire:model.live="filterStatus"
                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/[0.07] focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            >
                <option value="">@lang('All Status')</option>
                <option value="1">@lang('Active')</option>
                <option value="0">@lang('Inactive')</option>
            </select>
        </div>
    </div>

    <!-- Servers Table -->
    <div class="overflow-hidden rounded-2xl border border-white/5 bg-[#12121a]">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <x-admin.table-header>@lang('Server')</x-admin.table-header>
                        <x-admin.table-header>@lang('Group / Type')</x-admin.table-header>
                        <x-admin.table-header>@lang('IP Address')</x-admin.table-header>
                        <x-admin.table-header>@lang('Accounts')</x-admin.table-header>
                        <x-admin.table-header>@lang('Status')</x-admin.table-header>
                        <x-admin.table-header class="text-right">@lang('Actions')</x-admin.table-header>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($servers as $server)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="px-5 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-cyan-500/20 to-blue-500/20">
                                        <i class="ph-duotone ph-hard-drives text-lg text-cyan-400"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-white">{{ $server->name }}</p>
                                        <p class="text-xs text-slate-500">{{ $server->hostname }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-5 py-4">
                                @if($server->serverGroup)
                                    <div>
                                        <p class="text-sm font-medium text-white">{{ $server->serverGroup->name }}</p>
                                        <p class="text-xs text-slate-500">{{ $server->serverGroup->getType }}</p>
                                    </div>
                                @else
                                    <span class="text-slate-500">—</span>
                                @endif
                            </td>
                            <td class="px-5 py-4">
                                <div class="flex items-center gap-2">
                                    <code class="rounded bg-white/5 px-2 py-0.5 text-xs text-slate-300">{{ $server->ip_address ?: __('Not set') }}</code>
                                </div>
                            </td>
                            <td class="px-5 py-4">
                                <div class="flex items-center gap-2">
                                    <span class="text-sm font-medium text-white">{{ $server->hostings_count }}</span>
                                    <span class="text-xs text-slate-500">{{ $server->hostings_count !== 1 ? __('accounts') : __('account') }}</span>
                                </div>
                            </td>
                            <td class="px-5 py-4">
                                <button wire:click="toggleStatus({{ $server->id }})" class="group cursor-pointer">
                                    @if($server->status)
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400 ring-1 ring-emerald-500/20 transition-all group-hover:bg-emerald-500/20">
                                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                            @lang('Active')
                                        </span>
                                    @else
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-slate-500/10 px-2.5 py-1 text-xs font-medium text-slate-400 ring-1 ring-slate-500/20 transition-all group-hover:bg-slate-500/20">
                                            <span class="h-1.5 w-1.5 rounded-full bg-slate-400"></span>
                                            @lang('Inactive')
                                        </span>
                                    @endif
                                </button>
                            </td>
                            <td class="px-5 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="loginToServer({{ $server->id }})" icon="ph-sign-in">
                                        @lang('Login to Server')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item href="{{ route('admin.servers.edit', $server->id) }}" icon="ph-pencil">
                                        @lang('Edit Server')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    <x-admin.action-menu-item wire:click="confirmDelete({{ $server->id }})" icon="ph-trash" variant="danger">
                                        @lang('Delete')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-5 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="mb-4 flex h-16 w-16 items-center justify-center rounded-2xl bg-gradient-to-br from-cyan-500/20 to-blue-500/20">
                                        <i class="ph-duotone ph-hard-drives text-3xl text-cyan-400"></i>
                                    </div>
                                    <h3 class="mb-1 text-sm font-medium text-white">@lang('No servers found')</h3>
                                    <p class="text-sm text-slate-500">@lang('Add a server to get started with provisioning.')</p>
                                    <x-admin.button href="{{ route('admin.servers.create') }}" class="mt-4" size="sm" icon="ph-plus">
                                        @lang('Add Server')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($servers->hasPages())
            <div class="border-t border-white/5 px-5 py-4">
                {{ $servers->links() }}
            </div>
        @endif
    </div>

    <!-- Delete Confirmation Modal -->
    <x-admin.modal name="confirm-delete" :title="__('Delete Server')">
        <p class="text-slate-400">@lang('Are you sure you want to delete this server? This action cannot be undone.')</p>
        <div class="mt-6 flex justify-end gap-3">
            <x-admin.button variant="secondary" x-on:click="$dispatch('close-modal', 'confirm-delete')">
                @lang('Cancel')
            </x-admin.button>
            <x-admin.button variant="danger" wire:click="delete">
                @lang('Delete Server')
            </x-admin.button>
        </div>
    </x-admin.modal>

    <!-- Login Error Toast -->
    @if($loginError)
        <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-2"
             x-transition:enter-end="opacity-100 translate-y-0"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0"
             x-transition:leave-end="opacity-0 translate-y-2"
             class="fixed bottom-4 right-4 z-50 rounded-xl bg-red-500/10 p-4 text-sm text-red-400 ring-1 ring-red-500/20 shadow-lg">
            <div class="flex items-center gap-3">
                <i class="ph-duotone ph-x-circle text-lg"></i>
                <span>{{ $loginError }}</span>
                <button @click="show = false" class="ml-2 text-red-400/60 hover:text-red-400">
                    <i class="ph-bold ph-x"></i>
                </button>
            </div>
        </div>
    @endif

    @script
    <script>
        $wire.on('open-server-login', ({ url }) => {
            window.open(url, '_blank', 'noopener,noreferrer');
        });
    </script>
    @endscript
</div>

