<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Cancel Requests')" :subtitle="__('Manage service cancellation requests from clients.')" />

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            :title="__('Total Requests')"
            :value="$this->totalCount"
            icon="ph-duotone ph-x-circle"
            color="purple"
        />
        <x-admin.stat-card
            :title="__('Pending')"
            :value="$this->pendingCount"
            icon="ph-duotone ph-clock"
            color="amber"
        />
        <x-admin.stat-card
            :title="__('Approved')"
            :value="$this->approvedCount"
            icon="ph-duotone ph-check-circle"
            color="emerald"
        />
        <x-admin.stat-card
            :title="__('Rejected')"
            :value="$this->rejectedCount"
            icon="ph-duotone ph-prohibit"
            color="rose"
        />
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="relative flex-1">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search by username, product, or email...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />
            </div>
            <div class="flex items-center gap-3">
                <select
                    wire:model.live="status"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                >
                    @foreach($this->statusOptions as $value => $label)
                        <option value="{{ $value }}" class="bg-[#12121a]">{{ __($label) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Data Table --}}
    <x-admin.card class="mt-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 text-left">
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Product/Service')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Client')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Type')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Date')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Status')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($cancelRequests as $request)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="whitespace-nowrap px-4 py-4">
                                @if($request->hosting)
                                    <a href="{{ route('admin.order.hosting.details', $request->hosting_id) }}" class="text-sm font-medium text-white hover:text-purple-400 transition-colors">
                                        {{ $request->hosting->product?->serviceCategory?->name ?? __('N/A') }}
                                    </a>
                                    <p class="mt-0.5 text-xs text-slate-400">{{ $request->hosting->product?->name ?? __('N/A') }}</p>
                                @else
                                    <span class="text-sm text-slate-400">@lang('Deleted')</span>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-4">
                                @if($request->user)
                                    <a href="{{ route('admin.users.detail', $request->user->username) }}" class="text-sm font-medium text-white hover:text-purple-400 transition-colors">
                                        {{ $request->user->fullname }}
                                    </a>
                                    <p class="mt-0.5 text-xs text-slate-400">{{ '@' . $request->user->username }}</p>
                                @else
                                    <span class="text-sm text-slate-400">@lang('Deleted')</span>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-4">
                                @if($request->cancel_type === \App\Models\CancelRequest::TYPE_IMMEDIATE)
                                    <span class="inline-flex items-center gap-1.5 rounded-lg border border-rose-500/20 bg-rose-500/10 px-2.5 py-1 text-xs font-medium text-rose-400">
                                        <i class="ph-duotone ph-lightning"></i>
                                        @lang('Immediate')
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1.5 rounded-lg border border-blue-500/20 bg-blue-500/10 px-2.5 py-1 text-xs font-medium text-blue-400">
                                        <i class="ph-duotone ph-calendar"></i>
                                        @lang('End of Billing')
                                    </span>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-4">
                                <span class="text-sm text-white">{{ $request->created_at->format('M d, Y') }}</span>
                                <p class="mt-0.5 text-xs text-slate-400">{{ $request->created_at->format('h:i A') }}</p>
                            </td>
                            <td class="whitespace-nowrap px-4 py-4">
                                @php $badge = $this->statusBadge[$request->status] ?? ['class' => 'bg-slate-500/10 text-slate-400', 'text' => __('Unknown')]; @endphp
                                <span class="inline-flex items-center rounded-lg border px-2.5 py-1 text-xs font-medium {{ $badge['class'] }}">
                                    {{ __($badge['text']) }}
                                </span>
                            </td>
                            <td class="whitespace-nowrap px-4 py-4 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <button wire:click="viewReason({{ $request->id }})" class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/5 hover:text-white cursor-pointer" title="{{ __('View Reason') }}">
                                        <i class="ph-duotone ph-eye text-lg"></i>
                                    </button>
                                    @if($request->status === \App\Models\CancelRequest::STATUS_PENDING)
                                        <button wire:click="openApproveModal({{ $request->id }})" class="rounded-lg p-2 text-emerald-400 transition-colors hover:bg-emerald-500/10 cursor-pointer" title="{{ __('Approve') }}">
                                            <i class="ph-duotone ph-check-circle text-lg"></i>
                                        </button>
                                        <button wire:click="rejectRequest({{ $request->id }})" wire:confirm="{{ __('Are you sure you want to reject this cancellation request?') }}" class="rounded-lg p-2 text-amber-400 transition-colors hover:bg-amber-500/10 cursor-pointer" title="{{ __('Reject') }}">
                                            <i class="ph-duotone ph-prohibit text-lg"></i>
                                        </button>
                                    @endif
                                    <button wire:click="openDeleteModal({{ $request->id }})" class="rounded-lg p-2 text-rose-400 transition-colors hover:bg-rose-500/10 cursor-pointer" title="{{ __('Delete') }}">
                                        <i class="ph-duotone ph-trash text-lg"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-4 py-12 text-center">
                                <i class="ph-duotone ph-x-circle text-5xl text-slate-600"></i>
                                <p class="mt-4 text-sm font-medium text-white">@lang('No cancellation requests found')</p>
                                <p class="mt-1 text-xs text-slate-400">@lang('Cancellation requests from clients will appear here.')</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($cancelRequests->hasPages())
            <div class="border-t border-white/5 px-4 py-4">
                {{ $cancelRequests->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Reason Modal --}}
    <x-admin.modal wire:model="showReasonModal" :title="__('Cancellation Reason')" maxWidth="lg">
        <div class="p-6">
            <div class="rounded-xl border border-white/10 bg-white/5 p-4">
                <p class="text-sm text-slate-300 whitespace-pre-wrap">{{ $viewReason }}</p>
            </div>
        </div>
        <div class="flex justify-end gap-3 border-t border-white/10 p-4">
            <button wire:click="$set('showReasonModal', false)" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                @lang('Close')
            </button>
        </div>
    </x-admin.modal>

    {{-- Approve Modal --}}
    <x-admin.modal wire:model="showApproveModal" :title="__('Approve Cancellation')" maxWidth="md">
        <div class="p-6">
            <div class="flex items-start gap-4">
                <div class="flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-xl bg-amber-500/10">
                    <i class="ph-duotone ph-warning text-2xl text-amber-400"></i>
                </div>
                <div>
                    <p class="text-sm text-slate-300">
                        @lang('Are you sure you want to approve this cancellation request? This will cancel the associated service.')
                    </p>
                    <p class="mt-2 text-xs text-slate-400">
                        @lang('This action cannot be undone. The client\'s service will be marked as cancelled.')
                    </p>
                </div>
            </div>
        </div>
        <div class="flex justify-end gap-3 border-t border-white/10 p-4">
            <button wire:click="$set('showApproveModal', false)" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                @lang('Cancel')
            </button>
            <button wire:click="approveRequest" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 cursor-pointer">
                <i class="ph-duotone ph-check-circle"></i>
                @lang('Approve & Cancel Service')
            </button>
        </div>
    </x-admin.modal>

    {{-- Delete Modal --}}
    <x-admin.modal wire:model="showDeleteModal" :title="__('Delete Request')" maxWidth="md">
        <div class="p-6">
            <div class="flex items-start gap-4">
                <div class="flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-xl bg-rose-500/10">
                    <i class="ph-duotone ph-trash text-2xl text-rose-400"></i>
                </div>
                <div>
                    <p class="text-sm text-slate-300">
                        @lang('Are you sure you want to delete this cancellation request?')
                    </p>
                    <p class="mt-2 text-xs text-slate-400">
                        @lang('This will only delete the request record. The service will not be affected.')
                    </p>
                </div>
            </div>
        </div>
        <div class="flex justify-end gap-3 border-t border-white/10 p-4">
            <button wire:click="$set('showDeleteModal', false)" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                @lang('Cancel')
            </button>
            <button wire:click="deleteRequest" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-rose-500 to-rose-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:shadow-rose-500/40 cursor-pointer">
                <i class="ph-duotone ph-trash"></i>
                @lang('Delete Request')
            </button>
        </div>
    </x-admin.modal>
</div>

