<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Service Details')" :subtitle="$hosting->domain ?? __('Service') . ' #'.$hosting->id">
        <x-slot:actions>
            {{-- Desktop Actions --}}
            <div class="hidden sm:flex items-center gap-2">
                @if($hosting->order_id)
                    <a href="{{ route('admin.orders.details', $hosting->order_id) }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                        <i class="ph-duotone ph-shopping-cart"></i>
                        @lang('View Order')
                    </a>
                @endif
                <a href="{{ route('admin.invoices.hosting.all', $hosting->id) }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                    <i class="ph-duotone ph-receipt"></i>
                    @lang('Invoices')
                </a>
                @if($hosting->product?->server_group_id && $hosting->server_id && ($hosting->username || $hosting->domain))
                    @php
                        $serverType = $hosting->server?->group?->type ?? 'Panel';
                        $panelName = match($serverType) {
                            'cpanel' => 'cPanel',
                            'directadmin' => 'DirectAdmin',
                            'plesk' => 'Plesk',
                            'virtualmin' => 'Virtualmin',
                            default => 'Panel'
                        };
                    @endphp
                    <x-admin.button wire:click="syncWithServer" wire:loading.attr="disabled" variant="soft" icon="ph-arrows-clockwise">
                        <span wire:loading.remove wire:target="syncWithServer">@lang('Sync Info')</span>
                        <span wire:loading wire:target="syncWithServer">@lang('Syncing...')</span>
                    </x-admin.button>
                    <x-admin.button wire:click="loginToPanel" wire:loading.attr="disabled" icon="ph-sign-in">
                        <span wire:loading.remove wire:target="loginToPanel">@lang('Login to') {{ $panelName }}</span>
                        <span wire:loading wire:target="loginToPanel">@lang('Connecting...')</span>
                    </x-admin.button>
                @endif
            </div>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Mobile Actions - Horizontal Scroll --}}
    <div class="flex sm:hidden -mx-4 px-4 overflow-x-auto pb-2 mt-3">
        <div class="flex items-center gap-2 min-w-max">
            @if($hosting->order_id)
                <a href="{{ route('admin.orders.details', $hosting->order_id) }}" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
                    <i class="ph-duotone ph-shopping-cart"></i>
                    @lang('Order')
                </a>
            @endif
            <a href="{{ route('admin.invoices.hosting.all', $hosting->id) }}" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
                <i class="ph-duotone ph-receipt"></i>
                @lang('Invoices')
            </a>
            @if($hosting->product?->server_group_id && $hosting->server_id && ($hosting->username || $hosting->domain))
                @php
                    $serverType = $hosting->server?->group?->type ?? 'Panel';
                    $panelName = match($serverType) {
                        'cpanel' => 'cPanel',
                        'directadmin' => 'DirectAdmin',
                        'plesk' => 'Plesk',
                        'virtualmin' => 'Virtualmin',
                        default => 'Panel'
                    };
                @endphp
                <button wire:click="syncWithServer" wire:loading.attr="disabled" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
                    <i class="ph-duotone ph-arrows-clockwise {{ $isProcessing ? 'animate-spin' : '' }}"></i>
                    <span wire:loading.remove wire:target="syncWithServer">@lang('Sync')</span>
                    <span wire:loading wire:target="syncWithServer">...</span>
                </button>
                <button wire:click="loginToPanel" wire:loading.attr="disabled" class="inline-flex items-center gap-1.5 rounded-xl bg-gradient-to-r from-primary-500 to-primary-600 px-3 py-2 text-xs font-medium text-white shadow-lg shadow-primary-500/25 transition-all active:scale-[0.98] cursor-pointer min-h-9">
                    <i class="ph-duotone ph-sign-in"></i>
                    <span wire:loading.remove wire:target="loginToPanel">{{ $panelName }}</span>
                    <span wire:loading wire:target="loginToPanel">...</span>
                </button>
            @endif
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if(session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Module Response Output --}}
    @if($moduleResponse)
        <x-admin.card class="mt-6" :title="__('Module Response')">
            <div class="font-mono text-xs text-slate-300 whitespace-pre-wrap rounded-xl bg-black/30 p-4">
                {!! nl2br(e($moduleResponse)) !!}
            </div>
        </x-admin.card>
    @endif

    {{-- Suspend Alert --}}
    @if($hosting->suspend_reason)
        <x-admin.alert type="warning" class="mt-6">
            <div class="flex items-start gap-3">
                <div>
                    <strong class="block text-amber-400">@lang('Account Suspended')</strong>
                    @if($hosting->suspend_date)
                        <span class="text-xs text-slate-400">{{ \Carbon\Carbon::parse($hosting->suspend_date)->format('M d, Y H:i') }}</span>
                    @endif
                    <p class="mt-1 text-sm text-slate-300">{{ $hosting->suspend_reason }}</p>
                </div>
            </div>
        </x-admin.alert>
    @endif

    {{-- Module Commands Section --}}
    @if($hosting->product?->server_group_id)
        <x-admin.card class="mt-4 sm:mt-6" :title="__('Module Commands')" :subtitle="__('Execute server module commands')">
            @if(!$hosting->server_id)
                <x-admin.alert type="warning" class="mb-3 sm:mb-4">
                    @lang('Please select a server and save changes before running module commands.')
                </x-admin.alert>
            @endif
            <div class="grid grid-cols-3 sm:grid-cols-3 lg:grid-cols-6 gap-2 sm:gap-4">
                {{-- Create --}}
                <button type="button" wire:click="openModuleModal(1, 'Create')" @if(!$hosting->server_id) disabled @endif
                    class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-plus text-xl sm:text-2xl text-emerald-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white">@lang('Create')</span>
                </button>
                {{-- Suspend --}}
                <button type="button" wire:click="openModuleModal(2, 'Suspend')" @if(!$hosting->server_id) disabled @endif
                    class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-prohibit text-xl sm:text-2xl text-amber-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white">@lang('Suspend')</span>
                </button>
                {{-- Unsuspend --}}
                <button type="button" wire:click="openModuleModal(3, 'Unsuspend')" @if(!$hosting->server_id) disabled @endif
                    class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-arrow-counter-clockwise text-xl sm:text-2xl text-blue-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Unsuspend')</span>
                </button>
                {{-- Terminate --}}
                <button type="button" wire:click="openModuleModal(4, 'Terminate')" @if(!$hosting->server_id) disabled @endif
                    class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-trash text-xl sm:text-2xl text-red-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white">@lang('Terminate')</span>
                </button>
                {{-- Change Package --}}
                <button type="button" wire:click="openModuleModal(5, 'Change Package')" @if(!$hosting->server_id) disabled @endif
                    class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-arrows-left-right text-xl sm:text-2xl text-purple-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Package')</span>
                </button>
                {{-- Change Password --}}
                <button type="button" wire:click="openModuleModal(6, 'Change Password')" @if(!$hosting->server_id) disabled @endif
                    class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-key text-xl sm:text-2xl text-cyan-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Password')</span>
                </button>
                {{-- Convert to Reseller (only for reseller products) --}}
                @if($hosting->product?->product_type == 2 && $hosting->server_id)
                    <button type="button" wire:click="convertToReseller" wire:loading.attr="disabled"
                        class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-purple-500/30 bg-purple-500/10 p-2.5 sm:p-4 text-center transition-all hover:bg-purple-500/20 active:scale-[0.98] cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed min-h-[70px] sm:min-h-0">
                        <i class="ph-duotone ph-crown text-xl sm:text-2xl text-purple-400"></i>
                        <span class="text-[10px] sm:text-sm font-medium text-white leading-tight" wire:loading.remove wire:target="convertToReseller">@lang('To Reseller')</span>
                        <span class="text-[10px] sm:text-sm font-medium text-white leading-tight" wire:loading wire:target="convertToReseller">...</span>
                    </button>
                @endif
            </div>
        </x-admin.card>
    @endif

    <div class="mt-4 sm:mt-6 grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
        {{-- Main Form --}}
        <div class="lg:col-span-2 space-y-4 sm:space-y-6 order-2 lg:order-1">
            {{-- Hosting Information --}}
            <x-admin.card :title="__('Hosting Information')" :subtitle="__('Service configuration and billing details')">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-5">
                    {{-- Registration Date --}}
                    <x-admin.input type="date" :label="__('Registration Date')" wire:model="reg_date" />
                    {{-- Next Due Date --}}
                    <x-admin.input type="date" :label="__('Next Due Date')" wire:model="next_due_date" />
                    {{-- Next Invoice Date --}}
                    <x-admin.input type="date" :label="__('Next Invoice Date')" wire:model="next_invoice_date" />
                    {{-- Termination Date --}}
                    <x-admin.input type="date" :label="__('Termination Date')" wire:model="termination_date" />
                    {{-- First Payment Amount --}}
                    <x-admin.input type="number" step="0.01" :label="__('First Payment Amount')" wire:model="first_payment_amount" prefix="$" />
                    {{-- Recurring Amount --}}
                    <x-admin.input type="number" step="0.01" :label="__('Recurring Amount')" wire:model="recurring_amount" prefix="$" />
                    {{-- Product/Service (Change Product Dropdown) --}}
                    <div>
                        <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Product/Service')</label>
                        <div class="flex gap-2">
                            <div class="relative flex-1">
                                <select wire:model.live="change_product_id"
                                    class="block w-full appearance-none rounded-xl border border-white/10 bg-white/5 px-4 py-3 pr-10 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                    @foreach($this->productsByCategory as $category)
                                        <optgroup label="{{ $category->name }}" class="bg-[#1a1a2e] text-slate-400 font-semibold">
                                            @foreach($category->products as $product)
                                                <option value="{{ $product->id }}" class="bg-[#1a1a2e] text-white py-2">
                                                    {{ $product->name }}
                                                </option>
                                            @endforeach
                                        </optgroup>
                                    @endforeach
                                </select>
                                <span class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 text-slate-500">
                                    <i class="ph-bold ph-caret-down text-sm"></i>
                                </span>
                            </div>
                            @if($change_product_id && $change_product_id != $hosting->product_id)
                                <x-admin.button variant="primary" wire:click="changeProduct" wire:loading.attr="disabled" icon="ph-arrows-left-right">
                                    <span wire:loading.remove wire:target="changeProduct">@lang('Change')</span>
                                    <span wire:loading wire:target="changeProduct">...</span>
                                </x-admin.button>
                            @endif
                        </div>
                    </div>
                    {{-- Server --}}
                    <x-admin.select :label="__('Server')" wire:model="server_id">
                        <option value="">@lang('Select Server')</option>
                        @foreach($this->servers as $server)
                            <option value="{{ $server->id }}">{{ $server->hostname }} - {{ $server->name }}</option>
                        @endforeach
                    </x-admin.select>
                    {{-- Domain --}}
                    <x-admin.input :label="__('Domain')" wire:model="domain" placeholder="example.com" />
                    {{-- Dedicated IP --}}
                    <x-admin.input :label="__('Dedicated IP')" wire:model="dedicated_ip" placeholder="0.0.0.0" />
                    {{-- Username --}}
                    <x-admin.input :label="__('Username')" wire:model="username" />
                    {{-- Password --}}
                    <div>
                        <div class="mb-2 flex items-center justify-between">
                            <label class="text-sm font-medium text-slate-300">@lang('Password')</label>
                            <button type="button" wire:click="generatePassword" class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors">@lang('Generate')</button>
                        </div>
                        <x-admin.input wire:model="password" />
                    </div>
                    {{-- Status --}}
                    <x-admin.select :label="__('Status')" wire:model="status">
                        @foreach($this->statusOptions as $value => $label)
                            <option value="{{ $value }}">{{ __($label) }}</option>
                        @endforeach
                    </x-admin.select>
                    {{-- Billing Cycle --}}
                    <x-admin.select :label="__('Billing Cycle')" wire:model="billing_cycle">
                        @foreach($this->billingCycles as $value => $label)
                            <option value="{{ $value }}">{{ __($label) }}</option>
                        @endforeach
                    </x-admin.select>
                </div>
            </x-admin.card>

            {{-- Nameservers (for VPS/Dedicated) --}}
            @if($hosting->product?->product_type == 3)
                <x-admin.card :title="__('Nameservers & IPs')" :subtitle="__('VPS/Dedicated server configuration')">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                        <x-admin.input :label="__('Nameserver 1')" wire:model="ns1" placeholder="ns1.example.com" />
                        <x-admin.input :label="__('Nameserver 2')" wire:model="ns2" placeholder="ns2.example.com" />
                        <div class="md:col-span-2">
                            <x-admin.textarea :label="__('Assigned IPs')" wire:model="assigned_ips" rows="3" :placeholder="__('One IP per line')" />
                        </div>
                    </div>
                </x-admin.card>
            @endif

            {{-- Configurable Options with Dynamic Pricing --}}
            @if($hosting->product?->configurableGroups->count())
                <x-admin.card :title="__('Configurable Options')" :subtitle="__('Prices update with billing cycle')" x-data="configurableOptions()" x-init="init()">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5">
                        @foreach($hosting->product->configurableGroups as $group)
                            @foreach($group->options as $option)
                                <x-admin.select label="{{ $option->name }}" wire:model="config_options.{{ $option->id }}" class="config-option-select">
                                    <option value="">@lang('Select Option')</option>
                                    @foreach($option->subOptions as $subOption)
                                        @php
                                            $pricing = $subOption->pricing;
                                            $priceJson = $pricing ? json_encode([
                                                'monthly' => (float)($pricing->monthly ?? 0),
                                                'quarterly' => (float)($pricing->quarterly ?? 0),
                                                'semi_annually' => (float)($pricing->semi_annually ?? 0),
                                                'annually' => (float)($pricing->annually ?? 0),
                                                'biennially' => (float)($pricing->biennially ?? 0),
                                                'triennially' => (float)($pricing->triennially ?? 0),
                                            ]) : null;
                                        @endphp
                                        <option value="{{ $subOption->id }}"
                                            data-name="{{ $subOption->name }}"
                                            @if($priceJson) data-pricing='{{ $priceJson }}' @endif
                                        >{{ $subOption->name }}</option>
                                    @endforeach
                                </x-admin.select>
                            @endforeach
                        @endforeach
                    </div>
                </x-admin.card>
            @endif

            {{-- Admin Notes --}}
            <x-admin.card :title="__('Admin Notes')" :subtitle="__('Internal notes about this service')">
                <x-admin.textarea wire:model="admin_notes" rows="4" :placeholder="__('Internal notes about this service...')" />
            </x-admin.card>

            {{-- Save Button --}}
            <x-admin.button wire:click="save" wire:loading.attr="disabled" class="w-full" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </div>

        {{-- Sidebar --}}
        <div class="space-y-4 sm:space-y-6 order-1 lg:order-2">
            {{-- Client Info --}}
            <x-admin.card :title="__('Client Information')">
                <div class="space-y-3 sm:space-y-4">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-full bg-gradient-to-br from-indigo-500 to-purple-600 text-xs sm:text-sm font-semibold text-white">
                            {{ strtoupper(substr($hosting->user?->first_name ?? 'U', 0, 1)) }}{{ strtoupper(substr($hosting->user?->last_name ?? 'N', 0, 1)) }}
                        </div>
                        <div class="min-w-0">
                            <p class="text-sm font-medium text-white truncate">{{ $hosting->user?->first_name }} {{ $hosting->user?->last_name }}</p>
                            <p class="text-xs text-slate-400">{{ '@' . ($hosting->user?->username ?? 'unknown') }}</p>
                        </div>
                    </div>
                    <div class="space-y-2 border-t border-white/5 pt-3 sm:pt-4">
                        <div class="flex items-center gap-2 text-xs sm:text-sm min-w-0">
                            <i class="ph-duotone ph-envelope text-slate-400 shrink-0"></i>
                            <span class="text-slate-300 truncate">{{ $hosting->user?->email ?? __('N/A') }}</span>
                        </div>
                        <div class="flex items-center gap-2 text-xs sm:text-sm">
                            <i class="ph-duotone ph-phone text-slate-400 shrink-0"></i>
                            <span class="text-slate-300">{{ $hosting->user?->phone ?? __('N/A') }}</span>
                        </div>
                    </div>
                    @if($hosting->user)
                        <x-admin.button variant="outline" class="w-full" href="{{ route('admin.users.detail', $hosting->user->username) }}" icon="ph-arrow-square-out">
                            @lang('View Profile')
                        </x-admin.button>
                    @endif
                </div>
            </x-admin.card>

            {{-- Account Summary --}}
            @if($hosting->product?->server_group_id && count($accountSummary) > 0)
                <x-admin.card :title="__('Account Summary')">
                    <div class="max-h-60 sm:max-h-80 space-y-2 overflow-y-auto pr-1 custom-scrollbar">
                        @foreach($accountSummary as $key => $value)
                            <div class="flex items-center justify-between border-b border-white/5 py-1.5 sm:py-2 last:border-0">
                                <span class="text-[10px] sm:text-xs text-slate-400">{{ $key }}</span>
                                <span class="text-[10px] sm:text-xs font-medium text-white">{{ $value ?? __('N/A') }}</span>
                            </div>
                        @endforeach
                    </div>
                </x-admin.card>
            @endif

            {{-- Cancel Request --}}
            @if($hosting->cancelRequests?->first())
                @php $cancelRequest = $hosting->cancelRequests->first(); @endphp
                <x-admin.card :title="__('Cancellation Request')" class="border-red-500/20">
                    <div class="space-y-2.5 sm:space-y-3">
                        <div class="flex items-center justify-between">
                            <span class="text-[10px] sm:text-xs text-slate-400">@lang('Type')</span>
                            <span class="text-[10px] sm:text-xs font-medium text-white">{{ $cancelRequest->cancel_type == 1 ? __('Immediate') : __('End of Billing') }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-[10px] sm:text-xs text-slate-400">@lang('Status')</span>
                            <span class="text-[10px] sm:text-xs font-medium {{ $cancelRequest->status == 0 ? 'text-amber-400' : ($cancelRequest->status == 1 ? 'text-emerald-400' : 'text-red-400') }}">
                                {{ __($cancelRequest->status_label) }}
                            </span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-[10px] sm:text-xs text-slate-400">@lang('Requested')</span>
                            <span class="text-[10px] sm:text-xs font-medium text-white">{{ $cancelRequest->created_at->format('M d, Y') }}</span>
                        </div>
                        <div class="border-t border-white/5 pt-2.5 sm:pt-3">
                            <p class="mb-1 text-[10px] sm:text-xs text-slate-400">@lang('Reason'):</p>
                            <p class="text-xs sm:text-sm text-red-300">{{ $cancelRequest->reason }}</p>
                        </div>
                        {{-- Delete Cancel Request Checkbox --}}
                        <div class="border-t border-white/5 pt-2.5 sm:pt-3">
                            <x-admin.checkbox wire:model="deleteCancelRequest" :label="__('Delete this cancellation request on save')" />
                        </div>
                    </div>
                </x-admin.card>
            @endif
        </div>
    </div>

    {{-- Module Command Modal --}}
    <x-admin.modal wire:model="showModuleModal" :title="__('Confirm Module Command')" maxWidth="md">
        <p class="mb-3 sm:mb-4 text-xs sm:text-sm text-slate-300">
            @lang('Are you sure you want to run the') <span class="font-semibold text-red-400">{{ __($moduleName) }}</span> @lang('function?')
        </p>

        @if($moduleType === 2)
            <div class="space-y-3 sm:space-y-4">
                <x-admin.input :label="__('Suspend Reason') . ' *'" wire:model="suspend_reason" :placeholder="__('Enter reason for suspension')" />
                <x-admin.checkbox wire:model="send_email" :label="__('Send Suspension Email')" />
            </div>
        @endif

        @if($moduleType === 3)
            <x-admin.checkbox wire:model="send_email" :label="__('Send Unsuspension Email')" />
        @endif

        <x-slot:footer>
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <x-admin.button variant="ghost" wire:click="$set('showModuleModal', false)" wire:loading.attr="disabled" wire:target="runModuleCommand" class="w-full sm:w-auto min-h-11 sm:min-h-0">
                    @lang('Cancel')
                </x-admin.button>
                <x-admin.button wire:click="runModuleCommand" wire:loading.attr="disabled" wire:target="runModuleCommand" icon="ph-check" class="w-full sm:w-auto min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="runModuleCommand">@lang('Confirm')</span>
                    <span wire:loading wire:target="runModuleCommand">@lang('Processing...')</span>
                </x-admin.button>
            </div>
        </x-slot:footer>
    </x-admin.modal>

    <style>
        .custom-scrollbar::-webkit-scrollbar { width: 4px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: rgba(255,255,255,0.05); border-radius: 4px; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.1); border-radius: 4px; }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: rgba(255,255,255,0.2); }
    </style>

    <script>
        function configurableOptions() {
            return {
                billingCycle: @js($billing_cycle ?? 'monthly'),
                currencySymbol: '$',

                init() {
                    this.updateOptionPrices();
                    this.$watch('billingCycle', () => this.updateOptionPrices());
                    Livewire.on('billingCycleUpdated', (cycle) => {
                        this.billingCycle = cycle;
                        this.updateOptionPrices();
                    });
                    const billingSelect = document.querySelector('select[wire\\:model="billing_cycle"]');
                    if (billingSelect) {
                        billingSelect.addEventListener('change', (e) => {
                            this.billingCycle = e.target.value;
                            this.updateOptionPrices();
                        });
                    }
                },

                updateOptionPrices() {
                    const selects = document.querySelectorAll('.config-option-select');
                    selects.forEach(select => {
                        const options = select.querySelectorAll('option[data-pricing]');
                        options.forEach(option => {
                            const name = option.dataset.name;
                            const pricing = JSON.parse(option.dataset.pricing);
                            const price = pricing[this.billingCycle] || pricing.monthly || 0;
                            const formattedPrice = this.formatPrice(price);
                            option.textContent = price > 0 ? `${name} - ${this.currencySymbol}${formattedPrice}` : name;
                        });
                    });
                },

                formatPrice(price) {
                    return parseFloat(price).toFixed(2);
                }
            }
        }
    </script>
</div>
