<div>
    <x-admin.page-header :title="__('Services')" :description="__('Manage hosting services and accounts.')" />

    {{-- Stats Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-2 gap-2 sm:gap-4 lg:grid-cols-4">
        <div class="bg-[#12121a] border border-white/5 rounded-xl p-3 sm:p-5 active:scale-[0.98] transition-transform">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs font-medium text-slate-400 uppercase tracking-wider truncate">@lang('Total')</p>
                    <p class="text-lg sm:text-2xl font-bold text-white mt-0.5 sm:mt-1">{{ number_format($this->totalCount) }}</p>
                </div>
                <div class="w-10 h-10 sm:w-12 sm:h-12 shrink-0 rounded-lg sm:rounded-xl bg-blue-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-hard-drives text-lg sm:text-2xl text-blue-400"></i>
                </div>
            </div>
        </div>
        <div class="bg-[#12121a] border border-white/5 rounded-xl p-3 sm:p-5 active:scale-[0.98] transition-transform">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs font-medium text-slate-400 uppercase tracking-wider truncate">@lang('Active')</p>
                    <p class="text-lg sm:text-2xl font-bold text-emerald-400 mt-0.5 sm:mt-1">{{ number_format($this->activeCount) }}</p>
                </div>
                <div class="w-10 h-10 sm:w-12 sm:h-12 shrink-0 rounded-lg sm:rounded-xl bg-emerald-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-check-circle text-lg sm:text-2xl text-emerald-400"></i>
                </div>
            </div>
        </div>
        <div class="bg-[#12121a] border border-white/5 rounded-xl p-3 sm:p-5 active:scale-[0.98] transition-transform">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs font-medium text-slate-400 uppercase tracking-wider truncate">@lang('Pending')</p>
                    <p class="text-lg sm:text-2xl font-bold text-amber-400 mt-0.5 sm:mt-1">{{ number_format($this->pendingCount) }}</p>
                </div>
                <div class="w-10 h-10 sm:w-12 sm:h-12 shrink-0 rounded-lg sm:rounded-xl bg-amber-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-clock text-lg sm:text-2xl text-amber-400"></i>
                </div>
            </div>
        </div>
        <div class="bg-[#12121a] border border-white/5 rounded-xl p-3 sm:p-5 active:scale-[0.98] transition-transform">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs font-medium text-slate-400 uppercase tracking-wider truncate">@lang('Suspended')</p>
                    <p class="text-lg sm:text-2xl font-bold text-red-400 mt-0.5 sm:mt-1">{{ number_format($this->suspendedCount) }}</p>
                </div>
                <div class="w-10 h-10 sm:w-12 sm:h-12 shrink-0 rounded-lg sm:rounded-xl bg-red-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-prohibit text-lg sm:text-2xl text-red-400"></i>
                </div>
            </div>
        </div>
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-4 sm:mt-6">
        <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row">
            <div class="flex-1">
                <div class="relative">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                    <input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search services...') }}" class="w-full pl-10 pr-10 py-3 sm:py-2.5 text-base sm:text-sm text-white bg-white/5 border border-white/10 rounded-xl focus:border-blue-500 focus:ring-1 focus:ring-blue-500 transition-colors placeholder:text-slate-500">
                    @if($search)
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 hover:text-white cursor-pointer p-1 min-h-11 min-w-11 flex items-center justify-center -mr-2">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>
            </div>
            <div class="w-full sm:w-48">
                <select wire:model.live="status" class="w-full px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white bg-white/5 border border-white/10 rounded-xl focus:border-blue-500 focus:ring-1 focus:ring-blue-500 transition-colors cursor-pointer">
                    @foreach($this->statusOptions as $value => $label)
                        <option value="{{ $value }}">{{ __($label) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Services Table (Desktop) / Cards (Mobile) --}}
    <x-admin.card class="mt-4 sm:mt-6" :padding="false">
        {{-- Desktop Table View --}}
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/5">
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('ID')</th>
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Client')</th>
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider hidden lg:table-cell">@lang('Product')</th>
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Domain')</th>
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider hidden xl:table-cell">@lang('Server')</th>
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider hidden xl:table-cell">@lang('Next Due')</th>
                        <th class="px-4 lg:px-5 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Status')</th>
                        <th class="px-4 lg:px-5 py-3 text-right text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($hostings as $hosting)
                        <tr class="hover:bg-white/5 transition-colors">
                            <td class="px-4 lg:px-5 py-3">
                                <span class="text-sm font-medium text-white">#{{ $hosting->id }}</span>
                            </td>
                            <td class="px-4 lg:px-5 py-3">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 shrink-0 rounded-full bg-gradient-to-br from-blue-500 to-purple-600 flex items-center justify-center text-white font-semibold text-xs">
                                        {{ strtoupper(substr($hosting->user?->first_name ?? 'U', 0, 1)) }}
                                    </div>
                                    <div class="min-w-0">
                                        <p class="text-sm font-medium text-white truncate">{{ $hosting->user?->first_name }} {{ $hosting->user?->last_name }}</p>
                                        <p class="text-xs text-slate-400 truncate">{{ $hosting->user?->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 lg:px-5 py-3 hidden lg:table-cell">
                                <span class="text-sm text-slate-300 truncate block max-w-[150px]">{{ $hosting->product?->name ?? __('N/A') }}</span>
                            </td>
                            <td class="px-4 lg:px-5 py-3">
                                <span class="text-sm text-slate-300 truncate block max-w-[150px]">{{ $hosting->domain ?? '-' }}</span>
                            </td>
                            <td class="px-4 lg:px-5 py-3 hidden xl:table-cell">
                                <span class="text-sm text-slate-300">{{ $hosting->server?->name ?? '-' }}</span>
                            </td>
                            <td class="px-4 lg:px-5 py-3 hidden xl:table-cell">
                                @if($hosting->next_due_date)
                                    <span class="text-sm text-slate-300">{{ \Carbon\Carbon::parse($hosting->next_due_date)->format('M d, Y') }}</span>
                                @else
                                    <span class="text-sm text-slate-500">-</span>
                                @endif
                            </td>
                            <td class="px-4 lg:px-5 py-3">
                                @php $badge = $this->statusBadge[$hosting->status] ?? ['class' => 'bg-slate-500/10 text-slate-400 border-slate-500/20', 'label' => __('Unknown')]; @endphp
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full border {{ $badge['class'] }}">
                                    {{ __($badge['label']) }}
                                </span>
                            </td>
                            <td class="px-4 lg:px-5 py-3 text-right">
                                <a href="{{ route('admin.order.hosting.details', $hosting->id) }}" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-xs font-medium text-blue-400 bg-blue-500/10 border border-blue-500/20 rounded-lg hover:bg-blue-500/20 transition-colors">
                                    <i class="ph-duotone ph-eye text-sm"></i>
                                    <span class="hidden lg:inline">@lang('View')</span>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-5 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-hard-drives text-2xl text-slate-500"></i>
                                    </div>
                                    <p class="text-sm font-medium text-white mt-3">@lang('No services found')</p>
                                    <p class="text-xs text-slate-500 mt-1">@lang('Try adjusting your search or filters')</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Mobile Card View --}}
        <div class="md:hidden divide-y divide-white/5">
            @forelse($hostings as $hosting)
                @php $badge = $this->statusBadge[$hosting->status] ?? ['class' => 'bg-slate-500/10 text-slate-400 border-slate-500/20', 'label' => __('Unknown')]; @endphp
                <a href="{{ route('admin.order.hosting.details', $hosting->id) }}" class="block p-4 active:bg-white/5" wire:key="hosting-mobile-{{ $hosting->id }}">
                    <div class="flex items-start justify-between gap-3">
                        <div class="flex items-center gap-3 min-w-0 flex-1">
                            <div class="w-10 h-10 shrink-0 rounded-full bg-gradient-to-br from-blue-500 to-purple-600 flex items-center justify-center text-white font-semibold text-sm">
                                {{ strtoupper(substr($hosting->user?->first_name ?? 'U', 0, 1)) }}
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-white truncate">{{ $hosting->user?->first_name }} {{ $hosting->user?->last_name }}</p>
                                <p class="text-xs text-slate-500 truncate">{{ $hosting->domain ?? '-' }}</p>
                            </div>
                        </div>
                        <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full border shrink-0 {{ $badge['class'] }}">
                            {{ __($badge['label']) }}
                        </span>
                    </div>
                    <div class="mt-2 grid grid-cols-2 gap-2 text-xs">
                        <div>
                            <p class="text-slate-500">@lang('Product')</p>
                            <p class="text-slate-300 truncate">{{ $hosting->product?->name ?? __('N/A') }}</p>
                        </div>
                        <div>
                            <p class="text-slate-500">@lang('Next Due')</p>
                            <p class="text-slate-300">
                                @if($hosting->next_due_date)
                                    {{ \Carbon\Carbon::parse($hosting->next_due_date)->format('M d, Y') }}
                                @else
                                    -
                                @endif
                            </p>
                        </div>
                    </div>
                </a>
            @empty
                <div class="px-4 py-12 text-center">
                    <div class="flex flex-col items-center">
                        <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                            <i class="ph-duotone ph-hard-drives text-2xl text-slate-500"></i>
                        </div>
                        <p class="text-sm font-medium text-white mt-3">@lang('No services found')</p>
                        <p class="text-xs text-slate-500 mt-1">@lang('Try adjusting your search or filters')</p>
                    </div>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        @if($hostings->hasPages())
            <div class="px-4 sm:px-5 py-3 sm:py-4 border-t border-white/5">
                {{ $hostings->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

