<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Affiliate Settings')" :subtitle="__('Configure affiliate program, commission rates, and payout settings.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="affiliate-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-5">
        <x-admin.stat-card icon="ph-users-three" iconColor="primary" :label="__('Total Affiliates')" :value="$this->stats['total_affiliates']" />
        <x-admin.stat-card icon="ph-currency-circle-dollar" iconColor="success" :label="__('Total Commissions')" :value="showAmount($this->stats['total_commissions'])" />
        <x-admin.stat-card icon="ph-clock" iconColor="warning" :label="__('Pending Commissions')" :value="showAmount($this->stats['pending_commissions'])" />
        <x-admin.stat-card icon="ph-check-circle" iconColor="info" :label="__('Paid Commissions')" :value="showAmount($this->stats['paid_commissions'])" />
        <x-admin.stat-card icon="ph-hand-coins" iconColor="danger" :label="__('Pending Payouts')" :value="$this->stats['pending_payouts']" />
    </div>

    {{-- Tabs --}}
    <div class="mt-6 flex gap-1 border-b border-white/10">
        <button wire:click="$set('activeTab', 'settings')" class="px-5 py-3 text-sm font-medium transition-all {{ $activeTab === 'settings' ? 'text-white border-b-2 border-indigo-500' : 'text-slate-400 hover:text-white' }}">
            <i class="ph-duotone ph-gear-six mr-1.5"></i> @lang('Settings')
        </button>
        <button wire:click="$set('activeTab', 'payouts')" class="px-5 py-3 text-sm font-medium transition-all {{ $activeTab === 'payouts' ? 'text-white border-b-2 border-indigo-500' : 'text-slate-400 hover:text-white' }}">
            <i class="ph-duotone ph-hand-coins mr-1.5"></i> @lang('Pending Payouts')
            @if($this->stats['pending_payouts'] > 0)
                <span class="ml-1.5 inline-flex items-center justify-center rounded-full bg-rose-500/20 px-2 py-0.5 text-xs font-semibold text-rose-400">{{ $this->stats['pending_payouts'] }}</span>
            @endif
        </button>
    </div>

    @if($activeTab === 'settings')
        <form wire:submit="save" id="affiliate-settings-form">
            <div class="mt-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
                {{-- General Settings --}}
                <x-admin.card class="h-fit">
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-users-three text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Program Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Enable and configure affiliate program')</p>
                        </div>
                    </div>

                    <div class="space-y-5">
                        {{-- Enable Affiliate Program --}}
                        <div class="flex items-center justify-between p-4 rounded-xl bg-white/5 border border-white/10">
                            <div>
                                <h4 class="font-medium text-white">@lang('Enable Affiliate Program')</h4>
                                <p class="text-xs text-slate-500 mt-0.5">@lang('Allow users to earn commissions by referring new customers')</p>
                            </div>
                            <label class="relative inline-flex cursor-pointer items-center">
                                <input type="checkbox" wire:model="affiliate_enabled" class="peer sr-only">
                                <div class="h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-slate-400 after:transition-all peer-checked:bg-indigo-600 peer-checked:after:translate-x-full peer-checked:after:bg-white"></div>
                            </label>
                        </div>

                        {{-- Auto Approve Commissions --}}
                        <div class="flex items-center justify-between p-4 rounded-xl bg-white/5 border border-white/10">
                            <div>
                                <h4 class="font-medium text-white">@lang('Auto-Approve Commissions')</h4>
                                <p class="text-xs text-slate-500 mt-0.5">@lang('Automatically approve commissions after hold period')</p>
                            </div>
                            <label class="relative inline-flex cursor-pointer items-center">
                                <input type="checkbox" wire:model="affiliate_auto_approve" class="peer sr-only">
                                <div class="h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-slate-400 after:transition-all peer-checked:bg-indigo-600 peer-checked:after:translate-x-full peer-checked:after:bg-white"></div>
                            </label>
                        </div>

                        {{-- Cookie Days --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Referral Cookie Duration')</label>
                            <div class="relative">
                                <input type="number" wire:model="affiliate_cookie_days" min="1" max="365" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('days')</span>
                            </div>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('How long the referral tracking cookie is valid')</p>
                        </div>
                    </div>
                </x-admin.card>

                {{-- Commission Settings --}}
                <x-admin.card class="h-fit">
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                            <i class="ph-duotone ph-percent text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Commission Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure commission rates and type')</p>
                        </div>
                    </div>

                    <div class="space-y-5">
                        {{-- Commission Type --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Commission Type')</label>
                            <select wire:model="affiliate_commission_type" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                <option value="percentage" class="bg-[#1a1a24]">@lang('Percentage of Order')</option>
                                <option value="fixed" class="bg-[#1a1a24]">@lang('Fixed Amount per Order')</option>
                            </select>
                        </div>

                        {{-- Commission Rate --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Commission Rate')</label>
                            <div class="relative">
                                <input type="number" wire:model="affiliate_commission_rate" step="0.01" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-12 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500">{{ $affiliate_commission_type === 'percentage' ? '%' : gs('cur_sym') }}</span>
                            </div>
                        </div>

                        {{-- Hold Days --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Commission Hold Period')</label>
                            <div class="relative">
                                <input type="number" wire:model="affiliate_hold_days" min="0" max="365" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('days')</span>
                            </div>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('Days before commission becomes available for withdrawal')</p>
                        </div>
                    </div>
                </x-admin.card>

                {{-- Payout Settings --}}
                <x-admin.card class="lg:col-span-2">
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                            <i class="ph-duotone ph-hand-coins text-xl text-amber-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Payout Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure minimum payout and methods')</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                        {{-- Minimum Payout --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Minimum Payout Amount')</label>
                            <div class="relative">
                                <span class="absolute left-4 top-1/2 -translate-y-1/2 text-slate-500">{{ gs('cur_sym') }}</span>
                                <input type="number" wire:model="affiliate_min_payout" step="0.01" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 pl-10 pr-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            </div>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('Minimum balance required to request a payout')</p>
                        </div>

                        {{-- Payout Methods --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Available Payout Methods')</label>
                            <div class="flex flex-wrap gap-3">
                                @foreach(['paypal' => 'PayPal', 'bank_transfer' => 'Bank Transfer', 'crypto' => 'Cryptocurrency', 'account_credit' => 'Account Credit'] as $value => $label)
                                    <label class="inline-flex items-center gap-2 px-4 py-2 rounded-xl cursor-pointer transition-all {{ in_array($value, $affiliate_payout_methods) ? 'bg-indigo-600/20 border-indigo-500/50' : 'bg-white/5 border-white/10' }} border">
                                        <input type="checkbox" wire:model="affiliate_payout_methods" value="{{ $value }}" class="rounded border-white/20 bg-white/10 text-indigo-500 focus:ring-indigo-500/30">
                                        <span class="text-sm text-white">{{ $label }}</span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </x-admin.card>
            </div>
        </form>
    @elseif($activeTab === 'payouts')
        {{-- Pending Payouts Table --}}
        <x-admin.card class="mt-6">
            <div class="flex items-center justify-between pb-4 mb-5 border-b border-white/5">
                <div>
                    <h3 class="font-semibold text-white">@lang('Pending Payout Requests')</h3>
                    <p class="text-sm text-slate-500">@lang('Review and process affiliate payout requests')</p>
                </div>
            </div>

            @if($this->pendingPayouts->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-white/10">
                                <th class="py-3 px-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Affiliate')</th>
                                <th class="py-3 px-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Amount')</th>
                                <th class="py-3 px-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Method')</th>
                                <th class="py-3 px-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Requested')</th>
                                <th class="py-3 px-4 text-right text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @foreach($this->pendingPayouts as $payout)
                                <tr class="hover:bg-white/5 transition-colors">
                                    <td class="py-4 px-4">
                                        <div class="flex items-center gap-3">
                                            <div class="h-10 w-10 rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 flex items-center justify-center">
                                                <span class="text-sm font-semibold text-indigo-400">{{ strtoupper(substr($payout->user?->firstname ?? 'U', 0, 1)) }}</span>
                                            </div>
                                            <div>
                                                <p class="font-medium text-white">{{ $payout->user?->fullname ?? 'Unknown' }}</p>
                                                <p class="text-xs text-slate-500">{{ $payout->user?->email ?? '' }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-4 px-4">
                                        <span class="font-semibold text-emerald-400">{{ showAmount($payout->amount) }}</span>
                                    </td>
                                    <td class="py-4 px-4">
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg bg-white/10 text-xs font-medium text-white capitalize">
                                            {{ str_replace('_', ' ', $payout->method ?? 'Not specified') }}
                                        </span>
                                    </td>
                                    <td class="py-4 px-4 text-sm text-slate-400">
                                        {{ $payout->created_at?->diffForHumans() ?? 'N/A' }}
                                    </td>
                                    <td class="py-4 px-4 text-right">
                                        <button wire:click="openPayoutModal({{ $payout->id }})" class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg bg-indigo-600/20 text-indigo-400 text-xs font-medium hover:bg-indigo-600/30 transition-colors">
                                            <i class="ph-duotone ph-eye"></i> @lang('Review')
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $this->pendingPayouts->links() }}
                </div>
            @else
                <div class="text-center py-12">
                    <div class="mx-auto h-16 w-16 rounded-2xl bg-white/5 flex items-center justify-center mb-4">
                        <i class="ph-duotone ph-check-circle text-3xl text-emerald-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-1">@lang('No Pending Payouts')</h3>
                    <p class="text-sm text-slate-500">@lang('All payout requests have been processed')</p>
                </div>
            @endif
        </x-admin.card>
    @endif

    {{-- Payout Modal --}}
    @if($showPayoutModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm" wire:click.self="$set('showPayoutModal', false)">
            <div class="w-full max-w-md bg-[#1a1a24] rounded-2xl border border-white/10 shadow-2xl">
                <div class="p-6 border-b border-white/10">
                    <h3 class="text-lg font-semibold text-white">@lang('Process Payout Request')</h3>
                    <p class="text-sm text-slate-500 mt-1">@lang('Approve or reject this payout request')</p>
                </div>
                <div class="p-6 space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Admin Note') (@lang('Optional'))</label>
                        <textarea wire:model="payoutNote" rows="3" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Add a note for the affiliate...') }}"></textarea>
                    </div>
                </div>
                <div class="p-6 border-t border-white/10 flex gap-3 justify-end">
                    <button wire:click="$set('showPayoutModal', false)" class="px-4 py-2 rounded-xl bg-white/10 text-white text-sm font-medium hover:bg-white/20 transition-colors">
                        @lang('Cancel')
                    </button>
                    <button wire:click="rejectPayout" class="px-4 py-2 rounded-xl bg-rose-600/20 text-rose-400 text-sm font-medium hover:bg-rose-600/30 transition-colors">
                        <i class="ph-duotone ph-x-circle mr-1"></i> @lang('Reject')
                    </button>
                    <button wire:click="approvePayout" class="px-4 py-2 rounded-xl bg-emerald-600 text-white text-sm font-medium hover:bg-emerald-700 transition-colors">
                        <i class="ph-duotone ph-check-circle mr-1"></i> @lang('Approve & Pay')
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>

