<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Automation Settings')" :subtitle="__('Configure auto-provisioning, fraud detection, auto-billing, and other automation features.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="automation-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-robot"
            iconColor="primary"
            :label="__('Auto-Provision')"
            :value="$auto_provision_enabled ? __('Enabled') : __('Disabled')"
        />
        <x-admin.stat-card
            icon="ph-credit-card"
            iconColor="success"
            :label="__('Auto-Billing')"
            :value="$auto_billing_enabled ? __('Enabled') : __('Disabled')"
        />
        <x-admin.stat-card
            icon="ph-shield-check"
            iconColor="warning"
            :label="__('Fraud Check')"
            :value="$fraud_check_enabled ? __('Enabled') : __('Disabled')"
        />
        <x-admin.stat-card
            icon="ph-warning"
            iconColor="danger"
            :label="__('Failed Operations')"
            :value="$this->failedOperationsCount"
        />
    </div>

    <form wire:submit="save" id="automation-settings-form">
        <div class="mt-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
            {{-- Auto-Provisioning Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                        <i class="ph-duotone ph-rocket-launch text-xl text-emerald-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Auto-Provisioning')</h3>
                        <p class="text-sm text-slate-500">@lang('Automatic service provisioning settings')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    {{-- Auto-Provision Toggle --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-emerald-500/10">
                                <i class="ph-duotone ph-gear text-lg text-emerald-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Enable Auto-Provisioning')</p>
                                <p class="text-xs text-slate-500">@lang('Automatically provision services after order')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="auto_provision_enabled" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-emerald-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    {{-- Provision on Payment --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-sky-500/10">
                                <i class="ph-duotone ph-currency-dollar text-lg text-sky-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Provision on Payment')</p>
                                <p class="text-xs text-slate-500">@lang('Provision immediately after payment received')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="auto_provision_on_payment" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-sky-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    {{-- Unsuspend on Payment --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-violet-500/10">
                                <i class="ph-duotone ph-play-circle text-lg text-violet-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Unsuspend on Payment')</p>
                                <p class="text-xs text-slate-500">@lang('Automatically unsuspend when overdue invoice is paid')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="auto_unsuspend_on_payment" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-violet-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>
                </div>
            </x-admin.card>

            {{-- Auto-Billing Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-credit-card text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Auto-Billing')</h3>
                        <p class="text-sm text-slate-500">@lang('Automatic payment capture settings')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    {{-- Auto-Billing Toggle --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-indigo-500/10">
                                <i class="ph-duotone ph-arrows-clockwise text-lg text-indigo-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Enable Auto-Billing')</p>
                                <p class="text-xs text-slate-500">@lang('Automatically charge stored payment methods')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="auto_billing_enabled" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    @if($auto_billing_enabled)
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Retry Days')</label>
                            <input type="number" wire:model="auto_billing_retry_days" min="1" max="30" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <p class="text-xs text-slate-500 mt-1">@lang('Days between retry attempts')</p>
                            @error('auto_billing_retry_days') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Max Retries')</label>
                            <input type="number" wire:model="auto_billing_max_retries" min="1" max="10" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <p class="text-xs text-slate-500 mt-1">@lang('Maximum retry attempts')</p>
                            @error('auto_billing_max_retries') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                    </div>
                    @endif
                </div>
            </x-admin.card>

            {{-- Fraud Detection Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-rose-500/20 to-pink-500/20">
                        <i class="ph-duotone ph-shield-warning text-xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Fraud Detection')</h3>
                        <p class="text-sm text-slate-500">@lang('Protect against fraudulent orders')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    {{-- Fraud Check Toggle --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-rose-500/10">
                                <i class="ph-duotone ph-shield-check text-lg text-rose-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Enable Fraud Check')</p>
                                <p class="text-xs text-slate-500">@lang('Check orders for fraud before processing')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="fraud_check_enabled" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-rose-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    @if($fraud_check_enabled)
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Fraud Provider')</label>
                        <select wire:model="fraud_check_provider" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($this->fraudProviders as $key => $provider)
                                <option value="{{ $key }}" class="bg-[#1a1a24]">{{ $provider }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('API Key')</label>
                        <input type="password" wire:model="fraud_check_api_key" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="••••••••••••••••" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Auto-Reject Score')</label>
                        <div class="relative">
                            <input type="number" wire:model="fraud_auto_reject_score" min="1" max="100" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-12 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500">/100</span>
                        </div>
                        <p class="text-xs text-slate-500 mt-1">@lang('Orders with score above this will be auto-rejected')</p>
                        @error('fraud_auto_reject_score') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    @endif
                </div>
            </x-admin.card>

            {{-- Domain Automation --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-globe text-xl text-amber-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Domain Automation')</h3>
                        <p class="text-sm text-slate-500">@lang('Domain grace and redemption periods')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Grace Period')</label>
                        <div class="relative">
                            <input type="number" wire:model="domain_grace_days" min="0" max="90" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('Days')</span>
                        </div>
                        <p class="text-xs text-slate-500 mt-1">@lang('Days after expiry before domain enters redemption')</p>
                        @error('domain_grace_days') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Redemption Period')</label>
                        <div class="relative">
                            <input type="number" wire:model="domain_redemption_days" min="0" max="90" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('Days')</span>
                        </div>
                        <p class="text-xs text-slate-500 mt-1">@lang('Days in redemption before domain is released')</p>
                        @error('domain_redemption_days') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>

            {{-- Exchange Rate Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-cyan-500/20 to-blue-500/20">
                        <i class="ph-duotone ph-currency-circle-dollar text-xl text-cyan-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Exchange Rates')</h3>
                        <p class="text-sm text-slate-500">@lang('Currency exchange rate synchronization')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    {{-- Update Exchange Rate Toggle --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-cyan-500/10">
                                <i class="ph-duotone ph-arrows-clockwise text-lg text-cyan-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Auto Update Rates')</p>
                                <p class="text-xs text-slate-500">@lang('Automatically update gateway currency rates')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="update_exchange_rate" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-cyan-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    @if($update_exchange_rate)
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('ExchangeRate-API Key')</label>
                        <input type="password" wire:model="exchange_rate_api_key" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="••••••••••••••••" />
                        <p class="text-xs text-slate-500 mt-2">
                            @lang('Get your free API key from') <a href="https://www.exchangerate-api.com/" target="_blank" class="text-cyan-400 hover:underline">exchangerate-api.com</a>
                        </p>
                    </div>
                    @endif
                </div>
            </x-admin.card>


        </div>
    </form>
</div>

