<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Billing Settings')" :subtitle="__('Configure company details, invoice generation, late fees, and automation settings.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="billing-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-buildings"
            iconColor="primary"
            :label="__('Company')"
            :value="$company_name ?: __('Not Set')"
        />
        <x-admin.stat-card
            icon="ph-invoice"
            iconColor="success"
            :label="__('Invoice Prefix')"
            :value="($invoice_prefix ?: 'INV-') . ($invoice_start_number ?: '1')"
        />
        <x-admin.stat-card
            icon="ph-calendar"
            iconColor="info"
            :label="__('Due Days')"
            :value="($invoice_due_days ?? 14) . ' ' . __('days')"
        />
        <x-admin.stat-card
            icon="ph-wallet"
            iconColor="warning"
            :label="__('Credit')"
            :value="$credit_enabled ? __('Enabled') : __('Disabled')"
        />
    </div>

    <form wire:submit="save" id="billing-settings-form">
        <div class="mt-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
            {{-- Company Details for Invoices --}}
            <x-admin.card class="lg:col-span-2">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-buildings text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Company Details')</h3>
                        <p class="text-sm text-slate-500">@lang('Company information displayed on invoices')</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Company Name')</label>
                        <input type="text" wire:model="company_name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Your Company Name') }}" />
                        @error('company_name') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Email')</label>
                        <input type="email" wire:model="company_email" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="billing@company.com" />
                        @error('company_email') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Phone')</label>
                        <input type="text" wire:model="company_phone" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="+1 (555) 123-4567" />
                        @error('company_phone') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div class="md:col-span-2 lg:col-span-3">
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Address')</label>
                        <input type="text" wire:model="company_address" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Street Address') }}" />
                        @error('company_address') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('City')</label>
                        <input type="text" wire:model="company_city" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('City') }}" />
                        @error('company_city') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('State / Province')</label>
                        <input type="text" wire:model="company_state" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('State') }}" />
                        @error('company_state') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('ZIP / Postal Code')</label>
                        <input type="text" wire:model="company_zip" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="12345" />
                        @error('company_zip') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Country')</label>
                        <input type="text" wire:model="company_country" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Country') }}" />
                        @error('company_country') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Tax ID / VAT Number')</label>
                        <input type="text" wire:model="company_tax_id" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="XX-XXXXXXX" />
                        @error('company_tax_id') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div class="md:col-span-2 lg:col-span-3">
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Invoice Footer Text')</label>
                        <textarea wire:model="invoice_footer" rows="3" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-none" placeholder="{{ __('Additional text to display at the bottom of invoices (e.g., payment terms, thank you message)') }}"></textarea>
                        @error('invoice_footer') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>

            {{-- Invoice Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                        <i class="ph-duotone ph-invoice text-xl text-emerald-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Invoice Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure invoice numbering and timing')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Invoice Prefix')</label>
                            <input type="text" wire:model="invoice_prefix" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="INV-" />
                            @error('invoice_prefix') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Start Number')</label>
                            <input type="number" wire:model="invoice_start_number" min="1" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            @error('invoice_start_number') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Invoice Due Days')</label>
                        <input type="number" wire:model="invoice_due_days" min="1" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Days until invoice is due after creation')</p>
                        @error('invoice_due_days') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Invoice Generation Days')</label>
                            <button type="button" wire:click="$set('showAdvancedModal', true)" class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors">
                                (@lang('Advanced Settings'))
                            </button>
                        </div>
                        <div class="relative">
                            <input type="number" wire:model="create_default_invoice_days" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('Days')</span>
                        </div>
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Default days before due date to generate invoices')</p>
                    </div>
                </div>
            </x-admin.card>

            {{-- Late Fee Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-rose-500/20 to-pink-500/20">
                        <i class="ph-duotone ph-warning-circle text-xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Late Fee Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure late payment penalties')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Late Fee Type')</label>
                        <select wire:model="invoice_late_fee_type" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($lateFeeTypes as $key => $type)
                                <option value="{{ $key }}" class="bg-[#1a1a24]">{{ __($type) }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Late Fee Amount')</label>
                        <div class="relative">
                            <input type="number" wire:model="invoice_late_fee_amount" step="0.01" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-12 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500">{{ $invoice_late_fee_type == 2 ? '%' : '$' }}</span>
                        </div>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Late Fee Days')</label>
                        <input type="number" wire:model="invoice_late_fee_days" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Days after due date to apply late fee')</p>
                    </div>
                </div>
            </x-admin.card>

            {{-- Automation Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-robot text-xl text-amber-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Automation Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure automatic actions')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Auto Suspend Days')</label>
                        <input type="number" wire:model="auto_suspend_days" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Days after due date to suspend service (0 = disabled)')</p>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Auto Terminate Days')</label>
                        <input type="number" wire:model="auto_terminate_days" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Days after due date to terminate service (0 = disabled)')</p>
                    </div>
                </div>
            </x-admin.card>

            {{-- Invoice Reminders --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-blue-500/20">
                        <i class="ph-duotone ph-bell-ringing text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Invoice Reminders')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure payment reminder emails')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    {{-- Reminder Toggle --}}
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-indigo-500/10">
                                <i class="ph-duotone ph-envelope text-lg text-indigo-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Enable Payment Reminders')</p>
                                <p class="text-xs text-slate-500">@lang('Send email reminders for unpaid invoices')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="invoice_send_reminder" class="sr-only peer" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    @if($invoice_send_reminder)
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Invoice Unpaid Reminder')</label>
                        <div class="relative">
                            <input type="number" wire:model="invoice_send_reminder_days" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('Days')</span>
                        </div>
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Days before due date to send reminder (0 = disabled)')</p>
                    </div>
                    <div class="grid grid-cols-3 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('1st Overdue')</label>
                            <div class="relative">
                                <input type="number" wire:model="invoice_first_over_due_reminder" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                            </div>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('2nd Overdue')</label>
                            <div class="relative">
                                <input type="number" wire:model="invoice_second_over_due_reminder" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                            </div>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('3rd Overdue')</label>
                            <div class="relative">
                                <input type="number" wire:model="invoice_third_over_due_reminder" min="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                            </div>
                        </div>
                    </div>
                    <p class="text-xs text-slate-500">@lang('Days after due date to send overdue notices (0 = disabled)')</p>
                    @endif
                </div>
            </x-admin.card>

            {{-- Credit & Prorate Settings --}}
            <x-admin.card class="lg:col-span-2">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-violet-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-wallet text-xl text-violet-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Credit & Prorate')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure credit and proration')</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-4">
                        {{-- Credit Toggle --}}
                        <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                            <div class="flex items-center gap-3">
                                <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-violet-500/10">
                                    <i class="ph-duotone ph-credit-card text-lg text-violet-400"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-slate-200">@lang('Enable Credit')</p>
                                    <p class="text-xs text-slate-500">@lang('Allow customers to use account credit')</p>
                                </div>
                            </div>
                            <div class="relative">
                                <input type="checkbox" wire:model.live="credit_enabled" class="sr-only peer" />
                                <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-violet-500 transition-colors"></div>
                                <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                            </div>
                        </label>
                    </div>
                    <div class="space-y-4">
                        {{-- Prorate Toggle --}}
                        <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                            <div class="flex items-center gap-3">
                                <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-sky-500/10">
                                    <i class="ph-duotone ph-chart-pie-slice text-lg text-sky-400"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-slate-200">@lang('Enable Proration')</p>
                                    <p class="text-xs text-slate-500">@lang('Prorate charges for mid-cycle changes')</p>
                                </div>
                            </div>
                            <div class="relative">
                                <input type="checkbox" wire:model.live="prorate_enabled" class="sr-only peer" />
                                <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-sky-500 transition-colors"></div>
                                <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                            </div>
                        </label>
                        @if($prorate_enabled)
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Prorate Type')</label>
                            <select wire:model="prorate_type" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                @foreach($prorateTypes as $key => $type)
                                    <option value="{{ $key }}" class="bg-[#1a1a24]">{{ __($type) }}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
                    </div>
                </div>
            </x-admin.card>
        </div>
    </form>

    {{-- Advanced Settings Modal --}}
    @if($showAdvancedModal)
    <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex min-h-screen items-center justify-center p-4">
            {{-- Backdrop --}}
            <div class="fixed inset-0 bg-black/60 backdrop-blur-sm transition-opacity" wire:click="$set('showAdvancedModal', false)"></div>

            {{-- Modal --}}
            <div class="relative w-full max-w-4xl transform rounded-2xl bg-[#1a1a24] border border-white/10 shadow-2xl transition-all">
                {{-- Header --}}
                <div class="flex items-center justify-between px-6 py-4 border-b border-white/5">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-gear-six text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-white">@lang('Advanced Invoice Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Per billing cycle invoice generation days')</p>
                        </div>
                    </div>
                    <button type="button" wire:click="$set('showAdvancedModal', false)" class="rounded-lg p-2 text-slate-400 hover:bg-white/5 hover:text-white transition-colors">
                        <i class="ph ph-x text-xl"></i>
                    </button>
                </div>

                {{-- Body --}}
                <div class="p-6 space-y-6">
                    {{-- Per Billing Cycle Settings --}}
                    <div class="rounded-xl bg-white/[0.02] border border-white/5 p-5">
                        <div class="text-center mb-5">
                            <h4 class="text-sm font-semibold text-white mb-1">@lang('Per Billing Cycle Settings')</h4>
                            <p class="text-xs text-slate-500">@lang('Specify for certain cycles to generate further or less in advance of the due date than the default')</p>
                        </div>
                        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
                            <div>
                                <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Monthly')</label>
                                <div class="relative">
                                    <input type="number" wire:model="advancedSettings.monthly" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 pr-12 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Quarterly')</label>
                                <div class="relative">
                                    <input type="number" wire:model="advancedSettings.quarterly" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 pr-12 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Semi-Annually')</label>
                                <div class="relative">
                                    <input type="number" wire:model="advancedSettings.semi_annually" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 pr-12 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Annually')</label>
                                <div class="relative">
                                    <input type="number" wire:model="advancedSettings.annually" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 pr-12 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Biennially')</label>
                                <div class="relative">
                                    <input type="number" wire:model="advancedSettings.biennially" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 pr-12 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Triennially')</label>
                                <div class="relative">
                                    <input type="number" wire:model="advancedSettings.triennially" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 pr-12 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">@lang('Days')</span>
                                </div>
                            </div>
                        </div>
                        <p class="text-center text-xs text-slate-500 mt-4">@lang('Leave blank or 0 to use default setting for a cycle')</p>
                    </div>

                    {{-- Domain Settings --}}
                    <div class="rounded-xl bg-white/[0.02] border border-white/5 p-5">
                        <div class="text-center mb-5">
                            <h4 class="text-sm font-semibold text-white mb-1">@lang('Domain Settings')</h4>
                            <p class="text-xs text-slate-500">@lang('Days before renewal date to generate invoices for domain renewals')</p>
                        </div>
                        <div class="max-w-xs mx-auto">
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2 text-center">@lang('Domain Invoice Days')</label>
                            <div class="relative">
                                <input type="number" wire:model="create_domain_invoice_days" min="0" placeholder="0" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 text-center" />
                                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm">@lang('Days')</span>
                            </div>
                        </div>
                        <p class="text-center text-xs text-slate-500 mt-4">@lang('Leave blank or 0 to use default setting')</p>
                    </div>
                </div>

                {{-- Footer --}}
                <div class="flex items-center justify-end gap-3 px-6 py-4 border-t border-white/5">
                    <button type="button" wire:click="$set('showAdvancedModal', false)" class="px-4 py-2.5 rounded-xl text-sm font-medium text-slate-400 hover:text-white hover:bg-white/5 transition-colors">
                        @lang('Cancel')
                    </button>
                    <button type="button" wire:click="saveAdvancedSettings" class="px-5 py-2.5 rounded-xl text-sm font-medium text-white bg-indigo-500 hover:bg-indigo-600 transition-colors">
                        <span wire:loading.remove wire:target="saveAdvancedSettings">@lang('Save Settings')</span>
                        <span wire:loading wire:target="saveAdvancedSettings">@lang('Saving...')</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
