<div x-data="{ activeTab: 'system' }">
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Client Area Settings')" :subtitle="__('Configure system settings, navigation, features, design, and appearance of the client dashboard.')">
        <x-slot:actions>
            <x-admin.button type="button" wire:click="resetToDefaults" variant="secondary" icon="ph-arrow-counter-clockwise">
                @lang('Reset Defaults')
            </x-admin.button>
            <x-admin.button type="submit" form="settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-gear"
            iconColor="primary"
            :label="__('System Status')"
            :value="$registration_enabled ? __('Registration Open') : __('Registration Closed')"
        />
        <x-admin.stat-card
            icon="ph-list"
            iconColor="success"
            :label="__('Menu Items')"
            :value="collect(['menu_dashboard', 'menu_services', 'menu_domains', 'menu_invoices', 'menu_transactions', 'menu_deposits', 'menu_support', 'menu_profile', 'menu_security', 'menu_email_history', 'menu_kyc', 'menu_announcements'])->filter(fn($m) => $this->$m)->count() . ' active'"
        />
        <x-admin.stat-card
            icon="ph-toggle-left"
            iconColor="info"
            :label="__('Features')"
            :value="collect(['deposit_module', 'support_module', 'domain_module', 'announcement_module'])->filter(fn($m) => $this->$m)->count() . ' enabled'"
        />
        <x-admin.stat-card
            icon="ph-palette"
            iconColor="warning"
            :label="__('Theme')"
            :value="$font_family"
        />
    </div>

    <form wire:submit="save" id="settings-form">
        {{-- Tab Navigation Card --}}
        <x-admin.card class="mt-6" :padding="false">
            <div class="flex flex-wrap gap-1 p-2 border-b border-white/5">
                @foreach([
                    'system' => ['ph-gear-six', 'System'],
                    'navigation' => ['ph-layout', 'Navigation'],
                    'features' => ['ph-toggle-left', 'Features'],
                    'menu' => ['ph-list', 'Menu Items'],
                    'typography' => ['ph-text-aa', 'Typography'],
                    'footer' => ['ph-rows', 'Footer'],
                    'advanced' => ['ph-code', 'Advanced']
                ] as $tab => $info)
                    <button type="button"
                        @click="activeTab = '{{ $tab }}'"
                        :class="activeTab === '{{ $tab }}' ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/25' : 'text-slate-400 hover:text-white hover:bg-white/5'"
                        class="flex items-center gap-2 px-4 py-2.5 text-sm font-medium rounded-xl transition-all"
                    >
                        <i class="ph-duotone {{ $info[0] }} text-lg"></i>
                        {{ __($info[1]) }}
                    </button>
                @endforeach
            </div>
        </x-admin.card>

        {{-- SYSTEM CONFIGURATION TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'system'" x-cloak>
            <div class="grid gap-6 lg:grid-cols-2">
                {{-- Registration & Access Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                            <i class="ph-duotone ph-user-plus text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Registration & Access')</h3>
                            <p class="text-sm text-slate-500">@lang('Control user registration and access settings')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['registration_enabled', 'User Registration', 'Allow new users to register accounts', 'ph-user-plus', 'emerald'],
                            ['agree_policy', 'Terms Agreement', 'Require users to agree to terms during registration', 'ph-file-text', 'sky'],
                            ['secure_password', 'Secure Password', 'Require strong passwords (uppercase, lowercase, numbers, symbols)', 'ph-lock-key', 'amber'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-{{ $toggle[4] }}-500/10">
                                        <i class="ph-duotone {{ $toggle[3] }} text-lg text-{{ $toggle[4] }}-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">@lang($toggle[1])</p>
                                        <p class="text-xs text-slate-500">@lang($toggle[2])</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-{{ $toggle[4] }}-500 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>

                {{-- Verification Settings Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-shield-check text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Verification Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure user verification requirements')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['email_verification', 'Email Verification', 'Require email verification for new users', 'ph-envelope-simple', 'indigo'],
                            ['sms_verification', 'SMS Verification', 'Require SMS verification for new users', 'ph-device-mobile', 'violet'],
                            ['kyc_verification', 'KYC Verification', 'Require identity verification for new users', 'ph-identification-card', 'rose'],
                            ['two_factor_enabled', 'Two-Factor Auth', 'Allow users to enable 2FA for their accounts', 'ph-fingerprint', 'cyan'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-{{ $toggle[4] }}-500/10">
                                        <i class="ph-duotone {{ $toggle[3] }} text-lg text-{{ $toggle[4] }}-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">@lang($toggle[1])</p>
                                        <p class="text-xs text-slate-500">@lang($toggle[2])</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-{{ $toggle[4] }}-500 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>
            </div>

            {{-- Notifications & Advanced System Settings --}}
            <div class="mt-6 grid gap-6 lg:grid-cols-2">
                {{-- Notification Settings Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-sky-500/20 to-blue-500/20">
                            <i class="ph-duotone ph-bell-ringing text-xl text-sky-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Notification Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure system notification channels')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['email_notification', 'Email Notifications', 'Send notifications via email', 'ph-envelope', 'sky'],
                            ['sms_notification', 'SMS Notifications', 'Send notifications via SMS', 'ph-chat-circle-text', 'violet'],
                            ['push_notification', 'Push Notifications', 'Send browser push notifications', 'ph-broadcast', 'orange'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-{{ $toggle[4] }}-500/10">
                                        <i class="ph-duotone {{ $toggle[3] }} text-lg text-{{ $toggle[4] }}-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">@lang($toggle[1])</p>
                                        <p class="text-xs text-slate-500">@lang($toggle[2])</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-{{ $toggle[4] }}-500 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>

                {{-- Advanced System Settings Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                            <i class="ph-duotone ph-gear-fine text-xl text-amber-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Advanced System Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure advanced system options')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['force_ssl', 'Force SSL', 'Redirect all traffic to HTTPS', 'ph-lock-simple', 'emerald'],
                            ['multi_language', 'Multi Language', 'Enable multi-language support', 'ph-translate', 'indigo'],
                            ['auto_domain_register', 'Auto Domain Register', 'Automatically register domains with services', 'ph-globe-hemisphere-west', 'purple'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-{{ $toggle[4] }}-500/10">
                                        <i class="ph-duotone {{ $toggle[3] }} text-lg text-{{ $toggle[4] }}-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">@lang($toggle[1])</p>
                                        <p class="text-xs text-slate-500">@lang($toggle[2])</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-{{ $toggle[4] }}-500 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>
            </div>

            {{-- Important Notice --}}
            <div class="mt-6 p-4 rounded-xl bg-amber-500/10 border border-amber-500/20">
                <div class="flex gap-3">
                    <i class="ph-duotone ph-warning text-xl text-amber-400 flex-shrink-0"></i>
                    <div>
                        <p class="text-sm font-medium text-amber-300">@lang('Important Notice')</p>
                        <p class="text-xs text-amber-400/80 mt-1">@lang('These settings directly affect user registration and access. Changes take effect immediately after saving. Disabling registration will prevent new users from creating accounts.')</p>
                    </div>
                </div>
            </div>
        </x-admin.card>

        {{-- NAVIGATION TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'navigation'" x-cloak>
            <div class="grid gap-6 lg:grid-cols-2">
                {{-- Layout Style Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-layout text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Layout Style')</h3>
                            <p class="text-sm text-slate-500">@lang('Choose navigation layout for client area')</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-3">@lang('Navigation Type')</label>
                        <div class="grid grid-cols-2 gap-4">
                            <label class="relative flex cursor-pointer rounded-xl border-2 p-4 transition-all {{ $layout_style === 'sidebar' ? 'border-indigo-500 bg-indigo-500/10' : 'border-white/10 hover:border-white/20 hover:bg-white/[0.02]' }}">
                                <input type="radio" wire:model.live="layout_style" value="sidebar" class="sr-only" />
                                <div class="flex flex-col items-center gap-2 w-full">
                                    <i class="ph-duotone ph-sidebar text-3xl {{ $layout_style === 'sidebar' ? 'text-indigo-400' : 'text-slate-400' }}"></i>
                                    <span class="text-sm font-medium {{ $layout_style === 'sidebar' ? 'text-white' : 'text-slate-300' }}">@lang('Sidebar')</span>
                                    <span class="text-xs text-slate-500">@lang('Left navigation panel')</span>
                                </div>
                                @if($layout_style === 'sidebar')
                                    <div class="absolute top-2 right-2">
                                        <i class="ph-fill ph-check-circle text-indigo-400"></i>
                                    </div>
                                @endif
                            </label>
                            <label class="relative flex cursor-pointer rounded-xl border-2 p-4 transition-all {{ $layout_style === 'topnav' ? 'border-indigo-500 bg-indigo-500/10' : 'border-white/10 hover:border-white/20 hover:bg-white/[0.02]' }}">
                                <input type="radio" wire:model.live="layout_style" value="topnav" class="sr-only" />
                                <div class="flex flex-col items-center gap-2 w-full">
                                    <i class="ph-duotone ph-rows text-3xl {{ $layout_style === 'topnav' ? 'text-indigo-400' : 'text-slate-400' }}"></i>
                                    <span class="text-sm font-medium {{ $layout_style === 'topnav' ? 'text-white' : 'text-slate-300' }}">@lang('Top Navigation')</span>
                                    <span class="text-xs text-slate-500">@lang('Horizontal menu bar')</span>
                                </div>
                                @if($layout_style === 'topnav')
                                    <div class="absolute top-2 right-2">
                                        <i class="ph-fill ph-check-circle text-indigo-400"></i>
                                    </div>
                                @endif
                            </label>
                        </div>
                    </div>

                    @if($layout_style === 'sidebar')
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Sidebar Position')</label>
                        <select wire:model.live="sidebar_position" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            <option value="left" class="bg-[#1a1a24]">@lang('Left')</option>
                            <option value="right" class="bg-[#1a1a24]">@lang('Right')</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Sidebar Width')</label>
                        <div class="flex items-center gap-4">
                            <input type="range" wire:model.live="sidebar_width" min="240" max="320" step="10" class="flex-1 h-2 bg-white/10 rounded-full appearance-none cursor-pointer accent-indigo-500" />
                            <span class="text-sm font-mono text-indigo-400 bg-indigo-500/10 px-3 py-1 rounded-lg">{{ $sidebar_width }}px</span>
                        </div>
                    </div>
                    @endif

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Mobile Menu Style')</label>
                        <select wire:model.live="mobile_menu_style" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            <option value="hamburger" class="bg-[#1a1a24]">@lang('Hamburger Menu')</option>
                            <option value="bottom_tabs" class="bg-[#1a1a24]">@lang('Bottom Tab Bar')</option>
                        </select>
                    </div>
                </div>

                {{-- Header Settings Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                            <i class="ph-duotone ph-browser text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Header Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure header elements')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['header_sticky', 'Sticky Header', 'Keep header fixed at top when scrolling', 'ph-push-pin'],
                            ['show_breadcrumbs', 'Show Breadcrumbs', 'Display navigation breadcrumbs', 'ph-path'],
                            ['show_notification_bell', 'Notification Bell', 'Show notification icon in header', 'ph-bell'],
                            ['show_user_balance', 'User Balance', 'Display wallet balance in header', 'ph-wallet'],
                            ['show_cart_icon', 'Cart Icon', 'Show shopping cart in header', 'ph-shopping-cart'],
                            ['show_search', 'Search Bar', 'Enable search functionality', 'ph-magnifying-glass'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 group-hover:bg-white/10 transition-colors">
                                        <i class="ph-duotone {{ $toggle[3] }} text-slate-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">{{ __($toggle[1]) }}</p>
                                        <p class="text-xs text-slate-500">{{ __($toggle[2]) }}</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-indigo-600 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>
            </div>
        </x-admin.card>

        {{-- FEATURES TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'features'" x-cloak>
            <div class="grid gap-6 lg:grid-cols-2">
                {{-- Module Toggles Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-toggle-left text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Module Toggles')</h3>
                            <p class="text-sm text-slate-500">@lang('Enable or disable client area modules')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['deposit_module', 'Deposit Module', 'Allow users to add funds to wallet', 'ph-wallet', 'indigo'],
                            ['support_module', 'Support Tickets', 'Enable support ticket system', 'ph-headset', 'emerald'],
                            ['domain_module', 'Domain Management', 'Enable domain management features', 'ph-globe', 'sky'],
                            ['announcement_module', 'Announcements', 'Show announcements to users', 'ph-megaphone', 'rose'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-{{ $toggle[4] }}-500/10 group-hover:bg-{{ $toggle[4] }}-500/20 transition-colors">
                                        <i class="ph-duotone {{ $toggle[3] }} text-xl text-{{ $toggle[4] }}-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">{{ __($toggle[1]) }}</p>
                                        <p class="text-xs text-slate-500">{{ __($toggle[2]) }}</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-{{ $toggle[4] }}-600 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>

                {{-- Feature Settings Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                            <i class="ph-duotone ph-gear text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Feature Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure specific features')</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @foreach([
                            ['kyc_required', 'Require KYC', 'Users must complete KYC verification', 'ph-identification-card'],
                            ['email_history_enabled', 'Email History', 'Show email history to users', 'ph-envelope'],
                            ['service_cancellation', 'Service Cancellation', 'Allow users to request cancellation', 'ph-x-circle'],
                            ['invoice_download', 'Invoice Download', 'Allow PDF invoice download', 'ph-file-pdf'],
                            ['invoice_preview', 'Invoice Preview', 'Show invoice preview before download', 'ph-eye'],
                        ] as $toggle)
                            <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 group-hover:bg-white/10 transition-colors">
                                        <i class="ph-duotone {{ $toggle[3] }} text-slate-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-200">{{ __($toggle[1]) }}</p>
                                        <p class="text-xs text-slate-500">{{ __($toggle[2]) }}</p>
                                    </div>
                                </div>
                                <div class="relative">
                                    <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                    <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-emerald-600 transition-colors"></div>
                                    <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                </div>
                            </label>
                        @endforeach
                    </div>

                    @if($layout_style === 'sidebar')
                    {{-- Sidebar Options --}}
                    <div class="pt-4 mt-4 border-t border-white/5">
                        <div class="flex items-center gap-3 pb-4">
                            <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-violet-500/20 to-purple-500/20">
                                <i class="ph-duotone ph-sidebar text-xl text-violet-400"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-white">@lang('Sidebar Options')</h3>
                                <p class="text-sm text-slate-500">@lang('Additional sidebar settings')</p>
                            </div>
                        </div>

                        <div class="space-y-3">
                            @foreach([
                                ['sidebar_collapsible', 'Collapsible Sidebar', 'Allow users to collapse sidebar', 'ph-arrows-in-line-horizontal'],
                                ['show_sidebar_balance', 'Show Balance', 'Display wallet balance in sidebar', 'ph-wallet'],
                                ['show_quick_actions', 'Quick Actions', 'Show quick action buttons', 'ph-lightning'],
                            ] as $toggle)
                                <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 group-hover:bg-white/10 transition-colors">
                                            <i class="ph-duotone {{ $toggle[3] }} text-slate-400"></i>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-slate-200">{{ __($toggle[1]) }}</p>
                                            <p class="text-xs text-slate-500">{{ __($toggle[2]) }}</p>
                                        </div>
                                    </div>
                                    <div class="relative">
                                        <input type="checkbox" wire:model.live="{{ $toggle[0] }}" class="sr-only peer" />
                                        <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-violet-600 transition-colors"></div>
                                        <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </x-admin.card>

        {{-- MENU ITEMS TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'menu'" x-cloak>
            {{-- New Menu Manager Notice --}}
            <div class="mb-6 p-4 rounded-xl bg-gradient-to-r from-indigo-500/10 to-purple-500/10 border border-indigo-500/20">
                <div class="flex items-start gap-4">
                    <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-indigo-500/20 flex-shrink-0">
                        <i class="ph-duotone ph-sparkle text-2xl text-indigo-400"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="text-sm font-semibold text-white mb-1">@lang('Advanced Menu Manager Available')</h4>
                        <p class="text-sm text-slate-400 mb-3">
                            @lang('For more control over your menus, use the new Menu Manager. It allows you to create custom menus, add nested items, link to pages, and manage social links.')
                        </p>
                        <a href="{{ route('admin.menus.index') }}" class="inline-flex items-center gap-2 px-4 py-2 text-sm font-medium text-white bg-indigo-600 rounded-lg hover:bg-indigo-500 transition-colors">
                            <i class="ph-duotone ph-layout text-lg"></i>
                            @lang('Open Menu Manager')
                        </a>
                    </div>
                </div>
            </div>

            <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                    <i class="ph-duotone ph-list text-xl text-indigo-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-white">@lang('Legacy Menu Toggles')</h3>
                    <p class="text-sm text-slate-500">@lang('Quick toggles for default menu items (used when no custom menu is configured)')</p>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/5 bg-white/[0.02]">
                            <th class="px-4 py-3 text-left">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Menu Item')</span>
                            </th>
                            <th class="px-4 py-3 text-left">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Description')</span>
                            </th>
                            <th class="px-4 py-3 text-center">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Visible')</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @foreach([
                            ['menu_dashboard', 'Dashboard', 'ph-house', 'Main dashboard overview page'],
                            ['menu_services', 'Services', 'ph-cube', 'Active services and hosting accounts'],
                            ['menu_domains', 'Domains', 'ph-globe', 'Domain management and registration'],
                            ['menu_invoices', 'Invoices', 'ph-receipt', 'Billing invoices and payment history'],
                            ['menu_transactions', 'Transactions', 'ph-arrows-left-right', 'Transaction history and records'],
                            ['menu_deposits', 'Deposits', 'ph-wallet', 'Add funds to wallet balance'],
                            ['menu_support', 'Support', 'ph-headset', 'Support tickets and help center'],
                            ['menu_profile', 'Profile', 'ph-user', 'User profile and account settings'],
                            ['menu_security', 'Security', 'ph-shield-check', 'Security settings and 2FA'],
                            ['menu_email_history', 'Email History', 'ph-envelope', 'Sent email notifications log'],
                            ['menu_kyc', 'KYC Verification', 'ph-identification-card', 'Identity verification status'],
                            ['menu_announcements', 'Announcements', 'ph-megaphone', 'System announcements and news'],
                        ] as $item)
                            <tr class="group transition-all hover:bg-white/[0.02]">
                                <td class="px-4 py-3">
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-white/5 group-hover:bg-white/10 transition-colors">
                                            <i class="ph-duotone {{ $item[2] }} text-lg text-slate-400"></i>
                                        </div>
                                        <span class="text-sm font-medium text-slate-200">{{ __($item[1]) }}</span>
                                    </div>
                                </td>
                                <td class="px-4 py-3">
                                    <span class="text-sm text-slate-500">{{ __($item[3]) }}</span>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <label class="relative inline-flex cursor-pointer">
                                        <input type="checkbox" wire:model.live="{{ $item[0] }}" class="sr-only peer" />
                                        <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-indigo-600 transition-colors"></div>
                                        <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                                    </label>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </x-admin.card>

        {{-- TYPOGRAPHY TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'typography'" x-cloak>
            <div class="grid gap-6 lg:grid-cols-2">
                {{-- Font Settings Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-text-aa text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Font Settings')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure typography for client area')</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Primary Font')</label>
                        <select wire:model.live="font_family" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($fontOptions as $name => $url)
                                <option value="{{ $name }}" class="bg-[#1a1a24]">{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Custom Font URL')</label>
                        <input type="text" wire:model="font_url" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="https://fonts.googleapis.com/..." />
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Base Font Size')</label>
                        <div class="flex items-center gap-4">
                            <input type="range" wire:model.live="base_font_size" min="12" max="20" class="flex-1 h-2 bg-white/10 rounded-full appearance-none cursor-pointer accent-indigo-500" />
                            <span class="text-sm font-mono text-indigo-400 bg-indigo-500/10 px-3 py-1 rounded-lg">{{ $base_font_size }}px</span>
                        </div>
                    </div>
                </div>

                {{-- Font Preview Section --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-3 pb-4 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                            <i class="ph-duotone ph-eye text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Font Preview')</h3>
                            <p class="text-sm text-slate-500">@lang('See how your font choices look')</p>
                        </div>
                    </div>

                    <div class="space-y-4 p-5 rounded-xl bg-white/[0.02] border border-white/5" style="font-family: {{ $font_family }}, sans-serif; font-size: {{ $base_font_size }}px;">
                        <h1 class="text-2xl font-bold text-white">Heading Example</h1>
                        <p class="text-slate-300">The quick brown fox jumps over the lazy dog. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                        <p class="text-sm text-slate-500">Secondary text example with smaller size for descriptions and captions.</p>
                        <div class="flex gap-3 pt-2">
                            <span class="px-3 py-1 text-xs font-medium rounded-full bg-indigo-500/20 text-indigo-400">Badge</span>
                            <span class="px-3 py-1 text-xs font-medium rounded-full bg-emerald-500/20 text-emerald-400">Active</span>
                        </div>
                    </div>
                </div>
            </div>
        </x-admin.card>



        {{-- FOOTER TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'footer'" x-cloak>
            <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                    <i class="ph-duotone ph-rows text-xl text-indigo-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-white">@lang('Footer Settings')</h3>
                    <p class="text-sm text-slate-500">@lang('Configure client area footer')</p>
                </div>
            </div>

            <div class="grid gap-6 lg:grid-cols-2">
                <div class="space-y-5">
                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 group-hover:bg-white/10 transition-colors">
                                <i class="ph-duotone ph-eye text-slate-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Show Footer')</p>
                                <p class="text-xs text-slate-500">@lang('Display footer in client area')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="show_footer" class="sr-only peer" />
                            <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-indigo-600 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>

                    <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 group-hover:bg-white/10 transition-colors">
                                <i class="ph-duotone ph-share-network text-slate-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-slate-200">@lang('Show Social Links')</p>
                                <p class="text-xs text-slate-500">@lang('Display social media links in footer')</p>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="checkbox" wire:model.live="show_social_links" class="sr-only peer" />
                            <div class="w-11 h-6 bg-slate-700 rounded-full peer peer-checked:bg-indigo-600 transition-colors"></div>
                            <div class="absolute left-0.5 top-0.5 w-5 h-5 bg-white rounded-full shadow-sm transition-transform peer-checked:translate-x-5"></div>
                        </div>
                    </label>
                </div>

                <div>
                    <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Footer Text')</label>
                    <textarea wire:model="footer_text" rows="4" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="© 2024 Your Company. All rights reserved."></textarea>
                </div>
            </div>
        </x-admin.card>

        {{-- ADVANCED TAB --}}
        <x-admin.card class="mt-6" x-show="activeTab === 'advanced'" x-cloak>
            <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-violet-500/20 to-purple-500/20">
                    <i class="ph-duotone ph-code text-xl text-violet-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-white">@lang('Advanced Customization')</h3>
                    <p class="text-sm text-slate-500">@lang('Custom CSS, welcome messages, and advanced settings')</p>
                </div>
            </div>

            <div class="grid gap-6 lg:grid-cols-2">
                {{-- Welcome Message Customization --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-2 pb-3 border-b border-white/5">
                        <i class="ph-duotone ph-hand-waving text-slate-400"></i>
                        <div>
                            <span class="text-sm font-semibold text-white">@lang('Welcome Message')</span>
                            <p class="text-xs text-slate-500">@lang('Customize the dashboard greeting')</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Welcome Title')</label>
                        <input type="text" wire:model="welcome_title" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="Welcome back, :name!" />
                        <small class="block mt-1 text-xs text-slate-500">@lang('Use :name to display user\'s first name')</small>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Welcome Subtitle')</label>
                        <input type="text" wire:model="welcome_subtitle" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="Here's what's happening with your account today." />
                        <small class="block mt-1 text-xs text-slate-500">@lang('Subtitle shown below the welcome title')</small>
                    </div>

                    {{-- Preview --}}
                    <div class="p-4 rounded-xl bg-white/[0.02] border border-white/5">
                        <p class="text-xs text-slate-500 mb-2">@lang('Preview')</p>
                        <h3 class="text-lg font-semibold text-white">{{ str_replace(':name', 'John', $welcome_title) }}</h3>
                        <p class="text-sm text-slate-400">{{ $welcome_subtitle }}</p>
                    </div>
                </div>

                {{-- Custom CSS --}}
                <div class="space-y-5">
                    <div class="flex items-center gap-2 pb-3 border-b border-white/5">
                        <i class="ph-duotone ph-file-css text-slate-400"></i>
                        <div>
                            <span class="text-sm font-semibold text-white">@lang('Custom CSS')</span>
                            <p class="text-xs text-slate-500">@lang('Add custom styles to client area')</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Custom CSS Code')</label>
                        <textarea wire:model="custom_css" rows="12" class="w-full rounded-xl border border-white/10 bg-slate-900 px-4 py-3 text-sm text-emerald-400 font-mono placeholder-slate-600 transition-all focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="/* Add your custom CSS here */
.my-custom-class {
    color: #fff;
}"></textarea>
                        <small class="block mt-1 text-xs text-slate-500">@lang('CSS will be injected into the client area. Use with caution.')</small>
                    </div>
                </div>
            </div>

            {{-- Theme Import/Export --}}
            <div class="mt-6 pt-6 border-t border-white/5">
                <div class="flex items-center gap-2 pb-4">
                    <i class="ph-duotone ph-download-simple text-slate-400"></i>
                    <div>
                        <span class="text-sm font-semibold text-white">@lang('Theme Import/Export')</span>
                        <p class="text-xs text-slate-500">@lang('Backup or restore your theme settings')</p>
                    </div>
                </div>

                <div class="grid gap-6 lg:grid-cols-2">
                    {{-- Export --}}
                    <div class="p-4 rounded-xl bg-white/[0.02] border border-white/5">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10">
                                <i class="ph-duotone ph-export text-lg text-emerald-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Export Theme')</p>
                                <p class="text-xs text-slate-500">@lang('Download current settings as JSON')</p>
                            </div>
                        </div>
                        <button type="button" wire:click="exportTheme" class="w-full px-4 py-2.5 text-sm font-medium text-white bg-emerald-600 hover:bg-emerald-700 rounded-xl transition-all">
                            <i class="ph ph-download-simple mr-2"></i>
                            @lang('Export Theme')
                        </button>
                    </div>

                    {{-- Import --}}
                    <div class="p-4 rounded-xl bg-white/[0.02] border border-white/5">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-500/10">
                                <i class="ph-duotone ph-upload-simple text-lg text-indigo-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Import Theme')</p>
                                <p class="text-xs text-slate-500">@lang('Upload a theme JSON file')</p>
                            </div>
                        </div>
                        <div class="space-y-3">
                            <input type="file" wire:model="themeImportFile" accept=".json" class="w-full text-sm text-slate-400 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-indigo-500/10 file:text-indigo-400 hover:file:bg-indigo-500/20 cursor-pointer" />
                            @error('themeImportFile') <span class="text-xs text-red-400">{{ $message }}</span> @enderror
                            <button type="button" wire:click="importTheme" @if(!$themeImportFile) disabled @endif class="w-full px-4 py-2.5 text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 disabled:opacity-50 disabled:cursor-not-allowed rounded-xl transition-all">
                                <i class="ph ph-upload-simple mr-2"></i>
                                @lang('Import Theme')
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Warning Notice --}}
            <div class="mt-6 p-4 rounded-xl bg-amber-500/10 border border-amber-500/20">
                <div class="flex gap-3">
                    <i class="ph-duotone ph-warning text-xl text-amber-400 shrink-0"></i>
                    <div>
                        <p class="text-sm font-medium text-amber-300">@lang('Advanced Settings Warning')</p>
                        <p class="text-xs text-amber-400/80 mt-1">@lang('Custom CSS can break the layout if not used correctly. Test changes thoroughly before deploying to production. Invalid CSS will be ignored by browsers.')</p>
                    </div>
                </div>
            </div>
        </x-admin.card>
    </form>
</div>
