<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Cookie / GDPR Settings')" :subtitle="__('Configure cookie consent banner and GDPR compliance.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="cookie-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Settings')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-cookie"
            iconColor="primary"
            :label="__('Cookie Banner')"
            :value="$status ? __('Active') : __('Inactive')"
        />
        <x-admin.stat-card
            icon="ph-text-aa"
            iconColor="info"
            :label="__('Short Description')"
            :value="$short_desc ? (strlen($short_desc) . ' ' . __('chars')) : __('Not Set')"
        />
        <x-admin.stat-card
            icon="ph-file-text"
            iconColor="success"
            :label="__('Full Policy')"
            :value="$description ? __('Configured') : __('Not Set')"
        />
    </div>

    <form wire:submit="save" id="cookie-settings-form">
        <div class="mt-6 grid grid-cols-1 xl:grid-cols-3 gap-6">
            {{-- Status Card --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-cookie text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Cookie Consent')</h3>
                        <p class="text-sm text-slate-500">@lang('Enable or disable banner')</p>
                    </div>
                </div>

                <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                    <div class="flex items-center gap-3">
                        <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-indigo-500/10">
                            <i class="ph-duotone ph-eye text-lg text-indigo-400"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-slate-200">@lang('Cookie Banner')</p>
                            <p class="text-xs text-slate-500">{{ $status ? __('Banner is visible') : __('Banner is hidden') }}</p>
                        </div>
                    </div>
                    <div class="relative">
                        <input type="checkbox" wire:model.live="status" class="sr-only peer" />
                        <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                        <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                    </div>
                </label>

                @if($status)
                <div class="mt-4 p-4 bg-emerald-500/10 border border-emerald-500/20 rounded-xl">
                    <div class="flex items-center gap-2 text-emerald-400">
                        <i class="ph-duotone ph-check-circle text-lg"></i>
                        <span class="text-sm font-medium">@lang('Cookie consent is active')</span>
                    </div>
                    <p class="text-xs text-emerald-400/70 mt-1">@lang('Visitors will see the cookie consent banner.')</p>
                </div>
                @endif

                {{-- Preview --}}
                <div class="mt-4">
                    <p class="text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Banner Preview')</p>
                    <div class="p-4 bg-slate-900/50 rounded-xl border border-white/10">
                        <p class="text-xs text-slate-300 line-clamp-2">{{ $short_desc ?: __('Your cookie consent message will appear here...') }}</p>
                        <div class="flex gap-2 mt-3">
                            <span class="px-3 py-1.5 bg-indigo-600 text-white text-xs font-medium rounded-lg">@lang('Accept')</span>
                            <span class="px-3 py-1.5 bg-white/10 text-slate-300 text-xs font-medium rounded-lg">@lang('Learn More')</span>
                        </div>
                    </div>
                </div>
            </x-admin.card>

            {{-- Content Form --}}
            <div class="xl:col-span-2">
                <x-admin.card>
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                            <i class="ph-duotone ph-note-pencil text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Cookie Content')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure banner text and policy')</p>
                        </div>
                    </div>

                    <div class="space-y-5">
                        {{-- Short Description --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Short Description')</label>
                            <textarea wire:model="short_desc" rows="3" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-none" placeholder="{{ __('We use cookies to enhance your browsing experience...') }}"></textarea>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('This appears in the cookie banner. Max 500 characters.')</p>
                            @error('short_desc') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>

                        {{-- Full Description --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Full Cookie Policy')</label>
                            <textarea wire:model="description" rows="8" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-none" placeholder="{{ __('Enter your full cookie policy here...') }}"></textarea>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('This appears when users click "Learn More". HTML is allowed.')</p>
                            @error('description') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </x-admin.card>
            </div>
        </div>
    </form>
</div>
