<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Custom CSS')" :subtitle="__('Add custom CSS styles for the user interface.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="custom-css-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-file-css"
            iconColor="primary"
            :label="__('File')"
            value="custom.css"
        />
        <x-admin.stat-card
            icon="ph-text-aa"
            iconColor="info"
            :label="__('Characters')"
            :value="strlen($css)"
        />
        <x-admin.stat-card
            icon="ph-folder-simple"
            iconColor="success"
            :label="__('Location')"
            value="assets/css/"
        />
    </div>

    <div class="mt-6 grid grid-cols-1 xl:grid-cols-4 gap-6">
        {{-- Main Editor --}}
        <div class="xl:col-span-3">
            <x-admin.card>
                <form wire:submit="save" id="custom-css-form">
                    {{-- Warning Banner --}}
                    <div class="mb-6 p-4 bg-amber-500/10 border border-amber-500/20 rounded-xl">
                        <div class="flex items-start gap-3">
                            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-amber-500/20 shrink-0">
                                <i class="ph-duotone ph-warning text-lg text-amber-400"></i>
                            </div>
                            <div>
                                <p class="text-amber-300 text-sm font-medium">@lang('Caution Required')</p>
                                <p class="text-amber-400/80 text-xs mt-1">
                                    @lang('Changing content on this page requires programming knowledge. Please do not change, edit, or add anything without proper understanding. The website may misbehave due to any mistakes.')
                                </p>
                            </div>
                        </div>
                    </div>

                    {{-- Section Header --}}
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-file-css text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Custom Stylesheet')</h3>
                            <p class="text-sm text-slate-500">assets/css/custom.css</p>
                        </div>
                    </div>

                    {{-- Code Editor --}}
                    <div class="relative">
                        <div class="absolute top-3 left-3 flex items-center gap-2 z-10">
                            <span class="px-2 py-1 text-[10px] font-mono uppercase tracking-wider bg-emerald-500/10 text-emerald-400 rounded-md">CSS</span>
                        </div>
                        <textarea
                            wire:model="css"
                            rows="24"
                            spellcheck="false"
                            class="w-full rounded-xl border border-white/10 bg-slate-900/80 px-4 py-3 pt-12 text-sm text-white placeholder-slate-600 font-mono leading-relaxed transition-all focus:border-indigo-500/50 focus:bg-slate-900 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-y"
                            placeholder="{{ __('/* Add your custom CSS styles here */') }}

.example-class {
    color: #fff;
    background: #1e293b;
}"
                        ></textarea>
                    </div>
                </form>
            </x-admin.card>
        </div>

        {{-- Sidebar --}}
        <div class="xl:col-span-1 space-y-6">
            {{-- Quick Reference --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-code text-lg text-indigo-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('Quick Reference')</h3>
                </div>
                <div class="space-y-3">
                    <div class="p-3 bg-white/5 rounded-xl border border-white/5">
                        <p class="text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('CSS Variables')</p>
                        <code class="text-xs text-indigo-400 font-mono">--primary-color</code>
                    </div>
                    <div class="p-3 bg-white/5 rounded-xl border border-white/5">
                        <p class="text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Override Classes')</p>
                        <code class="text-xs text-emerald-400 font-mono">.btn-primary</code>
                    </div>
                    <div class="p-3 bg-white/5 rounded-xl border border-white/5">
                        <p class="text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Important Rule')</p>
                        <code class="text-xs text-amber-400 font-mono">!important</code>
                    </div>
                </div>
            </x-admin.card>

            {{-- Tips --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-lightbulb text-lg text-amber-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('Tips')</h3>
                </div>
                <ul class="space-y-2.5">
                    <li class="flex items-start gap-2.5 text-xs text-slate-400">
                        <i class="ph-bold ph-check-circle text-emerald-400 mt-0.5 shrink-0"></i>
                        <span>@lang('Use browser DevTools to inspect elements')</span>
                    </li>
                    <li class="flex items-start gap-2.5 text-xs text-slate-400">
                        <i class="ph-bold ph-check-circle text-emerald-400 mt-0.5 shrink-0"></i>
                        <span>@lang('Test on multiple screen sizes')</span>
                    </li>
                    <li class="flex items-start gap-2.5 text-xs text-slate-400">
                        <i class="ph-bold ph-check-circle text-emerald-400 mt-0.5 shrink-0"></i>
                        <span>@lang('Use specific selectors to avoid conflicts')</span>
                    </li>
                    <li class="flex items-start gap-2.5 text-xs text-slate-400">
                        <i class="ph-bold ph-check-circle text-emerald-400 mt-0.5 shrink-0"></i>
                        <span>@lang('Clear browser cache after changes')</span>
                    </li>
                </ul>
            </x-admin.card>

            {{-- File Info --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-slate-500/20 to-slate-600/20">
                        <i class="ph-duotone ph-info text-lg text-slate-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('File Information')</h3>
                </div>
                <div class="space-y-3 text-xs">
                    <div class="flex justify-between items-center p-2.5 rounded-lg bg-white/5">
                        <span class="text-slate-500">@lang('Location')</span>
                        <span class="text-slate-400 font-mono">public/assets/css/</span>
                    </div>
                    <div class="flex justify-between items-center p-2.5 rounded-lg bg-white/5">
                        <span class="text-slate-500">@lang('Filename')</span>
                        <span class="text-slate-400 font-mono">custom.css</span>
                    </div>
                    <div class="flex justify-between items-center p-2.5 rounded-lg bg-white/5">
                        <span class="text-slate-500">@lang('Characters')</span>
                        <span class="text-slate-400 font-mono">{{ strlen($css) }}</span>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>
</div>
