<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('General Settings')" :subtitle="__('Configure site name, currency, timezone, and invoice settings.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="general-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-4 sm:mt-6 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto pb-2 sm:pb-0">
        <div class="flex sm:grid sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 min-w-max sm:min-w-0">
            <x-admin.stat-card
                icon="ph-globe"
                iconColor="primary"
                :label="__('Site Name')"
                :value="$site_name ?: __('Not Set')"
                class="min-w-[140px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-currency-circle-dollar"
                iconColor="success"
                :label="__('Currency')"
                :value="($cur_sym ?: '$') . ' ' . ($cur_text ?: 'USD')"
                class="min-w-[140px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-clock"
                iconColor="info"
                :label="__('Timezone')"
                :value="$timezone ?: 'UTC'"
                class="min-w-[140px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-list-numbers"
                iconColor="warning"
                :label="__('Pagination')"
                :value="$paginate_number . ' ' . __('items')"
                class="min-w-[140px] sm:min-w-0"
            />
        </div>
    </div>

    <form wire:submit="save" id="general-settings-form">
        <div class="mt-4 sm:mt-6 grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
            {{-- Site Information --}}
            <x-admin.card class="h-fit">
                <div class="flex items-center gap-3 pb-3 sm:pb-4 mb-4 sm:mb-5 border-b border-white/5">
                    <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-globe text-lg sm:text-xl text-indigo-400"></i>
                    </div>
                    <div class="min-w-0">
                        <h3 class="font-semibold text-white text-sm sm:text-base">@lang('Site Information')</h3>
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Basic site configuration')</p>
                    </div>
                </div>

                <div class="space-y-4 sm:space-y-5">
                    {{-- Site Name --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Site Name')</label>
                        <input type="text" wire:model="site_name" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-2.5 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Your Site Name') }}" />
                        @error('site_name') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    {{-- Timezone --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Timezone')</label>
                        <select wire:model="timezone" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($timezones as $tz)
                                <option value="{{ $tz }}" class="bg-[#1a1a24]">{{ $tz }}</option>
                            @endforeach
                        </select>
                        @error('timezone') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    {{-- Pagination --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Items Per Page')</label>
                        <select wire:model="paginate_number" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($paginateOptions as $option)
                                <option value="{{ $option }}" class="bg-[#1a1a24]">{{ $option }}</option>
                            @endforeach
                        </select>
                        @error('paginate_number') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>

            {{-- Currency Settings --}}
            <x-admin.card class="h-fit">
                <div class="flex items-center gap-3 pb-3 sm:pb-4 mb-4 sm:mb-5 border-b border-white/5">
                    <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                        <i class="ph-duotone ph-currency-circle-dollar text-lg sm:text-xl text-emerald-400"></i>
                    </div>
                    <div class="min-w-0">
                        <h3 class="font-semibold text-white text-sm sm:text-base">@lang('Currency Settings')</h3>
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Configure currency display')</p>
                    </div>
                </div>

                <div class="space-y-4 sm:space-y-5">
                    <div class="grid grid-cols-2 gap-3 sm:gap-4">
                        {{-- Currency Text --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Currency Code')</label>
                            <input type="text" wire:model="cur_text" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="USD" />
                            @error('cur_text') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>

                        {{-- Currency Symbol --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Symbol')</label>
                            <input type="text" wire:model="cur_sym" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="$" />
                            @error('cur_sym') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    {{-- Currency Format --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Currency Format')</label>
                        <select wire:model="currency_format" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($currencyFormats as $key => $format)
                                <option value="{{ $key }}" class="bg-[#1a1a24]">{{ $format }}</option>
                            @endforeach
                        </select>
                        @error('currency_format') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>
        </div>
    </form>

    {{-- Mobile Sticky Save Button --}}
    <div class="fixed bottom-0 left-0 right-0 p-4 bg-[#0a0a0f]/95 backdrop-blur-sm border-t border-white/5 sm:hidden z-40">
        <x-admin.button type="submit" form="general-settings-form" class="w-full" icon="ph-floppy-disk">
            <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
            <span wire:loading wire:target="save">@lang('Saving...')</span>
        </x-admin.button>
    </div>
    <div class="h-20 sm:hidden"></div>
</div>

