<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('KYC Settings')" :subtitle="__('Configure Know Your Customer verification system')">
        <x-slot:actions>
            <a href="{{ route('admin.kyc.index') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                <i class="ph-duotone ph-users-three"></i>
                @lang('Manage KYC Requests')
                @if($stats['pending_count'] > 0)
                    <span class="ml-1 flex h-5 min-w-5 items-center justify-center rounded-full bg-amber-500/20 px-1.5 text-xs font-medium text-amber-400">{{ $stats['pending_count'] }}</span>
                @endif
            </a>
            <x-admin.button wire:click="save" wire:loading.attr="disabled" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save All Settings')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-4">
        <x-admin.stat-card
            icon="ph-hourglass"
            iconColor="warning"
            :label="__('Pending Review')"
            :value="$stats['pending_count']"
        />
        <x-admin.stat-card
            icon="ph-seal-check"
            iconColor="success"
            :label="__('Verified')"
            :value="$stats['verified_count']"
        />
        <x-admin.stat-card
            icon="ph-x-circle"
            iconColor="danger"
            :label="__('Rejected')"
            :value="$stats['rejected_count']"
        />
        <x-admin.stat-card
            icon="ph-files"
            iconColor="info"
            :label="__('Total Submissions')"
            :value="$stats['total_submissions']"
        />
    </div>

    <div class="mt-6 grid grid-cols-1 gap-6 lg:grid-cols-2">
        {{-- KYC Configuration Card --}}
        <x-admin.card>
            <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                    <i class="ph-duotone ph-gear text-xl text-indigo-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-white">@lang('KYC Configuration')</h3>
                    <p class="text-sm text-slate-500">@lang('General KYC system settings')</p>
                </div>
            </div>

            <div class="space-y-5">
                {{-- Enable KYC --}}
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Enable KYC Verification')</p>
                        <p class="text-xs text-slate-500">@lang('Allow users to submit identity verification')</p>
                    </div>
                    <x-admin.toggle wire:click="toggleKycEnabled" :checked="$kyc_enabled" />
                </div>

                <div class="border-t border-white/5"></div>

                {{-- Required for Orders --}}
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Require KYC for Orders')</p>
                        <p class="text-xs text-slate-500">@lang('Users must verify identity before placing orders')</p>
                    </div>
                    <x-admin.toggle wire:model.live="kyc_required_for_orders" :checked="$kyc_required_for_orders" />
                </div>

                <div class="border-t border-white/5"></div>

                {{-- Auto Approve --}}
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Auto-Approve KYC')</p>
                        <p class="text-xs text-slate-500">@lang('Automatically approve all KYC submissions')</p>
                    </div>
                    <x-admin.toggle wire:model.live="kyc_auto_approve" :checked="$kyc_auto_approve" />
                </div>

                <div class="border-t border-white/5"></div>

                {{-- Verification Level --}}
                <div>
                    <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Required Verification Level')</label>
                    <select wire:model.live="kyc_required_level" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        @foreach($this->verificationLevels as $level => $label)
                            <option value="{{ $level }}" class="bg-[#1a1a24]">{{ __($label) }}</option>
                        @endforeach
                    </select>
                    <p class="text-xs text-slate-500 mt-1.5">@lang('Minimum verification level required for verified status')</p>
                </div>
            </div>
        </x-admin.card>

        {{-- Accepted Document Types --}}
        <x-admin.card>
            <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                    <i class="ph-duotone ph-file-doc text-xl text-emerald-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-white">@lang('Accepted Document Types')</h3>
                    <p class="text-sm text-slate-500">@lang('Documents users can submit for verification')</p>
                </div>
            </div>

            <div class="space-y-3">
                @foreach($this->availableDocumentTypes as $type => $label)
                    <label class="flex cursor-pointer items-center gap-3 rounded-xl border border-white/10 bg-white/5 p-4 transition-all hover:bg-white/10 {{ in_array($type, $kyc_document_types) ? 'border-emerald-500/30 bg-emerald-500/5' : '' }}">
                        <input type="checkbox" wire:model.live="kyc_document_types" value="{{ $type }}"
                            class="h-5 w-5 rounded border-white/20 bg-white/10 text-emerald-500 focus:ring-emerald-500/20 focus:ring-offset-0" />
                        <div class="flex-1">
                            <p class="text-sm font-medium text-white">{{ __($label) }}</p>
                        </div>
                        @if(in_array($type, $kyc_document_types))
                            <i class="ph-duotone ph-check-circle text-emerald-400"></i>
                        @endif
                    </label>
                @endforeach
            </div>
        </x-admin.card>
    </div>

    {{-- KYC Form Fields --}}
    <x-admin.card class="mt-6">
        <div class="flex items-center justify-between gap-3 pb-4 mb-5 border-b border-white/5">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                    <i class="ph-duotone ph-list-checks text-xl text-amber-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-white">@lang('Custom Form Fields')</h3>
                    <p class="text-sm text-slate-500">@lang('Additional fields users must complete for verification')</p>
                </div>
            </div>
            <x-admin.button wire:click="openAddFieldModal" icon="ph-plus" size="sm" variant="secondary">
                @lang('Add Field')
            </x-admin.button>
        </div>

        @if(count($fields) > 0)
            <div class="space-y-3">
                @foreach($fields as $index => $field)
                    <div class="group flex items-center gap-4 rounded-xl border border-white/10 bg-white/5 p-4 transition-colors hover:bg-white/10">
                        {{-- Drag Handle --}}
                        <div class="flex flex-col gap-1 text-slate-500">
                            <button wire:click="moveFieldUp({{ $index }})" @if($index === 0) disabled @endif
                                class="rounded p-1 transition-colors hover:bg-white/10 hover:text-slate-300 disabled:opacity-30 disabled:cursor-not-allowed">
                                <i class="ph ph-caret-up text-sm"></i>
                            </button>
                            <button wire:click="moveFieldDown({{ $index }})" @if($index === count($fields) - 1) disabled @endif
                                class="rounded p-1 transition-colors hover:bg-white/10 hover:text-slate-300 disabled:opacity-30 disabled:cursor-not-allowed">
                                <i class="ph ph-caret-down text-sm"></i>
                            </button>
                        </div>

                        {{-- Field Info --}}
                        <div class="flex-1 grid grid-cols-1 gap-3 sm:grid-cols-5">
                            <div>
                                <p class="text-xs text-slate-500 uppercase tracking-wider font-semibold">@lang('Label')</p>
                                <p class="font-medium text-white">{{ $field['name'] }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-slate-500 uppercase tracking-wider font-semibold">@lang('Type')</p>
                                <p class="text-slate-300">{{ ucfirst($field['type']) }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-slate-500 uppercase tracking-wider font-semibold">@lang('Width')</p>
                                <p class="text-slate-300">{{ $this->widthOptions[$field['width'] ?? '12'] ?? '100%' }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-slate-500 uppercase tracking-wider font-semibold">@lang('Required')</p>
                                @if($field['is_required'] === 'required')
                                    <span class="inline-flex items-center gap-1 text-emerald-400">
                                        <i class="ph ph-check-circle"></i> @lang('Yes')
                                    </span>
                                @else
                                    <span class="text-slate-500">@lang('Optional')</span>
                                @endif
                            </div>
                            <div>
                                @if(!empty($field['instruction']))
                                    <p class="text-xs text-slate-500 uppercase tracking-wider font-semibold">@lang('Instruction')</p>
                                    <p class="text-sm text-slate-400 truncate" title="{{ $field['instruction'] }}">{{ $field['instruction'] }}</p>
                                @endif
                            </div>
                        </div>

                        {{-- Actions --}}
                        <div class="flex items-center gap-2 opacity-0 transition-opacity group-hover:opacity-100">
                            <x-admin.button variant="ghost" size="sm" wire:click="openEditFieldModal({{ $index }})" icon="ph-pencil-simple" />
                            <x-admin.button variant="ghost" size="sm" wire:click="removeField({{ $index }})" icon="ph-trash" class="text-rose-400 hover:text-rose-300" />
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="py-12 text-center">
                <div class="flex flex-col items-center gap-4">
                    <div class="flex h-16 w-16 items-center justify-center rounded-full bg-slate-500/10">
                        <i class="ph-duotone ph-list-plus text-3xl text-slate-500"></i>
                    </div>
                    <div>
                        <p class="font-medium text-slate-300">@lang('No KYC fields configured')</p>
                        <p class="mt-1 text-sm text-slate-500">@lang('Add fields that users need to fill for verification.')</p>
                    </div>
                    <x-admin.button wire:click="openAddFieldModal" icon="ph-plus">
                        @lang('Add First Field')
                    </x-admin.button>
                </div>
            </div>
        @endif
    </x-admin.card>

    {{-- Add/Edit Field Modal --}}
    @php $modalTitle = $isEditingField ? __('Edit Field') : __('Add Field'); @endphp
    <x-admin.modal wire:model="showFieldModal" :title="$modalTitle" maxWidth="lg">
        <div class="space-y-5">
            <x-admin.input :label="__('Field Label')" wire:model="field_label" placeholder="{{ __('e.g. Full Name, ID Number') }}" required />
            @error('field_label') <span class="text-xs text-rose-400">{{ $message }}</span> @enderror

            <div class="grid grid-cols-1 gap-5 sm:grid-cols-2">
                <div>
                    <x-admin.select :label="__('Field Type')" wire:model.live="field_type" required>
                        @foreach($this->fieldTypes as $value => $label)
                            <option value="{{ $value }}">{{ __($label) }}</option>
                        @endforeach
                    </x-admin.select>
                </div>
                <div>
                    <x-admin.select :label="__('Required')" wire:model="field_is_required" required>
                        <option value="required">@lang('Required')</option>
                        <option value="optional">@lang('Optional')</option>
                    </x-admin.select>
                </div>
            </div>

            <div class="grid grid-cols-1 gap-5 sm:grid-cols-2">
                <div>
                    <x-admin.select :label="__('Width')" wire:model="field_width">
                        @foreach($this->widthOptions as $value => $label)
                            <option value="{{ $value }}">{{ $label }}</option>
                        @endforeach
                    </x-admin.select>
                </div>
                <div>
                    <x-admin.input :label="__('Instruction')" wire:model="field_instruction" placeholder="{{ __('Help text for users') }}" />
                </div>
            </div>

            @if(in_array($field_type, ['select', 'checkbox', 'radio']))
                <x-admin.input :label="__('Options')" wire:model="field_options" placeholder="{{ __('Option 1, Option 2, Option 3') }}" :helper="__('Separate options with commas')" />
            @endif

            @if($field_type === 'file')
                <x-admin.input :label="__('Allowed Extensions')" wire:model="field_extensions" placeholder="jpg,jpeg,png,pdf" :helper="__('Separate extensions with commas')" />
            @endif
        </div>

        <x-slot:footer>
            <x-admin.button variant="ghost" wire:click="$set('showFieldModal', false)">@lang('Cancel')</x-admin.button>
            <x-admin.button wire:click="saveField" wire:loading.attr="disabled" icon="ph-check">
                <span wire:loading.remove wire:target="saveField">{{ $isEditingField ? __('Update') : __('Add') }} @lang('Field')</span>
                <span wire:loading wire:target="saveField">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>
</div>

