<div>
    @php
        $pageTitle = $language->name . ' ' . __('Translations');
        $pageSubtitle = __('Manage translation keys and values for :name (:code).', ['name' => $language->name, 'code' => $language->code]);
    @endphp
    <x-admin.page-header :title="$pageTitle" :subtitle="$pageSubtitle">
        <x-slot name="actions">
            <button type="button" wire:click="openImportModal" class="inline-flex items-center gap-2 px-4 py-2.5 bg-white/5 text-slate-300 ring-1 ring-white/10 hover:bg-white/10 rounded-xl font-semibold text-sm cursor-pointer">
                <i class="ph-duotone ph-download-simple"></i>
                @lang('Import Keys')
            </button>
            <button type="button" wire:click="openAddModal" class="inline-flex items-center gap-2 px-4 py-2.5 bg-gradient-to-r from-indigo-500 to-purple-500 text-white rounded-xl font-semibold text-sm cursor-pointer">
                <i class="ph-duotone ph-plus"></i>
                @lang('Add Key')
            </button>
        </x-slot>
    </x-admin.page-header>

    <!-- Stats & Search Bar -->
    <div class="mb-6 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div class="flex items-center gap-4">
            <div class="flex items-center gap-2 px-4 py-2 bg-[#12121a] border border-white/10 rounded-xl">
                <i class="ph-duotone ph-translate text-indigo-400"></i>
                <span class="text-sm text-slate-300">{{ $total }} @lang('keys')</span>
            </div>
            @if($language->is_default)
                <span class="inline-flex items-center gap-1.5 px-3 py-2 bg-emerald-500/10 text-emerald-400 text-sm font-medium rounded-xl">
                    <i class="ph-fill ph-check-circle"></i>
                    @lang('Default Language')
                </span>
            @endif
        </div>
        <div class="w-full sm:w-80">
            <div class="relative">
                <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search keys or values...') }}" class="w-full pl-11 pr-4 py-2.5 bg-[#12121a] border border-white/10 rounded-xl text-slate-200 placeholder-slate-500 focus:border-indigo-500/50 focus:ring-2 focus:ring-indigo-500/20 focus:outline-none transition-colors">
            </div>
        </div>
    </div>

    <x-admin.card>
        <!-- Translations Table -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/10">
                        <th class="px-4 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider w-1/3">@lang('Key')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Value')</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-slate-400 uppercase tracking-wider w-24">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($translations as $key => $value)
                        <tr wire:key="translation-{{ md5($key) }}" class="hover:bg-white/5 transition-colors group">
                            <td class="px-4 py-3">
                                <code class="text-xs font-mono text-amber-400 bg-amber-500/10 px-2 py-1 rounded break-all">{{ $key }}</code>
                            </td>
                            <td class="px-4 py-3">
                                <span class="text-sm text-slate-300 break-words">{{ Str::limit($value, 100) }}</span>
                            </td>
                            <td class="px-4 py-3">
                                <div class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                                    <button wire:click="openEditModal({{ json_encode($key) }}, {{ json_encode($value) }})" class="flex items-center justify-center w-8 h-8 rounded-lg bg-indigo-500/10 text-indigo-400 hover:bg-indigo-500/20 transition-colors cursor-pointer" title="{{ __('Edit') }}">
                                        <i class="ph-duotone ph-pencil-simple"></i>
                                    </button>
                                    <button wire:click="openDeleteModal({{ json_encode($key) }})" class="flex items-center justify-center w-8 h-8 rounded-lg bg-rose-500/10 text-rose-400 hover:bg-rose-500/20 transition-colors cursor-pointer" title="{{ __('Delete') }}">
                                        <i class="ph-duotone ph-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="px-4 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <i class="ph-duotone ph-file-text text-5xl text-slate-600 mb-3"></i>
                                    <p class="text-slate-400 font-medium">@lang('No translations found')</p>
                                    <p class="text-slate-500 text-sm mt-1">
                                        @if($search)
                                            @lang('No results for ":search". Try a different search.', ['search' => $search])
                                        @else
                                            @lang('Add your first translation key or import from system.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($lastPage > 1)
            @php
                $showingFrom = ($currentPage - 1) * $perPage + 1;
                $showingTo = min($currentPage * $perPage, $total);
            @endphp
            <div class="mt-6 flex items-center justify-between border-t border-white/10 pt-4">
                <p class="text-sm text-slate-500">
                    @lang('Showing :from to :to of :total keys', ['from' => $showingFrom, 'to' => $showingTo, 'total' => $total])
                </p>
                <div class="flex items-center gap-2">
                    @if($currentPage > 1)
                        <button wire:click="previousPage" class="px-3 py-1.5 bg-white/5 border border-white/10 rounded-lg text-slate-300 text-sm hover:bg-white/10 transition-colors cursor-pointer">
                            <i class="ph-bold ph-caret-left"></i>
                        </button>
                    @endif

                    @for($i = max(1, $currentPage - 2); $i <= min($lastPage, $currentPage + 2); $i++)
                        <button wire:click="gotoPage({{ $i }})" class="px-3 py-1.5 {{ $i === $currentPage ? 'bg-indigo-600 text-white' : 'bg-white/5 border border-white/10 text-slate-300 hover:bg-white/10' }} rounded-lg text-sm transition-colors cursor-pointer">
                            {{ $i }}
                        </button>
                    @endfor

                    @if($currentPage < $lastPage)
                        <button wire:click="nextPage" class="px-3 py-1.5 bg-white/5 border border-white/10 rounded-lg text-slate-300 text-sm hover:bg-white/10 transition-colors cursor-pointer">
                            <i class="ph-bold ph-caret-right"></i>
                        </button>
                    @endif
                </div>
            </div>
        @endif
    </x-admin.card>

    <!-- Add Key Modal -->
    <x-admin.modal wire:model.live="showAddModal" :title="__('Add Translation Key')" maxWidth="lg">
        <div class="space-y-5">
            <div class="space-y-2">
                <label class="block text-sm font-medium text-slate-300">@lang('Key')</label>
                <x-admin.input wire:model="newKey" placeholder="{{ __('e.g. Welcome to our site') }}" />
                <p class="text-xs text-slate-500">@lang('The original text that will be translated')</p>
                @error('newKey') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
            </div>

            <div class="space-y-2">
                <label class="block text-sm font-medium text-slate-300">@lang('Translation')</label>
                <textarea wire:model="newValue" rows="4" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-slate-200 placeholder-slate-500 focus:border-indigo-500/50 focus:ring-2 focus:ring-indigo-500/20 focus:outline-none transition-colors resize-none" placeholder="{{ __('Enter the translation...') }}"></textarea>
                @error('newValue') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
            </div>
        </div>

        <x-slot name="footer">
            <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
            <x-admin.button type="button" wire:click="storeKey" icon="ph-plus">@lang('Add Key')</x-admin.button>
        </x-slot>
    </x-admin.modal>

    <!-- Edit Key Modal -->
    <x-admin.modal wire:model.live="showEditModal" :title="__('Edit Translation')" maxWidth="lg">
        <div class="space-y-5">
            <div class="space-y-2">
                <label class="block text-sm font-medium text-slate-300">@lang('Key')</label>
                <div class="px-4 py-3 bg-white/5 border border-white/10 rounded-xl">
                    <code class="text-sm font-mono text-amber-400 break-all">{{ $editKey }}</code>
                </div>
            </div>

            <div class="space-y-2">
                <label class="block text-sm font-medium text-slate-300">@lang('Translation')</label>
                <textarea wire:model="editValue" rows="4" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-slate-200 placeholder-slate-500 focus:border-indigo-500/50 focus:ring-2 focus:ring-indigo-500/20 focus:outline-none transition-colors resize-none" placeholder="{{ __('Enter the translation...') }}"></textarea>
                @error('editValue') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
            </div>
        </div>

        <x-slot name="footer">
            <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
            <x-admin.button type="button" wire:click="updateKey" icon="ph-floppy-disk">@lang('Save Changes')</x-admin.button>
        </x-slot>
    </x-admin.modal>

    <!-- Delete Key Modal -->
    <x-admin.modal wire:model.live="showDeleteModal" :title="__('Delete Translation Key')" maxWidth="sm">
        <div class="text-center">
            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-rose-500/10 flex items-center justify-center">
                <i class="ph-duotone ph-warning text-3xl text-rose-400"></i>
            </div>
            <h4 class="text-lg font-semibold text-white mb-2">@lang('Delete this key?')</h4>
            <p class="text-slate-400 text-sm">@lang('This will permanently remove the translation key:')</p>
            <code class="inline-block mt-2 px-3 py-1.5 bg-rose-500/10 text-rose-400 text-sm font-mono rounded-lg break-all">{{ $deleteKey }}</code>
        </div>

        <x-slot name="footer">
            <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
            <x-admin.button type="button" variant="danger" wire:click="deleteKey" icon="ph-trash">@lang('Delete Key')</x-admin.button>
        </x-slot>
    </x-admin.modal>

    <!-- Import Keys Modal -->
    <x-admin.modal wire:model.live="showImportModal" :title="__('Import Translation Keys')" maxWidth="md">
        <div class="space-y-5">
            <div class="p-4 bg-indigo-500/10 border border-indigo-500/20 rounded-xl">
                <div class="flex items-start gap-3">
                    <i class="ph-duotone ph-info text-xl text-indigo-400 mt-0.5"></i>
                    <div>
                        <p class="text-sm font-medium text-indigo-300">@lang('Import Options')</p>
                        <p class="text-xs text-indigo-400/70 mt-1">@lang('Import keys from another language or extract from system blade files. Only new keys will be added.')</p>
                    </div>
                </div>
            </div>

            <div class="space-y-2">
                <label class="block text-sm font-medium text-slate-300">@lang('Import Source')</label>
                <select wire:model="importLanguageId" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-slate-200 focus:border-indigo-500/50 focus:ring-2 focus:ring-indigo-500/20 focus:outline-none transition-colors">
                    <option value="system">@lang('Extract from System (Blade Files)')</option>
                    @foreach($otherLanguages as $lang)
                        <option value="{{ $lang->id }}">@lang('Import from :name (:code)', ['name' => $lang->name, 'code' => $lang->code])</option>
                    @endforeach
                </select>
            </div>
        </div>

        <x-slot name="footer">
            <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
            <x-admin.button type="button" wire:click="importKeys" wire:loading.attr="disabled" icon="ph-download-simple">
                <span wire:loading.remove wire:target="importKeys">@lang('Import Keys')</span>
                <span wire:loading wire:target="importKeys">@lang('Importing...')</span>
            </x-admin.button>
        </x-slot>
    </x-admin.modal>
</div>

