<div>
    <x-admin.page-header :title="__('Languages')" :subtitle="__('Manage system languages and translations.')">
        <x-slot name="actions">
            <x-admin.button wire:click="openAddModal" icon="ph-plus">
                @lang('Add Language')
            </x-admin.button>
        </x-slot>
    </x-admin.page-header>

    <x-admin.card>
        <!-- Languages Table -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/10">
                        <th class="px-4 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Flag')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Language')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Code')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Status')</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-slate-400 uppercase tracking-wider">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($languages as $language)
                        <tr class="hover:bg-white/5 transition-colors">
                            <td class="px-4 py-4">
                                <div class="w-10 h-10 rounded-lg overflow-hidden border border-white/10 bg-white/5 flex items-center justify-center">
                                    @if($language->image)
                                        <img src="{{ $language->image_url }}" alt="{{ $language->name }}" class="w-full h-full object-cover">
                                    @else
                                        <i class="ph-duotone ph-flag text-xl text-slate-500"></i>
                                    @endif
                                </div>
                            </td>
                            <td class="px-4 py-4">
                                <span class="text-sm font-medium text-white">{{ $language->name }}</span>
                            </td>
                            <td class="px-4 py-4">
                                <span class="px-2.5 py-1 bg-slate-700/50 text-slate-300 text-xs font-mono rounded-lg">{{ $language->code }}</span>
                            </td>
                            <td class="px-4 py-4">
                                @if($language->is_default)
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-emerald-500/10 text-emerald-400 text-xs font-medium rounded-lg">
                                        <i class="ph-fill ph-check-circle"></i>
                                        @lang('Default')
                                    </span>
                                @else
                                    <button wire:click="setDefault({{ $language->id }})" class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-white/5 text-slate-400 text-xs font-medium rounded-lg hover:bg-indigo-500/10 hover:text-indigo-400 transition-colors cursor-pointer">
                                        <i class="ph-duotone ph-star"></i>
                                        @lang('Set Default')
                                    </button>
                                @endif
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('admin.language.key', $language->id) }}" class="flex items-center justify-center w-9 h-9 rounded-lg bg-indigo-500/10 text-indigo-400 hover:bg-indigo-500/20 transition-colors" title="{{ __('Translate') }}">
                                        <i class="ph-duotone ph-translate text-lg"></i>
                                    </a>
                                    <button wire:click="openEditModal({{ $language->id }})" class="flex items-center justify-center w-9 h-9 rounded-lg bg-amber-500/10 text-amber-400 hover:bg-amber-500/20 transition-colors cursor-pointer" title="{{ __('Edit') }}">
                                        <i class="ph-duotone ph-pencil-simple text-lg"></i>
                                    </button>
                                    @if(!$language->is_default && $language->code !== 'en')
                                        <button wire:click="openDeleteModal({{ $language->id }})" class="flex items-center justify-center w-9 h-9 rounded-lg bg-rose-500/10 text-rose-400 hover:bg-rose-500/20 transition-colors cursor-pointer" title="{{ __('Delete') }}">
                                            <i class="ph-duotone ph-trash text-lg"></i>
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-4 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <i class="ph-duotone ph-translate text-5xl text-slate-600 mb-3"></i>
                                    <p class="text-slate-400 font-medium">@lang('No languages found')</p>
                                    <p class="text-slate-500 text-sm mt-1">@lang('Add your first language to get started.')</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-admin.card>

    <!-- Add Language Modal -->
    <x-admin.modal wire:model.live="showAddModal" :title="__('Add New Language')" maxWidth="md">
        <form wire:submit="store">
            <div class="space-y-5">
                <!-- Language Name -->
                <div class="space-y-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Language Name')</label>
                    <x-admin.input wire:model="name" placeholder="{{ __('e.g. English, Spanish, French') }}" />
                    @error('name') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Language Code -->
                <div class="space-y-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Language Code')</label>
                    <x-admin.input wire:model="code" placeholder="{{ __('e.g. en, es, fr') }}" maxlength="10" />
                    <p class="text-xs text-slate-500">@lang('Use ISO 639-1 language codes (2 letters)')</p>
                    @error('code') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Flag Image -->
                <div class="space-y-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Flag Image')</label>
                    <div class="flex items-center gap-4">
                        @if($image)
                            <div class="w-14 h-14 rounded-xl overflow-hidden border border-white/10 bg-white/5">
                                <img src="{{ $image->temporaryUrl() }}" alt="{{ __('Preview') }}" class="w-full h-full object-cover">
                            </div>
                        @else
                            <div class="w-14 h-14 rounded-xl border border-dashed border-white/20 bg-white/5 flex items-center justify-center">
                                <i class="ph-duotone ph-flag text-2xl text-slate-500"></i>
                            </div>
                        @endif
                        <div class="flex-1">
                            <label class="flex items-center justify-center gap-2 px-4 py-2.5 bg-white/5 border border-white/10 rounded-xl text-slate-300 text-sm font-medium cursor-pointer hover:bg-white/10 transition-colors">
                                <i class="ph-duotone ph-upload-simple"></i>
                                <span>@lang('Choose Flag')</span>
                                <input type="file" wire:model="image" accept="image/*" class="hidden">
                            </label>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('Recommended: 50x50px, PNG or JPG')</p>
                        </div>
                    </div>
                    @error('image') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Set as Default -->
                <div class="flex items-center justify-between p-4 bg-white/5 rounded-xl border border-white/10">
                    <div>
                        <p class="text-sm font-medium text-slate-200">@lang('Set as Default')</p>
                        <p class="text-xs text-slate-500 mt-0.5">@lang('Make this the default language')</p>
                    </div>
                    <x-admin.toggle wire:model="is_default" />
                </div>
            </div>

            <x-slot name="footer">
                <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" icon="ph-plus">@lang('Add Language')</x-admin.button>
            </x-slot>
        </form>
    </x-admin.modal>

    <!-- Edit Language Modal -->
    <x-admin.modal wire:model.live="showEditModal" :title="__('Edit Language')" maxWidth="md">
        <form wire:submit="update">
            <div class="space-y-5">
                <!-- Language Name -->
                <div class="space-y-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Language Name')</label>
                    <x-admin.input wire:model="name" placeholder="{{ __('e.g. English, Spanish, French') }}" />
                    @error('name') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Language Code (Read-only) -->
                <div class="space-y-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Language Code')</label>
                    <x-admin.input wire:model="code" disabled class="opacity-60 cursor-not-allowed" />
                    <p class="text-xs text-slate-500">@lang('Language code cannot be changed')</p>
                </div>

                <!-- Flag Image -->
                <div class="space-y-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Flag Image')</label>
                    <div class="flex items-center gap-4">
                        @if($image)
                            <div class="w-14 h-14 rounded-xl overflow-hidden border border-white/10 bg-white/5">
                                <img src="{{ $image->temporaryUrl() }}" alt="{{ __('Preview') }}" class="w-full h-full object-cover">
                            </div>
                        @elseif($existingImage)
                            <div class="w-14 h-14 rounded-xl overflow-hidden border border-white/10 bg-white/5">
                                <img src="{{ asset(getFilePath('language') . '/' . $existingImage) }}" alt="{{ __('Current') }}" class="w-full h-full object-cover">
                            </div>
                        @else
                            <div class="w-14 h-14 rounded-xl border border-dashed border-white/20 bg-white/5 flex items-center justify-center">
                                <i class="ph-duotone ph-flag text-2xl text-slate-500"></i>
                            </div>
                        @endif
                        <div class="flex-1">
                            <label class="flex items-center justify-center gap-2 px-4 py-2.5 bg-white/5 border border-white/10 rounded-xl text-slate-300 text-sm font-medium cursor-pointer hover:bg-white/10 transition-colors">
                                <i class="ph-duotone ph-upload-simple"></i>
                                <span>@lang('Change Flag')</span>
                                <input type="file" wire:model="image" accept="image/*" class="hidden">
                            </label>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('Leave empty to keep current')</p>
                        </div>
                    </div>
                    @error('image') <span class="text-rose-400 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Set as Default -->
                <div class="flex items-center justify-between p-4 bg-white/5 rounded-xl border border-white/10">
                    <div>
                        <p class="text-sm font-medium text-slate-200">@lang('Set as Default')</p>
                        <p class="text-xs text-slate-500 mt-0.5">@lang('Make this the default language')</p>
                    </div>
                    <x-admin.toggle wire:model="is_default" />
                </div>
            </div>

            <x-slot name="footer">
                <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" icon="ph-floppy-disk">@lang('Save Changes')</x-admin.button>
            </x-slot>
        </form>
    </x-admin.modal>

    <!-- Delete Confirmation Modal -->
    <x-admin.modal wire:model.live="showDeleteModal" :title="__('Delete Language')" maxWidth="sm">
        <div class="text-center">
            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-rose-500/10 flex items-center justify-center">
                <i class="ph-duotone ph-warning text-3xl text-rose-400"></i>
            </div>
            <h4 class="text-lg font-semibold text-white mb-2">@lang('Are you sure?')</h4>
            <p class="text-slate-400 text-sm">@lang('This will permanently delete the language and all its translations. This action cannot be undone.')</p>
        </div>

        <x-slot name="footer">
            <x-admin.button type="button" variant="secondary" wire:click="closeModals">@lang('Cancel')</x-admin.button>
            <x-admin.button type="button" variant="danger" wire:click="delete" icon="ph-trash">@lang('Delete Language')</x-admin.button>
        </x-slot>
    </x-admin.modal>
</div>

