<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Logo & Favicon')" :subtitle="__('Upload your site logo and favicon images.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="logo-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-image"
            iconColor="primary"
            :label="__('Logo (Dark)')"
            :value="$currentLogo ? __('Uploaded') : __('Not Set')"
        />
        <x-admin.stat-card
            icon="ph-image-square"
            iconColor="info"
            :label="__('Logo (Light)')"
            :value="$currentLogoDark ? __('Uploaded') : __('Not Set')"
        />
        <x-admin.stat-card
            icon="ph-star"
            iconColor="warning"
            :label="__('Favicon')"
            :value="$currentFavicon ? __('Uploaded') : __('Not Set')"
        />
    </div>

    {{-- Cache Notice --}}
    <div class="mt-6 p-4 bg-indigo-500/10 border border-indigo-500/20 rounded-xl">
        <div class="flex items-start gap-3">
            <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-indigo-500/20 shrink-0">
                <i class="ph-duotone ph-info text-lg text-indigo-400"></i>
            </div>
            <div>
                <p class="text-sm text-indigo-300 font-medium">@lang('Cache Notice')</p>
                <p class="text-xs text-indigo-400/80 mt-1">@lang('If the logo and favicon are not changed after you update from this page, please clear your browser cache. The filename remains the same after update, so it may show the old image due to caching.')</p>
            </div>
        </div>
    </div>

    <form wire:submit="save" id="logo-settings-form">
        <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-6">
            {{-- Logo for Dark Background --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-moon-stars text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Logo (Dark Background)')</h3>
                        <p class="text-sm text-slate-500">@lang('Used on dark backgrounds')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="relative aspect-[3/1] bg-slate-800/50 rounded-xl border-2 border-dashed border-white/10 flex items-center justify-center overflow-hidden group hover:border-indigo-500/30 transition-colors">
                        @if($logo)
                            <img src="{{ $logo->temporaryUrl() }}" alt="{{ __('Logo Preview') }}" class="max-h-full max-w-full object-contain p-4" />
                        @elseif($currentLogo)
                            <img src="{{ $currentLogo }}" alt="{{ __('Current Logo') }}" class="max-h-full max-w-full object-contain p-4" />
                        @else
                            <div class="text-center">
                                <i class="ph-duotone ph-image text-4xl text-slate-600 group-hover:text-indigo-400 transition-colors"></i>
                                <p class="text-xs text-slate-500 mt-2">@lang('No logo uploaded')</p>
                            </div>
                        @endif
                    </div>
                    <div>
                        <label class="block w-full cursor-pointer group">
                            <div class="flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl border border-white/10 bg-white/5 text-slate-300 transition-all group-hover:bg-indigo-500/10 group-hover:border-indigo-500/30 group-hover:text-indigo-300">
                                <i class="ph-duotone ph-upload-simple"></i>
                                <span class="text-sm font-medium">@lang('Choose File')</span>
                            </div>
                            <input type="file" wire:model="logo" accept="image/png,image/jpeg,image/svg+xml" class="hidden" />
                        </label>
                        <p class="text-xs text-slate-500 mt-2 text-center">PNG, JPG, SVG</p>
                        @error('logo') <span class="text-rose-400 text-xs mt-1 block text-center">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>

            {{-- Logo for White Background --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-sun text-xl text-amber-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Logo (White Background)')</h3>
                        <p class="text-sm text-slate-500">@lang('Used on light backgrounds')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="relative aspect-[3/1] bg-white rounded-xl border-2 border-dashed border-slate-200 flex items-center justify-center overflow-hidden group hover:border-amber-400/50 transition-colors">
                        @if($logoDark)
                            <img src="{{ $logoDark->temporaryUrl() }}" alt="{{ __('Logo Dark Preview') }}" class="max-h-full max-w-full object-contain p-4" />
                        @elseif($currentLogoDark)
                            <img src="{{ $currentLogoDark }}" alt="{{ __('Current Logo Dark') }}" class="max-h-full max-w-full object-contain p-4" />
                        @else
                            <div class="text-center">
                                <i class="ph-duotone ph-image text-4xl text-slate-300 group-hover:text-amber-500 transition-colors"></i>
                                <p class="text-xs text-slate-400 mt-2">@lang('No logo uploaded')</p>
                            </div>
                        @endif
                    </div>
                    <div>
                        <label class="block w-full cursor-pointer group">
                            <div class="flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl border border-white/10 bg-white/5 text-slate-300 transition-all group-hover:bg-amber-500/10 group-hover:border-amber-500/30 group-hover:text-amber-300">
                                <i class="ph-duotone ph-upload-simple"></i>
                                <span class="text-sm font-medium">@lang('Choose File')</span>
                            </div>
                            <input type="file" wire:model="logoDark" accept="image/png,image/jpeg,image/svg+xml" class="hidden" />
                        </label>
                        <p class="text-xs text-slate-500 mt-2 text-center">PNG, JPG, SVG</p>
                        @error('logoDark') <span class="text-rose-400 text-xs mt-1 block text-center">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>

            {{-- Favicon --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                        <i class="ph-duotone ph-star text-xl text-emerald-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Favicon')</h3>
                        <p class="text-sm text-slate-500">@lang('Browser tab icon')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="relative aspect-square max-w-[120px] mx-auto bg-slate-800/50 rounded-xl border-2 border-dashed border-white/10 flex items-center justify-center overflow-hidden group hover:border-emerald-500/30 transition-colors">
                        @if($favicon)
                            <img src="{{ $favicon->temporaryUrl() }}" alt="{{ __('Favicon Preview') }}" class="max-h-full max-w-full object-contain p-2" />
                        @elseif($currentFavicon)
                            <img src="{{ $currentFavicon }}" alt="{{ __('Current Favicon') }}" class="max-h-full max-w-full object-contain p-2" />
                        @else
                            <div class="text-center">
                                <i class="ph-duotone ph-star text-3xl text-slate-600 group-hover:text-emerald-400 transition-colors"></i>
                                <p class="text-xs text-slate-500 mt-1">@lang('No favicon')</p>
                            </div>
                        @endif
                    </div>
                    <div>
                        <label class="block w-full cursor-pointer group">
                            <div class="flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl border border-white/10 bg-white/5 text-slate-300 transition-all group-hover:bg-emerald-500/10 group-hover:border-emerald-500/30 group-hover:text-emerald-300">
                                <i class="ph-duotone ph-upload-simple"></i>
                                <span class="text-sm font-medium">@lang('Choose File')</span>
                            </div>
                            <input type="file" wire:model="favicon" accept="image/png,image/x-icon" class="hidden" />
                        </label>
                        <p class="text-xs text-slate-500 mt-2 text-center">PNG, ICO (32x32)</p>
                        @error('favicon') <span class="text-rose-400 text-xs mt-1 block text-center">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>
        </div>
    </form>
</div>

