<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Maintenance Mode')" :subtitle="__('Configure maintenance mode settings and message.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="maintenance-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Content')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-wrench"
            :iconColor="$status ? 'warning' : 'success'"
            :label="__('Site Status')"
            :value="$status ? __('Maintenance') : __('Live')"
        />
        <x-admin.stat-card
            icon="ph-image"
            iconColor="info"
            :label="__('Maintenance Image')"
            :value="$currentImage ? __('Uploaded') : __('Not Set')"
        />
        <x-admin.stat-card
            icon="ph-text-aa"
            iconColor="primary"
            :label="__('Description')"
            :value="$description ? __('Configured') : __('Not Set')"
        />
    </div>

    <form wire:submit="save" id="maintenance-form">
        <div class="mt-6 grid grid-cols-1 xl:grid-cols-3 gap-6">
            {{-- Status Card --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-wrench text-xl text-amber-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Maintenance Status')</h3>
                        <p class="text-sm text-slate-500">@lang('Toggle site availability')</p>
                    </div>
                </div>

                <label class="group flex items-center justify-between p-3 rounded-xl border border-white/5 cursor-pointer hover:bg-white/[0.02] hover:border-white/10 transition-all">
                    <div class="flex items-center gap-3">
                        <div class="flex h-9 w-9 items-center justify-center rounded-lg {{ $status ? 'bg-amber-500/10' : 'bg-emerald-500/10' }}">
                            <i class="ph-duotone {{ $status ? 'ph-warning text-amber-400' : 'ph-check-circle text-emerald-400' }} text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-slate-200">@lang('Maintenance Mode')</p>
                            <p class="text-xs text-slate-500">{{ $status ? __('Site is in maintenance') : __('Site is live') }}</p>
                        </div>
                    </div>
                    <div class="relative">
                        <input type="checkbox" wire:model.live="status" class="sr-only peer" />
                        <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-amber-500 transition-colors"></div>
                        <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                    </div>
                </label>

                @if($status)
                <div class="mt-4 p-4 bg-amber-500/10 border border-amber-500/20 rounded-xl">
                    <div class="flex items-center gap-2 text-amber-400">
                        <i class="ph-duotone ph-warning text-lg"></i>
                        <span class="text-sm font-medium">@lang('Maintenance mode is active')</span>
                    </div>
                    <p class="text-xs text-amber-400/70 mt-1">@lang('Visitors will see the maintenance page instead of your site.')</p>
                </div>
                @else
                <div class="mt-4 p-4 bg-emerald-500/10 border border-emerald-500/20 rounded-xl">
                    <div class="flex items-center gap-2 text-emerald-400">
                        <i class="ph-duotone ph-check-circle text-lg"></i>
                        <span class="text-sm font-medium">@lang('Site is live')</span>
                    </div>
                    <p class="text-xs text-emerald-400/70 mt-1">@lang('Your site is accessible to all visitors.')</p>
                </div>
                @endif
            </x-admin.card>

            {{-- Content Form --}}
            <div class="xl:col-span-2">
                <x-admin.card>
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-note-pencil text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Maintenance Content')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure the maintenance page')</p>
                        </div>
                    </div>

                    <div class="space-y-5">
                        {{-- Image Upload --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Maintenance Image')</label>
                            <div class="flex items-start gap-4">
                                <div class="w-40 h-32 bg-slate-900/50 rounded-xl border-2 border-dashed border-white/10 flex items-center justify-center overflow-hidden group hover:border-indigo-500/30 transition-colors">
                                    @if($image)
                                        <img src="{{ $image->temporaryUrl() }}" alt="{{ __('Preview') }}" class="max-h-full max-w-full object-contain" />
                                    @elseif($currentImage)
                                        <img src="{{ $currentImage }}" alt="{{ __('Current') }}" class="max-h-full max-w-full object-contain" />
                                    @else
                                        <i class="ph-duotone ph-image text-3xl text-slate-600 group-hover:text-indigo-400 transition-colors"></i>
                                    @endif
                                </div>
                                <div class="flex-1">
                                    <label class="block w-full cursor-pointer group">
                                        <div class="flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl border border-white/10 bg-white/5 text-slate-300 transition-all group-hover:bg-indigo-500/10 group-hover:border-indigo-500/30 group-hover:text-indigo-300">
                                            <i class="ph-duotone ph-upload-simple"></i>
                                            <span class="text-sm font-medium">@lang('Choose Image')</span>
                                        </div>
                                        <input type="file" wire:model="image" accept="image/*" class="hidden" />
                                    </label>
                                    <p class="text-xs text-slate-500 mt-2">@lang('Recommended size: 600x400px. Max 2MB.')</p>
                                    @error('image') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>

                        {{-- Description --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Description')</label>
                            <textarea wire:model="description" rows="6" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-none" placeholder="{{ __('We\'re currently performing scheduled maintenance. We\'ll be back shortly!') }}"></textarea>
                            <p class="text-xs text-slate-500 mt-1.5">@lang('HTML is allowed for formatting.')</p>
                            @error('description') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </x-admin.card>
            </div>
        </div>
    </form>
</div>
