<div>
    <x-admin.page-header :title="__('Email Settings')" :description="__('Configure email sending method and SMTP/API credentials.')">
        <x-slot name="actions">
            <button wire:click="$set('showTestModal', true)" class="inline-flex items-center gap-2 px-4 py-2 bg-white/5 border border-white/10 rounded-xl text-slate-300 hover:bg-white/10 transition-colors">
                <i class="ph-duotone ph-paper-plane-tilt"></i>
                @lang('Send Test Mail')
            </button>
        </x-slot>
    </x-admin.page-header>

    <!-- Navigation Tabs -->
    <div class="flex gap-3 mb-6 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.email') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-primary-500/20 text-primary-400 border border-primary-500/30">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Email Settings')
        </a>
        <a href="{{ route('admin.setting.notification.sms') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('SMS Settings')
        </a>
        <a href="{{ route('admin.setting.notification.push') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Push Settings')
        </a>
    </div>

    <x-admin.card>
        <form wire:submit="save" class="space-y-6">
            <!-- Email Method Selection -->
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Email Send Method')</label>
                <select wire:model.live="email_method" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 focus:outline-none focus:ring-2 focus:ring-primary-500/50 focus:border-primary-500/50">
                    <option value="php">@lang('PHP Mail')</option>
                    <option value="smtp">@lang('SMTP')</option>
                    <option value="sendgrid">@lang('SendGrid API')</option>
                    <option value="mailjet">@lang('Mailjet API')</option>
                </select>
            </div>

            <!-- SMTP Configuration -->
            @if($email_method === 'smtp')
            <div class="border border-white/10 rounded-xl p-6 space-y-6 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200 flex items-center gap-2">
                    <i class="ph-duotone ph-plugs-connected text-primary-400"></i>
                    @lang('SMTP Configuration')
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Host')</label>
                        <input type="text" wire:model="host" placeholder="smtp.gmail.com" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        @error('host') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Port')</label>
                        <input type="text" wire:model="port" placeholder="465" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        @error('port') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Encryption')</label>
                        <select wire:model="enc" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                            <option value="ssl">SSL</option>
                            <option value="tls">TLS</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Username')</label>
                        <input type="text" wire:model="username" placeholder="{{ __('your@email.com') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        @error('username') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Password')</label>
                        <input type="password" wire:model="password" placeholder="••••••••" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        @error('password') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>
            @endif

            <!-- SendGrid Configuration -->
            @if($email_method === 'sendgrid')
            <div class="border border-white/10 rounded-xl p-6 space-y-6 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200 flex items-center gap-2">
                    <i class="ph-duotone ph-key text-primary-400"></i>
                    @lang('SendGrid API Configuration')
                </h3>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API Key')</label>
                    <input type="password" wire:model="appkey" placeholder="SG.xxxxxxxx" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    @error('appkey') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                </div>
            </div>
            @endif

            <!-- Mailjet Configuration -->
            @if($email_method === 'mailjet')
            <div class="border border-white/10 rounded-xl p-6 space-y-6 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200 flex items-center gap-2">
                    <i class="ph-duotone ph-key text-primary-400"></i>
                    @lang('Mailjet API Configuration')
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Public Key')</label>
                        <input type="password" wire:model="public_key" placeholder="{{ __('API Public Key') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        @error('public_key') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Secret Key')</label>
                        <input type="password" wire:model="secret_key" placeholder="{{ __('API Secret Key') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        @error('secret_key') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>
            @endif

            <div class="flex justify-end pt-4">
                <button type="submit" class="inline-flex items-center gap-2 px-6 py-3 bg-primary-500 hover:bg-primary-600 text-white font-medium rounded-xl transition-colors">
                    <i class="ph-bold ph-floppy-disk"></i>
                    @lang('Save Settings')
                </button>
            </div>
        </form>
    </x-admin.card>

    <!-- Test Email Modal -->
    <x-admin.modal wire:model="showTestModal" :title="__('Send Test Email')" maxWidth="md">
        <form wire:submit="sendTestEmail" class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Recipient Email')</label>
                <input type="email" wire:model="testEmail" placeholder="test@example.com" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                @error('testEmail') <span class="text-red-400 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            <div class="flex justify-end gap-3">
                <button type="button" wire:click="$set('showTestModal', false)" class="px-4 py-2.5 bg-white/5 border border-white/10 rounded-xl text-slate-300 hover:bg-white/10 transition-colors">
                    @lang('Cancel')
                </button>
                <button type="submit" class="inline-flex items-center gap-2 px-4 py-2.5 bg-primary-500 hover:bg-primary-600 text-white font-medium rounded-xl transition-colors">
                    <i class="ph-bold ph-paper-plane-tilt"></i>
                    @lang('Send Test')
                </button>
            </div>
        </form>
    </x-admin.modal>
</div>

