<div x-data="globalEmailEditor(@js(config('app.name')))" x-init="updatePreview()">
    <x-admin.page-header :title="__('Global Email Template')" :subtitle="__('Configure the global email template wrapper and sender information.')" />

    <!-- Navigation Tabs -->
    <div class="mt-6 flex gap-3 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.global.email') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-indigo-500/20 text-indigo-400 border border-indigo-500/30">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Global Email')
        </a>
        <a href="{{ route('admin.setting.notification.global.sms') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('Global SMS')
        </a>
        <a href="{{ route('admin.setting.notification.global.push') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Global Push')
        </a>
        <a href="{{ route('admin.setting.notification.templates') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-files"></i>
            @lang('Templates')
        </a>
    </div>

    <div class="mt-6 grid grid-cols-1 xl:grid-cols-3 gap-6">
        <!-- Form Section -->
        <div class="xl:col-span-2 space-y-6">
            <x-admin.card>
                <form wire:submit="save" class="space-y-6">
                    <!-- Sender Info -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <x-admin.input wire:model="email_from_name" :label="__('From Name')" placeholder="{{ __('Company Name') }}" :error="$errors->first('email_from_name')" />
                        <x-admin.input type="email" wire:model="email_from" :label="__('From Email')" placeholder="noreply@example.com" :error="$errors->first('email_from')" />
                    </div>

                    <!-- Email Template Editor -->
                    <div>
                        <div class="flex items-center justify-between mb-3">
                            <label class="block text-sm font-medium text-slate-300">@lang('Email Template (HTML)')</label>
                            <button type="button" @click="showPreview = !showPreview; if(showPreview) updatePreview()" class="inline-flex items-center gap-2 px-3 py-1.5 text-xs font-medium rounded-lg transition-colors" :class="showPreview ? 'bg-indigo-500/20 text-indigo-400' : 'bg-white/5 text-slate-400 hover:bg-white/10'">
                                <i class="ph-duotone" :class="showPreview ? 'ph-eye-slash' : 'ph-eye'"></i>
                                <span x-text="showPreview ? '{{ __('Hide Preview') }}' : '{{ __('Show Preview') }}'"></span>
                            </button>
                        </div>

                        <!-- Shortcode Quick Insert Buttons -->
                        <div class="flex flex-wrap gap-2 mb-3">
                            <span class="text-xs text-slate-500">@lang('Quick insert:')</span>
                            @foreach($shortcodes as $code => $description)
                            <button type="button" onclick="insertShortcode('{{ $code }}')" class="px-2 py-1 text-xs font-mono bg-indigo-500/10 text-indigo-400 rounded-lg hover:bg-indigo-500/20 transition-colors" title="{{ __($description) }}">
                                {{ $code }}
                            </button>
                            @endforeach
                        </div>

                        <div class="grid gap-4" :class="showPreview ? 'grid-cols-1 lg:grid-cols-2' : 'grid-cols-1'">
                            <!-- Code Editor -->
                            <div>
                                <textarea
                                    id="email-template-editor"
                                    wire:model.live.debounce.500ms="email_template"
                                    rows="24"
                                    @input="updatePreview()"
                                    class="w-full bg-slate-900/50 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:border-indigo-500/50 focus:ring-2 focus:ring-indigo-500/20 font-mono text-sm leading-relaxed"
                                    style="tab-size: 2;"
                                ></textarea>
                                @error('email_template') <span class="text-rose-400 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>

                            <!-- Live Preview -->
                            <div x-show="showPreview" x-transition class="relative">
                                <div class="absolute top-0 left-0 right-0 bg-slate-800 border-b border-white/10 rounded-t-xl px-4 py-2 flex items-center gap-2">
                                    <div class="flex gap-1.5">
                                        <span class="w-3 h-3 rounded-full bg-rose-500/80"></span>
                                        <span class="w-3 h-3 rounded-full bg-amber-500/80"></span>
                                        <span class="w-3 h-3 rounded-full bg-emerald-500/80"></span>
                                    </div>
                                    <span class="text-xs text-slate-400 ml-2">@lang('Email Preview')</span>
                                </div>
                                <div class="bg-slate-100 rounded-xl pt-10 overflow-hidden" style="height: 500px;">
                                    <iframe
                                        id="preview-frame"
                                        class="w-full h-full border-0"
                                        :srcdoc="previewHtml"
                                    ></iframe>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center justify-between pt-4 border-t border-white/5">
                        <x-admin.button type="button" wire:click="resetTemplate" variant="ghost" icon="ph-arrow-counter-clockwise">
                            @lang('Reset to Default')
                        </x-admin.button>
                        <x-admin.button type="submit" icon="ph-floppy-disk">
                            @lang('Save Template')
                        </x-admin.button>
                    </div>
                </form>
            </x-admin.card>
        </div>

        <!-- Shortcodes Reference -->
        <div class="space-y-6">
            <x-admin.card>
                <h3 class="text-lg font-semibold text-slate-200 mb-4 flex items-center gap-2">
                    <i class="ph-duotone ph-code text-indigo-400"></i>
                    @lang('Available Shortcodes')
                </h3>
                <div class="space-y-3">
                    @foreach($shortcodes as $code => $description)
                    <div class="group flex items-start gap-3 p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors cursor-pointer" onclick="insertShortcode('{{ $code }}')">
                        <code class="text-indigo-400 text-sm font-mono bg-indigo-500/10 px-2 py-1 rounded-lg shrink-0">{{ $code }}</code>
                        <div class="flex-1">
                            <span class="text-slate-400 text-sm">{{ __($description) }}</span>
                        </div>
                        <i class="ph-duotone ph-copy text-slate-500 group-hover:text-indigo-400 transition-colors"></i>
                    </div>
                    @endforeach
                </div>
            </x-admin.card>

            <!-- Tips Card -->
            <x-admin.card>
                <h3 class="text-lg font-semibold text-slate-200 mb-4 flex items-center gap-2">
                    <i class="ph-duotone ph-lightbulb text-amber-400"></i>
                    @lang('Template Tips')
                </h3>
                <ul class="space-y-3 text-sm text-slate-400">
                    <li class="flex gap-2">
                        <i class="ph-duotone ph-check-circle text-emerald-400 mt-0.5"></i>
                        <span>@lang('Use') <code class="bg-white/10 px-1.5 py-0.5 rounded-lg text-xs">@{{message}}</code> @lang('to place the email content')</span>
                    </li>
                    <li class="flex gap-2">
                        <i class="ph-duotone ph-check-circle text-emerald-400 mt-0.5"></i>
                        <span>@lang('Include') <code class="bg-white/10 px-1.5 py-0.5 rounded-lg text-xs">@{{site_name}}</code> @lang('for branding')</span>
                    </li>
                    <li class="flex gap-2">
                        <i class="ph-duotone ph-check-circle text-emerald-400 mt-0.5"></i>
                        <span>@lang('Use inline CSS for email compatibility')</span>
                    </li>
                    <li class="flex gap-2">
                        <i class="ph-duotone ph-check-circle text-emerald-400 mt-0.5"></i>
                        <span>@lang('Test with different email clients')</span>
                    </li>
                </ul>
            </x-admin.card>
        </div>
    </div>

    <script>
        function globalEmailEditor(siteName) {
            return {
                showPreview: false,
                previewHtml: '',
                siteName: siteName,
                updatePreview() {
                    const template = this.$wire.email_template || '';
                    let preview = template
                        .replace(/\{\{fullname\}\}/g, 'John Doe')
                        .replace(/\{\{username\}\}/g, 'johndoe')
                        .replace(/\{\{message\}\}/g, '<p>This is a sample email message content that will appear in your emails.</p>')
                        .replace(/\{\{site_name\}\}/g, this.siteName)
                        .replace(/\{\{subject\}\}/g, 'Sample Email Subject');
                    this.previewHtml = preview;
                }
            }
        }

        function insertShortcode(code) {
            const textarea = document.getElementById('email-template-editor');
            if (!textarea) return;

            const start = textarea.selectionStart;
            const end = textarea.selectionEnd;
            const text = textarea.value;

            textarea.value = text.substring(0, start) + code + text.substring(end);
            textarea.selectionStart = textarea.selectionEnd = start + code.length;
            textarea.focus();

            // Trigger Livewire update
            textarea.dispatchEvent(new Event('input', { bubbles: true }));
        }
    </script>
</div>

