<div>
    <x-admin.page-header :title="__('Global Push Template')" :subtitle="__('Configure the global push notification template.')" />

    <!-- Navigation Tabs -->
    <div class="mt-6 flex gap-3 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.global.email') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Global Email')
        </a>
        <a href="{{ route('admin.setting.notification.global.sms') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('Global SMS')
        </a>
        <a href="{{ route('admin.setting.notification.global.push') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-purple-500/20 text-purple-400 border border-purple-500/30">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Global Push')
        </a>
        <a href="{{ route('admin.setting.notification.templates') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-files"></i>
            @lang('Templates')
        </a>
    </div>

    <div class="mt-6 grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Form Section -->
        <div class="lg:col-span-2">
            <x-admin.card>
                <form wire:submit="save" class="space-y-6">
                    <!-- Push Title -->
                    <x-admin.input wire:model="push_title" :label="__('Default Push Title')" placeholder="{{ __('Notification Title') }}" :helper="__('Default title for push notifications (can be overridden per template)')" :error="$errors->first('push_title')" />

                    <!-- Push Template -->
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Push Template')</label>
                        <p class="text-xs text-slate-500 mb-3">@lang('Use') <code class="bg-white/10 px-1.5 py-0.5 rounded-lg text-xs">@{{message}}</code> @lang('where the push content should appear.')</p>
                        <textarea wire:model="push_template" rows="6" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20 font-mono text-sm" placeholder="@{{message}}"></textarea>
                        @error('push_template') <span class="text-rose-400 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div class="flex justify-end pt-4 border-t border-white/5">
                        <x-admin.button type="submit" icon="ph-floppy-disk">
                            @lang('Save Template')
                        </x-admin.button>
                    </div>
                </form>
            </x-admin.card>
        </div>

        <!-- Shortcodes Reference -->
        <div>
            <x-admin.card>
                <h3 class="text-lg font-semibold text-slate-200 mb-4 flex items-center gap-2">
                    <i class="ph-duotone ph-code text-indigo-400"></i>
                    @lang('Available Shortcodes')
                </h3>
                <div class="space-y-3">
                    @foreach($shortcodes as $code => $description)
                    <div class="flex items-start gap-3 p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                        <code class="text-indigo-400 text-sm font-mono bg-indigo-500/10 px-2 py-1 rounded-lg">{{ $code }}</code>
                        <span class="text-slate-400 text-sm">{{ __($description) }}</span>
                    </div>
                    @endforeach
                </div>
            </x-admin.card>
        </div>
    </div>
</div>

