<div>
    <x-admin.page-header :title="__('Push Notification Settings')" :description="__('Configure Firebase Cloud Messaging for push notifications.')" />

    <!-- Navigation Tabs -->
    <div class="flex gap-3 mb-6 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.email') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Email Settings')
        </a>
        <a href="{{ route('admin.setting.notification.sms') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('SMS Settings')
        </a>
        <a href="{{ route('admin.setting.notification.push') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-primary-500/20 text-primary-400 border border-primary-500/30">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Push Settings')
        </a>
    </div>

    <!-- SSL Notice -->
    <div class="mb-6 p-4 bg-amber-500/10 border border-amber-500/20 rounded-xl">
        <div class="flex items-start gap-3">
            <i class="ph-duotone ph-warning text-amber-400 text-xl mt-0.5"></i>
            <div>
                <p class="text-amber-300 font-medium">@lang('SSL Required')</p>
                <p class="text-amber-400/80 text-sm">@lang('Push notifications require your site to have a valid SSL certificate (HTTPS).')</p>
            </div>
        </div>
    </div>

    <x-admin.card>
        <form wire:submit="save" class="space-y-6">
            <h3 class="text-lg font-semibold text-slate-200 flex items-center gap-2 mb-4">
                <i class="ph-duotone ph-fire text-orange-400"></i>
                @lang('Firebase Configuration')
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API Key')</label>
                    <input type="text" wire:model="apiKey" placeholder="AIzaSy..." class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Auth Domain')</label>
                    <input type="text" wire:model="authDomain" placeholder="project.firebaseapp.com" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Project ID')</label>
                    <input type="text" wire:model="projectId" placeholder="your-project-id" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Storage Bucket')</label>
                    <input type="text" wire:model="storageBucket" placeholder="project.appspot.com" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Messaging Sender ID')</label>
                    <input type="text" wire:model="messagingSenderId" placeholder="123456789" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('App ID')</label>
                    <input type="text" wire:model="appId" placeholder="1:123:web:abc" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Measurement ID')</label>
                    <input type="text" wire:model="measurementId" placeholder="G-XXXXXXXXXX" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
            </div>

            <!-- Service Account JSON -->
            <div class="border border-white/10 rounded-xl p-6 bg-white/[0.02]">
                <label class="block text-sm font-medium text-slate-300 mb-3">@lang('Service Account JSON File')</label>
                <p class="text-xs text-slate-500 mb-4">@lang('Upload the service account JSON file from Firebase Console → Project Settings → Service Accounts')</p>
                <div class="flex items-center gap-4">
                    <label class="flex-1 flex items-center justify-center px-6 py-4 border-2 border-dashed border-white/20 rounded-xl cursor-pointer hover:border-primary-500/50 transition-colors">
                        <input type="file" wire:model="serviceAccountFile" accept=".json" class="hidden">
                        <div class="text-center">
                            <i class="ph-duotone ph-upload-simple text-2xl text-slate-400 mb-2"></i>
                            <p class="text-sm text-slate-400">@lang('Click to upload JSON file')</p>
                        </div>
                    </label>
                    @if($serviceAccountFile)
                    <div class="flex items-center gap-2 px-4 py-2 bg-emerald-500/10 border border-emerald-500/20 rounded-xl">
                        <i class="ph-duotone ph-file-text text-emerald-400"></i>
                        <span class="text-emerald-400 text-sm">{{ $serviceAccountFile->getClientOriginalName() }}</span>
                    </div>
                    @endif
                </div>
            </div>

            <div class="flex justify-end pt-4">
                <button type="submit" class="inline-flex items-center gap-2 px-6 py-3 bg-primary-500 hover:bg-primary-600 text-white font-medium rounded-xl transition-colors">
                    <i class="ph-bold ph-floppy-disk"></i>
                    @lang('Save Settings')
                </button>
            </div>
        </form>
    </x-admin.card>
</div>

