<div>
    <x-admin.page-header :title="__('SMS Settings')" :description="__('Configure SMS gateway for sending SMS notifications.')" />

    <!-- Navigation Tabs -->
    <div class="flex gap-3 mb-6 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.email') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Email Settings')
        </a>
        <a href="{{ route('admin.setting.notification.sms') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-primary-500/20 text-primary-400 border border-primary-500/30">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('SMS Settings')
        </a>
        <a href="{{ route('admin.setting.notification.push') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Push Settings')
        </a>
    </div>

    <x-admin.card>
        <form wire:submit="save" class="space-y-6">
            <!-- SMS Method Selection -->
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">@lang('SMS Gateway')</label>
                <select wire:model.live="sms_method" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    <option value="clickatell">Clickatell</option>
                    <option value="infobip">Infobip</option>
                    <option value="messageBird">Message Bird</option>
                    <option value="nexmo">Nexmo (Vonage)</option>
                    <option value="smsBroadcast">SMS Broadcast</option>
                    <option value="twilio">Twilio</option>
                    <option value="textMagic">TextMagic</option>
                    <option value="custom">@lang('Custom API')</option>
                </select>
            </div>

            <!-- Clickatell -->
            @if($sms_method === 'clickatell')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('Clickatell Configuration')</h3>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API Key')</label>
                    <input type="password" wire:model="clickatell_api_key" placeholder="{{ __('Clickatell API Key') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
            </div>
            @endif

            <!-- Infobip -->
            @if($sms_method === 'infobip')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('Infobip Configuration')</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Username')</label>
                        <input type="text" wire:model="infobip_username" placeholder="{{ __('Username') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Password')</label>
                        <input type="password" wire:model="infobip_password" placeholder="{{ __('Password') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                </div>
            </div>
            @endif

            <!-- MessageBird -->
            @if($sms_method === 'messageBird')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('MessageBird Configuration')</h3>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API Key')</label>
                    <input type="password" wire:model="messagebird_api_key" placeholder="{{ __('MessageBird API Key') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                </div>
            </div>
            @endif

            <!-- Nexmo -->
            @if($sms_method === 'nexmo')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('Nexmo (Vonage) Configuration')</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API Key')</label>
                        <input type="text" wire:model="nexmo_api_key" placeholder="{{ __('API Key') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API Secret')</label>
                        <input type="password" wire:model="nexmo_api_secret" placeholder="{{ __('API Secret') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                </div>
            </div>
            @endif

            <!-- SMS Broadcast -->
            @if($sms_method === 'smsBroadcast')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('SMS Broadcast Configuration')</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Username')</label>
                        <input type="text" wire:model="smsbroadcast_username" placeholder="{{ __('Username') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Password')</label>
                        <input type="password" wire:model="smsbroadcast_password" placeholder="{{ __('Password') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                </div>
            </div>
            @endif

            <!-- Twilio -->
            @if($sms_method === 'twilio')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('Twilio Configuration')</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Account SID')</label>
                        <input type="text" wire:model="twilio_account_sid" placeholder="{{ __('Account SID') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Auth Token')</label>
                        <input type="password" wire:model="twilio_auth_token" placeholder="{{ __('Auth Token') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('From Number')</label>
                        <input type="text" wire:model="twilio_from" placeholder="+1234567890" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                </div>
            </div>
            @endif

            <!-- TextMagic -->
            @if($sms_method === 'textMagic')
            <div class="border border-white/10 rounded-xl p-6 space-y-4 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('TextMagic Configuration')</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Username')</label>
                        <input type="text" wire:model="textmagic_username" placeholder="{{ __('Username') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API v2 Key')</label>
                        <input type="password" wire:model="textmagic_apiv2_key" placeholder="{{ __('API v2 Key') }}" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                </div>
            </div>
            @endif

            <!-- Custom API - Part 1 -->
            @if($sms_method === 'custom')
            <div class="border border-white/10 rounded-xl p-6 space-y-6 bg-white/[0.02]">
                <h3 class="text-lg font-semibold text-slate-200">@lang('Custom API Configuration')</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('API URL')</label>
                        <input type="url" wire:model="custom_url" placeholder="https://api.example.com/sms" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Method')</label>
                        <select wire:model="custom_method" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-slate-200 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                            <option value="GET">GET</option>
                            <option value="POST">POST</option>
                        </select>
                    </div>
                </div>

                <!-- Headers -->
                <div>
                    <div class="flex items-center justify-between mb-3">
                        <label class="text-sm font-medium text-slate-300">@lang('Headers')</label>
                        <button type="button" wire:click="addHeader" class="text-xs text-primary-400 hover:text-primary-300">+ @lang('Add Header')</button>
                    </div>
                    @foreach($custom_headers as $index => $header)
                    <div class="flex gap-3 mb-2">
                        <input type="text" wire:model="custom_headers.{{ $index }}.key" placeholder="{{ __('Header Key') }}" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-2 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        <input type="text" wire:model="custom_headers.{{ $index }}.value" placeholder="{{ __('Header Value') }}" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-2 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        <button type="button" wire:click="removeHeader({{ $index }})" class="p-2 text-red-400 hover:text-red-300"><i class="ph-bold ph-trash"></i></button>
                    </div>
                    @endforeach
                </div>

                <!-- Body Params -->
                <div>
                    <div class="flex items-center justify-between mb-3">
                        <label class="text-sm font-medium text-slate-300">@lang('Body Parameters')</label>
                        <button type="button" wire:click="addBodyParam" class="text-xs text-primary-400 hover:text-primary-300">+ @lang('Add Parameter')</button>
                    </div>
                    <p class="text-xs text-slate-500 mb-3">@lang('Use') <code class="bg-white/10 px-1 rounded">@{{number}}</code> @lang('and') <code class="bg-white/10 px-1 rounded">@{{message}}</code> @lang('as placeholders')</p>
                    @foreach($custom_body as $index => $param)
                    <div class="flex gap-3 mb-2">
                        <input type="text" wire:model="custom_body.{{ $index }}.key" placeholder="{{ __('Parameter Key') }}" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-2 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        <input type="text" wire:model="custom_body.{{ $index }}.value" placeholder="{{ __('Parameter Value') }}" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-2 text-slate-200 placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/50">
                        <button type="button" wire:click="removeBodyParam({{ $index }})" class="p-2 text-red-400 hover:text-red-300"><i class="ph-bold ph-trash"></i></button>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <div class="flex justify-end pt-4">
                <button type="submit" class="inline-flex items-center gap-2 px-6 py-3 bg-primary-500 hover:bg-primary-600 text-white font-medium rounded-xl transition-colors">
                    <i class="ph-bold ph-floppy-disk"></i>
                    @lang('Save Settings')
                </button>
            </div>
        </form>
    </x-admin.card>
</div>

