@php $editTitle = __('Edit :type Template', ['type' => ucfirst($type)]); @endphp
<div x-data="templateEditor(@js(config('app.name')))" x-init="updatePreview()">
    <x-admin.page-header :title="$editTitle" :subtitle="$template->name">
        <x-slot name="actions">
            <x-admin.button href="{{ route('admin.setting.notification.templates') }}" variant="secondary"
                icon="ph-arrow-left">
                @lang('Back to Templates')
            </x-admin.button>
        </x-slot>
    </x-admin.page-header>

    <!-- Type Tabs -->
    <div class="mt-6 flex gap-3 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.template.edit', ['type' => 'email', 'id' => $template->id]) }}"
            class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium {{ $type === 'email' ? 'bg-indigo-500/20 text-indigo-400 border border-indigo-500/30' : 'bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10' }} transition-colors">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Email Template')
        </a>
        <a href="{{ route('admin.setting.notification.template.edit', ['type' => 'sms', 'id' => $template->id]) }}"
            class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium {{ $type === 'sms' ? 'bg-amber-500/20 text-amber-400 border border-amber-500/30' : 'bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10' }} transition-colors">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('SMS Template')
        </a>
        <a href="{{ route('admin.setting.notification.template.edit', ['type' => 'push', 'id' => $template->id]) }}"
            class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium {{ $type === 'push' ? 'bg-purple-500/20 text-purple-400 border border-purple-500/30' : 'bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10' }} transition-colors">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Push Template')
        </a>
    </div>

    <div class="mt-6 grid grid-cols-1 xl:grid-cols-3 gap-6">
        <!-- Form Section -->
        <div class="xl:col-span-2">
            <x-admin.card>
                <form wire:submit="save" class="space-y-6">
                    @if($type === 'email')
                        <!-- Email Template Form -->
                        <div
                            class="flex items-center justify-between p-4 bg-indigo-500/10 border border-indigo-500/20 rounded-xl">
                            <div class="flex items-center gap-3">
                                <i class="ph-duotone ph-envelope text-2xl text-indigo-400"></i>
                                <div>
                                    <p class="text-indigo-300 font-medium">@lang('Email Notification')</p>
                                    <p class="text-indigo-400/70 text-sm">@lang('Configure email template for this event')
                                    </p>
                                </div>
                            </div>
                            <x-admin.toggle wire:model="email_status" />
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <x-admin.input wire:model="email_sent_from_name" :label="__('From Name (Optional)')"
                                :placeholder="__('Leave empty to use global')" />
                            <x-admin.input type="email" wire:model="email_sent_from_address" :label="__('From Email (Optional)')" :placeholder="__('Leave empty to use global')" />
                        </div>

                        <x-admin.input wire:model="subject" :label="__('Subject')" :placeholder="__('Email subject')"
                            :error="$errors->first('subject')" />

                        <div>
                            <div class="flex items-center justify-between mb-3">
                                <label class="block text-sm font-medium text-slate-300">@lang('Email Body (HTML)')</label>
                                <button type="button" @click="showPreview = !showPreview; if(showPreview) updatePreview()"
                                    class="inline-flex items-center gap-2 px-3 py-1.5 text-xs font-medium rounded-xl transition-colors"
                                    :class="showPreview ? 'bg-indigo-500/20 text-indigo-400' : 'bg-white/5 text-slate-400 hover:bg-white/10'">
                                    <i class="ph-duotone" :class="showPreview ? 'ph-eye-slash' : 'ph-eye'"></i>
                                    <span
                                        x-text="showPreview ? '{{ __('Hide Preview') }}' : '{{ __('Show Preview') }}'"></span>
                                </button>
                            </div>

                            <!-- Quick Insert Shortcodes -->
                            @if(count($shortcodes) > 0)
                                <div class="flex flex-wrap gap-2 mb-3">
                                    <span class="text-xs text-slate-500">@lang('Insert'):</span>
                                    @foreach($shortcodes as $code => $description)
                                        @php $shortcode = '{{' . $code . '}}'; @endphp

                                                                    <button type="button" onclick="insertEmailShortcode('{{ $shortcode }}')"
                                            class="px-2 py-1 text-xs font-mono bg-indigo-500/10 text-indigo-400 rounded-lg hover:bg-indigo-500/20 transition-colors"
                                            title="{{ $description }}">
                                            {{ $shortcode }}
                                        </button>
                                    @endforeach
                                </div>
                            @endif

                            <div class="grid gap-4" :class="showPreview ? 'grid-cols-1 lg:grid-cols-2' : 'grid-cols-1'">
                                <div>
                                    <textarea id="email-body-editor" wire:model.live.debounce.500ms="email_body" rows="18"
                                        @input="updatePreview()"
                                        class="w-full bg-slate-900/50 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:border-indigo-500/50 focus:ring-2 focus:ring-indigo-500/20 font-mono text-sm leading-relaxed"></textarea>
                                    @error('email_body') <span class="text-rose-400 text-xs mt-1">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Live Preview -->
                                <div x-show="showPreview" x-transition class="relative">
                                    <div
                                        class="absolute top-0 left-0 right-0 bg-slate-800 border-b border-white/10 rounded-t-xl px-4 py-2 flex items-center gap-2 z-10">
                                        <div class="flex gap-1.5">
                                            <span class="w-3 h-3 rounded-full bg-rose-500/80"></span>
                                            <span class="w-3 h-3 rounded-full bg-amber-500/80"></span>
                                            <span class="w-3 h-3 rounded-full bg-emerald-500/80"></span>
                                        </div>
                                        <span class="text-xs text-slate-400 ml-2">@lang('Email Preview')</span>
                                    </div>
                                    <div class="bg-white rounded-xl pt-10 overflow-hidden" style="height: 380px;">
                                        <iframe class="w-full h-full border-0" :srcdoc="previewHtml"></iframe>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($type === 'sms')
                        <!-- SMS Template Form -->
                        <div
                            class="flex items-center justify-between p-4 bg-amber-500/10 border border-amber-500/20 rounded-xl">
                            <div class="flex items-center gap-3">
                                <i class="ph-duotone ph-chat-text text-2xl text-amber-400"></i>
                                <div>
                                    <p class="text-amber-300 font-medium">@lang('SMS Notification')</p>
                                    <p class="text-amber-400/70 text-sm">@lang('Configure SMS template for this event')</p>
                                </div>
                            </div>
                            <x-admin.toggle wire:model="sms_status" />
                        </div>

                        <x-admin.input wire:model="sms_sent_from" :label="__('From (Sender ID) - Optional')"
                            :placeholder="__('Leave empty to use global')" />

                        <div>
                            <div class="flex items-center justify-between mb-3">
                                <label class="block text-sm font-medium text-slate-300">@lang('SMS Body')</label>
                                <span class="text-xs text-slate-500" x-data="{ count: 0 }"
                                    x-init="count = $wire.sms_body?.length || 0; $watch('$wire.sms_body', val => count = val?.length || 0)">
                                    <span x-text="count"></span>/160 @lang('characters')
                                </span>
                            </div>

                            <!-- Quick Insert Shortcodes -->
                            @if(count($shortcodes) > 0)
                                <div class="flex flex-wrap gap-2 mb-3">
                                    <span class="text-xs text-slate-500">@lang('Insert'):</span>
                                    @foreach($shortcodes as $code => $description)
                                        @php $shortcode = '{{' . $code . '}}'; @endphp

                                                                    <button type="button" onclick="insertSmsShortcode('{{ $shortcode }}')"
                                            class="px-2 py-1 text-xs font-mono bg-amber-500/10 text-amber-400 rounded-lg hover:bg-amber-500/20 transition-colors"
                                            title="{{ $description }}">
                                            {{ $shortcode }}
                                        </button>
                                    @endforeach
                                </div>
                            @endif

                            <textarea id="sms-body-editor" wire:model.live="sms_body" rows="6"
                                class="w-full bg-slate-900/50 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:border-amber-500/50 focus:ring-2 focus:ring-amber-500/20 font-mono text-sm"></textarea>
                            @error('sms_body') <span class="text-rose-400 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>
                    @endif

                    @if($type === 'push')
                        <!-- Push Template Form -->
                        <div
                            class="flex items-center justify-between p-4 bg-purple-500/10 border border-purple-500/20 rounded-xl">
                            <div class="flex items-center gap-3">
                                <i class="ph-duotone ph-bell-ringing text-2xl text-purple-400"></i>
                                <div>
                                    <p class="text-purple-300 font-medium">@lang('Push Notification')</p>
                                    <p class="text-purple-400/70 text-sm">@lang('Configure push template for this event')
                                    </p>
                                </div>
                            </div>
                            <x-admin.toggle wire:model="push_status" />
                        </div>

                        <x-admin.input wire:model="push_title" :label="__('Push Title')" :placeholder="__('Notification title')" />

                        <div>
                            <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Push Body')</label>

                            <!-- Quick Insert Shortcodes -->
                            @if(count($shortcodes) > 0)
                                <div class="flex flex-wrap gap-2 mb-3">
                                    <span class="text-xs text-slate-500">@lang('Insert'):</span>
                                    @foreach($shortcodes as $code => $description)
                                        @php $shortcode = '{{' . $code . '}}'; @endphp

                                                                    <button type="button" onclick="insertPushShortcode('{{ $shortcode }}')"
                                            class="px-2 py-1 text-xs font-mono bg-purple-500/10 text-purple-400 rounded-lg hover:bg-purple-500/20 transition-colors"
                                            title="{{ $description }}">
                                            {{ $shortcode }}
                                        </button>
                                    @endforeach
                                </div>
                            @endif

                            <textarea id="push-body-editor" wire:model="push_body" rows="4"
                                class="w-full bg-slate-900/50 border border-white/10 rounded-xl px-4 py-3 text-slate-200 placeholder-slate-500 focus:outline-none focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20 font-mono text-sm"></textarea>
                            @error('push_body') <span class="text-rose-400 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <!-- Push Preview -->
                        @php $defaultTitle = __('Notification Title');
                        $defaultBody = __('Notification body message will appear here...'); @endphp
                        <div class="p-4 bg-slate-800 rounded-xl">
                            <p class="text-xs text-slate-500 mb-3">@lang('Push Notification Preview')</p>
                            <div class="bg-white rounded-xl p-4 max-w-sm shadow-lg">
                                <div class="flex items-start gap-3">
                                    <div
                                        class="w-10 h-10 bg-gradient-to-br from-indigo-500 to-purple-500 rounded-xl flex items-center justify-center shrink-0">
                                        <i class="ph-bold ph-bell text-white"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-slate-900 font-medium text-sm truncate">
                                            {{ $push_title ?: $defaultTitle }}</p>
                                        <p class="text-slate-600 text-xs mt-0.5 line-clamp-2">
                                            {{ $push_body ?: $defaultBody }}</p>
                                        <p class="text-slate-400 text-xs mt-1">@lang('now')</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="flex justify-end pt-4 border-t border-white/5">
                        <x-admin.button type="submit" icon="ph-floppy-disk">
                            @lang('Save Template')
                        </x-admin.button>
                    </div>
                </form>
            </x-admin.card>
        </div>

        <!-- Shortcodes Reference -->
        <div class="space-y-6">
            <x-admin.card>
                <h3 class="text-lg font-semibold text-slate-200 mb-4 flex items-center gap-2">
                    <i class="ph-duotone ph-code text-indigo-400"></i>
                    @lang('Available Shortcodes')
                </h3>
                <div class="space-y-2 max-h-[400px] overflow-y-auto pr-2">
                    @forelse($shortcodes as $code => $description)
                        @php $shortcode = '{{' . $code . '}}'; @endphp

                                            <div class="group flex items-start gap-3 p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors cursor-pointer"
                            onclick="copyShortcode('{{ $shortcode }}')">
                            <code
                                class="text-indigo-400 text-xs font-mono bg-indigo-500/10 px-2 py-1 rounded-lg shrink-0">{{ $shortcode }}</code>
                            <span class="text-slate-400 text-xs flex-1">{{ $description }}</span>
                            <i
                                class="ph-duotone ph-copy text-slate-500 group-hover:text-indigo-400 transition-colors text-sm"></i>
                        </div>
                    @empty
                        <p class="text-slate-500 text-sm">@lang('No shortcodes available for this template.')</p>
                    @endforelse
                </div>
            </x-admin.card>

            <!-- Template Info -->
            <x-admin.card>
                <h3 class="text-lg font-semibold text-slate-200 mb-4 flex items-center gap-2">
                    <i class="ph-duotone ph-info text-indigo-400"></i>
                    @lang('Template Info')
                </h3>
                <div class="space-y-3">
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-slate-400 text-sm">@lang('Action Code')</span>
                        <code class="text-slate-300 text-xs bg-white/5 px-2 py-1 rounded-lg">{{ $template->act }}</code>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-slate-400 text-sm">@lang('Name')</span>
                        <span class="text-slate-300 text-sm">{{ $template->name }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-slate-400 text-sm">@lang('Email')</span>
                        <x-admin.badge :type="$template->email_status ? 'success' : 'secondary'" size="sm">
                            {{ $template->email_status ? __('Enabled') : __('Disabled') }}
                        </x-admin.badge>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-slate-400 text-sm">@lang('SMS')</span>
                        <x-admin.badge :type="$template->sms_status ? 'success' : 'secondary'" size="sm">
                            {{ $template->sms_status ? __('Enabled') : __('Disabled') }}
                        </x-admin.badge>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-slate-400 text-sm">@lang('Push')</span>
                        <x-admin.badge :type="$template->push_status ? 'success' : 'secondary'" size="sm">
                            {{ $template->push_status ? __('Enabled') : __('Disabled') }}
                        </x-admin.badge>
                    </div>
                    <div class="flex justify-between items-center py-2">
                        <span class="text-slate-400 text-sm">@lang('Last Updated')</span>
                        <span class="text-slate-300 text-sm">{{ $template->updated_at->diffForHumans() }}</span>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.8.2/tinymce.min.js"></script>
    <script>
        function templateEditor(siteName) {
            return {
            showPreview: false,
        previewHtml: '',
        siteName: siteName,
        editor: null,

        init() {
                    if (@js($type) === 'email') {
            this.initEditor();
                    }
        this.updatePreview();
                },

        initEditor() {
                    const self = this;
        tinymce.init({
            selector: '#email-body-editor',
        height: 500,
        skin: 'oxide-dark',
        content_css: 'dark',
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        setup: function(ed) {
            self.editor = ed;
        ed.on('init', function() {
            ed.setContent(@js($email_body));
                            });
        ed.on('change keyup', function() {
                                const content = ed.getContent();
        self.$wire.set('email_body', content);
        self.updatePreview();
                            });
                        }
                    });
                },

        updatePreview() {
                    const body = this.editor ? this.editor.getContent() : (this.$wire.email_body || '');
        let preview = body
        .replace(/\{\{fullname\}\}/g, 'John Doe')
        .replace(/\{\{username\}\}/g, 'johndoe')
        .replace(/\{\{site_name\}\}/g, this.siteName)
        .replace(/\{\{site_currency\}\}/g, 'USD')
        .replace(/\{\{amount\}\}/g, '99.00')
        .replace(/\{\{trx\}\}/g, 'TRX123456')
        .replace(/\{\{code\}\}/g, '123456')
        .replace(/\{\{service_name\}\}/g, 'Premium Hosting')
        .replace(/\{\{invoice_number\}\}/g, 'INV-001')
        .replace(/\{\{order_id\}\}/g, 'ORD-001')
        .replace(/\{\{domain\}\}/g, 'example.com')
        .replace(/\{\{[a - z_] +\}\}/gi, '<span style="background:#dbeafe;padding:2px 6px;border-radius:4px;font-size:12px;color:#1e40af;">[dynamic]</span>');
        this.previewHtml = '<div style="font-family: Arial, sans-serif; padding: 20px;">' + preview + '</div>';
                },

        insertShortcode(code) {
                    if (this.editor) {
            this.editor.insertContent(code);
        this.$wire.set('email_body', this.editor.getContent());
                    } else {
            insertToTextarea('sms-body-editor', code);
        insertToTextarea('push-body-editor', code);
                    }
        this.updatePreview();
                }
            }
        }

        function insertEmailShortcode(code) {
            const alpine = document.querySelector('[x-data^="templateEditor"]').__x.$data;
        alpine.insertShortcode(code);
        }

        function insertSmsShortcode(code) {
            insertToTextarea('sms-body-editor', code);
        }

        function insertPushShortcode(code) {
            insertToTextarea('push-body-editor', code);
        }

        function insertToTextarea(id, code) {
            const textarea = document.getElementById(id);
        if (!textarea) return;

        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const text = textarea.value;

        textarea.value = text.substring(0, start) + code + text.substring(end);
        textarea.selectionStart = textarea.selectionEnd = start + code.length;
        textarea.focus();

        // Trigger Livewire update
        textarea.dispatchEvent(new Event('input', {bubbles: true }));
        }

        function copyShortcode(code) {
            navigator.clipboard.writeText(code);
        }
    </script>
</div>