<div>
    <x-admin.page-header :title="__('Notification Templates')" :subtitle="__('Manage email, SMS, and push notification templates for various system events.')" />

    <!-- Navigation Tabs -->
    <div class="mt-6 flex gap-3 overflow-x-auto pb-2">
        <a href="{{ route('admin.setting.notification.global.email') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-envelope"></i>
            @lang('Global Email')
        </a>
        <a href="{{ route('admin.setting.notification.global.sms') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-chat-text"></i>
            @lang('Global SMS')
        </a>
        <a href="{{ route('admin.setting.notification.global.push') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-white/5 text-slate-400 border border-white/10 hover:bg-white/10 transition-colors">
            <i class="ph-duotone ph-bell-ringing"></i>
            @lang('Global Push')
        </a>
        <a href="{{ route('admin.setting.notification.templates') }}" class="flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium bg-indigo-500/20 text-indigo-400 border border-indigo-500/30">
            <i class="ph-duotone ph-files"></i>
            @lang('Templates')
        </a>
    </div>

    <!-- Search -->
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search templates...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>
        </div>
    </x-admin.card>

    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Template')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Subject')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Email')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('SMS')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Push')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($templates as $template)
                    <tr class="group transition-all hover:bg-white/[0.02]" wire:key="template-{{ $template->id }}">
                        <td class="px-6 py-4">
                            <div>
                                <p class="font-medium text-white">{{ $template->name }}</p>
                                <p class="text-xs text-slate-500">{{ $template->act }}</p>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-slate-300">{{ Str::limit($template->subject, 40) }}</span>
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($template->email_status)
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-xl bg-emerald-500/10 text-emerald-400">
                                <i class="ph-bold ph-check"></i>
                            </span>
                            @else
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-xl bg-slate-500/10 text-slate-500">
                                <i class="ph-bold ph-x"></i>
                            </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($template->sms_status)
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-xl bg-emerald-500/10 text-emerald-400">
                                <i class="ph-bold ph-check"></i>
                            </span>
                            @else
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-xl bg-slate-500/10 text-slate-500">
                                <i class="ph-bold ph-x"></i>
                            </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($template->push_status)
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-xl bg-emerald-500/10 text-emerald-400">
                                <i class="ph-bold ph-check"></i>
                            </span>
                            @else
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-xl bg-slate-500/10 text-slate-500">
                                <i class="ph-bold ph-x"></i>
                            </span>
                            @endif
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center justify-end gap-2">
                                <a href="{{ route('admin.setting.notification.template.edit', ['type' => 'email', 'id' => $template->id]) }}" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-xs font-medium rounded-xl bg-indigo-500/10 text-indigo-400 hover:bg-indigo-500/20 transition-colors" title="{{ __('Edit Email') }}">
                                    <i class="ph-duotone ph-envelope"></i>
                                    @lang('Email')
                                </a>
                                <a href="{{ route('admin.setting.notification.template.edit', ['type' => 'sms', 'id' => $template->id]) }}" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-xs font-medium rounded-xl bg-amber-500/10 text-amber-400 hover:bg-amber-500/20 transition-colors" title="{{ __('Edit SMS') }}">
                                    <i class="ph-duotone ph-chat-text"></i>
                                    @lang('SMS')
                                </a>
                                <a href="{{ route('admin.setting.notification.template.edit', ['type' => 'push', 'id' => $template->id]) }}" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-xs font-medium rounded-xl bg-purple-500/10 text-purple-400 hover:bg-purple-500/20 transition-colors" title="{{ __('Edit Push') }}">
                                    <i class="ph-duotone ph-bell-ringing"></i>
                                    @lang('Push')
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-16 text-center">
                            <div class="flex flex-col items-center">
                                <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                    <i class="ph-duotone ph-files text-3xl text-slate-500"></i>
                                </div>
                                <h3 class="mt-4 text-lg font-medium text-white">@lang('No templates found')</h3>
                                <p class="mt-1 text-sm text-slate-500">
                                    @if($search)
                                        @lang('No templates match your search criteria.')
                                    @else
                                        @lang('No notification templates have been created yet.')
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($templates->hasPages())
        <div class="border-t border-white/5 px-6 py-4">
            {{ $templates->links() }}
        </div>
        @endif
    </x-admin.card>
</div>

