<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Robots.txt Settings')" :subtitle="__('Configure your robots.txt file to control search engine crawlers')">
        <x-slot:actions>
            <x-admin.button type="submit" form="robots-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-robot"
            iconColor="primary"
            :label="__('File')"
            value="robots.txt"
        />
        <x-admin.stat-card
            icon="ph-text-aa"
            iconColor="info"
            :label="__('Content Length')"
            :value="strlen($content ?? '') . ' ' . __('chars')"
        />
        <x-admin.stat-card
            icon="ph-folder-simple"
            iconColor="success"
            :label="__('Location')"
            value="public/"
        />
    </div>

    <div class="mt-6 grid grid-cols-1 xl:grid-cols-3 gap-6">
        {{-- Main Editor --}}
        <div class="xl:col-span-2">
            <x-admin.card>
                <form wire:submit="save" id="robots-form">
                    {{-- Section Header --}}
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-robot text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Robots.txt Content')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure crawler access rules')</p>
                        </div>
                    </div>

                    {{-- Content Editor --}}
                    <div class="relative">
                        <div class="absolute top-3 left-3 flex items-center gap-2 z-10">
                            <span class="px-2 py-1 text-xs font-mono uppercase tracking-wider bg-emerald-500/10 text-emerald-400 rounded-md">TXT</span>
                        </div>
                        <textarea
                            id="content"
                            wire:model="content"
                            rows="15"
                            spellcheck="false"
                            class="w-full rounded-xl border border-white/10 bg-slate-900/80 px-4 py-3 pt-12 font-mono text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-slate-900 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-y"
                            placeholder="{{ __('Enter your robots.txt content...') }}"
                        ></textarea>
                        @error('content') <span class="mt-1 text-sm text-rose-400 block">{{ $message }}</span> @enderror
                    </div>

                    {{-- Actions --}}
                    <div class="mt-5 pt-5 border-t border-white/5">
                        <button type="button" wire:click="resetToDefault" class="inline-flex items-center gap-2 rounded-xl bg-white/5 border border-white/10 px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                            <i class="ph-bold ph-arrow-counter-clockwise text-base"></i>
                            @lang('Reset to Default')
                        </button>
                    </div>
                </form>
            </x-admin.card>
        </div>

        {{-- Sidebar --}}
        <div class="space-y-6">
            {{-- Info Card --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-sky-500/20 to-cyan-500/20">
                        <i class="ph-duotone ph-info text-lg text-sky-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('About Robots.txt')</h3>
                </div>
                <p class="text-sm text-slate-400 leading-relaxed">
                    @lang('The robots.txt file tells search engine crawlers which pages or files they can or can\'t request from your site. This is used mainly to avoid overloading your site with requests.')
                </p>
            </x-admin.card>

            {{-- Common Directives --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-code text-lg text-amber-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('Common Directives')</h3>
                </div>
                <div class="space-y-3">
                    <div class="rounded-xl bg-white/5 border border-white/5 px-3 py-2.5">
                        <code class="text-xs text-indigo-400 font-mono">User-agent: *</code>
                        <p class="mt-1 text-xs text-slate-500">@lang('Applies to all crawlers')</p>
                    </div>
                    <div class="rounded-xl bg-white/5 border border-white/5 px-3 py-2.5">
                        <code class="text-xs text-rose-400 font-mono">Disallow: /path/</code>
                        <p class="mt-1 text-xs text-slate-500">@lang('Block access to a path')</p>
                    </div>
                    <div class="rounded-xl bg-white/5 border border-white/5 px-3 py-2.5">
                        <code class="text-xs text-emerald-400 font-mono">Allow: /path/</code>
                        <p class="mt-1 text-xs text-slate-500">@lang('Allow access to a path')</p>
                    </div>
                    <div class="rounded-xl bg-white/5 border border-white/5 px-3 py-2.5">
                        <code class="text-xs text-purple-400 font-mono">Sitemap: URL</code>
                        <p class="mt-1 text-xs text-slate-500">@lang('Location of your sitemap')</p>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>
</div>

