<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Sitemap Settings')" :subtitle="__('Configure and generate your XML sitemap for search engines')">
        <x-slot:actions>
            <x-admin.button type="submit" form="sitemap-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="saveSettings">@lang('Save Settings')</span>
                <span wire:loading wire:target="saveSettings">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-file-xml"
            iconColor="primary"
            :label="__('Sitemap')"
            :value="$lastGenerated ? __('Generated') : __('Not Generated')"
        />
        <x-admin.stat-card
            icon="ph-clock"
            iconColor="info"
            :label="__('Frequency')"
            :value="ucfirst($changeFrequency ?? 'weekly')"
        />
        <x-admin.stat-card
            icon="ph-chart-bar"
            iconColor="success"
            :label="__('Priority')"
            :value="$priority ?? '0.5'"
        />
    </div>

    <div class="mt-6 grid gap-6 lg:grid-cols-3">
        {{-- Settings Form --}}
        <div class="lg:col-span-2">
            <x-admin.card>
                <form wire:submit="saveSettings" id="sitemap-form">
                    {{-- Section Header --}}
                    <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-gear text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Sitemap Configuration')</h3>
                            <p class="text-sm text-slate-500">@lang('Configure what to include in your sitemap')</p>
                        </div>
                    </div>

                    {{-- Include Options --}}
                    <div class="space-y-4 mb-6">
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Include in Sitemap')</label>

                        <label class="group flex cursor-pointer items-center justify-between rounded-xl border border-white/5 bg-white/[0.02] px-4 py-3 transition-all hover:border-white/10 hover:bg-white/5">
                            <div class="flex items-center gap-3">
                                <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-indigo-500/10">
                                    <i class="ph-duotone ph-file-text text-lg text-indigo-400"></i>
                                </div>
                                <span class="text-sm font-medium text-slate-300">@lang('Static Pages')</span>
                            </div>
                            <div class="relative">
                                <input type="checkbox" wire:model="includePages" class="sr-only peer" />
                                <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                                <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                            </div>
                        </label>

                        <label class="group flex cursor-pointer items-center justify-between rounded-xl border border-white/5 bg-white/[0.02] px-4 py-3 transition-all hover:border-white/10 hover:bg-white/5">
                            <div class="flex items-center gap-3">
                                <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-emerald-500/10">
                                    <i class="ph-duotone ph-package text-lg text-emerald-400"></i>
                                </div>
                                <span class="text-sm font-medium text-slate-300">@lang('Products')</span>
                            </div>
                            <div class="relative">
                                <input type="checkbox" wire:model="includeProducts" class="sr-only peer" />
                                <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                                <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                            </div>
                        </label>

                        <label class="group flex cursor-pointer items-center justify-between rounded-xl border border-white/5 bg-white/[0.02] px-4 py-3 transition-all hover:border-white/10 hover:bg-white/5">
                            <div class="flex items-center gap-3">
                                <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-purple-500/10">
                                    <i class="ph-duotone ph-article text-lg text-purple-400"></i>
                                </div>
                                <span class="text-sm font-medium text-slate-300">@lang('Blog Posts')</span>
                            </div>
                            <div class="relative">
                                <input type="checkbox" wire:model="includeBlog" class="sr-only peer" />
                                <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                                <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5"></div>
                            </div>
                        </label>
                    </div>

                    {{-- Change Frequency --}}
                    <div class="mb-5">
                        <label for="changeFrequency" class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Change Frequency')</label>
                        <select id="changeFrequency" wire:model="changeFrequency" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($this->frequencyOptions as $value => $label)
                                <option value="{{ $value }}" class="bg-[#1a1a24]">{{ __($label) }}</option>
                            @endforeach
                        </select>
                        <p class="mt-1.5 text-xs text-slate-500">@lang('How frequently the page is likely to change')</p>
                    </div>

                    {{-- Priority --}}
                    <div>
                        <label for="priority" class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Default Priority')</label>
                        <select id="priority" wire:model="priority" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($this->priorityOptions as $value => $label)
                                <option value="{{ $value }}" class="bg-[#1a1a24]">{{ $label }}</option>
                            @endforeach
                        </select>
                        <p class="mt-1.5 text-xs text-slate-500">@lang('The priority of this URL relative to other URLs on your site')</p>
                    </div>
                </form>
            </x-admin.card>
        </div>

        {{-- Sidebar --}}
        <div class="space-y-6">
            {{-- Generate Sitemap --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                        <i class="ph-duotone ph-arrows-clockwise text-lg text-emerald-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('Generate Sitemap')</h3>
                </div>

                <div class="space-y-4">
                    @if($lastGenerated)
                        <div class="rounded-xl border border-emerald-500/20 bg-emerald-500/10 p-4">
                            <div class="flex items-center gap-3">
                                <i class="ph-duotone ph-check-circle text-xl text-emerald-400"></i>
                                <div>
                                    <p class="text-sm font-medium text-white">@lang('Last Generated')</p>
                                    <p class="text-xs text-slate-400">{{ $lastGenerated }}</p>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="rounded-xl border border-amber-500/20 bg-amber-500/10 p-4">
                            <div class="flex items-center gap-3">
                                <i class="ph-duotone ph-warning text-xl text-amber-400"></i>
                                <div>
                                    <p class="text-sm font-medium text-white">@lang('No Sitemap')</p>
                                    <p class="text-xs text-slate-400">@lang('Sitemap has not been generated yet')</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <button wire:click="generateSitemap" wire:loading.attr="disabled" class="w-full inline-flex items-center justify-center gap-2 rounded-xl bg-emerald-500/10 border border-emerald-500/20 px-4 py-3 text-sm font-medium text-emerald-400 transition-all hover:bg-emerald-500/20 disabled:opacity-50">
                        <span wire:loading.remove wire:target="generateSitemap" class="flex items-center gap-2">
                            <i class="ph-bold ph-arrows-clockwise text-base"></i>
                            @lang('Generate Sitemap')
                        </span>
                        <span wire:loading wire:target="generateSitemap" class="flex items-center gap-2">
                            <svg class="h-4 w-4 animate-spin" viewBox="0 0 24 24" fill="none">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            @lang('Generating...')
                        </span>
                    </button>

                    @if($lastGenerated)
                        <a href="{{ url('sitemap.xml') }}" target="_blank" class="w-full inline-flex items-center justify-center gap-2 rounded-xl bg-white/5 border border-white/10 px-4 py-3 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                            <i class="ph-bold ph-arrow-square-out text-base"></i>
                            @lang('View Sitemap')
                        </a>
                    @endif
                </div>
            </x-admin.card>

            {{-- Info --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-sky-500/20 to-cyan-500/20">
                        <i class="ph-duotone ph-info text-lg text-sky-400"></i>
                    </div>
                    <h3 class="font-semibold text-white">@lang('About Sitemaps')</h3>
                </div>
                <div class="space-y-3 text-sm text-slate-400 leading-relaxed">
                    <p>@lang('A sitemap is a file that provides information about the pages, videos, and other files on your site, and the relationships between them.')</p>
                    <p>@lang('Search engines like Google read this file to crawl your site more efficiently.')</p>
                </div>
            </x-admin.card>
        </div>
    </div>
</div>

