<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Social Login Credentials')" :subtitle="__('Configure OAuth credentials for social login providers.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="social-credentials-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Credentials')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-google-logo"
            :iconColor="$google_status ? 'success' : 'secondary'"
            :label="__('Google')"
            :value="$google_status ? __('Active') : __('Inactive')"
        />
        <x-admin.stat-card
            icon="ph-facebook-logo"
            :iconColor="$facebook_status ? 'success' : 'secondary'"
            :label="__('Facebook')"
            :value="$facebook_status ? __('Active') : __('Inactive')"
        />
        <x-admin.stat-card
            icon="ph-linkedin-logo"
            :iconColor="$linkedin_status ? 'success' : 'secondary'"
            :label="__('LinkedIn')"
            :value="$linkedin_status ? __('Active') : __('Inactive')"
        />
    </div>

    <form wire:submit="save" id="social-credentials-form">
        <div class="mt-6 grid grid-cols-1 lg:grid-cols-3 gap-6">
            {{-- Google --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="w-10 h-10 bg-white rounded-xl flex items-center justify-center">
                        <svg class="w-5 h-5" viewBox="0 0 24 24"><path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/><path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/><path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/><path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/></svg>
                    </div>
                    <div class="flex-1">
                        <p class="text-sm font-semibold text-white">Google</p>
                        <p class="text-xs text-slate-500">OAuth 2.0</p>
                    </div>
                    <label class="relative inline-block cursor-pointer">
                        <input type="checkbox" wire:model.live="google_status" class="sr-only peer" />
                        <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                        <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5 pointer-events-none"></div>
                    </label>
                </div>
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Client ID')</label>
                        <input type="text" wire:model="google_client_id" placeholder="{{ __('Enter Client ID') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Client Secret')</label>
                        <input type="password" wire:model="google_client_secret" placeholder="{{ __('Enter Client Secret') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Callback URL')</label>
                        <div class="flex items-center gap-2">
                            <input type="text" value="{{ $this->getCallbackUrl('google') }}" readonly class="flex-1 rounded-xl border border-white/10 bg-slate-900/50 px-4 py-2.5 text-xs text-slate-400 focus:outline-none" />
                            <button type="button" onclick="navigator.clipboard.writeText('{{ $this->getCallbackUrl('google') }}')" class="p-2.5 bg-white/5 hover:bg-indigo-500/10 border border-white/10 rounded-xl text-slate-400 hover:text-indigo-400 transition-colors">
                                <i class="ph-duotone ph-copy text-sm"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </x-admin.card>

            {{-- Facebook --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="w-10 h-10 bg-[#1877F2] rounded-xl flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                    </div>
                    <div class="flex-1">
                        <p class="text-sm font-semibold text-white">Facebook</p>
                        <p class="text-xs text-slate-500">OAuth 2.0</p>
                    </div>
                    <label class="relative inline-block cursor-pointer">
                        <input type="checkbox" wire:model.live="facebook_status" class="sr-only peer" />
                        <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                        <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5 pointer-events-none"></div>
                    </label>
                </div>
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('App ID')</label>
                        <input type="text" wire:model="facebook_client_id" placeholder="{{ __('Enter App ID') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('App Secret')</label>
                        <input type="password" wire:model="facebook_client_secret" placeholder="{{ __('Enter App Secret') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Callback URL')</label>
                        <div class="flex items-center gap-2">
                            <input type="text" value="{{ $this->getCallbackUrl('facebook') }}" readonly class="flex-1 rounded-xl border border-white/10 bg-slate-900/50 px-4 py-2.5 text-xs text-slate-400 focus:outline-none" />
                            <button type="button" onclick="navigator.clipboard.writeText('{{ $this->getCallbackUrl('facebook') }}')" class="p-2.5 bg-white/5 hover:bg-indigo-500/10 border border-white/10 rounded-xl text-slate-400 hover:text-indigo-400 transition-colors">
                                <i class="ph-duotone ph-copy text-sm"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </x-admin.card>

            {{-- LinkedIn --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="w-10 h-10 bg-[#0A66C2] rounded-xl flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg>
                    </div>
                    <div class="flex-1">
                        <p class="text-sm font-semibold text-white">LinkedIn</p>
                        <p class="text-xs text-slate-500">OAuth 2.0</p>
                    </div>
                    <label class="relative inline-block cursor-pointer">
                        <input type="checkbox" wire:model.live="linkedin_status" class="sr-only peer" />
                        <div class="h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors"></div>
                        <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5 pointer-events-none"></div>
                    </label>
                </div>
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Client ID')</label>
                        <input type="text" wire:model="linkedin_client_id" placeholder="{{ __('Enter Client ID') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Client Secret')</label>
                        <input type="password" wire:model="linkedin_client_secret" placeholder="{{ __('Enter Client Secret') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Callback URL')</label>
                        <div class="flex items-center gap-2">
                            <input type="text" value="{{ $this->getCallbackUrl('linkedin') }}" readonly class="flex-1 rounded-xl border border-white/10 bg-slate-900/50 px-4 py-2.5 text-xs text-slate-400 focus:outline-none" />
                            <button type="button" onclick="navigator.clipboard.writeText('{{ $this->getCallbackUrl('linkedin') }}')" class="p-2.5 bg-white/5 hover:bg-indigo-500/10 border border-white/10 rounded-xl text-slate-400 hover:text-indigo-400 transition-colors">
                                <i class="ph-duotone ph-copy text-sm"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </form>
</div>
