<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Store Settings')" :subtitle="__('Configure the store URL path.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="store-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <form wire:submit="save" id="store-settings-form">
        <div class="mt-6 max-w-xl">
            {{-- Store URL Configuration --}}
            <x-admin.card class="h-fit">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-storefront text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Store URL')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure store path and routing')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    {{-- Store Base Path --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Store Base Path')</label>
                        <div class="flex items-center gap-2">
                            <span class="text-slate-400">{{ url('/') }}/</span>
                            <input type="text" wire:model="store_base_path" 
                                class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" 
                                placeholder="store" />
                        </div>
                        <p class="text-xs text-slate-500 mt-1">@lang('Only lowercase letters, numbers, and hyphens allowed.')</p>
                        @error('store_base_path') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>
        </div>
    </form>
</div>
