<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Tax Settings')" :subtitle="__('Configure tax rates, country-specific rates, and EU VAT settings.')">
        <x-slot:actions>
            <x-admin.button type="submit" form="tax-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <form wire:submit="save" id="tax-settings-form">
        <div class="mt-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
            {{-- Basic Tax Settings --}}
            <x-admin.card class="h-fit">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                        <i class="ph-duotone ph-percent text-xl text-emerald-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Basic Tax Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure default tax rate and type')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    {{-- Enable Tax --}}
                    <div class="flex items-center justify-between p-4 rounded-xl bg-white/5 border border-white/10">
                        <div>
                            <h4 class="font-medium text-white">@lang('Enable Tax')</h4>
                            <p class="text-xs text-slate-500 mt-0.5">@lang('Apply tax to invoices and orders')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="tax_enabled" class="peer sr-only">
                            <div class="h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-slate-400 after:transition-all peer-checked:bg-emerald-600 peer-checked:after:translate-x-full peer-checked:after:bg-white"></div>
                        </label>
                    </div>

                    {{-- Tax Name --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Tax Name')</label>
                        <input type="text" wire:model="tax_name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-emerald-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-emerald-500/20" placeholder="VAT, GST, Sales Tax..." />
                        @error('tax_name') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    {{-- Tax Rate --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Default Tax Rate')</label>
                        <div class="relative">
                            <input type="number" wire:model="tax_rate" step="0.01" min="0" max="100" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-12 text-sm text-white transition-all focus:border-emerald-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-emerald-500/20" />
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500">%</span>
                        </div>
                        <p class="text-xs text-slate-500 mt-1.5">@lang('Applied when no country-specific rate is found')</p>
                    </div>

                    {{-- Tax Type --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Tax Type')</label>
                        <select wire:model="tax_type" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-emerald-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-emerald-500/20">
                            <option value="1" class="bg-[#1a1a24]">@lang('Inclusive') - @lang('Tax included in prices')</option>
                            <option value="2" class="bg-[#1a1a24]">@lang('Exclusive') - @lang('Tax added to prices')</option>
                        </select>
                    </div>
                </div>
            </x-admin.card>

            {{-- Advanced Tax Settings --}}
            <x-admin.card class="h-fit">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-globe text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Country-Specific Rates')</h3>
                        <p class="text-sm text-slate-500">@lang('Apply different rates per country')</p>
                    </div>
                </div>

                <div class="space-y-5">
                    {{-- Enable Country Rates --}}
                    <div class="flex items-center justify-between p-4 rounded-xl bg-white/5 border border-white/10">
                        <div>
                            <h4 class="font-medium text-white">@lang('Enable Country-Specific Rates')</h4>
                            <p class="text-xs text-slate-500 mt-0.5">@lang('Use different tax rates based on customer country')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="tax_country_rates" class="peer sr-only">
                            <div class="h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-slate-400 after:transition-all peer-checked:bg-indigo-600 peer-checked:after:translate-x-full peer-checked:after:bg-white"></div>
                        </label>
                    </div>

                    {{-- Use EU VAT Rates --}}
                    <div class="flex items-center justify-between p-4 rounded-xl bg-white/5 border border-white/10">
                        <div>
                            <h4 class="font-medium text-white">@lang('Use EU VAT Rates')</h4>
                            <p class="text-xs text-slate-500 mt-0.5">@lang('Automatically apply standard EU VAT rates')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="tax_use_eu_vat" class="peer sr-only">
                            <div class="h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-slate-400 after:transition-all peer-checked:bg-indigo-600 peer-checked:after:translate-x-full peer-checked:after:bg-white"></div>
                        </label>
                    </div>

                    @if($tax_use_eu_vat)
                        <div class="p-4 rounded-xl bg-indigo-500/10 border border-indigo-500/20">
                            <h5 class="text-sm font-medium text-indigo-400 mb-2">@lang('EU VAT Rates Applied')</h5>
                            <div class="grid grid-cols-4 gap-2 text-xs">
                                @foreach($euVatRates as $code => $rate)
                                    <div class="flex justify-between text-slate-400">
                                        <span>{{ $code }}</span>
                                        <span class="text-white">{{ $rate }}%</span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </x-admin.card>

            {{-- Custom Country Rates --}}
            <x-admin.card class="lg:col-span-2">
                <div class="flex items-center justify-between pb-4 mb-5 border-b border-white/5">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                            <i class="ph-duotone ph-list-plus text-xl text-amber-400"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white">@lang('Custom Country Rates')</h3>
                            <p class="text-sm text-slate-500">@lang('Override or add custom tax rates for specific countries')</p>
                        </div>
                    </div>
                </div>

                {{-- Add New Country Rate --}}
                <div class="flex gap-3 mb-5">
                    <div class="w-32">
                        <input type="text" wire:model="newCountryCode" maxlength="2" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white uppercase placeholder-slate-500 transition-all focus:border-amber-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-amber-500/20" placeholder="US" />
                    </div>
                    <div class="flex-1 relative">
                        <input type="number" wire:model="newCountryRate" step="0.01" min="0" max="100" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-12 text-sm text-white placeholder-slate-500 transition-all focus:border-amber-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-amber-500/20" placeholder="Tax rate" />
                        <span class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500">%</span>
                    </div>
                    <button type="button" wire:click="addCountryRate" class="px-4 py-2.5 rounded-xl bg-amber-600 text-white text-sm font-medium hover:bg-amber-700 transition-colors">
                        <i class="ph-duotone ph-plus mr-1"></i> @lang('Add')
                    </button>
                </div>

                {{-- Custom Rates List --}}
                @if(count($tax_country_rates_data) > 0)
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="border-b border-white/10">
                                    <th class="py-3 px-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Country Code')</th>
                                    <th class="py-3 px-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Tax Rate')</th>
                                    <th class="py-3 px-4 text-right text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-white/5">
                                @foreach($tax_country_rates_data as $code => $rate)
                                    <tr class="hover:bg-white/5 transition-colors">
                                        <td class="py-3 px-4">
                                            <span class="inline-flex items-center gap-2 px-3 py-1 rounded-lg bg-white/10 text-sm font-medium text-white">
                                                {{ $code }}
                                            </span>
                                        </td>
                                        <td class="py-3 px-4 text-white">{{ number_format($rate, 2) }}%</td>
                                        <td class="py-3 px-4 text-right">
                                            <button type="button" wire:click="removeCountryRate('{{ $code }}')" class="inline-flex items-center gap-1 px-2.5 py-1 rounded-lg bg-rose-600/20 text-rose-400 text-xs font-medium hover:bg-rose-600/30 transition-colors">
                                                <i class="ph-duotone ph-trash"></i> @lang('Remove')
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="mx-auto h-12 w-12 rounded-xl bg-white/5 flex items-center justify-center mb-3">
                            <i class="ph-duotone ph-globe-hemisphere-west text-2xl text-slate-500"></i>
                        </div>
                        <p class="text-sm text-slate-500">@lang('No custom country rates configured')</p>
                        <p class="text-xs text-slate-600 mt-1">@lang('Add country codes (e.g., US, CA, AU) with their tax rates')</p>
                    </div>
                @endif
            </x-admin.card>
        </div>
    </form>
</div>

