<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Ticket Settings')" :subtitle="__('Configure support ticket system, SLA, auto-close, and notification settings.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.support.categories') }}" variant="secondary" icon="ph-folders">
                @lang('Categories')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.support.canned') }}" variant="secondary" icon="ph-chat-text">
                @lang('Canned Responses')
            </x-admin.button>
            <x-admin.button type="submit" form="ticket-settings-form" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">@lang('Save Changes')</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if(session('success'))
        <x-admin.alert type="success" class="mt-6" dismissible>{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-ticket"
            iconColor="primary"
            :label="__('Ticket System')"
            :value="$ticket_enabled ? __('Enabled') : __('Disabled')"
        />
        <x-admin.stat-card
            icon="ph-timer"
            iconColor="info"
            :label="__('SLA Response')"
            :value="$ticket_default_sla_response_hours . ' ' . __('hours')"
        />
        <x-admin.stat-card
            icon="ph-clock-countdown"
            iconColor="warning"
            :label="__('Auto-Close')"
            :value="$ticket_auto_close_enabled ? ($ticket_auto_close_days . ' ' . __('days')) : __('Disabled')"
        />
        <x-admin.stat-card
            icon="ph-star"
            iconColor="success"
            :label="__('Feedback')"
            :value="$ticket_feedback_enabled ? __('Enabled') : __('Disabled')"
        />
    </div>

    <form wire:submit="save" id="ticket-settings-form">
        <div class="mt-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
            {{-- General Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-gear text-xl text-indigo-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('General Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Basic ticket system configuration')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    {{-- Enable Ticket System --}}
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Enable Ticket System')</p>
                            <p class="text-xs text-slate-500">@lang('Allow customers to create support tickets')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_enabled" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-indigo-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    {{-- Require Category --}}
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Require Category')</p>
                            <p class="text-xs text-slate-500">@lang('Customers must select a category')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_require_category" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-indigo-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    {{-- Allow Guest Tickets --}}
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Allow Guest Tickets')</p>
                            <p class="text-xs text-slate-500">@lang('Allow non-registered users')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_allow_guest_tickets" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-indigo-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    {{-- Show Related Articles --}}
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Show Related Articles')</p>
                            <p class="text-xs text-slate-500">@lang('Suggest KB articles in flow')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_show_related_articles" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-indigo-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    {{-- Max Open Tickets --}}
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Max Open Tickets Per User')</label>
                        <input type="number" wire:model="ticket_max_open_per_user" min="0" 
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white focus:border-indigo-500/50 outline-none" placeholder="0 = Unlimited" />
                        @error('ticket_max_open_per_user') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </x-admin.card>

            {{-- SLA Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20">
                        <i class="ph-duotone ph-timer text-xl text-blue-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('SLA Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Service Level Agreement configuration')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Enable SLA Tracking')</p>
                            <p class="text-xs text-slate-500">@lang('Track response/resolution times')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_sla_enabled" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-blue-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Response (H)')</label>
                            <input type="number" wire:model="ticket_default_sla_response_hours" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Resolution (H)')</label>
                            <input type="number" wire:model="ticket_default_sla_resolution_hours" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                        </div>
                    </div>

                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Escalate on Breach')</p>
                            <p class="text-xs text-slate-500">@lang('Trigger automated escalation')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_escalate_on_sla_breach" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-blue-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Escalation Email')</label>
                        <input type="email" wire:model="ticket_escalation_email" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" placeholder="manager@company.com" />
                    </div>
                </div>
            </x-admin.card>

            {{-- Auto-Close Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20">
                        <i class="ph-duotone ph-clock-countdown text-xl text-amber-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Auto-Close Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Automatically close inactive tickets')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Enable Auto-Close')</p>
                            <p class="text-xs text-slate-500">@lang('Close stale conversations')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_auto_close_enabled" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-amber-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Close After (Days)')</label>
                            <input type="number" wire:model="ticket_auto_close_days" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Warn Before (Hours)')</label>
                            <input type="number" wire:model="ticket_auto_close_warning_hours" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                        </div>
                    </div>

                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Send Warning Email')</p>
                            <p class="text-xs text-slate-500">@lang('Notify before closing')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_auto_close_notify" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-amber-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>
                </div>
            </x-admin.card>

            {{-- Assignment Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-green-500/20 to-emerald-500/20">
                        <i class="ph-duotone ph-user-switch text-xl text-green-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Assignment Settings')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure ticket auto-assignment')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Method')</label>
                        <select wire:model="ticket_auto_assign_method" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white">
                            @foreach($assignMethods as $value => $label)
                                <option value="{{ $value }}" class="bg-slate-800">{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Notify Agent')</p>
                            <p class="text-xs text-slate-500">@lang('Email when assigned')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_notify_on_assignment" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-green-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>
                </div>
            </x-admin.card>

            {{-- Customer Feedback (RESTORED) --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-yellow-500/20 to-amber-500/20">
                        <i class="ph-duotone ph-star text-xl text-yellow-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Customer Feedback')</h3>
                        <p class="text-sm text-slate-500">@lang('Satisfaction rating configuration')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Enable Feedback')</p>
                            <p class="text-xs text-slate-500">@lang('Ask for rating after closing')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_feedback_enabled" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-yellow-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Request Delay (Hours)')</label>
                        <input type="number" wire:model="ticket_feedback_delay_hours" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                    </div>
                </div>
            </x-admin.card>

            {{-- Attachment Settings --}}
            <x-admin.card>
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-purple-500/20 to-pink-500/20">
                        <i class="ph-duotone ph-paperclip text-xl text-purple-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Attachment Protocol')</h3>
                        <p class="text-sm text-slate-500">@lang('File upload configuration')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Allow Uploads')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_attachments_enabled" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-purple-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Max Files')</label>
                            <input type="number" wire:model="ticket_max_attachments" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Size (MB)')</label>
                            <input type="number" wire:model="ticket_max_attachment_size" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Allowed Extensions')</label>
                        <input type="text" wire:model="ticket_allowed_extensions" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                    </div>
                </div>
            </x-admin.card>

            {{-- Notification Settings (RESTORED) --}}
            <x-admin.card class="lg:col-span-2">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-rose-500/20 to-red-500/20">
                        <i class="ph-duotone ph-bell text-xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('Notification Protocol')</h3>
                        <p class="text-sm text-slate-500">@lang('Configure automated email triggers')</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    @php
                        $notifs = [
                            ['wire' => 'ticket_notify_admin_new', 'label' => 'Alert Admin: New Ticket'],
                            ['wire' => 'ticket_notify_admin_reply', 'label' => 'Alert Admin: Client Reply'],
                            ['wire' => 'ticket_notify_customer_reply', 'label' => 'Alert Client: Staff Reply'],
                            ['wire' => 'ticket_notify_customer_closed', 'label' => 'Alert Client: Ticket Closed'],
                        ];
                    @endphp

                    @foreach($notifs as $notif)
                        <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                            <span class="text-sm font-medium text-white">{{ __($notif['label']) }}</span>
                            <label class="relative inline-flex cursor-pointer items-center">
                                <input type="checkbox" wire:model="{{ $notif['wire'] }}" class="peer sr-only">
                                <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-rose-600 peer-checked:after:translate-x-full"></div>
                            </label>
                        </div>
                    @endforeach
                </div>
            </x-admin.card>

            {{-- LiveChat Concierge Settings --}}
            <x-admin.card class="lg:col-span-2 bg-[#0d0d12]">
                <div class="flex items-center gap-3 pb-4 mb-5 border-b border-white/5">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-600 shadow-lg shadow-indigo-600/20">
                        <i class="ph-duotone ph-chat-centered-dots text-xl text-white"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-white">@lang('LiveChat Concierge')</h3>
                        <p class="text-sm text-slate-500">@lang('Standardized floating widget configuration')</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <div class="flex items-center justify-between p-4 bg-white/5 rounded-2xl border border-white/5">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Active Widget')</p>
                        </div>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="ticket_livechat_enabled" class="peer sr-only">
                            <div class="peer h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:bg-white after:transition-all after:content-[''] peer-checked:bg-indigo-600 peer-checked:after:translate-x-full"></div>
                        </label>
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Branding Title')</label>
                        <input type="text" wire:model="ticket_livechat_title" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white" />
                    </div>

                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Primary Signature')</label>
                        <div class="flex items-center gap-3">
                            <input type="color" wire:model="ticket_livechat_color" class="h-10 w-12 rounded bg-transparent border-none cursor-pointer" />
                            <input type="text" wire:model="ticket_livechat_color" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm text-white" />
                        </div>
                    </div>

                    <div class="md:col-span-2 lg:col-span-3">
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Initial Agent Message')</label>
                        <textarea wire:model="ticket_livechat_welcome_msg" rows="2" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white"></textarea>
                    </div>
                </div>

                <div class="mt-8 flex items-center justify-between p-6 bg-white/5 rounded-3xl border border-white/10">
                    <div class="flex items-center gap-4">
                         <div class="flex -space-x-3">
                            @foreach($admins as $admin)
                                @if($admin->image)
                                    <img src="{{ $admin->image_url }}" class="w-10 h-10 rounded-full border-2 border-[#0d0d12] shadow-lg object-cover" title="{{ $admin->name }}">
                                @else
                                    <div class="w-10 h-10 rounded-full border-2 border-[#0d0d12] shadow-lg flex items-center justify-center text-white text-[10px] font-black uppercase" 
                                         style="background: {{ $admin->color }};"
                                         title="{{ $admin->name }}">
                                        {{ $admin->initials }}
                                    </div>
                                @endif
                            @endforeach
                         </div>
                         <div class="hidden sm:block">
                             <p class="text-xs font-black text-slate-200">Real-Staff Integration Active</p>
                             <p class="text-[10px] text-slate-500">Avatars and proximity sync automatically based on available staff.</p>
                         </div>
                    </div>
                    <div class="px-3 py-1 bg-indigo-500/20 text-indigo-400 rounded-full text-[10px] font-black uppercase tracking-widest border border-indigo-500/20">
                        Live Preview logic
                    </div>
                </div>
            </x-admin.card>
        </div>
    </form>
</div>

