<div>
    <x-admin.page-header 
        :title="$isEdit ? __('Edit Staff Member') : __('Add Staff Member')" 
        :subtitle="$isEdit ? __('Update staff account details and permissions.') : __('Create a new administrative staff account.')"
        :backRoute="route('admin.staff.index')"
        :backLabel="__('Back to Staff')"
    />

    <div class="mt-6">
        <x-admin.card>
            <form wire:submit="save" class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-4">
                        <x-admin.input 
                            wire:model="name" 
                            :label="__('Full Name')" 
                            :placeholder="__('e.g. John Doe')" 
                            required 
                        />
                        
                        <x-admin.input 
                            wire:model="username" 
                            :label="__('Username')" 
                            :placeholder="__('e.g. johndoe')" 
                            required 
                            :disabled="$isEdit"
                        />

                        <x-admin.input 
                            wire:model="email" 
                            type="email" 
                            :label="__('Email Address')" 
                            :placeholder="__('e.g. john@example.com')" 
                            required 
                        />
                    </div>

                    <div class="space-y-4">
                        <x-admin.input 
                            wire:model="password" 
                            type="password" 
                            :label="__('Password')" 
                            :placeholder="$isEdit ? __('Leave blank to keep current') : __('Min. 8 characters')" 
                            :required="!$isEdit" 
                        />

                        <x-admin.select wire:model="role_id" :label="__('Role')">
                            <option value="">@lang('Super Admin (All Permissions)')</option>
                            @foreach($roles as $role)
                                <option value="{{ $role->id }}">{{ $role->name }}</option>
                            @endforeach
                        </x-admin.select>

                        <div class="pt-2">
                            <x-admin.toggle wire:model="status" :label="__('Account Status')" :description="__('Toggle whether this staff member can log in.')" />
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 border-t border-white/5 pt-6">
                    <x-admin.button 
                        variant="secondary" 
                        href="{{ route('admin.staff.index') }}"
                    >
                        @lang('Cancel')
                    </x-admin.button>
                    
                    <x-admin.button 
                        type="submit" 
                        wireLoading="save"
                    >
                        {{ $isEdit ? __('Update Staff Member') : __('Create Staff Member') }}
                    </x-admin.button>
                </div>
            </form>
        </x-admin.card>
    </div>
</div>
