<div>
    <div class="mb-6">
        <x-admin.page-header :title="__('Staff Management')" :subtitle="__('Manage admin staff members')">
            <x-slot:actions>
                <x-admin.button
                    href="{{ route('admin.staff.create') }}"
                    icon="ph-plus"
                >
                    @lang('Add Staff Member')
                </x-admin.button>
            </x-slot:actions>
        </x-admin.page-header>
    </div>

    <!-- Filters -->
    <div class="mb-6">
        <div class="relative">
            <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('Search staff by name or email...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 py-3 pl-11 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/[0.07] focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            />
        </div>
    </div>

    <!-- Staff Table -->
    <div class="overflow-hidden rounded-2xl border border-white/5 bg-[#12121a]">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <x-admin.table-header>@lang('Staff Member')</x-admin.table-header>
                        <x-admin.table-header>@lang('Role')</x-admin.table-header>
                        <x-admin.table-header>@lang('Status')</x-admin.table-header>
                        <x-admin.table-header>@lang('Last Login')</x-admin.table-header>
                        <x-admin.table-header class="text-right">@lang('Actions')</x-admin.table-header>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($staff as $member)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="px-5 py-4">
                                <div class="flex items-center gap-3">
                                    <x-admin.avatar :name="$member->name" size="sm" />
                                    <div>
                                        <div class="font-medium text-white">{{ $member->name }}</div>
                                        <div class="text-sm text-slate-500">{{ $member->email }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-5 py-4">
                                @if($member->role)
                                    <x-admin.badge variant="primary">{{ $member->role->name }}</x-admin.badge>
                                @else
                                    <span class="inline-flex items-center gap-1.5 rounded-lg bg-gradient-to-r from-amber-500/20 to-orange-500/20 px-2.5 py-1 text-xs font-medium text-amber-400">
                                        <i class="ph-duotone ph-crown text-sm"></i>
                                        @lang('Super Admin')
                                    </span>
                                @endif
                            </td>
                            <td class="px-5 py-4">
                                @if($member->id > 1)
                                    <button wire:click="toggleStatus({{ $member->id }})" class="focus:outline-none">
                                        @if($member->status)
                                            <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400">
                                                <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                                @lang('Active')
                                            </span>
                                        @else
                                            <span class="inline-flex items-center gap-1.5 rounded-lg bg-rose-500/10 px-2.5 py-1 text-xs font-medium text-rose-400">
                                                <span class="h-1.5 w-1.5 rounded-full bg-rose-400"></span>
                                                @lang('Inactive')
                                            </span>
                                        @endif
                                    </button>
                                @else
                                    <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400">
                                        <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                        @lang('Active')
                                    </span>
                                @endif
                            </td>
                            <td class="px-5 py-4 text-sm text-slate-400">
                                {{ $member->last_login ? $member->last_login->diffForHumans() : __('Never') }}
                            </td>
                            <td class="px-5 py-4 text-right">
                                @if($member->id > 1)
                                    <x-admin.action-menu>
                                        <x-admin.action-menu-item href="{{ route('admin.staff.edit', $member->id) }}" icon="pencil">
                                            @lang('Edit')
                                        </x-admin.action-menu-item>
                                        @if($member->role_id)
                                            <x-admin.action-menu-item wire:click="loginAs({{ $member->id }})" icon="sign-in">
                                                @lang('Login As')
                                            </x-admin.action-menu-item>
                                        @endif
                                        <x-admin.action-menu-item wire:click="confirmDelete({{ $member->id }})" icon="trash" variant="danger">
                                            @lang('Delete')
                                        </x-admin.action-menu-item>
                                    </x-admin.action-menu>
                                @else
                                    <span class="text-xs text-slate-500">@lang('Protected')</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-5 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="mb-4 flex h-16 w-16 items-center justify-center rounded-2xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                                        <i class="ph-duotone ph-users text-3xl text-indigo-400"></i>
                                    </div>
                                    <h3 class="mb-1 text-sm font-medium text-white">@lang('No staff members found')</h3>
                                    <p class="mb-4 text-sm text-slate-500">@lang('Get started by adding a new staff member.')</p>
                                    <x-admin.button href="{{ route('admin.staff.create') }}" icon="ph-plus" size="sm">
                                        @lang('Add Staff')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($staff->hasPages())
            <div class="border-t border-white/5 px-5 py-4">
                {{ $staff->links() }}
            </div>
        @endif
    </div>

    <!-- Delete Confirmation Modal -->
    <x-admin.modal name="confirm-delete" :title="__('Delete Staff Member')">
        <p class="text-slate-400">@lang('Are you sure you want to delete this staff member? This action cannot be undone.')</p>
        <div class="mt-6 flex justify-end gap-3">
            <x-admin.button variant="secondary" x-on:click="$dispatch('close-modal', 'confirm-delete')">@lang('Cancel')</x-admin.button>
            <x-admin.button variant="danger" wire:click="delete">@lang('Delete')</x-admin.button>
        </div>
    </x-admin.modal>
</div>

