<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Subscribers')" :subtitle="__('Manage newsletter subscribers')">
        <x-slot:actions>
            <x-admin.button wire:click="openAddModal" icon="ph-plus">
                @lang('Add Subscriber')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Flash Messages --}}
    @if(session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if(session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Stats --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            icon="ph-users"
            iconColor="primary"
            :label="__('Total Subscribers')"
            :value="number_format(\App\Models\Subscriber::count())"
        />
        <x-admin.stat-card
            icon="ph-calendar-check"
            iconColor="success"
            :label="__('Today')"
            :value="number_format(\App\Models\Subscriber::whereDate('created_at', today())->count())"
        />
        <x-admin.stat-card
            icon="ph-calendar"
            iconColor="warning"
            :label="__('This Month')"
            :value="number_format(\App\Models\Subscriber::whereMonth('created_at', now()->month)->count())"
        />
    </div>

    {{-- Filters & Actions --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="flex flex-1 gap-3">
                <x-admin.input wire:model.live.debounce.300ms="search" :placeholder="__('Search by email...')" class="max-w-xs" />
            </div>
            <div class="flex items-center gap-3">
                @if(count($selectedIds) > 0)
                    <span class="text-sm text-slate-400">{{ count($selectedIds) }} @lang('selected')</span>
                    <x-admin.button variant="danger" size="sm" wire:click="deleteSelected" icon="ph-trash">
                        @lang('Delete Selected')
                    </x-admin.button>
                @endif
                <a href="{{ route('admin.subscriber.send.email') }}">
                    <x-admin.button variant="secondary" icon="ph-envelope">
                        @lang('Send Email')
                    </x-admin.button>
                </a>
            </div>
        </div>
    </x-admin.card>

    {{-- Subscribers Table --}}
    <x-admin.card class="mt-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 text-left text-xs font-medium uppercase tracking-wider text-slate-400">
                        <th class="px-4 py-3 w-12">
                            <input type="checkbox" wire:model.live="selectAll"
                                class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                        </th>
                        <th class="px-4 py-3">@lang('Email')</th>
                        <th class="px-4 py-3">@lang('Subscribed At')</th>
                        <th class="px-4 py-3 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($subscribers as $subscriber)
                        <tr class="transition-colors hover:bg-white/5">
                            <td class="px-4 py-4">
                                <input type="checkbox" wire:model.live="selectedIds" value="{{ $subscriber->id }}"
                                    class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-indigo-500/10">
                                        <i class="ph-duotone ph-envelope-simple text-lg text-indigo-400"></i>
                                    </div>
                                    <span class="font-medium text-white">{{ $subscriber->email }}</span>
                                </div>
                            </td>
                            <td class="px-4 py-4 text-slate-400">
                                <div class="flex flex-col">
                                    <span>{{ $subscriber->created_at->format('M d, Y') }}</span>
                                    <span class="text-xs text-slate-500">{{ $subscriber->created_at->diffForHumans() }}</span>
                                </div>
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    <x-admin.button variant="ghost" size="sm" wire:click="confirmDelete({{ $subscriber->id }})" icon="ph-trash" class="text-rose-400 hover:text-rose-300" />
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-4 py-12 text-center">
                                <div class="flex flex-col items-center gap-3">
                                    <i class="ph-duotone ph-envelope text-4xl text-slate-500"></i>
                                    <p class="text-slate-400">@lang('No subscribers found')</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($subscribers->hasPages())
            <div class="mt-6 border-t border-white/5 pt-4">
                {{ $subscribers->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Add Subscriber Modal --}}
    <x-admin.modal wire:model="showAddModal" :title="__('Add Subscriber')" maxWidth="md">
        <div class="space-y-5">
            <x-admin.input type="email" :label="__('Email Address')" wire:model="email" :placeholder="__('subscriber@example.com')" required />
            @error('email') <span class="text-xs text-rose-400">{{ $message }}</span> @enderror
        </div>

        <x-slot:footer>
            <x-admin.button variant="ghost" wire:click="$set('showAddModal', false)">@lang('Cancel')</x-admin.button>
            <x-admin.button wire:click="save" wire:loading.attr="disabled" icon="ph-check">
                <span wire:loading.remove wire:target="save">@lang('Add Subscriber')</span>
                <span wire:loading wire:target="save">@lang('Adding...')</span>
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>

    {{-- Delete Confirmation --}}
    @if($deleteId)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm">
            <div class="w-full max-w-md rounded-2xl border border-white/10 bg-[#1a1a2e] p-6 shadow-2xl">
                <div class="mb-4 flex items-center gap-3">
                    <div class="flex h-12 w-12 items-center justify-center rounded-full bg-rose-500/10">
                        <i class="ph-duotone ph-warning text-2xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-white">@lang('Remove Subscriber')</h3>
                        <p class="text-sm text-slate-400">@lang('This action cannot be undone.')</p>
                    </div>
                </div>
                <p class="mb-6 text-sm text-slate-300">@lang('Are you sure you want to remove this subscriber from your mailing list?')</p>
                <div class="flex justify-end gap-3">
                    <x-admin.button variant="ghost" wire:click="cancelDelete">@lang('Cancel')</x-admin.button>
                    <x-admin.button variant="danger" wire:click="delete" icon="ph-trash">@lang('Remove')</x-admin.button>
                </div>
            </div>
        </div>
    @endif
</div>

