<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Canned Responses')" :subtitle="__('Pre-written responses for quick ticket replies.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.ticket.setting') }}" variant="secondary" icon="ph-gear">
                @lang('Settings')
            </x-admin.button>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Response')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Filters --}}
    <div class="mt-6">
        <x-admin.card>
            <div class="flex flex-col md:flex-row items-center gap-4">
                <div class="relative flex-1 w-full">
                    <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input type="text" wire:model.live.debounce.300ms="search"
                        class="w-full rounded-xl border border-white/10 bg-white/5 pl-11 pr-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        placeholder="{{ __('Search by name or shortcut...') }}" />
                </div>
                <select wire:model.live="filterCategory"
                    class="w-full md:w-48 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                    <option value="" class="bg-slate-800">@lang('All Categories')</option>
                    <option value="global" class="bg-slate-800">@lang('Global (No Category)')</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" class="bg-slate-800">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
        </x-admin.card>
    </div>

    {{-- Responses Table --}}
    <div class="mt-6">
        <x-admin.card noPadding>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/5">
                            <th class="px-6 py-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Response')</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Shortcut')</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</th>
                            <th class="px-6 py-4 text-center text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Usage')</th>
                            <th class="px-6 py-4 text-center text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</th>
                            <th class="px-6 py-4 text-right text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @forelse($responses as $response)
                            <tr class="hover:bg-white/5 transition-colors">
                                <td class="px-6 py-4">
                                    <div>
                                        <p class="font-medium text-white">{{ $response->name }}</p>
                                        <p class="text-xs text-slate-500 line-clamp-1 max-w-md">{{ Str::limit(strip_tags($response->content), 80) }}</p>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <code class="px-2 py-1 text-xs font-mono bg-indigo-500/20 text-indigo-400 rounded-lg">#{{ $response->shortcut }}</code>
                                </td>
                                <td class="px-6 py-4">
                                    @if($response->category)
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-lg bg-{{ $response->category->color }}-500/20 text-{{ $response->category->color }}-400">
                                            <i class="ph-duotone {{ $response->category->icon }} text-xs"></i>
                                            {{ $response->category->name }}
                                        </span>
                                    @else
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-lg bg-slate-700 text-slate-400">
                                            <i class="ph-duotone ph-globe text-xs"></i>
                                            @lang('Global')
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="text-sm font-medium text-slate-400">{{ number_format($response->usage_count) }}</span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <button wire:click="toggleStatus({{ $response->id }})"
                                        class="px-2.5 py-1 text-xs font-medium rounded-lg transition-colors {{ $response->is_active ? 'bg-emerald-500/20 text-emerald-400' : 'bg-slate-700 text-slate-400' }}">
                                        {{ $response->is_active ? __('Active') : __('Inactive') }}
                                    </button>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center justify-end gap-2">
                                        <button wire:click="duplicate({{ $response->id }})"
                                            class="p-2 text-slate-400 hover:text-cyan-400 hover:bg-cyan-500/10 rounded-lg transition-colors"
                                            title="{{ __('Duplicate') }}">
                                            <i class="ph-duotone ph-copy text-lg"></i>
                                        </button>
                                        <button wire:click="openModal({{ $response->id }})"
                                            class="p-2 text-slate-400 hover:text-white hover:bg-white/10 rounded-lg transition-colors"
                                            title="{{ __('Edit') }}">
                                            <i class="ph-duotone ph-pencil text-lg"></i>
                                        </button>
                                        <button wire:click="delete({{ $response->id }})"
                                            wire:confirm="{{ __('Are you sure you want to delete this response?') }}"
                                            class="p-2 text-slate-400 hover:text-rose-400 hover:bg-rose-500/10 rounded-lg transition-colors"
                                            title="{{ __('Delete') }}">
                                            <i class="ph-duotone ph-trash text-lg"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-12 text-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-slate-800 mx-auto mb-4">
                                        <i class="ph-duotone ph-chat-text text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="text-lg font-semibold text-white mb-2">@lang('No Canned Responses')</h3>
                                    <p class="text-sm text-slate-500 mb-4">@lang('Create pre-written responses for faster ticket replies.')</p>
                                    <x-admin.button wire:click="openModal" icon="ph-plus">
                                        @lang('Add Response')
                                    </x-admin.button>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </x-admin.card>
    </div>

    {{-- Pagination --}}
    @if($responses->hasPages())
        <div class="mt-6">
            {{ $responses->links() }}
        </div>
    @endif

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Canned Response') : __('Add Canned Response')" maxWidth="2xl">
        <form wire:submit="save">
            <div class="space-y-5">
                {{-- Name & Shortcut --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Name') *</label>
                        <input type="text" wire:model="name"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                            placeholder="{{ __('e.g., Greeting Response') }}" />
                        @error('name') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Shortcut') *</label>
                        <div class="relative">
                            <span class="absolute left-4 top-1/2 -translate-y-1/2 text-slate-500">#</span>
                            <input type="text" wire:model="shortcut"
                                class="w-full rounded-xl border border-white/10 bg-white/5 pl-8 pr-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                                placeholder="greeting" />
                        </div>
                        <p class="text-xs text-slate-500 mt-1">@lang('Type #shortcut to insert this response')</p>
                        @error('shortcut') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>

                {{-- Category --}}
                <div>
                    <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Category')</label>
                    <select wire:model="category_id"
                        class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="" class="bg-slate-800">@lang('Global (All Categories)')</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" class="bg-slate-800">{{ $category->name }}</option>
                        @endforeach
                    </select>
                    <p class="text-xs text-slate-500 mt-1">@lang('Leave empty to make available in all categories')</p>
                    @error('category_id') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>

                {{-- Content --}}
                <div>
                    <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Response Content') *</label>
                    <textarea wire:model="content" rows="8"
                        class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 font-mono"
                        placeholder="{{ __('Enter the response content...') }}"></textarea>
                    <div class="flex items-center justify-between mt-2">
                        <p class="text-xs text-slate-500">@lang('Supports HTML formatting')</p>
                        <p class="text-xs text-slate-500">@lang('Variables: {name}, {email}, {ticket_id}')</p>
                    </div>
                    @error('content') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>

                {{-- Active Toggle --}}
                <div class="flex items-center justify-between p-4 bg-white/5 rounded-xl">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Active')</p>
                        <p class="text-xs text-slate-500">@lang('Make this response available for use')</p>
                    </div>
                    <button type="button" wire:click="$toggle('is_active')"
                        class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors {{ $is_active ? 'bg-indigo-600' : 'bg-slate-700' }}">
                        <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $is_active ? 'translate-x-6' : 'translate-x-1' }}"></span>
                    </button>
                </div>
            </div>
        </form>

        <x-slot:footer>
            <x-admin.button wire:click="closeModal" variant="secondary">@lang('Cancel')</x-admin.button>
            <x-admin.button wire:click="save" icon="ph-check">
                <span wire:loading.remove wire:target="save">{{ $editingId ? __('Update') : __('Create') }}</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>
</div>

