<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Ticket Categories')" :subtitle="__('Manage support ticket categories with SLA settings and auto-assignment.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.ticket.setting') }}" variant="secondary" icon="ph-gear">
                @lang('Settings')
            </x-admin.button>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Category')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Search --}}
    <div class="mt-6">
        <x-admin.card>
            <div class="flex items-center gap-4">
                <div class="relative flex-1">
                    <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input type="text" wire:model.live.debounce.300ms="search"
                        class="w-full rounded-xl border border-white/10 bg-white/5 pl-11 pr-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        placeholder="{{ __('Search categories...') }}" />
                </div>
            </div>
        </x-admin.card>
    </div>

    {{-- Categories Grid --}}
    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        @forelse($categories as $category)
            <div class="group relative bg-slate-800/50 border border-white/5 rounded-2xl p-5 hover:border-{{ $category->color }}-500/30 transition-all duration-300">
                {{-- Status Badge --}}
                <div class="absolute top-4 right-4">
                    <button wire:click="toggleStatus({{ $category->id }})"
                        class="px-2 py-1 text-xs font-medium rounded-lg transition-colors {{ $category->is_active ? 'bg-emerald-500/20 text-emerald-400' : 'bg-slate-700 text-slate-400' }}">
                        {{ $category->is_active ? __('Active') : __('Inactive') }}
                    </button>
                </div>

                {{-- Header --}}
                <div class="flex items-start gap-4 mb-4">
                    <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-{{ $category->color }}-500/20">
                        <i class="ph-duotone {{ $category->icon }} text-2xl text-{{ $category->color }}-400"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="font-semibold text-white truncate">{{ $category->name }}</h3>
                        <p class="text-xs text-slate-500">{{ $category->slug }}</p>
                    </div>
                </div>

                {{-- Description --}}
                @if($category->description)
                    <p class="text-sm text-slate-400 mb-4 line-clamp-2">{{ $category->description }}</p>
                @endif

                {{-- Stats --}}
                <div class="grid grid-cols-3 gap-2 mb-4">
                    <div class="bg-white/5 rounded-lg p-2 text-center">
                        <p class="text-lg font-bold text-white">{{ $category->tickets_count }}</p>
                        <p class="text-xs text-slate-500">@lang('Tickets')</p>
                    </div>
                    <div class="bg-white/5 rounded-lg p-2 text-center">
                        <p class="text-lg font-bold text-{{ $category->sla_response_hours ? 'blue' : 'slate' }}-400">
                            {{ $category->sla_response_hours ?? '—' }}
                        </p>
                        <p class="text-xs text-slate-500">@lang('SLA Resp.')</p>
                    </div>
                    <div class="bg-white/5 rounded-lg p-2 text-center">
                        <p class="text-lg font-bold text-{{ $category->sla_resolution_hours ? 'amber' : 'slate' }}-400">
                            {{ $category->sla_resolution_hours ?? '—' }}
                        </p>
                        <p class="text-xs text-slate-500">@lang('SLA Res.')</p>
                    </div>
                </div>

                {{-- Meta Info --}}
                <div class="flex items-center gap-2 mb-4 flex-wrap">
                    <span class="inline-flex items-center gap-1 px-2 py-1 text-xs rounded-lg bg-white/5 text-slate-400">
                        <i class="ph-duotone ph-flag text-xs"></i>
                        {{ $priorities[$category->default_priority] ?? 'Medium' }}
                    </span>
                    @if($category->requires_service)
                        <span class="inline-flex items-center gap-1 px-2 py-1 text-xs rounded-lg bg-purple-500/20 text-purple-400">
                            <i class="ph-duotone ph-link text-xs"></i>
                            @lang('Service Required')
                        </span>
                    @endif
                    @if($category->autoAssignAdmin)
                        <span class="inline-flex items-center gap-1 px-2 py-1 text-xs rounded-lg bg-cyan-500/20 text-cyan-400">
                            <i class="ph-duotone ph-user text-xs"></i>
                            {{ $category->autoAssignAdmin->name }}
                        </span>
                    @endif
                </div>

                {{-- Actions --}}
                <div class="flex items-center justify-between pt-4 border-t border-white/5">
                    <span class="text-xs text-slate-500">@lang('Order'): {{ $category->order }}</span>
                    <div class="flex items-center gap-2">
                        <button wire:click="openModal({{ $category->id }})"
                            class="p-2 text-slate-400 hover:text-white hover:bg-white/10 rounded-lg transition-colors">
                            <i class="ph-duotone ph-pencil text-lg"></i>
                        </button>
                        @if($category->tickets_count === 0)
                            <button wire:click="delete({{ $category->id }})"
                                wire:confirm="{{ __('Are you sure you want to delete this category?') }}"
                                class="p-2 text-slate-400 hover:text-rose-400 hover:bg-rose-500/10 rounded-lg transition-colors">
                                <i class="ph-duotone ph-trash text-lg"></i>
                            </button>
                        @endif
                    </div>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <x-admin.card>
                    <div class="text-center py-12">
                        <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-slate-800 mx-auto mb-4">
                            <i class="ph-duotone ph-folders text-3xl text-slate-500"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-white mb-2">@lang('No Categories Found')</h3>
                        <p class="text-sm text-slate-500 mb-4">@lang('Create your first ticket category to get started.')</p>
                        <x-admin.button wire:click="openModal" icon="ph-plus">
                            @lang('Add Category')
                        </x-admin.button>
                    </div>
                </x-admin.card>
            </div>
        @endforelse
    </div>

    {{-- Pagination --}}
    @if($categories->hasPages())
        <div class="mt-6">
            {{ $categories->links() }}
        </div>
    @endif

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Category') : __('Add Category')" maxWidth="2xl">
        <form wire:submit="save">
            <div class="space-y-5">
                {{-- Basic Info --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Category Name') *</label>
                        <input type="text" wire:model.live="name"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                            placeholder="{{ __('e.g., Technical Support') }}" />
                        @error('name') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Slug') *</label>
                        <input type="text" wire:model="slug"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                            placeholder="technical-support" />
                        @error('slug') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Description')</label>
                    <textarea wire:model="description" rows="2"
                        class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        placeholder="{{ __('Brief description of this category') }}"></textarea>
                    @error('description') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>

                {{-- Appearance --}}
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Icon') *</label>
                        <input type="text" wire:model="icon"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                            placeholder="ph-folder" />
                        <p class="text-xs text-slate-500 mt-1">@lang('Phosphor icon class')</p>
                        @error('icon') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Color') *</label>
                        <select wire:model="color"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($colors as $value => $label)
                                <option value="{{ $value }}" class="bg-slate-800">{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('color') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Order')</label>
                        <input type="number" wire:model="order" min="0"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                        @error('order') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>

                {{-- SLA Settings --}}
                <div class="p-4 bg-blue-500/10 border border-blue-500/20 rounded-xl">
                    <h4 class="text-sm font-semibold text-blue-400 mb-3 flex items-center gap-2">
                        <i class="ph-duotone ph-timer"></i>
                        @lang('SLA Settings')
                    </h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Response Time (Hours)')</label>
                            <input type="number" wire:model="sla_response_hours" min="1" max="720"
                                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                                placeholder="{{ __('Leave empty for default') }}" />
                            @error('sla_response_hours') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Resolution Time (Hours)')</label>
                            <input type="number" wire:model="sla_resolution_hours" min="1" max="720"
                                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                                placeholder="{{ __('Leave empty for default') }}" />
                            @error('sla_resolution_hours') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>

                {{-- Assignment & Priority --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Default Priority')</label>
                        <select wire:model="default_priority"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($priorities as $value => $label)
                                <option value="{{ $value }}" class="bg-slate-800">{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('default_priority') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Auto-Assign To')</label>
                        <select wire:model="auto_assign_admin_id"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            <option value="" class="bg-slate-800">@lang('No Auto-Assignment')</option>
                            @foreach($admins as $admin)
                                <option value="{{ $admin->id }}" class="bg-slate-800">{{ $admin->name }}</option>
                            @endforeach
                        </select>
                        @error('auto_assign_admin_id') <span class="text-rose-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>

                {{-- Toggles --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Active')</p>
                            <p class="text-xs text-slate-500">@lang('Show in ticket creation')</p>
                        </div>
                        <button type="button" wire:click="$toggle('is_active')"
                            class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors {{ $is_active ? 'bg-indigo-600' : 'bg-slate-700' }}">
                            <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $is_active ? 'translate-x-6' : 'translate-x-1' }}"></span>
                        </button>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Requires Service')</p>
                            <p class="text-xs text-slate-500">@lang('Must select a service')</p>
                        </div>
                        <button type="button" wire:click="$toggle('requires_service')"
                            class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors {{ $requires_service ? 'bg-indigo-600' : 'bg-slate-700' }}">
                            <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $requires_service ? 'translate-x-6' : 'translate-x-1' }}"></span>
                        </button>
                    </div>
                </div>
            </div>
        </form>

        <x-slot:footer>
            <x-admin.button wire:click="closeModal" variant="secondary">@lang('Cancel')</x-admin.button>
            <x-admin.button wire:click="save" icon="ph-check">
                <span wire:loading.remove wire:target="save">{{ $editingId ? __('Update') : __('Create') }}</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>
</div>

