<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Support Tickets')" :subtitle="__('Manage and respond to customer support tickets.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.support.categories') }}" variant="secondary" icon="ph-folders" class="hidden sm:inline-flex">
                @lang('Categories')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.support.canned') }}" variant="secondary" icon="ph-chat-text" class="hidden sm:inline-flex">
                @lang('Canned Responses')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.ticket.setting') }}" variant="secondary" icon="ph-gear">
                <span class="hidden sm:inline">@lang('Settings')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards - Scrollable on mobile --}}
    <div class="mt-4 sm:mt-6 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto pb-2 sm:pb-0">
        <div class="flex gap-2 sm:gap-4 sm:grid sm:grid-cols-4 lg:grid-cols-8 min-w-max sm:min-w-0">
            <x-admin.stat-card
                icon="ph-ticket"
                iconColor="primary"
                :label="__('Total')"
                :value="number_format($stats['total'])"
                wire:click="$set('status', '')"
                class="cursor-pointer hover:border-indigo-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-envelope-open"
                iconColor="info"
                :label="__('Open')"
                :value="number_format($stats['open'])"
                wire:click="$set('status', 'open')"
                class="cursor-pointer hover:border-blue-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-clock"
                iconColor="warning"
                :label="__('Pending')"
                :value="number_format($stats['pending'])"
                wire:click="$set('status', 'pending')"
                class="cursor-pointer hover:border-amber-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-check-circle"
                iconColor="success"
                :label="__('Answered')"
                :value="number_format($stats['answered'])"
                wire:click="$set('status', 'answered')"
                class="cursor-pointer hover:border-emerald-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-x-circle"
                iconColor="secondary"
                :label="__('Closed')"
                :value="number_format($stats['closed'])"
                wire:click="$set('status', 'closed')"
                class="cursor-pointer hover:border-slate-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-warning"
                iconColor="danger"
                :label="__('Overdue')"
                :value="number_format($stats['overdue'])"
                class="{{ $stats['overdue'] > 0 ? 'border-rose-500/30 animate-pulse' : '' }} min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-user-circle-minus"
                iconColor="warning"
                :label="__('Unassigned')"
                :value="number_format($stats['unassigned'])"
                wire:click="$set('assigned', 'unassigned')"
                class="cursor-pointer hover:border-amber-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-user-circle"
                iconColor="info"
                :label="__('My Tickets')"
                :value="number_format($stats['my_tickets'])"
                wire:click="$set('assigned', 'me')"
                class="cursor-pointer hover:border-blue-500/30 active:scale-[0.98] min-w-[120px] sm:min-w-0"
            />
        </div>
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-4 sm:mt-6">
        <div class="flex flex-col gap-3 sm:gap-4">
            {{-- Top Row: Search & Bulk Actions --}}
            <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
                {{-- Search --}}
                <div class="relative w-full sm:w-80">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="{{ __('Search tickets...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-3 sm:py-2.5 pl-10 pr-10 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    />
                    @if($search)
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white cursor-pointer p-1 min-h-11 min-w-11 flex items-center justify-center -mr-2">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>

                {{-- Bulk Actions --}}
                @if(count($selectedTickets) > 0)
                    <div class="flex flex-wrap items-center gap-2 px-3 py-2 bg-indigo-500/10 border border-indigo-500/20 rounded-xl">
                        <span class="text-sm text-indigo-400">{{ count($selectedTickets) }} @lang('selected')</span>
                        <div class="h-4 w-px bg-white/10 hidden sm:block"></div>
                        <button wire:click="bulkClose" class="px-3 py-2 sm:py-1 text-xs font-medium text-white bg-slate-700 hover:bg-slate-600 rounded-lg transition-colors min-h-11 sm:min-h-0">
                            @lang('Close')
                        </button>
                        <select wire:change="bulkAssign($event.target.value)" class="px-3 py-2 sm:py-1 text-xs bg-slate-700 text-white rounded-lg border-0 min-h-11 sm:min-h-0">
                            <option value="">@lang('Assign to...')</option>
                            @foreach($admins as $admin)
                                <option value="{{ $admin->id }}">{{ $admin->name }}</option>
                            @endforeach
                        </select>
                    </div>
                @endif
            </div>

            {{-- Filter Dropdowns - Scrollable on mobile --}}
            <div class="-mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto pb-1 sm:pb-0">
                <div class="flex gap-2 min-w-max sm:min-w-0 sm:flex-wrap">
                    <select
                        wire:model.live="status"
                        class="rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 cursor-pointer"
                    >
                        <option value="" class="bg-slate-800">@lang('All Status')</option>
                        <option value="open" class="bg-slate-800">@lang('Open')</option>
                        <option value="answered" class="bg-slate-800">@lang('Answered')</option>
                        <option value="customer_reply" class="bg-slate-800">@lang('Customer Reply')</option>
                        <option value="pending" class="bg-slate-800">@lang('Pending')</option>
                        <option value="closed" class="bg-slate-800">@lang('Closed')</option>
                    </select>

                    <select
                        wire:model.live="priority"
                        class="rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 cursor-pointer"
                    >
                        <option value="" class="bg-slate-800">@lang('All Priority')</option>
                        <option value="critical" class="bg-slate-800">@lang('Critical')</option>
                        <option value="high" class="bg-slate-800">@lang('High')</option>
                        <option value="medium" class="bg-slate-800">@lang('Medium')</option>
                        <option value="low" class="bg-slate-800">@lang('Low')</option>
                    </select>

                    <select
                        wire:model.live="category"
                        class="rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 cursor-pointer"
                    >
                        <option value="" class="bg-slate-800">@lang('All Categories')</option>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}" class="bg-slate-800">{{ $cat->name }}</option>
                        @endforeach
                    </select>

                    <select
                        wire:model.live="assigned"
                        class="rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 cursor-pointer"
                    >
                        <option value="" class="bg-slate-800">@lang('All Assigned')</option>
                        <option value="me" class="bg-slate-800">@lang('Assigned to Me')</option>
                        <option value="unassigned" class="bg-slate-800">@lang('Unassigned')</option>
                        @foreach($admins as $admin)
                            <option value="{{ $admin->id }}" class="bg-slate-800">{{ $admin->name }}</option>
                        @endforeach
                    </select>

                    @if($status || $priority || $category || $assigned || $search)
                        <button wire:click="$set('status', ''); $set('priority', ''); $set('category', ''); $set('assigned', ''); $set('search', '')"
                            class="px-4 py-3 sm:py-2.5 text-sm text-rose-400 hover:text-rose-300 transition-colors whitespace-nowrap min-h-11 sm:min-h-0 flex items-center cursor-pointer">
                            <i class="ph-duotone ph-x-circle mr-1"></i>
                            @lang('Clear')
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </x-admin.card>

    {{-- Tickets Table (Desktop) / Cards (Mobile) --}}
    <x-admin.card class="mt-4 sm:mt-6" :padding="false">
        {{-- Desktop Table View --}}
        <div class="hidden lg:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/5">
                        <th class="w-12 px-4 py-3">
                            <input type="checkbox" wire:model.live="selectAll"
                                class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20" />
                        </th>
                        <th class="px-4 py-3 text-left">
                            <button wire:click="sortBy('ticket')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white cursor-pointer">
                                @lang('Ticket')
                                @if($sortField === 'ticket')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-4 py-3 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Subject')</span>
                        </th>
                        <th class="px-4 py-3 text-left hidden xl:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Customer')</span>
                        </th>
                        <th class="px-4 py-3 text-center hidden xl:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</span>
                        </th>
                        <th class="px-4 py-3 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Priority')</span>
                        </th>
                        <th class="px-4 py-3 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-4 py-3 text-center hidden xl:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Assigned')</span>
                        </th>
                        <th class="px-4 py-3 text-left hidden 2xl:table-cell">
                            <button wire:click="sortBy('last_reply')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white cursor-pointer">
                                @lang('Last Reply')
                                @if($sortField === 'last_reply')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-4 py-3 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($tickets as $ticket)
                        <tr class="group transition-all hover:bg-white/5 {{ in_array((string)$ticket->id, $selectedTickets) ? 'bg-indigo-500/5' : '' }}" wire:key="ticket-{{ $ticket->id }}">
                            <td class="px-4 py-3">
                                <input type="checkbox" wire:model.live="selectedTickets" value="{{ $ticket->id }}"
                                    class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20" />
                            </td>
                            <td class="px-4 py-3">
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('admin.ticket.view', $ticket->id) }}" class="font-mono text-sm text-indigo-400 transition-colors hover:text-indigo-300">
                                        #{{ $ticket->ticket }}
                                    </a>
                                    @if($ticket->sla_response_breached || $ticket->sla_resolution_breached)
                                        <span class="flex h-2 w-2 rounded-full bg-rose-500 animate-pulse" title="@lang('SLA Breached')"></span>
                                    @elseif($ticket->sla_response_due_at && $ticket->sla_response_due_at < now() && !$ticket->first_response_at)
                                        <span class="flex h-2 w-2 rounded-full bg-amber-500 animate-pulse" title="@lang('Response Overdue')"></span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-4 py-3">
                                <a href="{{ route('admin.ticket.view', $ticket->id) }}" class="font-medium text-white transition-colors hover:text-indigo-400 line-clamp-1 max-w-[200px] block truncate">
                                    {{ $ticket->subject }}
                                </a>
                            </td>
                            <td class="px-4 py-3 hidden xl:table-cell">
                                <div class="flex items-center gap-2">
                                    <div class="flex h-7 w-7 shrink-0 items-center justify-center rounded-lg bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-xs font-semibold text-indigo-400">
                                        {{ strtoupper(substr($ticket->name, 0, 1)) }}
                                    </div>
                                    <span class="text-sm text-white truncate max-w-[100px]">{{ Str::limit($ticket->name, 12) }}</span>
                                </div>
                            </td>
                            <td class="px-4 py-3 text-center hidden xl:table-cell">
                                @if($ticket->category)
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-lg"
                                        style="background-color: {{ $ticket->category->color }}20; color: {{ $ticket->category->color }}">
                                        {{ Str::limit($ticket->category->name, 10) }}
                                    </span>
                                @else
                                    <span class="text-xs text-slate-500">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-center">
                                @if($ticket->priority == \App\Models\SupportTicket::PRIORITY_CRITICAL)
                                    <x-admin.badge type="danger" size="sm" class="animate-pulse">@lang('Critical')</x-admin.badge>
                                @elseif($ticket->priority == \App\Models\SupportTicket::PRIORITY_HIGH)
                                    <x-admin.badge type="danger" size="sm">@lang('High')</x-admin.badge>
                                @elseif($ticket->priority == \App\Models\SupportTicket::PRIORITY_MEDIUM)
                                    <x-admin.badge type="warning" size="sm">@lang('Medium')</x-admin.badge>
                                @else
                                    <x-admin.badge type="secondary" size="sm">@lang('Low')</x-admin.badge>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-center">
                                @if($ticket->status == \App\Models\SupportTicket::STATUS_OPEN)
                                    <x-admin.badge type="info" size="sm">@lang('Open')</x-admin.badge>
                                @elseif($ticket->status == \App\Models\SupportTicket::STATUS_ANSWERED)
                                    <x-admin.badge type="success" size="sm">@lang('Answered')</x-admin.badge>
                                @elseif($ticket->status == \App\Models\SupportTicket::STATUS_CUSTOMER_REPLY)
                                    <x-admin.badge type="warning" size="sm">@lang('Awaiting')</x-admin.badge>
                                @elseif($ticket->status == \App\Models\SupportTicket::STATUS_ON_HOLD)
                                    <x-admin.badge type="secondary" size="sm">@lang('On Hold')</x-admin.badge>
                                @else
                                    <x-admin.badge type="secondary" size="sm">@lang('Closed')</x-admin.badge>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-center hidden xl:table-cell">
                                @if($ticket->assignedAdmin)
                                    <div class="flex items-center justify-center gap-1">
                                        <div class="flex h-6 w-6 items-center justify-center rounded-full bg-emerald-500/20 text-xs font-semibold text-emerald-400">
                                            {{ strtoupper(substr($ticket->assignedAdmin->name, 0, 1)) }}
                                        </div>
                                    </div>
                                @else
                                    <span class="text-xs text-slate-500">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 hidden 2xl:table-cell">
                                <span class="text-sm text-slate-400">{{ $ticket->last_reply ? \Carbon\Carbon::parse($ticket->last_reply)->diffForHumans() : '—' }}</span>
                            </td>
                            <td class="px-4 py-3 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item href="{{ route('admin.ticket.view', $ticket->id) }}" icon="ph-eye">
                                        @lang('View')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    @foreach($admins as $admin)
                                        <x-admin.action-menu-item wire:click="assignTicket({{ $ticket->id }}, {{ $admin->id }})" icon="ph-user">
                                            @lang('Assign to') {{ $admin->name }}
                                        </x-admin.action-menu-item>
                                    @endforeach
                                    @if($ticket->assigned_to)
                                        <x-admin.action-menu-item wire:click="assignTicket({{ $ticket->id }}, null)" icon="ph-user-minus">
                                            @lang('Unassign')
                                        </x-admin.action-menu-item>
                                    @endif
                                    <x-admin.action-menu-item :divider="true" />
                                    @if($ticket->status != \App\Models\SupportTicket::STATUS_CLOSED)
                                        <x-admin.action-menu-item wire:click="closeTicket({{ $ticket->id }})" icon="ph-x-circle" :danger="true">
                                            @lang('Close')
                                        </x-admin.action-menu-item>
                                    @else
                                        <x-admin.action-menu-item wire:click="reopenTicket({{ $ticket->id }})" icon="ph-arrow-counter-clockwise">
                                            @lang('Reopen')
                                        </x-admin.action-menu-item>
                                    @endif
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-ticket text-2xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-3 text-base font-medium text-white">@lang('No tickets found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $status || $priority || $category || $assigned)
                                            @lang('No tickets match your search criteria.')
                                        @else
                                            @lang('There are no support tickets yet.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Mobile Card View --}}
        <div class="lg:hidden divide-y divide-white/5">
            @forelse($tickets as $ticket)
                <a href="{{ route('admin.ticket.view', $ticket->id) }}" class="block p-4 active:bg-white/5" wire:key="ticket-mobile-{{ $ticket->id }}">
                    <div class="flex items-start justify-between gap-3">
                        <div class="flex items-center gap-3 min-w-0 flex-1">
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-sm font-semibold text-indigo-400">
                                {{ strtoupper(substr($ticket->name, 0, 1)) }}
                            </div>
                            <div class="min-w-0 flex-1">
                                <div class="flex items-center gap-2">
                                    <span class="font-mono text-xs text-indigo-400">#{{ $ticket->ticket }}</span>
                                    @if($ticket->sla_response_breached || $ticket->sla_resolution_breached)
                                        <span class="flex h-2 w-2 rounded-full bg-rose-500 animate-pulse"></span>
                                    @endif
                                </div>
                                <p class="text-sm font-medium text-white truncate mt-0.5">{{ $ticket->subject }}</p>
                            </div>
                        </div>
                        <div class="flex flex-col items-end gap-1 shrink-0">
                            @if($ticket->status == \App\Models\SupportTicket::STATUS_OPEN)
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-blue-500/10 text-blue-400">@lang('Open')</span>
                            @elseif($ticket->status == \App\Models\SupportTicket::STATUS_ANSWERED)
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-emerald-500/10 text-emerald-400">@lang('Answered')</span>
                            @elseif($ticket->status == \App\Models\SupportTicket::STATUS_CUSTOMER_REPLY)
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-amber-500/10 text-amber-400">@lang('Awaiting')</span>
                            @else
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-slate-500/10 text-slate-400">@lang('Closed')</span>
                            @endif
                            @if($ticket->priority == \App\Models\SupportTicket::PRIORITY_CRITICAL || $ticket->priority == \App\Models\SupportTicket::PRIORITY_HIGH)
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-full bg-rose-500/10 text-rose-400">
                                    {{ $ticket->priority == \App\Models\SupportTicket::PRIORITY_CRITICAL ? __('Critical') : __('High') }}
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="mt-2 flex items-center justify-between text-xs text-slate-500">
                        <span>{{ Str::limit($ticket->name, 20) }}</span>
                        <span>{{ $ticket->last_reply ? \Carbon\Carbon::parse($ticket->last_reply)->diffForHumans() : __('No reply') }}</span>
                    </div>
                </a>
            @empty
                <div class="px-4 py-12 text-center">
                    <div class="flex flex-col items-center">
                        <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                            <i class="ph-duotone ph-ticket text-2xl text-slate-500"></i>
                        </div>
                        <h3 class="mt-3 text-base font-medium text-white">@lang('No tickets found')</h3>
                        <p class="mt-1 text-sm text-slate-500">
                            @if($search || $status || $priority || $category || $assigned)
                                @lang('No tickets match your search criteria.')
                            @else
                                @lang('There are no support tickets yet.')
                            @endif
                        </p>
                        @if($search || $status || $priority || $category || $assigned)
                            <button wire:click="$set('status', ''); $set('priority', ''); $set('category', ''); $set('assigned', ''); $set('search', '')"
                                class="mt-4 px-4 py-2 text-sm font-medium text-indigo-400 hover:text-indigo-300 transition-colors cursor-pointer">
                                <i class="ph-duotone ph-arrow-counter-clockwise mr-1"></i>
                                @lang('Clear all filters')
                            </button>
                        @endif
                    </div>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        @if($tickets->hasPages())
            <div class="border-t border-white/5 px-4 sm:px-6 py-3 sm:py-4">
                {{ $tickets->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

