<div x-data="{ showMobileSidebar: false }">
    {{-- Page Header --}}
    @php $pageTitle = __('Ticket') . ' #' . $ticket->ticket; @endphp
    <x-admin.page-header :title="$pageTitle" :subtitle="$ticket->subject">
        <x-slot:actions>
            {{-- Desktop Actions --}}
            <div class="hidden sm:flex items-center gap-2">
                <x-admin.button href="{{ route('admin.ticket.index') }}" variant="secondary" icon="ph-arrow-left">
                    @lang('Back')
                </x-admin.button>
                @if($ticket->status != \App\Models\SupportTicket::STATUS_CLOSED)
                    <x-admin.button wire:click="putOnHold" variant="secondary" icon="ph-pause">
                        @lang('Hold')
                    </x-admin.button>
                    <x-admin.button wire:click="escalate" variant="warning" icon="ph-arrow-up">
                        @lang('Escalate')
                    </x-admin.button>
                    <x-admin.button wire:click="closeTicket" variant="danger" icon="ph-x-circle">
                        @lang('Close')
                    </x-admin.button>
                @else
                    <x-admin.button wire:click="reopenTicket" variant="success" icon="ph-arrow-counter-clockwise">
                        @lang('Reopen')
                    </x-admin.button>
                @endif
            </div>
            {{-- Mobile Actions --}}
            <div class="flex sm:hidden items-center gap-2">
                <x-admin.button href="{{ route('admin.ticket.index') }}" variant="secondary" icon="ph-arrow-left" size="sm" />
                <button type="button" @click="showMobileSidebar = !showMobileSidebar"
                    class="inline-flex items-center justify-center h-9 w-9 rounded-xl border border-white/10 bg-white/5 text-slate-400 hover:bg-white/10 hover:text-white transition-colors">
                    <i class="ph-duotone ph-sidebar text-lg"></i>
                </button>
            </div>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Mobile Quick Actions Bar --}}
    <div class="mt-4 sm:hidden -mx-4 px-4 overflow-x-auto pb-2">
        <div class="flex items-center gap-2 min-w-max">
            @if($ticket->status != \App\Models\SupportTicket::STATUS_CLOSED)
                <button wire:click="putOnHold" class="inline-flex items-center gap-1.5 px-3 py-2 text-xs font-medium rounded-lg bg-white/5 text-slate-300 hover:bg-white/10 active:scale-[0.98] transition-all">
                    <i class="ph-duotone ph-pause"></i>
                    @lang('Hold')
                </button>
                <button wire:click="escalate" class="inline-flex items-center gap-1.5 px-3 py-2 text-xs font-medium rounded-lg bg-amber-500/10 text-amber-400 hover:bg-amber-500/20 active:scale-[0.98] transition-all">
                    <i class="ph-duotone ph-arrow-up"></i>
                    @lang('Escalate')
                </button>
                <button wire:click="closeTicket" class="inline-flex items-center gap-1.5 px-3 py-2 text-xs font-medium rounded-lg bg-rose-500/10 text-rose-400 hover:bg-rose-500/20 active:scale-[0.98] transition-all">
                    <i class="ph-duotone ph-x-circle"></i>
                    @lang('Close')
                </button>
            @else
                <button wire:click="reopenTicket" class="inline-flex items-center gap-1.5 px-3 py-2 text-xs font-medium rounded-lg bg-emerald-500/10 text-emerald-400 hover:bg-emerald-500/20 active:scale-[0.98] transition-all">
                    <i class="ph-duotone ph-arrow-counter-clockwise"></i>
                    @lang('Reopen')
                </button>
            @endif
        </div>
    </div>

    <div class="mt-4 sm:mt-6 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-3">
        {{-- Ticket Details Sidebar --}}
        <div class="lg:col-span-1 space-y-4 sm:space-y-6 order-2 lg:order-1"
            :class="{ 'hidden lg:block': !showMobileSidebar, 'block': showMobileSidebar }">
            {{-- Quick Actions Card --}}
            <x-admin.card>
                <h3 class="text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-500 mb-3 sm:mb-4">@lang('Quick Actions')</h3>

                <div class="space-y-3 sm:space-y-4">
                    {{-- Status --}}
                    <div>
                        <label class="text-xs text-slate-500 mb-1 block">@lang('Status')</label>
                        <select wire:change="changeStatus($event.target.value)"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-base sm:text-sm text-white focus:border-indigo-500/50 focus:outline-none">
                            @foreach($statusOptions as $value => $label)
                                <option value="{{ $value }}" {{ $ticket->status == $value ? 'selected' : '' }} class="bg-slate-800">
                                    {{ $label }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Priority --}}
                    <div>
                        <label class="text-xs text-slate-500 mb-1 block">@lang('Priority')</label>
                        <select wire:change="changePriority($event.target.value)"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-base sm:text-sm text-white focus:border-indigo-500/50 focus:outline-none">
                            @foreach($priorityOptions as $value => $label)
                                <option value="{{ $value }}" {{ $ticket->priority == $value ? 'selected' : '' }} class="bg-slate-800">
                                    {{ $label }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Category --}}
                    <div>
                        <label class="text-xs text-slate-500 mb-1 block">@lang('Category')</label>
                        <select wire:change="changeCategory($event.target.value)"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-base sm:text-sm text-white focus:border-indigo-500/50 focus:outline-none">
                            <option value="" class="bg-slate-800">@lang('No Category')</option>
                            @foreach($categories as $cat)
                                <option value="{{ $cat->id }}" {{ $ticket->category_id == $cat->id ? 'selected' : '' }} class="bg-slate-800">
                                    {{ $cat->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Assigned To --}}
                    <div>
                        <label class="text-xs text-slate-500 mb-1 block">@lang('Assigned To')</label>
                        <select wire:change="assignTo($event.target.value ? $event.target.value : null)"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-base sm:text-sm text-white focus:border-indigo-500/50 focus:outline-none">
                            <option value="" class="bg-slate-800">@lang('Unassigned')</option>
                            @foreach($admins as $admin)
                                <option value="{{ $admin->id }}" {{ $ticket->assigned_to == $admin->id ? 'selected' : '' }} class="bg-slate-800">
                                    {{ $admin->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </x-admin.card>

            {{-- Customer Info Card --}}
            <x-admin.card>
                <h3 class="text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-500 mb-3 sm:mb-4">@lang('Customer')</h3>

                <div class="flex items-center gap-3 mb-3 sm:mb-4">
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 font-semibold text-indigo-400 text-base sm:text-lg">
                        {{ strtoupper(substr($ticket->name, 0, 1)) }}
                    </div>
                    <div class="min-w-0">
                        @if($ticket->user)
                            <a href="{{ route('admin.users.detail', $ticket->user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400 text-sm sm:text-base truncate block">
                                {{ $ticket->name }}
                            </a>
                        @else
                            <span class="font-medium text-white text-sm sm:text-base truncate block">{{ $ticket->name }}</span>
                        @endif
                        <p class="text-xs sm:text-sm text-slate-500 truncate">{{ $ticket->email }}</p>
                    </div>
                </div>

                @if($ticket->user)
                    <div class="pt-3 border-t border-white/5 space-y-2">
                        <div class="flex justify-between text-xs sm:text-sm">
                            <span class="text-slate-500">@lang('Total Tickets')</span>
                            <span class="text-white">{{ $ticket->user->tickets()->count() }}</span>
                        </div>
                        <div class="flex justify-between text-xs sm:text-sm">
                            <span class="text-slate-500">@lang('Open Tickets')</span>
                            <span class="text-white">{{ $ticket->user->tickets()->active()->count() }}</span>
                        </div>
                    </div>
                @endif
            </x-admin.card>

            {{-- SLA Info Card --}}
            @if($ticket->sla_response_due_at || $ticket->sla_resolution_due_at)
                <x-admin.card class="{{ $ticket->isOverdue() ? 'border-rose-500/30' : '' }}">
                    <h3 class="text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-500 mb-3 sm:mb-4">
                        <i class="ph-duotone ph-timer mr-1"></i>
                        @lang('SLA Status')
                    </h3>

                    <div class="space-y-2 sm:space-y-3">
                        @if($ticket->sla_response_due_at)
                            <div class="flex justify-between items-center">
                                <span class="text-xs sm:text-sm text-slate-400">@lang('First Response')</span>
                                @if($ticket->first_response_at)
                                    <span class="text-xs sm:text-sm text-emerald-400">
                                        <i class="ph-duotone ph-check-circle mr-1"></i>
                                        {{ $ticket->first_response_at->diffForHumans() }}
                                    </span>
                                @elseif($ticket->sla_response_breached)
                                    <span class="text-xs sm:text-sm text-rose-400 animate-pulse">
                                        <i class="ph-duotone ph-warning mr-1"></i>
                                        @lang('Breached')
                                    </span>
                                @else
                                    <span class="text-xs sm:text-sm {{ $ticket->sla_response_due_at->isPast() ? 'text-rose-400' : 'text-amber-400' }}">
                                        {{ $ticket->sla_response_due_at->diffForHumans() }}
                                    </span>
                                @endif
                            </div>
                        @endif

                        @if($ticket->sla_resolution_due_at)
                            <div class="flex justify-between items-center">
                                <span class="text-xs sm:text-sm text-slate-400">@lang('Resolution')</span>
                                @if($ticket->resolved_at)
                                    <span class="text-xs sm:text-sm text-emerald-400">
                                        <i class="ph-duotone ph-check-circle mr-1"></i>
                                        {{ $ticket->resolved_at->diffForHumans() }}
                                    </span>
                                @elseif($ticket->sla_resolution_breached)
                                    <span class="text-xs sm:text-sm text-rose-400 animate-pulse">
                                        <i class="ph-duotone ph-warning mr-1"></i>
                                        @lang('Breached')
                                    </span>
                                @else
                                    <span class="text-xs sm:text-sm {{ $ticket->sla_resolution_due_at->isPast() ? 'text-rose-400' : 'text-amber-400' }}">
                                        {{ $ticket->sla_resolution_due_at->diffForHumans() }}
                                    </span>
                                @endif
                            </div>
                        @endif
                    </div>
                </x-admin.card>
            @endif

            {{-- Ticket Info Card --}}
            <x-admin.card>
                <h3 class="text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-500 mb-3 sm:mb-4">@lang('Details')</h3>

                <div class="space-y-2 sm:space-y-3 text-xs sm:text-sm">
                    <div class="flex justify-between">
                        <span class="text-slate-500">@lang('Created')</span>
                        <span class="text-white">{{ $ticket->created_at->format('M d, Y H:i') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-slate-500">@lang('Last Reply')</span>
                        <span class="text-white">{{ $ticket->last_reply ? $ticket->last_reply->diffForHumans() : __('N/A') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-slate-500">@lang('Replies')</span>
                        <span class="text-white">{{ $ticket->reply_count ?? 0 }}</span>
                    </div>
                    @if($ticket->escalation_level > 0)
                        <div class="flex justify-between">
                            <span class="text-slate-500">@lang('Escalation Level')</span>
                            <span class="text-amber-400">{{ $ticket->escalation_level }}</span>
                        </div>
                    @endif
                    @if($ticket->source)
                        <div class="flex justify-between">
                            <span class="text-slate-500">@lang('Source')</span>
                            <span class="text-white capitalize">{{ $ticket->source }}</span>
                        </div>
                    @endif
                </div>
            </x-admin.card>
        </div>

        {{-- Conversation Thread --}}
        <div class="lg:col-span-2 space-y-4 sm:space-y-6 order-1 lg:order-2"
             wire:poll.5s="checkNewMessages">
            {{-- Messages --}}
            <div class="space-y-3 sm:space-y-4">
                @foreach($ticket->messages->sortBy('created_at') as $msg)
                    @php
                        $isInternal = $msg->is_internal_note ?? false;
                        $isAdmin = $msg->isAdminReply();
                        $borderColor = $isInternal ? 'border-l-amber-500' : ($isAdmin ? 'border-l-indigo-500' : 'border-l-emerald-500');
                        $bgColor = $isInternal ? 'bg-amber-500/5' : '';
                    @endphp
                    <x-admin.card class="border-l-4 {{ $borderColor }} {{ $bgColor }}">
                        <div class="flex items-start justify-between gap-2 sm:gap-4">
                            <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl {{ $isInternal ? 'bg-amber-500/20 text-amber-400' : ($isAdmin ? 'bg-indigo-500/20 text-indigo-400' : 'bg-emerald-500/20 text-emerald-400') }} font-semibold text-sm sm:text-base">
                                    @if($isInternal)
                                        <i class="ph-duotone ph-note text-base sm:text-lg"></i>
                                    @elseif($isAdmin)
                                        <i class="ph-duotone ph-user-gear text-base sm:text-lg"></i>
                                    @else
                                        {{ strtoupper(substr($ticket->name, 0, 1)) }}
                                    @endif
                                </div>
                                <div class="min-w-0">
                                    <div class="flex flex-wrap items-center gap-1 sm:gap-2">
                                        <span class="font-medium text-white text-sm sm:text-base truncate">
                                            @if($isAdmin)
                                                {{ $msg->admin?->name ?? __('Admin') }}
                                            @else
                                                {{ $ticket->name }}
                                            @endif
                                        </span>
                                        @if($isInternal)
                                            <span class="px-1.5 sm:px-2 py-0.5 text-[10px] sm:text-xs font-medium bg-amber-500/20 text-amber-400 rounded-full whitespace-nowrap">
                                                @lang('Internal')
                                            </span>
                                        @endif
                                    </div>
                                    <p class="text-[10px] sm:text-xs text-slate-500">{{ $msg->created_at->format('M d, Y h:i A') }}</p>
                                </div>
                            </div>
                            <div class="flex items-center gap-1 sm:gap-2 shrink-0">
                                @if($msg->cannedResponse)
                                    <span class="text-xs text-slate-500 hidden sm:inline" title="@lang('Used canned response')">
                                        <i class="ph-duotone ph-lightning"></i>
                                    </span>
                                @endif
                                @if($isAdmin)
                                    <button wire:click="deleteMessage({{ $msg->id }})" wire:confirm="{{ __('Are you sure you want to delete this message?') }}" class="text-slate-500 transition-colors hover:text-red-400 p-1 min-h-[36px] min-w-[36px] sm:min-h-0 sm:min-w-0 flex items-center justify-center">
                                        <i class="ph-duotone ph-trash text-base sm:text-lg"></i>
                                    </button>
                                @endif
                            </div>
                        </div>

                        <div class="mt-3 sm:mt-4 prose prose-invert prose-sm max-w-none text-slate-300 text-sm sm:text-base">
                            {!! nl2br(e($msg->message)) !!}
                        </div>

                        {{-- Attachments --}}
                        @if($msg->attachments->count() > 0)
                            <div class="mt-3 sm:mt-4 pt-3 sm:pt-4 border-t border-white/5">
                                <span class="text-[10px] sm:text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Attachments')</span>
                                <div class="mt-2 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto">
                                    <div class="flex gap-2 min-w-max sm:min-w-0 sm:flex-wrap">
                                        @foreach($msg->attachments as $attachment)
                                            <a href="{{ asset('storage/support/' . $attachment->attachment) }}" target="_blank" class="inline-flex items-center gap-2 rounded-lg bg-white/5 px-2.5 sm:px-3 py-2 text-xs sm:text-sm text-slate-300 transition-colors hover:bg-white/10 hover:text-white whitespace-nowrap active:scale-[0.98]">
                                                <i class="ph-duotone ph-paperclip"></i>
                                                <span class="max-w-[120px] sm:max-w-none truncate">{{ $attachment->original_name ?? $attachment->attachment }}</span>
                                            </a>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                    </x-admin.card>
                @endforeach

                @if($this->isUserTyping)
                    <div class="flex items-center gap-2 px-4 py-2 text-xs text-slate-400 italic animate-pulse" wire:key="user-typing">
                        <i class="ph-bold ph-pencil-simple-line"></i>
                        @lang('Client is typing...')
                    </div>
                @endif
            </div>

            {{-- Reply Form --}}
            @if($ticket->status != \App\Models\SupportTicket::STATUS_CLOSED)
                <x-admin.card class="{{ $isInternalNote ? 'border border-amber-500/30' : '' }}">
                    <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-2 sm:gap-4 mb-3 sm:mb-4">
                        <h3 class="text-base sm:text-lg font-semibold text-white">
                            @if($isInternalNote)
                                <i class="ph-duotone ph-note text-amber-400 mr-2"></i>
                                @lang('Add Internal Note')
                            @else
                                @lang('Send Reply')
                            @endif
                        </h3>

                        {{-- Canned Responses Button --}}
                        <div class="relative">
                            <button type="button" wire:click="$toggle('showCannedResponses')"
                                class="inline-flex items-center gap-2 px-3 py-2 text-xs sm:text-sm text-slate-400 hover:text-white transition-colors rounded-lg hover:bg-white/5 active:scale-[0.98]">
                                <i class="ph-duotone ph-lightning"></i>
                                <span class="hidden sm:inline">@lang('Canned Responses')</span>
                                <span class="sm:hidden">@lang('Canned')</span>
                            </button>

                            {{-- Canned Responses Dropdown --}}
                            @if($showCannedResponses)
                                <div class="fixed sm:absolute inset-x-4 sm:inset-x-auto sm:right-0 top-1/4 sm:top-full sm:mt-2 w-auto sm:w-80 rounded-xl border border-white/10 bg-slate-800 shadow-xl z-50">
                                    <div class="p-3 border-b border-white/10">
                                        <input type="text" wire:model.live.debounce.300ms="cannedSearch"
                                            placeholder="{{ __('Search responses...') }}"
                                            class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2.5 text-base sm:text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none">
                                    </div>
                                    <div class="max-h-64 overflow-y-auto">
                                        @forelse($cannedResponses as $canned)
                                            <button type="button" wire:click="insertCannedResponse({{ $canned->id }})"
                                                class="w-full px-4 py-3 text-left hover:bg-white/5 transition-colors border-b border-white/5 last:border-0 active:bg-white/10">
                                                <div class="flex items-center justify-between">
                                                    <span class="font-medium text-white text-sm">{{ $canned->name }}</span>
                                                    @if($canned->shortcut)
                                                        <span class="text-xs text-slate-500">/{{ $canned->shortcut }}</span>
                                                    @endif
                                                </div>
                                                <p class="text-xs text-slate-400 mt-1 line-clamp-2">{{ Str::limit($canned->content, 80) }}</p>
                                            </button>
                                        @empty
                                            <div class="px-4 py-6 text-center text-slate-500 text-sm">
                                                @lang('No canned responses found')
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    <form wire:submit="sendReply">
                        <div class="space-y-3 sm:space-y-4">
                            {{-- Message --}}
                            <div>
                                <textarea
                                    wire:model.live="message"
                                    rows="4"
                                    placeholder="{{ $isInternalNote ? __('Write an internal note (not visible to customer)...') : __('Type your reply here...') }}"
                                    class="w-full rounded-xl border {{ $isInternalNote ? 'border-amber-500/30 bg-amber-500/5' : 'border-white/10 bg-white/5' }} px-3 sm:px-4 py-3 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                                ></textarea>
                                @error('message')
                                    <p class="mt-1 text-xs sm:text-sm text-red-400">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- Attachments --}}
                            <div>
                                <label class="block text-xs sm:text-sm font-medium text-slate-300 mb-1.5 sm:mb-2">@lang('Attachments (Max 5)')</label>
                                <input
                                    type="file"
                                    wire:model="attachments"
                                    multiple
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-3 text-base sm:text-sm text-white file:mr-2 sm:file:mr-4 file:rounded-lg file:border-0 file:bg-indigo-500/20 file:px-3 sm:file:px-4 file:py-2 file:text-xs sm:file:text-sm file:font-medium file:text-indigo-400 hover:file:bg-indigo-500/30"
                                />
                                @error('attachments.*')
                                    <p class="mt-1 text-xs sm:text-sm text-red-400">{{ $message }}</p>
                                @enderror

                                {{-- Preview Attachments --}}
                                @if(count($attachments) > 0)
                                    <div class="mt-2 sm:mt-3 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto">
                                        <div class="flex gap-2 min-w-max sm:min-w-0 sm:flex-wrap">
                                            @foreach($attachments as $index => $attachment)
                                                <div class="inline-flex items-center gap-2 rounded-lg bg-white/5 px-2.5 sm:px-3 py-2 text-xs sm:text-sm text-slate-300 whitespace-nowrap">
                                                    <i class="ph-duotone ph-file"></i>
                                                    <span class="max-w-[100px] sm:max-w-none truncate">{{ $attachment->getClientOriginalName() }}</span>
                                                    <button type="button" wire:click="removeAttachment({{ $index }})" class="text-red-400 hover:text-red-300 p-1 min-h-9 min-w-9 sm:min-h-0 sm:min-w-0 flex items-center justify-center">
                                                        <i class="ph-bold ph-x"></i>
                                                    </button>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>

                            {{-- Actions Row --}}
                            <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-3 sm:gap-4 pt-3 sm:pt-2 border-t border-white/5">
                                {{-- Internal Note Toggle --}}
                                <label class="inline-flex items-center gap-2 cursor-pointer min-h-11 sm:min-h-0">
                                    <input type="checkbox" wire:model.live="isInternalNote"
                                        class="w-5 h-5 sm:w-4 sm:h-4 rounded border-white/20 bg-white/5 text-amber-500 focus:ring-amber-500/20">
                                    <span class="text-xs sm:text-sm text-slate-400">@lang('Internal note')</span>
                                </label>

                                {{-- Submit Button --}}
                                <x-admin.button type="submit" :variant="$isInternalNote ? 'warning' : 'primary'" icon="{{ $isInternalNote ? 'ph-note' : 'ph-paper-plane-tilt' }}" wire:loading.attr="disabled" class="w-full sm:w-auto justify-center">
                                    <span wire:loading.remove wire:target="sendReply">
                                        {{ $isInternalNote ? __('Add Note') : __('Send Reply') }}
                                    </span>
                                    <span wire:loading wire:target="sendReply">@lang('Sending...')</span>
                                </x-admin.button>
                            </div>
                        </div>
                    </form>
                </x-admin.card>
            @else
                <x-admin.card class="text-center">
                    <div class="py-6 sm:py-8">
                        <i class="ph-duotone ph-lock-simple text-3xl sm:text-4xl text-slate-500 mb-3"></i>
                        <p class="text-sm sm:text-base text-slate-400">@lang('This ticket is closed. Reopen it to send a reply.')</p>
                        <button wire:click="reopenTicket" class="mt-4 inline-flex items-center gap-2 px-4 py-2.5 text-sm font-medium text-indigo-400 hover:text-indigo-300 transition-colors active:scale-[0.98] min-h-11 sm:min-h-0">
                            <i class="ph-duotone ph-arrow-counter-clockwise"></i>
                            @lang('Reopen Ticket')
                        </button>
                    </div>
                </x-admin.card>
            @endif
        </div>
    </div>

    {{-- Audio for Notifications --}}
    <audio id="adminNotificationSound" preload="auto">
        <source src="https://assets.mixkit.co/active_storage/sfx/2358/2358-preview.mp3" type="audio/mpeg">
    </audio>

    <script>
        window.addEventListener('play-admin-sound', () => {
            const audio = document.getElementById('adminNotificationSound');
            if (audio) {
                audio.currentTime = 0;
                audio.play().catch(e => console.log('Audio playback failed:', e));
            }
        });
    </script>
</div>

