<div>
    <x-admin.page-header :title="__('Automation Errors')" :subtitle="__('Monitor and resolve cron job errors.')">
        <x-slot:actions>
            <x-admin.button wire:click="flushResolved" variant="secondary" size="sm" icon="ph-broom">
                @lang('Flush Resolved')
            </x-admin.button>
            <x-admin.button wire:click="flushLogs" variant="danger" size="sm" icon="ph-trash" wire:confirm="{{ __('Are you sure you want to delete all error logs?') }}">
                @lang('Flush All')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Stats -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
        <x-admin.stat-card :label="__('Total Errors')" :value="number_format($totalCount)" icon="ph-warning" iconColor="warning" />
        <x-admin.stat-card :label="__('Unresolved')" :value="number_format($unresolvedCount)" icon="ph-warning-circle" iconColor="danger" />
        <x-admin.stat-card :label="__('Resolved')" :value="number_format($totalCount - $unresolvedCount)" icon="ph-check-circle" iconColor="success" />
    </div>

    <!-- Filters -->
    <div class="flex flex-wrap items-center gap-4 mb-6">
        <div class="flex-1 min-w-[200px]">
            <input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search error messages...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
        </div>
        <select wire:model.live="cronJob"
            class="rounded-xl border border-white/10 bg-white/5 px-4 py-3 pr-10 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
            <option value="">@lang('All Cron Jobs')</option>
            @foreach($cronJobs as $job)
                <option value="{{ $job->id }}">{{ $job->name }}</option>
            @endforeach
        </select>
        <label class="flex items-center gap-2 text-sm text-slate-400 cursor-pointer">
            <input type="checkbox" wire:model.live="showResolved"
                class="rounded border-white/20 bg-white/5 text-indigo-600 focus:ring-indigo-500/30" />
            @lang('Show Resolved')
        </label>
    </div>

    <!-- Errors List -->
    <x-admin.card :padding="false">
        <div class="divide-y divide-white/5">
            @forelse($logs as $log)
                <div class="flex items-start gap-4 p-4 hover:bg-white/[0.02] transition-colors">
                    <div class="shrink-0 w-10 h-10 rounded-full flex items-center justify-center {{ $log->is_resolved ? 'bg-emerald-500/10 text-emerald-400' : 'bg-red-500/10 text-red-400' }}">
                        <i class="ph-duotone {{ $log->is_resolved ? 'ph-check-circle' : 'ph-warning-circle' }} text-xl"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex items-start justify-between gap-4">
                            <div>
                                <p class="font-medium text-white">{{ $log->cronJob->name ?? __('Unknown Job') }}</p>
                                <p class="text-sm text-slate-400 mt-1 line-clamp-2">{{ $log->error }}</p>
                                <div class="flex items-center gap-4 mt-2 text-xs text-slate-500">
                                    <span>{{ $log->created_at->diffForHumans() }}</span>
                                    @if($log->is_resolved && $log->resolved_at)
                                        <span class="text-emerald-500">@lang('Resolved') {{ $log->resolved_at->diffForHumans() }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="flex items-center gap-2 shrink-0">
                                @if($log->is_resolved)
                                    <x-admin.badge type="success">@lang('Resolved')</x-admin.badge>
                                @else
                                    <x-admin.badge type="danger">@lang('Unresolved')</x-admin.badge>
                                @endif
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="viewDetails({{ $log->id }})" icon="ph-eye">@lang('View Details')</x-admin.action-menu-item>
                                    @if($log->is_resolved)
                                        <x-admin.action-menu-item wire:click="markUnresolved({{ $log->id }})" icon="ph-arrow-counter-clockwise">@lang('Mark Unresolved')</x-admin.action-menu-item>
                                    @else
                                        <x-admin.action-menu-item wire:click="markResolved({{ $log->id }})" icon="ph-check">@lang('Mark Resolved')</x-admin.action-menu-item>
                                    @endif
                                    <x-admin.action-menu-item wire:click="delete({{ $log->id }})" icon="ph-trash" danger wire:confirm="{{ __('Delete this error log?') }}">@lang('Delete')</x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="p-12 text-center">
                    <div class="w-16 h-16 mx-auto bg-emerald-500/10 rounded-full flex items-center justify-center mb-4">
                        <i class="ph-duotone ph-check-circle text-3xl text-emerald-400"></i>
                    </div>
                    <p class="text-slate-400">@lang('No automation errors found.')</p>
                </div>
            @endforelse
        </div>
    </x-admin.card>

    <!-- Pagination -->
    @if($logs->hasPages())
        <div class="mt-6">
            {{ $logs->links() }}
        </div>
    @endif

    <!-- Error Details Modal -->
    <x-admin.modal wire:model="viewingLogId" :title="__('Error Details')" size="lg">
        @if($viewingLog)
            <div class="space-y-4">
                <div>
                    <label class="text-sm font-medium text-slate-400">@lang('Cron Job')</label>
                    <p class="text-white">{{ $viewingLog->cronJob->name ?? __('Unknown') }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-slate-400">@lang('Error Message')</label>
                    <pre class="mt-1 p-4 bg-slate-900/50 border border-white/10 rounded-xl text-sm text-red-400 overflow-x-auto whitespace-pre-wrap">{{ $viewingLog->error }}</pre>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm font-medium text-slate-400">@lang('Occurred At')</label>
                        <p class="text-white">{{ $viewingLog->created_at->format('M d, Y H:i:s') }}</p>
                    </div>
                    <div>
                        <label class="text-sm font-medium text-slate-400">@lang('Duration')</label>
                        <p class="text-white">{{ $viewingLog->duration ?? 0 }} ms</p>
                    </div>
                    <div>
                        <label class="text-sm font-medium text-slate-400">@lang('Status')</label>
                        <p class="mt-1">
                            @if($viewingLog->is_resolved)
                                <x-admin.badge type="success">@lang('Resolved')</x-admin.badge>
                            @else
                                <x-admin.badge type="danger">@lang('Unresolved')</x-admin.badge>
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        @endif
        <x-slot:footer>
            <x-admin.button wire:click="closeDetails" variant="secondary">@lang('Close')</x-admin.button>
            @if($viewingLog && !$viewingLog->is_resolved)
                <x-admin.button wire:click="markResolved({{ $viewingLog->id }})" variant="success" icon="ph-check">@lang('Mark Resolved')</x-admin.button>
            @endif
        </x-slot:footer>
    </x-admin.modal>
</div>

