<div>
    <x-admin.page-header :title="__('System Optimization')" :subtitle="__('Manage application cache and optimize performance.')" />

    {{-- Current Status --}}
    <div class="mb-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            :label="__('Cache Driver')"
            :value="ucfirst($cacheInfo['cache_driver'])"
            icon="ph-hard-drives"
            iconColor="primary"
        />
        <x-admin.stat-card
            :label="__('Session Driver')"
            :value="ucfirst($cacheInfo['session_driver'])"
            icon="ph-cookie"
            iconColor="info"
        />
        <x-admin.stat-card
            :label="__('Compiled Views')"
            :value="number_format($cacheInfo['compiled_views'])"
            icon="ph-file-code"
            iconColor="warning"
        />
    </div>

    <!-- Cache Actions -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Clear Individual Caches -->
        <x-admin.card>
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 rounded-xl bg-amber-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-broom text-xl text-amber-400"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-white">@lang('Clear Cache')</h3>
                    <p class="text-sm text-slate-400">@lang('Clear individual cache types')</p>
                </div>
            </div>

            <div class="space-y-4">
                <!-- Config Cache -->
                <div class="flex items-center justify-between p-4 rounded-xl bg-white/[0.02] border border-white/5">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-lg bg-blue-500/10 flex items-center justify-center">
                            <i class="ph-duotone ph-gear-six text-lg text-blue-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-white">@lang('Configuration Cache')</p>
                            <p class="text-xs text-slate-500">@lang('Clear cached config files')</p>
                        </div>
                    </div>
                    <x-admin.button wire:click="clearConfigCache" variant="secondary" size="sm" :disabled="$isClearing">
                        <span wire:loading.remove wire:target="clearConfigCache">@lang('Clear')</span>
                        <span wire:loading wire:target="clearConfigCache">@lang('Clearing...')</span>
                    </x-admin.button>
                </div>

                <!-- Route Cache -->
                <div class="flex items-center justify-between p-4 rounded-xl bg-white/[0.02] border border-white/5">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-lg bg-emerald-500/10 flex items-center justify-center">
                            <i class="ph-duotone ph-signpost text-lg text-emerald-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-white">@lang('Route Cache')</p>
                            <p class="text-xs text-slate-500">@lang('Clear cached route files')</p>
                        </div>
                    </div>
                    <x-admin.button wire:click="clearRouteCache" variant="secondary" size="sm" :disabled="$isClearing">
                        <span wire:loading.remove wire:target="clearRouteCache">@lang('Clear')</span>
                        <span wire:loading wire:target="clearRouteCache">@lang('Clearing...')</span>
                    </x-admin.button>
                </div>

                <!-- View Cache -->
                <div class="flex items-center justify-between p-4 rounded-xl bg-white/[0.02] border border-white/5">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-lg bg-purple-500/10 flex items-center justify-center">
                            <i class="ph-duotone ph-layout text-lg text-purple-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-white">@lang('View Cache')</p>
                            <p class="text-xs text-slate-500">@lang('Clear compiled blade views')</p>
                        </div>
                    </div>
                    <x-admin.button wire:click="clearViewCache" variant="secondary" size="sm" :disabled="$isClearing">
                        <span wire:loading.remove wire:target="clearViewCache">@lang('Clear')</span>
                        <span wire:loading wire:target="clearViewCache">@lang('Clearing...')</span>
                    </x-admin.button>
                </div>

                <!-- Application Cache -->
                <div class="flex items-center justify-between p-4 rounded-xl bg-white/[0.02] border border-white/5">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-lg bg-orange-500/10 flex items-center justify-center">
                            <i class="ph-duotone ph-database text-lg text-orange-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-white">@lang('Application Cache')</p>
                            <p class="text-xs text-slate-500">@lang('Flush all application data cache')</p>
                        </div>
                    </div>
                    <x-admin.button wire:click="clearApplicationCache" variant="secondary" size="sm" :disabled="$isClearing">
                        <span wire:loading.remove wire:target="clearApplicationCache">@lang('Clear')</span>
                        <span wire:loading wire:target="clearApplicationCache">@lang('Clearing...')</span>
                    </x-admin.button>
                </div>
            </div>
        </x-admin.card>

        <!-- Quick Actions -->
        <x-admin.card>
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 rounded-xl bg-indigo-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-rocket text-xl text-indigo-400"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-white">@lang('Quick Actions')</h3>
                    <p class="text-sm text-slate-400">@lang('One-click optimization commands')</p>
                </div>
            </div>

            <div class="space-y-4">
                <!-- Clear All Cache -->
                <div class="p-6 rounded-xl bg-gradient-to-r from-red-500/10 to-orange-500/10 border border-red-500/20">
                    <div class="flex items-center gap-4">
                        <div class="w-14 h-14 rounded-xl bg-red-500/20 flex items-center justify-center">
                            <i class="ph-duotone ph-trash text-2xl text-red-400"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-white">@lang('Clear All Cache')</h4>
                            <p class="text-sm text-slate-400 mt-1">@lang('Remove all cached data including config, routes, views, and application cache.')</p>
                        </div>
                    </div>
                    <div class="mt-4">
                        <x-admin.button wire:click="clearAllCache" variant="danger" class="w-full" :disabled="$isClearing">
                            <i class="ph-duotone ph-trash mr-2"></i>
                            <span wire:loading.remove wire:target="clearAllCache">@lang('Clear All Cache')</span>
                            <span wire:loading wire:target="clearAllCache">@lang('Clearing All...')</span>
                        </x-admin.button>
                    </div>
                </div>

                <!-- Optimize Application -->
                <div class="p-6 rounded-xl bg-gradient-to-r from-emerald-500/10 to-cyan-500/10 border border-emerald-500/20">
                    <div class="flex items-center gap-4">
                        <div class="w-14 h-14 rounded-xl bg-emerald-500/20 flex items-center justify-center">
                            <i class="ph-duotone ph-rocket-launch text-2xl text-emerald-400"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-white">@lang('Optimize Application')</h4>
                            <p class="text-sm text-slate-400 mt-1">@lang('For best performance, run optimization from command line:')</p>
                            <code class="mt-2 block text-xs text-emerald-400 bg-black/30 px-3 py-2 rounded-lg font-mono">php artisan optimize</code>
                        </div>
                    </div>
                </div>

                <!-- Cache Status -->
                <div class="p-4 rounded-xl bg-white/[0.02] border border-white/5">
                    <h4 class="text-sm font-medium text-slate-400 mb-3">@lang('Cache Status')</h4>
                    <div class="space-y-2">
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-slate-300">@lang('Config Cache')</span>
                            @if($cacheInfo['has_config_cache'])
                                <span class="text-emerald-400 flex items-center gap-1">
                                    <i class="ph-duotone ph-check-circle"></i> @lang('Cached')
                                </span>
                            @else
                                <span class="text-slate-500 flex items-center gap-1">
                                    <i class="ph-duotone ph-x-circle"></i> @lang('Not cached')
                                </span>
                            @endif
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-slate-300">@lang('Route Cache')</span>
                            @if($cacheInfo['has_route_cache'])
                                <span class="text-emerald-400 flex items-center gap-1">
                                    <i class="ph-duotone ph-check-circle"></i> @lang('Cached')
                                </span>
                            @else
                                <span class="text-slate-500 flex items-center gap-1">
                                    <i class="ph-duotone ph-x-circle"></i> @lang('Not cached')
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </x-admin.card>
    </div>

    <!-- Info Box -->
    <div class="mt-6">
        <x-admin.alert type="info">
            <strong>@lang('Note'):</strong> @lang('Clearing cache may temporarily slow down the application as it rebuilds the cache.')
            @lang('Use "Optimize Application" in production for best performance.')
        </x-admin.alert>
    </div>
</div>

