<div class="space-y-6">
    <!-- Page Header -->
    <x-admin.page-header
        :title="__('Report & Request')"
        :subtitle="__('Submit bug reports, feature requests, or improvement suggestions')"
    />

    <div class="grid gap-6 lg:grid-cols-3">
        <!-- Main Form -->
        <div class="lg:col-span-2">
            <x-admin.card>
                <form wire:submit="submit" class="space-y-6">
                    <!-- Type Selection -->
                    <div>
                        <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Report Type')</label>
                        <div class="grid gap-3 sm:grid-cols-3">
                            @foreach($this->typeOptions as $value => $label)
                                <label class="flex cursor-pointer items-center gap-3 rounded-xl border border-white/10 bg-white/5 px-4 py-3 transition-all hover:border-indigo-500/50" :class="{ 'border-indigo-500 bg-indigo-500/10': $wire.type === '{{ $value }}' }">
                                    <input type="radio" wire:model.live="type" value="{{ $value }}" class="hidden">
                                    <i class="ph-duotone {{ $value === 'bug' ? 'ph-bug' : ($value === 'feature' ? 'ph-lightbulb' : ($value === 'improvement' ? 'ph-trend-up' : ($value === 'security' ? 'ph-shield-warning' : 'ph-question'))) }} text-xl" :class="$wire.type === '{{ $value }}' ? 'text-indigo-400' : 'text-slate-400'"></i>
                                    <span class="text-sm font-medium" :class="$wire.type === '{{ $value }}' ? 'text-white' : 'text-slate-300'">{{ __($label) }}</span>
                                </label>
                            @endforeach
                        </div>
                    </div>

                    <!-- Subject -->
                    <div>
                        <label for="subject" class="mb-2 block text-sm font-medium text-slate-300">@lang('Subject')</label>
                        <input type="text" id="subject" wire:model="subject" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Brief description of the issue or request') }}">
                        @error('subject') <span class="mt-1 text-sm text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <!-- Priority -->
                    <div>
                        <label for="priority" class="mb-2 block text-sm font-medium text-slate-300">@lang('Priority')</label>
                        <select id="priority" wire:model="priority" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white transition-all focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach($this->priorityOptions as $value => $label)
                                <option value="{{ $value }}" class="bg-[#1a1a24]">{{ __($label) }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Description -->
                    <div>
                        <label for="description" class="mb-2 block text-sm font-medium text-slate-300">@lang('Description')</label>
                        <textarea id="description" wire:model="description" rows="8" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Please provide detailed information about the issue or request...') }}"></textarea>
                        @error('description') <span class="mt-1 text-sm text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email" class="mb-2 block text-sm font-medium text-slate-300">@lang('Contact Email')</label>
                        <input type="email" id="email" wire:model="email" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="your@email.com">
                        @error('email') <span class="mt-1 text-sm text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <!-- Submit -->
                    <div class="flex justify-end border-t border-white/5 pt-6">
                        <button type="submit" wire:loading.attr="disabled" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-indigo-500 to-purple-500 px-6 py-3 text-sm font-semibold text-white shadow-lg shadow-indigo-500/25 transition-all hover:shadow-xl hover:shadow-indigo-500/30 disabled:opacity-50">
                            <span wire:loading.remove wire:target="submit">
                                <i class="ph-bold ph-paper-plane-tilt text-base"></i>
                                @lang('Submit Report')
                            </span>
                            <span wire:loading wire:target="submit" class="flex items-center gap-2">
                                <svg class="h-4 w-4 animate-spin" viewBox="0 0 24 24" fill="none">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                @lang('Submitting...')
                            </span>
                        </button>
                    </div>
                </form>
            </x-admin.card>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <x-admin.card :title="__('Guidelines')">
                <div class="space-y-4 text-sm text-slate-400">
                    <div class="flex items-start gap-3">
                        <i class="ph-duotone ph-bug text-lg text-rose-400"></i>
                        <div>
                            <p class="font-medium text-white">@lang('Bug Reports')</p>
                            <p class="mt-1">@lang('Include steps to reproduce, expected vs actual behavior, and any error messages.')</p>
                        </div>
                    </div>
                    <div class="flex items-start gap-3">
                        <i class="ph-duotone ph-lightbulb text-lg text-amber-400"></i>
                        <div>
                            <p class="font-medium text-white">@lang('Feature Requests')</p>
                            <p class="mt-1">@lang('Describe the feature, its benefits, and potential use cases.')</p>
                        </div>
                    </div>
                    <div class="flex items-start gap-3">
                        <i class="ph-duotone ph-shield-warning text-lg text-purple-400"></i>
                        <div>
                            <p class="font-medium text-white">@lang('Security Issues')</p>
                            <p class="mt-1">@lang('For security vulnerabilities, please provide detailed information privately.')</p>
                        </div>
                    </div>
                </div>
            </x-admin.card>

            <x-admin.card :title="__('System Information')">
                <div class="space-y-2 text-sm">
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <span class="text-slate-400">@lang('PHP Version')</span>
                        <span class="font-mono text-white">{{ PHP_VERSION }}</span>
                    </div>
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <span class="text-slate-400">@lang('Laravel Version')</span>
                        <span class="font-mono text-white">{{ app()->version() }}</span>
                    </div>
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <span class="text-slate-400">@lang('Environment')</span>
                        <span class="font-mono text-white">{{ config('app.env') }}</span>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>

    <!-- Success Modal -->
    @if($showSuccessModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm">
            <div class="w-full max-w-md rounded-2xl border border-white/10 bg-[#1a1a24] p-6 shadow-2xl">
                <div class="text-center">
                    <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-emerald-500/10">
                        <i class="ph-duotone ph-check-circle text-4xl text-emerald-400"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-white">@lang('Report Submitted!')</h3>
                    <p class="mt-2 text-sm text-slate-400">@lang('Thank you for your feedback. Your report has been logged and will be reviewed.')</p>
                    <button wire:click="closeSuccessModal" class="mt-6 inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-indigo-500 to-purple-500 px-6 py-3 text-sm font-semibold text-white">
                        <i class="ph-bold ph-check text-base"></i>
                        @lang('Got it')
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>

