<div>
    <x-admin.page-header :title="__('Server Information')" :subtitle="__('View PHP configuration, extensions, and server details.')" />

    <!-- Tabs -->
    <div class="flex items-center gap-2 mb-6 border-b border-white/10 pb-4">
        <button wire:click="$set('activeTab', 'php')"
            class="px-4 py-2 rounded-lg text-sm font-medium transition-all {{ $activeTab === 'php' ? 'bg-indigo-500 text-white' : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
            <i class="ph-duotone ph-code mr-2"></i>@lang('PHP Configuration')
        </button>
        <button wire:click="$set('activeTab', 'server')"
            class="px-4 py-2 rounded-lg text-sm font-medium transition-all {{ $activeTab === 'server' ? 'bg-indigo-500 text-white' : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
            <i class="ph-duotone ph-desktop-tower mr-2"></i>@lang('Server Info')
        </button>
        <button wire:click="$set('activeTab', 'extensions')"
            class="px-4 py-2 rounded-lg text-sm font-medium transition-all {{ $activeTab === 'extensions' ? 'bg-indigo-500 text-white' : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
            <i class="ph-duotone ph-puzzle-piece mr-2"></i>@lang('Extensions')
        </button>
        <button wire:click="$set('activeTab', 'requirements')"
            class="px-4 py-2 rounded-lg text-sm font-medium transition-all {{ $activeTab === 'requirements' ? 'bg-indigo-500 text-white' : 'text-slate-400 hover:text-white hover:bg-white/5' }}">
            <i class="ph-duotone ph-check-square mr-2"></i>@lang('Requirements')
        </button>
    </div>

    <!-- PHP Configuration Tab -->
    @if($activeTab === 'php')
        <x-admin.card>
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 rounded-xl bg-indigo-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-code text-xl text-indigo-400"></i>
                </div>
                <h3 class="text-lg font-semibold text-white">@lang('PHP Configuration')</h3>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8">
                @foreach($phpInfo as $key => $value)
                    <div class="flex items-center justify-between py-3 border-b border-white/5">
                        <span class="text-sm text-slate-400">{{ $key }}</span>
                        <span class="text-sm font-medium {{ in_array($value, ['Yes', 'On']) ? 'text-emerald-400' : (in_array($value, ['No', 'Off']) ? 'text-red-400' : 'text-white') }}">
                            {{ $value }}
                        </span>
                    </div>
                @endforeach
            </div>
        </x-admin.card>
    @endif

    <!-- Server Info Tab -->
    @if($activeTab === 'server')
        <x-admin.card>
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 rounded-xl bg-cyan-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-desktop-tower text-xl text-cyan-400"></i>
                </div>
                <h3 class="text-lg font-semibold text-white">@lang('Server Details')</h3>
            </div>
            <div class="space-y-0">
                @foreach($serverInfo as $key => $value)
                    <div class="flex items-center justify-between py-3 border-b border-white/5 last:border-0">
                        <span class="text-sm text-slate-400">{{ $key }}</span>
                        <span class="text-sm font-medium text-white font-mono">{{ $value }}</span>
                    </div>
                @endforeach
            </div>
        </x-admin.card>
    @endif

    <!-- Extensions Tab -->
    @if($activeTab === 'extensions')
        <x-admin.card>
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-xl bg-purple-500/10 flex items-center justify-center">
                        <i class="ph-duotone ph-puzzle-piece text-xl text-purple-400"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-white">@lang('Loaded Extensions')</h3>
                        <p class="text-sm text-slate-400">{{ count($extensions) }} @lang('extensions loaded')</p>
                    </div>
                </div>
            </div>
            <div class="flex flex-wrap gap-2">
                @foreach($extensions as $ext)
                    <span class="px-3 py-1.5 rounded-lg bg-white/5 border border-white/10 text-sm text-slate-300 font-mono">
                        {{ $ext }}
                    </span>
                @endforeach
            </div>
        </x-admin.card>
    @endif

    <!-- Requirements Tab -->
    @if($activeTab === 'requirements')
        <x-admin.card>
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 rounded-xl bg-emerald-500/10 flex items-center justify-center">
                    <i class="ph-duotone ph-check-square text-xl text-emerald-400"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-white">@lang('System Requirements')</h3>
                    <p class="text-sm text-slate-400">@lang('Required PHP extensions status')</p>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @foreach($requiredExtensions as $ext => $info)
                    <div class="flex items-center gap-4 p-4 rounded-xl {{ $info['loaded'] ? 'bg-emerald-500/5 border border-emerald-500/20' : 'bg-red-500/5 border border-red-500/20' }}">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center {{ $info['loaded'] ? 'bg-emerald-500/20' : 'bg-red-500/20' }}">
                            <i class="ph-duotone {{ $info['loaded'] ? 'ph-check text-emerald-400' : 'ph-x text-red-400' }} text-lg"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="font-medium {{ $info['loaded'] ? 'text-emerald-400' : 'text-red-400' }} font-mono">{{ $ext }}</p>
                            <p class="text-xs text-slate-500 mt-0.5">{{ $info['description'] }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </x-admin.card>
    @endif
</div>

