<div>
    <x-admin.page-header :title="__('System Information')" :subtitle="__('View Salieno version, system configuration and environment details.')" />

    {{-- Salieno Version Card - Hero Section --}}
    <div class="mb-8">
        <div class="relative overflow-hidden rounded-3xl border border-white/10 bg-gradient-to-br from-[#12121a] via-[#1a1a2e] to-[#12121a] p-8 shadow-2xl">
            {{-- Background decorations --}}
            <div class="absolute -right-20 -top-20 h-64 w-64 rounded-full bg-gradient-to-br from-indigo-500/20 to-purple-500/10 blur-3xl"></div>
            <div class="absolute -bottom-20 -left-20 h-64 w-64 rounded-full bg-gradient-to-tr from-emerald-500/10 to-sky-500/10 blur-3xl"></div>

            <div class="relative grid gap-8 lg:grid-cols-2">
                {{-- Salieno Core --}}
                <div class="flex items-start gap-6">
                    <div class="flex h-20 w-20 shrink-0 items-center justify-center rounded-2xl bg-gradient-to-br from-indigo-500 to-purple-600 shadow-lg shadow-indigo-500/30">
                        <i class="ph-duotone ph-cube text-4xl text-white"></i>
                    </div>
                    <div>
                        <div class="flex items-center gap-3">
                            <h2 class="text-2xl font-bold text-white">Salieno</h2>
                            @if($salienoInfo['channel'] === 'stable')
                                <span class="rounded-lg bg-emerald-500/15 px-2.5 py-1 text-xs font-semibold text-emerald-400">@lang('Stable')</span>
                            @else
                                <span class="rounded-lg bg-amber-500/15 px-2.5 py-1 text-xs font-semibold text-amber-400">{{ ucfirst($salienoInfo['channel']) }}</span>
                            @endif
                        </div>
                        <div class="mt-3 flex flex-wrap items-center gap-4 text-sm">
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-hash text-indigo-400"></i>
                                <span class="text-slate-400">@lang('Version'):</span>
                                <span class="font-semibold text-white">v{{ $salienoInfo['version'] }}</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-package text-purple-400"></i>
                                <span class="text-slate-400">@lang('Build'):</span>
                                <span class="font-medium text-white">{{ $salienoInfo['build'] }}</span>
                            </div>
                        </div>
                        <div class="mt-2 flex flex-wrap items-center gap-4 text-sm">
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-code text-sky-400"></i>
                                <span class="text-slate-400">@lang('Codename'):</span>
                                <span class="font-medium text-sky-300">{{ $salienoInfo['codename'] }}</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-calendar text-slate-400"></i>
                                <span class="text-slate-400">@lang('Released'):</span>
                                <span class="text-slate-300">{{ \Carbon\Carbon::parse($salienoInfo['release_date'])->format('M d, Y') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Activated Theme --}}
                <div class="flex items-start gap-6">
                    <div class="flex h-20 w-20 shrink-0 items-center justify-center rounded-2xl bg-gradient-to-br from-rose-500 to-orange-600 shadow-lg shadow-rose-500/30">
                        <i class="ph-duotone ph-paint-brush text-4xl text-white"></i>
                    </div>
                    <div>
                        <div class="flex items-center gap-3">
                            <h2 class="text-2xl font-bold text-white">{{ $themeInfo['name'] }}</h2>
                            <span class="rounded-lg bg-rose-500/15 px-2.5 py-1 text-xs font-semibold text-rose-400">@lang('Activated Theme')</span>
                        </div>
                        <div class="mt-3 flex flex-wrap items-center gap-4 text-sm">
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-hash text-rose-400"></i>
                                <span class="text-slate-400">@lang('Version'):</span>
                                <span class="font-semibold text-white">v{{ $themeInfo['version'] }}</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-user text-orange-400"></i>
                                <span class="text-slate-400">@lang('Author'):</span>
                                <span class="font-medium text-white">{{ $themeInfo['author'] }}</span>
                            </div>
                        </div>
                        <div class="mt-2 flex flex-wrap items-center gap-4 text-sm">
                            <div class="flex items-center gap-2">
                                <i class="ph-bold ph-folder text-amber-400"></i>
                                <span class="text-slate-400">@lang('Slug'):</span>
                                <span class="font-medium text-amber-300">{{ $themeInfo['slug'] }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Requirements Status --}}
            <div class="relative mt-8 grid grid-cols-2 gap-4 border-t border-white/10 pt-6 sm:grid-cols-4">
                <div class="text-center">
                    <p class="text-xs text-slate-500">@lang('Min. PHP Version')</p>
                    <p class="mt-1 text-lg font-bold {{ version_compare(PHP_VERSION, $salienoInfo['min_php_version'], '>=') ? 'text-emerald-400' : 'text-rose-400' }}">
                        {{ $salienoInfo['min_php_version'] }}+
                    </p>
                    <p class="text-xs {{ version_compare(PHP_VERSION, $salienoInfo['min_php_version'], '>=') ? 'text-emerald-500' : 'text-rose-500' }}">
                        <i class="ph-bold {{ version_compare(PHP_VERSION, $salienoInfo['min_php_version'], '>=') ? 'ph-check-circle' : 'ph-x-circle' }}"></i>
                        {{ PHP_VERSION }}
                    </p>
                </div>
                <div class="text-center">
                    <p class="text-xs text-slate-500">@lang('Min. Laravel Version')</p>
                    <p class="mt-1 text-lg font-bold {{ version_compare(app()->version(), $salienoInfo['min_laravel_version'], '>=') ? 'text-emerald-400' : 'text-rose-400' }}">
                        {{ $salienoInfo['min_laravel_version'] }}+
                    </p>
                    <p class="text-xs {{ version_compare(app()->version(), $salienoInfo['min_laravel_version'], '>=') ? 'text-emerald-500' : 'text-rose-500' }}">
                        <i class="ph-bold {{ version_compare(app()->version(), $salienoInfo['min_laravel_version'], '>=') ? 'ph-check-circle' : 'ph-x-circle' }}"></i>
                        {{ app()->version() }}
                    </p>
                </div>
                <div class="text-center">
                    <p class="text-xs text-slate-500">@lang('Environment')</p>
                    <p class="mt-1 text-lg font-bold {{ app()->environment('production') ? 'text-emerald-400' : 'text-amber-400' }}">
                        {{ ucfirst(app()->environment()) }}
                    </p>
                    <p class="text-xs text-slate-500">
                        @if(config('app.debug'))
                            <i class="ph-bold ph-bug text-amber-400"></i> @lang('Debug On')
                        @else
                            <i class="ph-bold ph-shield-check text-emerald-400"></i> @lang('Debug Off')
                        @endif
                    </p>
                </div>
                <div class="text-center">
                    <p class="text-xs text-slate-500">@lang('License')</p>
                    <p class="mt-1 text-lg font-bold text-indigo-400">{{ ucfirst($salienoInfo['license']) }}</p>
                    <p class="text-xs text-slate-500">
                        <i class="ph-bold ph-check-circle text-emerald-400"></i> @lang('Activated')
                    </p>
                </div>
            </div>
        </div>
    </div>

    {{-- System Configuration Grid --}}
    <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
        @foreach($systemInfo as $section => $items)
            <x-admin.card>
                <div class="mb-6 flex items-center gap-3">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-500/10">
                        <i class="ph-duotone
                            @if($section === 'Framework') ph-code
                            @elseif($section === 'Environment') ph-gear-six
                            @elseif($section === 'Database') ph-database
                            @elseif($section === 'Cache & Session') ph-hard-drives
                            @elseif($section === 'Queue & Mail') ph-queue
                            @else ph-gear
                            @endif text-xl text-indigo-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white">{{ __($section) }}</h3>
                </div>

                <div class="space-y-3">
                    @foreach($items as $key => $value)
                        <div class="flex items-center justify-between border-b border-white/5 py-2 last:border-0">
                            <span class="text-sm text-slate-400">{{ __($key) }}</span>
                            <span class="text-sm font-medium
                                @if($value === 'Enabled' || $value === 'production') text-emerald-400
                                @elseif($value === 'Disabled' || $value === 'local') text-amber-400
                                @else text-white
                                @endif">
                                {{ $value ?: __('Not Set') }}
                            </span>
                        </div>
                    @endforeach
                </div>
            </x-admin.card>
        @endforeach
    </div>

    {{-- Server & PHP Info --}}
    <div class="mt-6 grid grid-cols-1 gap-6 lg:grid-cols-2">
        {{-- Server Information --}}
        <x-admin.card>
            <div class="mb-6 flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-sky-500/10">
                    <i class="ph-duotone ph-desktop-tower text-xl text-sky-400"></i>
                </div>
                <h3 class="text-lg font-semibold text-white">@lang('Server Information')</h3>
            </div>

            <div class="space-y-3">
                @foreach($serverInfo as $key => $value)
                    <div class="flex items-center justify-between border-b border-white/5 py-2 last:border-0">
                        <span class="text-sm text-slate-400">{{ __($key) }}</span>
                        <span class="text-sm font-medium text-white">{{ $value ?: __('Unknown') }}</span>
                    </div>
                @endforeach
            </div>
        </x-admin.card>

        {{-- PHP Extensions --}}
        <x-admin.card>
            <div class="mb-6 flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-purple-500/10">
                    <i class="ph-duotone ph-puzzle-piece text-xl text-purple-400"></i>
                </div>
                <h3 class="text-lg font-semibold text-white">@lang('PHP Extensions')</h3>
            </div>

            <div class="grid grid-cols-2 gap-3 sm:grid-cols-3">
                @foreach($phpExtensions as $ext => $loaded)
                    <div class="flex items-center gap-2 rounded-lg border border-white/5 bg-slate-800/30 px-3 py-2">
                        <i class="ph-bold {{ $loaded ? 'ph-check-circle text-emerald-400' : 'ph-x-circle text-rose-400' }}"></i>
                        <span class="text-sm {{ $loaded ? 'text-slate-300' : 'text-rose-300' }}">{{ $ext }}</span>
                    </div>
                @endforeach
            </div>
        </x-admin.card>
    </div>

    {{-- System Status --}}
    <div class="mt-6">
        <x-admin.card>
            <div class="mb-6 flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10">
                    <i class="ph-duotone ph-heartbeat text-xl text-emerald-400"></i>
                </div>
                <h3 class="text-lg font-semibold text-white">@lang('System Resources')</h3>
            </div>

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
                {{-- Disk Usage --}}
                <div class="rounded-xl border border-white/5 bg-slate-800/50 p-4">
                    <div class="mb-2 flex items-center justify-between">
                        <span class="text-sm text-slate-400">@lang('Disk Space')</span>
                        <i class="ph-duotone ph-hard-drive text-lg text-slate-400"></i>
                    </div>
                    @php
                        $totalSpace = @disk_total_space(base_path()) ?: 1;
                        $freeSpace = @disk_free_space(base_path()) ?: 0;
                        $usedPercent = round((($totalSpace - $freeSpace) / $totalSpace) * 100);
                    @endphp
                    <p class="text-lg font-semibold text-white">{{ $usedPercent }}% @lang('used')</p>
                    <div class="mt-2 h-1.5 w-full overflow-hidden rounded-full bg-slate-700">
                        <div class="h-full rounded-full {{ $usedPercent > 90 ? 'bg-rose-500' : ($usedPercent > 70 ? 'bg-amber-500' : 'bg-emerald-500') }}" style="width: {{ $usedPercent }}%"></div>
                    </div>
                    <p class="mt-1 text-xs text-slate-500">{{ number_format($freeSpace / 1073741824, 2) }} GB @lang('free')</p>
                </div>

                {{-- Memory --}}
                <div class="rounded-xl border border-white/5 bg-slate-800/50 p-4">
                    <div class="mb-2 flex items-center justify-between">
                        <span class="text-sm text-slate-400">@lang('Memory Limit')</span>
                        <i class="ph-duotone ph-memory text-lg text-slate-400"></i>
                    </div>
                    <p class="text-lg font-semibold text-white">{{ ini_get('memory_limit') }}</p>
                    <p class="mt-1 text-xs text-slate-500">@lang('Current'): {{ round(memory_get_usage() / 1048576, 2) }} MB</p>
                </div>

                {{-- Upload Size --}}
                <div class="rounded-xl border border-white/5 bg-slate-800/50 p-4">
                    <div class="mb-2 flex items-center justify-between">
                        <span class="text-sm text-slate-400">@lang('Max Upload')</span>
                        <i class="ph-duotone ph-cloud-arrow-up text-lg text-slate-400"></i>
                    </div>
                    <p class="text-lg font-semibold text-white">{{ ini_get('upload_max_filesize') }}</p>
                    <p class="mt-1 text-xs text-slate-500">@lang('Post max'): {{ ini_get('post_max_size') }}</p>
                </div>

                {{-- Execution Time --}}
                <div class="rounded-xl border border-white/5 bg-slate-800/50 p-4">
                    <div class="mb-2 flex items-center justify-between">
                        <span class="text-sm text-slate-400">@lang('Max Execution')</span>
                        <i class="ph-duotone ph-timer text-lg text-slate-400"></i>
                    </div>
                    <p class="text-lg font-semibold text-white">{{ ini_get('max_execution_time') }}s</p>
                    <p class="mt-1 text-xs text-slate-500">@lang('Input time'): {{ ini_get('max_input_time') }}s</p>
                </div>
            </div>
        </x-admin.card>
    </div>
</div>

