<div>
    <x-admin.page-header :title="__('System Update')" :subtitle="__('Check for and apply system updates.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.system.update.log') }}" variant="secondary" icon="ph-duotone ph-clock-counter-clockwise">
                @lang('Update History')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- License Status Card -->
    @if(!$licenseValid)
        <div class="mb-6">
            <x-admin.alert type="error">
                <div class="flex items-center gap-3">
                    <i class="ph-duotone ph-shield-warning text-2xl"></i>
                    <div>
                        <strong class="block">@lang('License Required')</strong>
                        <span>{{ $licenseError ?? __('A valid license is required to check for and install updates.') }}</span>
                        <a href="{{ route('admin.system.register') }}" class="ml-2 underline hover:no-underline">
                            @lang('Activate License')
                        </a>
                    </div>
                </div>
            </x-admin.alert>
        </div>
    @elseif($licenseInfo)
        <div class="mb-6">
            <div class="p-4 rounded-xl bg-emerald-500/5 border border-emerald-500/20">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-emerald-500/20 flex items-center justify-center">
                        <i class="ph-duotone ph-check-circle text-xl text-emerald-400"></i>
                    </div>
                    <div>
                        <span class="text-sm text-slate-400">@lang('License Status'):</span>
                        <span class="ml-2 font-medium text-emerald-400">@lang('Active')</span>
                        <span class="mx-2 text-slate-600">|</span>
                        <span class="text-sm text-slate-400">@lang('Tier'):</span>
                        <span class="ml-1 font-medium text-white">{{ ucfirst($licenseInfo['tier'] ?? 'unknown') }}</span>
                        @if($licenseInfo['expires_at'])
                            <span class="mx-2 text-slate-600">|</span>
                            <span class="text-sm text-slate-400">@lang('Expires'):</span>
                            <span class="ml-1 text-white">{{ \Carbon\Carbon::parse($licenseInfo['expires_at'])->format('M d, Y') }}</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Version Info -->
        <div class="lg:col-span-2">
            <x-admin.card>
                <div class="flex items-center gap-4 mb-6">
                    <div class="w-14 h-14 rounded-xl {{ $updateInfo['is_up_to_date'] ? 'bg-emerald-500/10' : 'bg-amber-500/10' }} flex items-center justify-center">
                        <i class="ph-duotone {{ $updateInfo['is_up_to_date'] ? 'ph-check-circle text-emerald-400' : 'ph-arrow-circle-up text-amber-400' }} text-3xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-white">
                            @if($updateInfo['is_up_to_date'])
                                @lang('System is Up to Date')
                            @else
                                @lang('Update Available')
                            @endif
                        </h3>
                        <p class="text-sm text-slate-400">
                            @if($updateInfo['last_checked'])
                                @lang('Last checked'): {{ \Carbon\Carbon::parse($updateInfo['last_checked'])->diffForHumans() }}
                            @else
                                @lang('Never checked')
                            @endif
                        </p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4 mb-6">
                    <div class="p-4 rounded-xl bg-white/[0.02] border border-white/5">
                        <p class="text-sm text-slate-400 mb-1">@lang('Current Version')</p>
                        <p class="text-2xl font-bold text-white">v{{ $updateInfo['current_version'] }}</p>
                    </div>
                    <div class="p-4 rounded-xl {{ $updateInfo['is_up_to_date'] ? 'bg-emerald-500/5 border-emerald-500/20' : 'bg-amber-500/5 border-amber-500/20' }} border">
                        <p class="text-sm text-slate-400 mb-1">@lang('Available Version')</p>
                        <p class="text-2xl font-bold {{ $updateInfo['is_up_to_date'] ? 'text-emerald-400' : 'text-amber-400' }}">v{{ $updateInfo['available_version'] }}</p>
                    </div>
                </div>

                @if($updateInfo['system_customized'])
                    <x-admin.alert type="warning" class="mb-6">
                        <strong>@lang('System Customized'):</strong> @lang('Your system has been customized. Automatic updates are disabled. Please contact support for manual updates.')
                    </x-admin.alert>
                @endif

                <!-- Changelog -->
                @if(count($changelog) > 0)
                    <div class="p-4 rounded-xl bg-indigo-500/5 border border-indigo-500/20 mb-6">
                        <div class="flex items-center gap-2 mb-3">
                            <i class="ph-duotone ph-scroll text-indigo-400"></i>
                            <span class="font-medium text-white">@lang('Changelog')</span>
                        </div>
                        <div class="space-y-2 text-sm">
                            @foreach($changelog as $section => $items)
                                @if(is_array($items))
                                    <div>
                                        <span class="font-medium text-slate-300">{{ $section }}:</span>
                                        <ul class="list-disc list-inside ml-2 text-slate-400">
                                            @foreach($items as $item)
                                                <li>{{ $item }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @else
                                    <p class="text-slate-400">• {{ $items }}</p>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Update Messages -->
                @if(count($updateMessages) > 0)
                    <div class="p-4 rounded-xl bg-slate-900/50 border border-white/5 mb-6">
                        <div class="flex items-center gap-2 mb-3">
                            <i class="ph-duotone ph-terminal text-slate-400"></i>
                            <span class="text-sm font-medium text-slate-400">@lang('Update Log')</span>
                        </div>
                        <div class="space-y-1 font-mono text-sm max-h-64 overflow-y-auto">
                            @foreach($updateMessages as $message)
                                <p class="{{ str_starts_with($message, '✓') ? 'text-emerald-400' : (str_starts_with($message, '✗') ? 'text-red-400' : (str_starts_with($message, '⚠') ? 'text-amber-400' : 'text-slate-300')) }}">
                                    <span class="text-indigo-400">></span> {{ $message }}
                                </p>
                            @endforeach
                            @if($updating || $restoringBackup)
                                <p class="text-slate-400 animate-pulse">
                                    <span class="text-indigo-400">></span> @lang('Processing...')
                                </p>
                            @endif
                        </div>
                    </div>
                @endif

                <div class="flex items-center gap-3 flex-wrap">
                    <x-admin.button
                        wire:click="checkForUpdates"
                        variant="secondary"
                        :disabled="$checking || $updating || !$licenseValid"
                        title="{{ !$licenseValid ? __('Valid license required') : '' }}"
                    >
                        <i class="ph-duotone ph-magnifying-glass mr-2"></i>
                        <span wire:loading.remove wire:target="checkForUpdates">@lang('Check for Updates')</span>
                        <span wire:loading wire:target="checkForUpdates">@lang('Checking...')</span>
                    </x-admin.button>

                    @if(!$updateInfo['is_up_to_date'] && !$updateInfo['system_customized'] && $licenseValid)
                        <x-admin.button
                            wire:click="performUpdate"
                            variant="primary"
                            :disabled="$checking || $updating"
                            wire:confirm="{{ __('Are you sure you want to update the system? A backup will be created automatically.') }}"
                        >
                            <i class="ph-duotone ph-cloud-arrow-down mr-2"></i>
                            <span wire:loading.remove wire:target="performUpdate">@lang('Update Now')</span>
                            <span wire:loading wire:target="performUpdate">@lang('Updating...')</span>
                        </x-admin.button>
                    @endif

                    <x-admin.button
                        wire:click="toggleBackups"
                        variant="secondary"
                    >
                        <i class="ph-duotone ph-archive mr-2"></i>
                        @lang('Manage Backups')
                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-white/10">{{ count($backups) }}</span>
                    </x-admin.button>
                </div>
            </x-admin.card>

            <!-- Backup Management Section -->
            @if($showBackups)
                <x-admin.card class="mt-6">
                    <div class="flex items-center justify-between mb-6">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-purple-500/10 flex items-center justify-center">
                                <i class="ph-duotone ph-archive text-xl text-purple-400"></i>
                            </div>
                            <h3 class="text-lg font-semibold text-white">@lang('System Backups')</h3>
                        </div>
                        <x-admin.button
                            wire:click="createBackup"
                            variant="secondary"
                            size="sm"
                            :disabled="$creatingBackup"
                        >
                            <i class="ph-duotone ph-plus mr-2"></i>
                            <span wire:loading.remove wire:target="createBackup">@lang('Create Backup')</span>
                            <span wire:loading wire:target="createBackup">@lang('Creating...')</span>
                        </x-admin.button>
                    </div>

                    @if(count($backups) > 0)
                        <div class="space-y-3">
                            @foreach($backups as $backup)
                                <div class="p-4 rounded-xl bg-white/[0.02] border border-white/5 hover:border-white/10 transition-colors">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center gap-4">
                                            <div class="w-10 h-10 rounded-lg bg-slate-700/50 flex items-center justify-center">
                                                <i class="ph-duotone ph-file-zip text-slate-400"></i>
                                            </div>
                                            <div>
                                                <div class="flex items-center gap-2">
                                                    <span class="font-medium text-white">v{{ $backup['version'] }}</span>
                                                    <span class="text-xs px-2 py-0.5 rounded-full bg-slate-700 text-slate-300">
                                                        {{ $this->formatBytes($backup['size'] ?? 0) }}
                                                    </span>
                                                </div>
                                                <p class="text-sm text-slate-400">
                                                    {{ $backup['created_at'] instanceof \Carbon\Carbon ? $backup['created_at']->format('M d, Y H:i:s') : $backup['created_at'] }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            <x-admin.button
                                                wire:click="restoreFromBackup('{{ $backup['path'] }}')"
                                                variant="secondary"
                                                size="sm"
                                                :disabled="$restoringBackup || $updating"
                                                wire:confirm="{{ __('Are you sure you want to restore from this backup? This will overwrite current files.') }}"
                                            >
                                                <i class="ph-duotone ph-arrow-counter-clockwise mr-1"></i>
                                                @lang('Restore')
                                            </x-admin.button>
                                            <x-admin.button
                                                wire:click="deleteBackup('{{ $backup['path'] }}')"
                                                variant="danger"
                                                size="sm"
                                                wire:confirm="{{ __('Are you sure you want to delete this backup? This cannot be undone.') }}"
                                            >
                                                <i class="ph-duotone ph-trash"></i>
                                            </x-admin.button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="mt-4 text-sm text-slate-500">
                            <i class="ph-duotone ph-info mr-1"></i>
                            @lang('Backups are stored in'): <code class="text-slate-400">{{ config('auto-update.paths.backups', storage_path('app/backups')) }}</code>
                        </div>
                    @else
                        <div class="text-center py-8">
                            <i class="ph-duotone ph-archive text-4xl text-slate-600 mb-3"></i>
                            <p class="text-sm text-slate-400">@lang('No backups available.')</p>
                            <p class="text-xs text-slate-500 mt-1">@lang('Backups are created automatically before updates.')</p>
                        </div>
                    @endif
                </x-admin.card>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Recent Updates -->
            <x-admin.card>
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 rounded-xl bg-indigo-500/10 flex items-center justify-center">
                        <i class="ph-duotone ph-clock-counter-clockwise text-xl text-indigo-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white">@lang('Recent Updates')</h3>
                </div>

                @if($latestUpdates->count() > 0)
                    <div class="space-y-3">
                        @foreach($latestUpdates as $update)
                            <div class="p-3 rounded-lg bg-white/[0.02] border border-white/5">
                                <div class="flex items-center justify-between mb-1">
                                    <span class="font-medium text-white">v{{ $update->version }}</span>
                                    <span class="text-xs text-slate-500">{{ $update->created_at->diffForHumans() }}</span>
                                </div>
                                <p class="text-xs text-slate-400 line-clamp-2">{{ $update->update_log }}</p>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="ph-duotone ph-package text-4xl text-slate-600 mb-3"></i>
                        <p class="text-sm text-slate-400">@lang('No update history available.')</p>
                    </div>
                @endif
            </x-admin.card>

            <!-- Update Settings Info -->
            <x-admin.card>
                <div class="flex items-center gap-3 mb-4">
                    <div class="w-10 h-10 rounded-xl bg-slate-500/10 flex items-center justify-center">
                        <i class="ph-duotone ph-gear text-xl text-slate-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white">@lang('Update Settings')</h3>
                </div>

                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Auto Backup')</span>
                        <span class="{{ config('auto-update.backup.enabled', true) ? 'text-emerald-400' : 'text-slate-500' }}">
                            {{ config('auto-update.backup.enabled', true) ? __('Enabled') : __('Disabled') }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Maintenance Mode')</span>
                        <span class="{{ config('auto-update.maintenance_mode', true) ? 'text-emerald-400' : 'text-slate-500' }}">
                            {{ config('auto-update.maintenance_mode', true) ? __('Enabled') : __('Disabled') }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Auto Migrate')</span>
                        <span class="{{ config('auto-update.auto_migrate', true) ? 'text-emerald-400' : 'text-slate-500' }}">
                            {{ config('auto-update.auto_migrate', true) ? __('Enabled') : __('Disabled') }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Auto Rollback')</span>
                        <span class="{{ config('auto-update.rollback_on_failure', true) ? 'text-emerald-400' : 'text-slate-500' }}">
                            {{ config('auto-update.rollback_on_failure', true) ? __('Enabled') : __('Disabled') }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Max Backups')</span>
                        <span class="text-white">{{ config('auto-update.backup.max_backups', 5) }}</span>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>

    <!-- Important Info -->
    <div class="mt-6">
        <x-admin.alert type="info">
            <div class="flex items-start gap-3">
                <i class="ph-duotone ph-info text-xl mt-0.5"></i>
                <div>
                    <strong class="block mb-1">@lang('Important Information')</strong>
                    <ul class="list-disc list-inside text-sm space-y-1">
                        <li>@lang('A valid license is required to check for and install updates.')</li>
                        <li>@lang('Backups are created automatically before each update.')</li>
                        <li>@lang('Database migrations run automatically after updates.')</li>
                        <li>@lang('If an update fails, the system will automatically rollback.')</li>
                        <li>@lang('You can also create manual backups and restore from them anytime.')</li>
                    </ul>
                </div>
            </div>
        </x-admin.alert>
    </div>
</div>
