<div>
    <x-admin.page-header :title="__('Update History')" :subtitle="__('View system update log and changelog.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.system.update') }}" variant="secondary" icon="ph-duotone ph-arrow-left">
                @lang('Back to Updates')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Stats -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
        <x-admin.stat-card
            :label="__('Current Version')"
            :value="'v' . $currentVersion"
            icon="ph-duotone ph-tag"
            color="indigo"
        />
        <x-admin.stat-card
            :label="__('Total Updates')"
            :value="number_format($totalUpdates)"
            icon="ph-duotone ph-cloud-arrow-down"
            color="emerald"
        />
        <x-admin.stat-card
            :label="__('Last Updated')"
            :value="$updates->count() > 0 ? $updates->first()->created_at->diffForHumans() : __('Never')"
            icon="ph-duotone ph-clock"
            color="amber"
        />
    </div>

    <!-- Update Log Table -->
    <x-admin.card>
        @if($updates->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/5">
                            <th class="text-left py-3 px-4 text-xs font-medium text-slate-400 uppercase tracking-wider">@lang('Version')</th>
                            <th class="text-left py-3 px-4 text-xs font-medium text-slate-400 uppercase tracking-wider">@lang('Description')</th>
                            <th class="text-left py-3 px-4 text-xs font-medium text-slate-400 uppercase tracking-wider">@lang('Date')</th>
                            <th class="text-right py-3 px-4 text-xs font-medium text-slate-400 uppercase tracking-wider">@lang('Actions')</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @foreach($updates as $update)
                            <tr class="hover:bg-white/[0.02] transition-colors">
                                <td class="py-4 px-4">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-lg bg-indigo-500/10 flex items-center justify-center">
                                            <i class="ph-duotone ph-tag text-lg text-indigo-400"></i>
                                        </div>
                                        <span class="font-semibold text-white">v{{ $update->version }}</span>
                                    </div>
                                </td>
                                <td class="py-4 px-4">
                                    <p class="text-sm text-slate-300 line-clamp-2">{{ $update->update_log }}</p>
                                </td>
                                <td class="py-4 px-4">
                                    <div>
                                        <p class="text-sm text-white">{{ $update->created_at->format('M d, Y') }}</p>
                                        <p class="text-xs text-slate-500">{{ $update->created_at->format('H:i:s') }}</p>
                                    </div>
                                </td>
                                <td class="py-4 px-4 text-right">
                                    <x-admin.button wire:click="viewDetails({{ $update->id }})" variant="ghost" size="sm">
                                        <i class="ph-duotone ph-eye text-lg"></i>
                                    </x-admin.button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="p-12 text-center">
                <div class="w-16 h-16 mx-auto bg-slate-800 rounded-full flex items-center justify-center mb-4">
                    <i class="ph-duotone ph-clock-counter-clockwise text-3xl text-slate-500"></i>
                </div>
                <h3 class="text-lg font-medium text-white mb-2">@lang('No Update History')</h3>
                <p class="text-slate-400 text-sm">@lang('No system updates have been applied yet.')</p>
            </div>
        @endif
    </x-admin.card>

    <!-- Pagination -->
    @if($updates->hasPages())
        <div class="mt-6">
            {{ $updates->links() }}
        </div>
    @endif

    <!-- Update Details Modal -->
    <x-admin.modal wire:model="viewingLogId" :title="__('Update Details')" size="md">
        @if($viewingLog)
            <div class="space-y-4">
                <div class="flex items-center gap-4 p-4 rounded-xl bg-indigo-500/5 border border-indigo-500/20">
                    <div class="w-12 h-12 rounded-lg bg-indigo-500/20 flex items-center justify-center">
                        <i class="ph-duotone ph-tag text-2xl text-indigo-400"></i>
                    </div>
                    <div>
                        <p class="text-xl font-bold text-white">@lang('Version') {{ $viewingLog->version }}</p>
                        <p class="text-sm text-slate-400">{{ $viewingLog->created_at->format('F d, Y \a\t H:i:s') }}</p>
                    </div>
                </div>

                <div>
                    <label class="text-sm font-medium text-slate-400 block mb-2">@lang('Changelog')</label>
                    <div class="p-4 rounded-xl bg-slate-900/50 border border-white/10">
                        <p class="text-sm text-slate-300 whitespace-pre-wrap">{{ $viewingLog->update_log }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="text-sm font-medium text-slate-400">@lang('Applied At')</label>
                        <p class="text-white">{{ $viewingLog->created_at->diffForHumans() }}</p>
                    </div>
                    <div>
                        <label class="text-sm font-medium text-slate-400">@lang('Timestamp')</label>
                        <p class="text-white font-mono text-sm">{{ $viewingLog->created_at->timestamp }}</p>
                    </div>
                </div>
            </div>
        @endif
        <x-slot:footer>
            <x-admin.button wire:click="closeDetails" variant="secondary">@lang('Close')</x-admin.button>
        </x-slot:footer>
    </x-admin.modal>
</div>

