<div class="space-y-6">
    <!-- Page Header -->
    <x-admin.page-header
        :title="__('Send Notification to Clients')"
        :subtitle="__('Send email, SMS, or push notifications to selected client segments')"
    >
        <x-slot:actions>
            <a href="{{ route('admin.users.all') }}" class="inline-flex items-center gap-2 rounded-xl bg-white/5 px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                <i class="ph-bold ph-arrow-left text-base"></i>
                @lang('Back to Clients')
            </a>
        </x-slot:actions>
    </x-admin.page-header>

    <div class="grid gap-6 lg:grid-cols-3">
        <!-- Main Form -->
        <div class="lg:col-span-2">
            <x-admin.card>
                <form wire:submit="send" class="space-y-6">
                    <!-- Send Via -->
                    <div>
                        <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Send Via')</label>
                        <div class="flex flex-wrap gap-3">
                            <label class="flex cursor-pointer items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-3 transition-all hover:border-indigo-500/50" :class="{ 'border-indigo-500 bg-indigo-500/10': $wire.sendVia === 'email' }">
                                <input type="radio" wire:model.live="sendVia" value="email" class="hidden">
                                <i class="ph-duotone ph-envelope text-xl" :class="$wire.sendVia === 'email' ? 'text-indigo-400' : 'text-slate-400'"></i>
                                <span class="text-sm font-medium" :class="$wire.sendVia === 'email' ? 'text-white' : 'text-slate-300'">@lang('Email')</span>
                            </label>
                            <label class="flex cursor-pointer items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-3 transition-all hover:border-emerald-500/50" :class="{ 'border-emerald-500 bg-emerald-500/10': $wire.sendVia === 'sms' }">
                                <input type="radio" wire:model.live="sendVia" value="sms" class="hidden">
                                <i class="ph-duotone ph-chat-circle text-xl" :class="$wire.sendVia === 'sms' ? 'text-emerald-400' : 'text-slate-400'"></i>
                                <span class="text-sm font-medium" :class="$wire.sendVia === 'sms' ? 'text-white' : 'text-slate-300'">@lang('SMS')</span>
                            </label>
                            <label class="flex cursor-pointer items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-3 transition-all hover:border-purple-500/50" :class="{ 'border-purple-500 bg-purple-500/10': $wire.sendVia === 'push' }">
                                <input type="radio" wire:model.live="sendVia" value="push" class="hidden">
                                <i class="ph-duotone ph-bell text-xl" :class="$wire.sendVia === 'push' ? 'text-purple-400' : 'text-slate-400'"></i>
                                <span class="text-sm font-medium" :class="$wire.sendVia === 'push' ? 'text-white' : 'text-slate-300'">@lang('Push')</span>
                            </label>
                        </div>
                    </div>

                    <!-- Subject -->
                    <div>
                        <label for="subject" class="mb-2 block text-sm font-medium text-slate-300">@lang('Subject')</label>
                        <input type="text" id="subject" wire:model="subject" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Enter notification subject') }}">
                        @error('subject') <span class="mt-1 text-sm text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <!-- Message -->
                    <div>
                        <label for="message" class="mb-2 block text-sm font-medium text-slate-300">@lang('Message')</label>
                        <textarea id="message" wire:model="message" rows="8" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Enter your notification message...') }}"></textarea>
                        @error('message') <span class="mt-1 text-sm text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    <!-- Submit -->
                    <div class="flex items-center justify-end gap-3 border-t border-white/5 pt-6">
                        <button type="submit" wire:loading.attr="disabled" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-indigo-500 to-purple-500 px-6 py-3 text-sm font-semibold text-white shadow-lg shadow-indigo-500/25 transition-all hover:shadow-xl hover:shadow-indigo-500/30 disabled:opacity-50">
                            <span wire:loading.remove wire:target="send">
                                <i class="ph-bold ph-paper-plane-tilt text-base"></i>
                                @lang('Send Notification')
                            </span>
                            <span wire:loading wire:target="send" class="flex items-center gap-2">
                                <svg class="h-4 w-4 animate-spin" viewBox="0 0 24 24" fill="none">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                @lang('Sending...')
                            </span>
                        </button>
                    </div>
                </form>
            </x-admin.card>
        </div>

        <!-- Sidebar - Segment Selection -->
        <div class="space-y-6">
            <x-admin.card :title="__('Select Recipients')">
                <div class="space-y-2">
                    @foreach($this->segmentOptions as $value => $label)
                        <label class="flex cursor-pointer items-center justify-between rounded-xl border border-white/10 bg-white/5 px-4 py-3 transition-all hover:border-indigo-500/50" :class="{ 'border-indigo-500 bg-indigo-500/10': $wire.segment === '{{ $value }}' }">
                            <div class="flex items-center gap-3">
                                <input type="radio" wire:model.live="segment" value="{{ $value }}" class="h-4 w-4 border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                                <span class="text-sm font-medium" :class="$wire.segment === '{{ $value }}' ? 'text-white' : 'text-slate-300'">{{ __($label) }}</span>
                            </div>
                        </label>
                    @endforeach
                </div>
            </x-admin.card>

            <!-- Recipient Count -->
            <x-admin.card>
                <div class="text-center">
                    <div class="mb-2 text-4xl font-bold text-white">{{ number_format($this->segmentCount) }}</div>
                    <div class="text-sm text-slate-400">@lang('Recipients will receive this notification')</div>
                </div>
            </x-admin.card>

            <!-- Shortcodes -->
            <x-admin.card :title="__('Available Shortcodes')">
                <div class="space-y-2 text-sm">
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <code class="text-indigo-400">@{{fullname}}</code>
                        <span class="text-slate-400">@lang("Client's full name")</span>
                    </div>
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <code class="text-indigo-400">@{{username}}</code>
                        <span class="text-slate-400">@lang("Client's username")</span>
                    </div>
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <code class="text-indigo-400">@{{email}}</code>
                        <span class="text-slate-400">@lang("Client's email")</span>
                    </div>
                    <div class="flex items-center justify-between rounded-lg bg-white/5 px-3 py-2">
                        <code class="text-indigo-400">@{{site_name}}</code>
                        <span class="text-slate-400">@lang('Site name')</span>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>
</div>

