<div x-data="{ showMobileProfile: false }">
    {{-- Page Header --}}
    <x-admin.page-header :title="$user->fullname ?: $user->username" :subtitle="__('Client account details and management.')">
        <x-slot:actions>
            {{-- Desktop Actions --}}
            <div class="hidden sm:flex items-center gap-2">
                <x-admin.button variant="secondary" wire:click="$set('showNotifyModal', true)" icon="ph-envelope">
                    @lang('Send Notification')
                </x-admin.button>
                <x-admin.button wire:click="loginAsUser" icon="ph-sign-in">
                    @lang('Login as Client')
                </x-admin.button>
            </div>
            {{-- Mobile Actions --}}
            <div class="flex sm:hidden items-center gap-2">
                <button type="button" @click="showMobileProfile = !showMobileProfile"
                    class="inline-flex items-center justify-center h-9 w-9 rounded-xl border border-white/10 bg-white/5 text-slate-400 hover:bg-white/10 hover:text-white transition-colors">
                    <i class="ph-duotone ph-user text-lg"></i>
                </button>
                <x-admin.button wire:click="loginAsUser" icon="ph-sign-in" size="sm" />
            </div>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-4 sm:mt-6">{{ session('success') }}</x-admin.alert>
    @endif

    <div class="mt-4 sm:mt-6 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-3">
        {{-- Left Column - User Info --}}
        <div class="lg:col-span-1 order-2 lg:order-1"
            :class="{ 'hidden lg:block': !showMobileProfile, 'block': showMobileProfile }">
            {{-- Profile Card --}}
            <x-admin.card>
                <div class="flex flex-col items-center text-center">
                    <div class="flex h-16 w-16 sm:h-20 sm:w-20 items-center justify-center rounded-2xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-2xl sm:text-3xl font-bold text-indigo-400">
                        {{ strtoupper(substr($user->firstname ?? $user->username, 0, 1)) }}
                    </div>
                    <h3 class="mt-3 sm:mt-4 text-lg sm:text-xl font-semibold text-white">{{ $user->fullname ?: $user->username }}</h3>
                    <p class="text-xs sm:text-sm text-slate-500">{{ '@' . $user->username }}</p>

                    {{-- Status Badges --}}
                    <div class="mt-3 sm:mt-4 flex flex-wrap justify-center gap-1.5 sm:gap-2">
                        @if($user->status)
                            <x-admin.badge type="success">@lang('Active')</x-admin.badge>
                        @else
                            <x-admin.badge type="danger">@lang('Banned')</x-admin.badge>
                        @endif
                        @if($user->ev)
                            <x-admin.badge type="primary">@lang('Email Verified')</x-admin.badge>
                        @endif
                        @if($user->kv == \App\Constants\Status::KYC_VERIFIED)
                            <x-admin.badge type="info">@lang('KYC Verified')</x-admin.badge>
                        @elseif($user->kv == \App\Constants\Status::KYC_PENDING)
                            <x-admin.badge type="warning">@lang('KYC Pending')</x-admin.badge>
                        @endif
                    </div>

                    {{-- Balance --}}
                    <div class="mt-4 sm:mt-6 w-full rounded-xl bg-gradient-to-r from-indigo-500/10 via-purple-500/10 to-pink-500/10 p-3 sm:p-4">
                        <p class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Account Balance')</p>
                        <p class="mt-1 text-xl sm:text-2xl font-bold text-white">{{ showAmount($user->balance) }}</p>
                    </div>

                    {{-- Quick Actions --}}
                    <div class="mt-4 sm:mt-6 grid w-full grid-cols-2 gap-2">
                        <button wire:click="$set('showBalanceModal', true)" class="flex items-center justify-center gap-2 rounded-xl bg-white/5 px-3 sm:px-4 py-2.5 sm:py-3 text-xs sm:text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white active:scale-[0.98] min-h-11 sm:min-h-0">
                            <i class="ph-duotone ph-wallet text-base sm:text-lg"></i>
                            @lang('Balance')
                        </button>
                        <button wire:click="$set('showEditModal', true)" class="flex items-center justify-center gap-2 rounded-xl bg-white/5 px-3 sm:px-4 py-2.5 sm:py-3 text-xs sm:text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white active:scale-[0.98] min-h-11 sm:min-h-0">
                            <i class="ph-duotone ph-pencil text-base sm:text-lg"></i>
                            @lang('Edit')
                        </button>
                    </div>
                    {{-- Mobile Notify Button --}}
                    <button wire:click="$set('showNotifyModal', true)" class="mt-2 w-full flex sm:hidden items-center justify-center gap-2 rounded-xl bg-white/5 px-3 py-2.5 text-xs font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white active:scale-[0.98] min-h-11">
                        <i class="ph-duotone ph-envelope text-base"></i>
                        @lang('Send Notification')
                    </button>
                </div>
            </x-admin.card>

            {{-- Contact Info --}}
            <x-admin.card class="mt-4 sm:mt-6" :title="__('Contact Information')">
                <div class="space-y-3 sm:space-y-4">
                    <div class="flex items-start gap-3">
                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-indigo-500/10 text-indigo-400">
                            <i class="ph-duotone ph-envelope text-base sm:text-lg"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-xs text-slate-500">@lang('Email Address')</p>
                            <p class="text-xs sm:text-sm text-white truncate">{{ $user->email }}</p>
                        </div>
                    </div>
                    @if($user->mobile)
                    <div class="flex items-start gap-3">
                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-emerald-500/10 text-emerald-400">
                            <i class="ph-duotone ph-phone text-base sm:text-lg"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-xs text-slate-500">@lang('Phone Number')</p>
                            <p class="text-xs sm:text-sm text-white">{{ $user->mobile_number }}</p>
                        </div>
                    </div>
                    @endif
                    @if($user->address)
                    <div class="flex items-start gap-3">
                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-amber-500/10 text-amber-400">
                            <i class="ph-duotone ph-map-pin text-base sm:text-lg"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-xs text-slate-500">@lang('Address')</p>
                            <p class="text-xs sm:text-sm text-white">{{ $user->address }}</p>
                            <p class="text-xs sm:text-sm text-slate-400">{{ $user->city }}, {{ $user->state }} {{ $user->zip }}</p>
                            <p class="text-xs sm:text-sm text-slate-400">{{ $user->country_name }}</p>
                        </div>
                    </div>
                    @endif
                    <div class="flex items-start gap-3">
                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-sky-500/10 text-sky-400">
                            <i class="ph-duotone ph-calendar text-base sm:text-lg"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-xs text-slate-500">@lang('Member Since')</p>
                            <p class="text-xs sm:text-sm text-white">{{ $user->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>
                </div>
            </x-admin.card>

            {{-- Status Toggles --}}
            <x-admin.card class="mt-4 sm:mt-6" :title="__('Account Controls')">
                <div class="space-y-3 sm:space-y-4">
                    <div class="flex items-center justify-between gap-3">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm font-medium text-white">@lang('Account Status')</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">{{ $user->status ? __('User can access their account') : __('User is banned') }}</p>
                        </div>
                        <x-admin.toggle wire:click="toggleStatus" :checked="$user->status" />
                    </div>
                    <div class="border-t border-white/5"></div>
                    <div class="flex items-center justify-between gap-3">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm font-medium text-white">@lang('Email Verified')</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">{{ $user->ev ? __('Email is verified') : __('Email not verified') }}</p>
                        </div>
                        <x-admin.toggle wire:click="toggleEmailVerification" :checked="$user->ev" />
                    </div>
                    <div class="border-t border-white/5"></div>
                    <div class="flex items-center justify-between gap-3">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm font-medium text-white">@lang('Mobile Verified')</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">{{ $user->sv ? __('Mobile is verified') : __('Mobile not verified') }}</p>
                        </div>
                        <x-admin.toggle wire:click="toggleMobileVerification" :checked="$user->sv" />
                    </div>
                </div>
            </x-admin.card>
        </div>

        {{-- Right Column - Tabs --}}
        <div class="lg:col-span-2 order-1 lg:order-2">
            {{-- Stats Row --}}
            <div class="-mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto pb-2 sm:pb-0">
                <div class="flex sm:grid sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 min-w-max sm:min-w-0">
                    <x-admin.stat-card icon="ph-shopping-bag" iconColor="primary" :label="__('Orders')" :value="$stats['total_orders']" class="min-w-[120px] sm:min-w-0" />
                    <x-admin.stat-card icon="ph-hard-drives" iconColor="success" :label="__('Services')" :value="$stats['active_services']" class="min-w-[120px] sm:min-w-0" />
                    <x-admin.stat-card icon="ph-globe" iconColor="info" :label="__('Domains')" :value="$stats['active_domains']" class="min-w-[120px] sm:min-w-0" />
                    <x-admin.stat-card icon="ph-ticket" iconColor="warning" :label="__('Open Tickets')" :value="$stats['open_tickets']" class="min-w-[120px] sm:min-w-0" />
                </div>
            </div>

            {{-- Tabs Navigation --}}
            <div class="mt-4 sm:mt-6 border-b border-white/5 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto">
                <nav class="-mb-px flex gap-4 sm:gap-6 min-w-max sm:min-w-0" aria-label="Tabs">
                    @foreach(['overview' => __('Overview'), 'orders' => __('Orders'), 'services' => __('Services'), 'invoices' => __('Invoices'), 'transactions' => __('Transactions'), 'cancellations' => __('Cancellations')] as $tab => $label)
                        <button
                            wire:click="$set('activeTab', '{{ $tab }}')"
                            class="relative whitespace-nowrap border-b-2 px-1 py-3 text-xs sm:text-sm font-medium transition-all min-h-11 sm:min-h-0 {{ $activeTab === $tab ? 'border-indigo-500 text-white' : 'border-transparent text-slate-500 hover:border-white/20 hover:text-slate-300' }}"
                        >
                            {{ $label }}
                            @if($tab === 'cancellations' && $stats['pending_cancellations'] > 0)
                                <span class="ml-1 sm:ml-1.5 inline-flex h-4 sm:h-5 min-w-4 sm:min-w-5 items-center justify-center rounded-full bg-rose-500/20 px-1 sm:px-1.5 text-[10px] sm:text-xs font-medium text-rose-400">
                                    {{ $stats['pending_cancellations'] }}
                                </span>
                            @endif
                        </button>
                    @endforeach
                </nav>
            </div>

            {{-- Tab Content --}}
            <div class="mt-4 sm:mt-6">
                @if($activeTab === 'overview')
                    {{-- Recent Orders --}}
                    <x-admin.card :title="__('Recent Orders')" :padding="false">
                        <div class="divide-y divide-white/5">
                            @forelse($orders->take(5) as $order)
                                <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4">
                                    <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-indigo-500/10 text-indigo-400">
                                            <i class="ph-duotone ph-shopping-bag text-base sm:text-lg"></i>
                                        </div>
                                        <div class="min-w-0">
                                            <p class="text-xs sm:text-sm font-medium text-white truncate">@lang('Order') #{{ $order->order_number }}</p>
                                            <p class="text-[10px] sm:text-xs text-slate-500">{{ $order->created_at->diffForHumans() }}</p>
                                        </div>
                                    </div>
                                    <div class="text-right shrink-0 ml-2">
                                        <p class="text-xs sm:text-sm font-medium text-white">{{ showAmount($order->total) }}</p>
                                        @if($order->status == 1)
                                            <x-admin.badge type="success" size="sm">@lang('Active')</x-admin.badge>
                                        @elseif($order->status == 0)
                                            <x-admin.badge type="warning" size="sm">@lang('Pending')</x-admin.badge>
                                        @else
                                            <x-admin.badge type="danger" size="sm">@lang('Cancelled')</x-admin.badge>
                                        @endif
                                    </div>
                                </div>
                            @empty
                                <x-admin.empty-state icon="ph-shopping-bag" :title="__('No orders yet')" :description="__('This client hasn\'t placed any orders.')" />
                            @endforelse
                        </div>
                    </x-admin.card>
                @elseif($activeTab === 'orders')
                    <x-admin.card :title="__('All Orders')" :padding="false">
                        <div class="divide-y divide-white/5">
                            @forelse($orders as $order)
                                <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4 transition-all hover:bg-white/5 active:bg-white/5">
                                    <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-indigo-500/10 text-indigo-400">
                                            <i class="ph-duotone ph-shopping-bag text-base sm:text-lg"></i>
                                        </div>
                                        <div class="min-w-0">
                                            <p class="text-xs sm:text-sm font-medium text-white truncate">@lang('Order') #{{ $order->order_number }}</p>
                                            <p class="text-[10px] sm:text-xs text-slate-500">{{ $order->created_at->format('M d, Y') }}</p>
                                        </div>
                                    </div>
                                    <div class="text-right shrink-0 ml-2">
                                        <p class="text-xs sm:text-sm font-medium text-white">{{ showAmount($order->total) }}</p>
                                        @if($order->status == 1)
                                            <x-admin.badge type="success" size="sm">@lang('Active')</x-admin.badge>
                                        @elseif($order->status == 0)
                                            <x-admin.badge type="warning" size="sm">@lang('Pending')</x-admin.badge>
                                        @else
                                            <x-admin.badge type="danger" size="sm">@lang('Cancelled')</x-admin.badge>
                                        @endif
                                    </div>
                                </div>
                            @empty
                                <x-admin.empty-state icon="ph-shopping-bag" :title="__('No orders')" :description="__('This client has no orders.')" />
                            @endforelse
                        </div>
                    </x-admin.card>
                @elseif($activeTab === 'services')
                    <div class="space-y-3 sm:space-y-4">
                        <x-admin.card :title="__('Hosting Services')" :padding="false">
                            <div class="divide-y divide-white/5">
                                @forelse($hostings as $hosting)
                                    <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4 transition-all hover:bg-white/5 active:bg-white/5">
                                        <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                            <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-emerald-500/10 text-emerald-400">
                                                <i class="ph-duotone ph-hard-drives text-base sm:text-lg"></i>
                                            </div>
                                            <div class="min-w-0">
                                                <p class="text-xs sm:text-sm font-medium text-white truncate">{{ $hosting->domain }}</p>
                                                <p class="text-[10px] sm:text-xs text-slate-500 truncate">{{ $hosting->product->name ?? __('N/A') }}</p>
                                            </div>
                                        </div>
                                        <div class="text-right shrink-0 ml-2">
                                            @if($hosting->status == 1)
                                                <x-admin.badge type="success" size="sm">@lang('Active')</x-admin.badge>
                                            @else
                                                <x-admin.badge type="danger" size="sm">@lang('Suspended')</x-admin.badge>
                                            @endif
                                            <p class="mt-1 text-[10px] sm:text-xs text-slate-500">{{ $hosting->next_due_date?->format('M d, Y') ?? __('N/A') }}</p>
                                        </div>
                                    </div>
                                @empty
                                    <x-admin.empty-state icon="ph-hard-drives" :title="__('No hosting services')" :description="__('This client has no hosting services.')" />
                                @endforelse
                            </div>
                        </x-admin.card>

                        <x-admin.card :title="__('Domains')" :padding="false">
                            <div class="divide-y divide-white/5">
                                @forelse($domains as $domain)
                                    <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4 transition-all hover:bg-white/5 active:bg-white/5">
                                        <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                            <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-sky-500/10 text-sky-400">
                                                <i class="ph-duotone ph-globe text-base sm:text-lg"></i>
                                            </div>
                                            <div class="min-w-0">
                                                <p class="text-xs sm:text-sm font-medium text-white truncate">{{ $domain->domain }}</p>
                                                <p class="text-[10px] sm:text-xs text-slate-500">{{ $domain->tld->extension ?? __('N/A') }}</p>
                                            </div>
                                        </div>
                                        <div class="text-right shrink-0 ml-2">
                                            @if($domain->status == 1)
                                                <x-admin.badge type="success" size="sm">@lang('Active')</x-admin.badge>
                                            @else
                                                <x-admin.badge type="danger" size="sm">@lang('Inactive')</x-admin.badge>
                                            @endif
                                            <p class="mt-1 text-[10px] sm:text-xs text-slate-500">{{ $domain->expiry_date?->format('M d, Y') ?? __('N/A') }}</p>
                                        </div>
                                    </div>
                                @empty
                                    <x-admin.empty-state icon="ph-globe" :title="__('No domains')" :description="__('This client has no domains.')" />
                                @endforelse
                            </div>
                        </x-admin.card>
                    </div>
                @elseif($activeTab === 'invoices')
                    <x-admin.card :title="__('Invoices')" :padding="false">
                        <div class="divide-y divide-white/5">
                            @forelse($invoices as $invoice)
                                <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4 transition-all hover:bg-white/5 active:bg-white/5">
                                    <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-amber-500/10 text-amber-400">
                                            <i class="ph-duotone ph-file-text text-base sm:text-lg"></i>
                                        </div>
                                        <div class="min-w-0">
                                            <p class="text-xs sm:text-sm font-medium text-white truncate">@lang('Invoice') #{{ $invoice->invoice_num }}</p>
                                            <p class="text-[10px] sm:text-xs text-slate-500">@lang('Due'): {{ $invoice->due_date?->format('M d, Y') ?? __('N/A') }}</p>
                                        </div>
                                    </div>
                                    <div class="text-right shrink-0 ml-2">
                                        <p class="text-xs sm:text-sm font-medium text-white">{{ showAmount($invoice->total) }}</p>
                                        @if($invoice->status == 1)
                                            <x-admin.badge type="success" size="sm">@lang('Paid')</x-admin.badge>
                                        @elseif($invoice->status == 0)
                                            <x-admin.badge type="warning" size="sm">@lang('Unpaid')</x-admin.badge>
                                        @else
                                            <x-admin.badge type="danger" size="sm">@lang('Cancelled')</x-admin.badge>
                                        @endif
                                    </div>
                                </div>
                            @empty
                                <x-admin.empty-state icon="ph-file-text" :title="__('No invoices')" :description="__('This client has no invoices.')" />
                            @endforelse
                        </div>
                    </x-admin.card>
                @elseif($activeTab === 'transactions')
                    <x-admin.card :title="__('Transactions')" :padding="false">
                        <div class="divide-y divide-white/5">
                            @forelse($transactions as $trx)
                                <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4 transition-all hover:bg-white/5 active:bg-white/5">
                                    <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl {{ $trx->trx_type === '+' ? 'bg-emerald-500/10 text-emerald-400' : 'bg-rose-500/10 text-rose-400' }}">
                                            <i class="ph-duotone {{ $trx->trx_type === '+' ? 'ph-arrow-down' : 'ph-arrow-up' }} text-base sm:text-lg"></i>
                                        </div>
                                        <div class="min-w-0">
                                            <p class="text-xs sm:text-sm font-medium text-white truncate">{{ $trx->details }}</p>
                                            <p class="text-[10px] sm:text-xs text-slate-500">{{ $trx->created_at->format('M d, Y H:i') }}</p>
                                        </div>
                                    </div>
                                    <div class="text-right shrink-0 ml-2">
                                        <p class="text-xs sm:text-sm font-medium {{ $trx->trx_type === '+' ? 'text-emerald-400' : 'text-rose-400' }}">
                                            {{ $trx->trx_type }}{{ showAmount($trx->amount) }}
                                        </p>
                                        <p class="text-[10px] sm:text-xs text-slate-500">{{ showAmount($trx->post_balance) }}</p>
                                    </div>
                                </div>
                            @empty
                                <x-admin.empty-state icon="ph-arrows-left-right" :title="__('No transactions')" :description="__('This client has no transactions.')" />
                            @endforelse
                        </div>
                    </x-admin.card>
                @elseif($activeTab === 'cancellations')
                    <x-admin.card :title="__('Cancellation Requests')" :padding="false">
                        <div class="divide-y divide-white/5">
                            @forelse($cancelRequests as $request)
                                <div class="flex flex-col sm:flex-row sm:items-center justify-between px-4 sm:px-6 py-3 sm:py-4 gap-3 transition-all hover:bg-white/5 active:bg-white/5">
                                    <div class="flex items-center gap-2 sm:gap-3 min-w-0">
                                        <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl
                                            {{ $request->status === \App\Models\CancelRequest::STATUS_PENDING ? 'bg-amber-500/10 text-amber-400' : '' }}
                                            {{ $request->status === \App\Models\CancelRequest::STATUS_APPROVED ? 'bg-rose-500/10 text-rose-400' : '' }}
                                            {{ $request->status === \App\Models\CancelRequest::STATUS_REJECTED ? 'bg-slate-500/10 text-slate-400' : '' }}
                                        ">
                                            <i class="ph-duotone ph-x-circle text-base sm:text-lg"></i>
                                        </div>
                                        <div class="min-w-0">
                                            <p class="text-xs sm:text-sm font-medium text-white truncate">
                                                {{ $request->hosting?->product?->name ?? __('Unknown Service') }}
                                            </p>
                                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">
                                                {{ $request->hosting?->domain ?? __('N/A') }} • {{ $request->created_at->format('M d, Y') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex items-center justify-between sm:justify-end gap-2 sm:gap-3 ml-11 sm:ml-0">
                                        <div class="text-left sm:text-right">
                                            @if($request->status === \App\Models\CancelRequest::STATUS_PENDING)
                                                <x-admin.badge type="warning" size="sm">@lang('Pending')</x-admin.badge>
                                            @elseif($request->status === \App\Models\CancelRequest::STATUS_APPROVED)
                                                <x-admin.badge type="danger" size="sm">@lang('Approved')</x-admin.badge>
                                            @else
                                                <x-admin.badge type="secondary" size="sm">@lang('Rejected')</x-admin.badge>
                                            @endif
                                            <p class="mt-1 text-[10px] sm:text-xs text-slate-500">
                                                {{ $request->cancel_type === \App\Models\CancelRequest::TYPE_IMMEDIATE ? __('Immediate') : __('End of Billing') }}
                                            </p>
                                        </div>
                                        <x-admin.action-menu>
                                            <x-admin.action-menu-item
                                                icon="ph-eye"
                                                wire:click="viewCancelReason({{ $request->id }})"
                                            >
                                                @lang('View Reason')
                                            </x-admin.action-menu-item>
                                            @if($request->status === \App\Models\CancelRequest::STATUS_PENDING)
                                                <x-admin.action-menu-item
                                                    icon="ph-check-circle"
                                                    wire:click="approveCancelRequest({{ $request->id }})"
                                                    wire:confirm="{{ __('Are you sure you want to approve this cancellation? The service will be cancelled.') }}"
                                                    class="text-emerald-400 hover:text-emerald-300"
                                                >
                                                    @lang('Approve')
                                                </x-admin.action-menu-item>
                                                <x-admin.action-menu-item
                                                    icon="ph-x-circle"
                                                    wire:click="rejectCancelRequest({{ $request->id }})"
                                                    wire:confirm="{{ __('Are you sure you want to reject this cancellation request?') }}"
                                                    class="text-rose-400 hover:text-rose-300"
                                                >
                                                    @lang('Reject')
                                                </x-admin.action-menu-item>
                                            @endif
                                            <x-admin.action-menu-item
                                                icon="ph-trash"
                                                wire:click="deleteCancelRequest({{ $request->id }})"
                                                wire:confirm="{{ __('Are you sure you want to delete this cancellation request?') }}"
                                                class="text-rose-400 hover:text-rose-300"
                                            >
                                                @lang('Delete')
                                            </x-admin.action-menu-item>
                                        </x-admin.action-menu>
                                    </div>
                                </div>
                            @empty
                                <x-admin.empty-state icon="ph-x-circle" :title="__('No cancellation requests')" :description="__('This client has not submitted any cancellation requests.')" />
                            @endforelse
                        </div>
                    </x-admin.card>
                @endif
            </div>
        </div>
    </div>

    {{-- Reason Modal --}}
    <x-admin.modal wire:model="showReasonModal" :title="__('Cancellation Reason')">
        <div class="rounded-xl bg-white/5 p-3 sm:p-4">
            <p class="text-xs sm:text-sm text-slate-300 whitespace-pre-wrap">{{ $viewReason }}</p>
        </div>
        <div class="mt-4 sm:mt-6 flex justify-end">
            <x-admin.button type="button" variant="secondary" wire:click="$set('showReasonModal', false)">@lang('Close')</x-admin.button>
        </div>
    </x-admin.modal>

    {{-- Edit User Modal --}}
    <x-admin.modal wire:model="showEditModal" :title="__('Edit Client')" size="lg">
        <form wire:submit="updateUser">
            <div class="grid grid-cols-1 gap-3 sm:gap-4 sm:grid-cols-2">
                <x-admin.input :label="__('First Name')" wire:model="firstname" required />
                <x-admin.input :label="__('Last Name')" wire:model="lastname" required />
                <x-admin.input :label="__('Email Address')" type="email" wire:model="email" required />
                <x-admin.input :label="__('Mobile Number')" wire:model="mobile" />
                <x-admin.input :label="__('Address')" wire:model="address" class="sm:col-span-2" />
                <x-admin.input :label="__('City')" wire:model="city" />
                <x-admin.input :label="__('State')" wire:model="state" />
                <x-admin.input :label="__('ZIP Code')" wire:model="zip" />
                <x-admin.input :label="__('Country')" wire:model="country" />
            </div>
            <div class="mt-4 sm:mt-6 flex flex-col-reverse sm:flex-row justify-end gap-2 sm:gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showEditModal', false)" class="w-full sm:w-auto">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" class="w-full sm:w-auto">@lang('Save Changes')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>

    {{-- Balance Modal --}}
    <x-admin.modal wire:model="showBalanceModal" :title="__('Manage Balance')">
        <form wire:submit="updateBalance">
            <div class="space-y-3 sm:space-y-4">
                <div class="flex gap-2 sm:gap-4">
                    <label class="flex flex-1 cursor-pointer items-center justify-center gap-1.5 sm:gap-2 rounded-xl border-2 p-3 sm:p-4 transition-all min-h-11 {{ $balanceType === 'add' ? 'border-emerald-500 bg-emerald-500/10' : 'border-white/10 hover:border-white/20' }}">
                        <input type="radio" wire:model.live="balanceType" value="add" class="hidden">
                        <i class="ph-duotone ph-plus-circle text-lg sm:text-xl {{ $balanceType === 'add' ? 'text-emerald-400' : 'text-slate-500' }}"></i>
                        <span class="text-xs sm:text-sm {{ $balanceType === 'add' ? 'text-white' : 'text-slate-400' }}">@lang('Add')</span>
                    </label>
                    <label class="flex flex-1 cursor-pointer items-center justify-center gap-1.5 sm:gap-2 rounded-xl border-2 p-3 sm:p-4 transition-all min-h-11 {{ $balanceType === 'subtract' ? 'border-rose-500 bg-rose-500/10' : 'border-white/10 hover:border-white/20' }}">
                        <input type="radio" wire:model.live="balanceType" value="subtract" class="hidden">
                        <i class="ph-duotone ph-minus-circle text-lg sm:text-xl {{ $balanceType === 'subtract' ? 'text-rose-400' : 'text-slate-500' }}"></i>
                        <span class="text-xs sm:text-sm {{ $balanceType === 'subtract' ? 'text-white' : 'text-slate-400' }}">@lang('Subtract')</span>
                    </label>
                </div>
                <x-admin.input :label="__('Amount')" type="number" step="0.01" wire:model="balanceAmount" required />
                <x-admin.textarea :label="__('Remark')" wire:model="balanceRemark" rows="2" required />
            </div>
            <div class="mt-4 sm:mt-6 flex flex-col-reverse sm:flex-row justify-end gap-2 sm:gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showBalanceModal', false)" class="w-full sm:w-auto">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" class="w-full sm:w-auto">@lang('Update Balance')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>

    {{-- Notification Modal --}}
    <x-admin.modal wire:model="showNotifyModal" :title="__('Send Notification')">
        <form wire:submit="sendNotification">
            <div class="space-y-3 sm:space-y-4">
                <x-admin.input :label="__('Subject')" wire:model="notifySubject" required />
                <x-admin.textarea :label="__('Message')" wire:model="notifyMessage" rows="4" required />
            </div>
            <div class="mt-4 sm:mt-6 flex flex-col-reverse sm:flex-row justify-end gap-2 sm:gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showNotifyModal', false)" class="w-full sm:w-auto">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" class="w-full sm:w-auto">@lang('Send Notification')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

