<div>
    {{-- Page Header --}}
    <x-admin.page-header
        :title="$isEdit ? __('Edit Client') : __('Add New Client')"
        :subtitle="$isEdit ? __('Update client account information.') : __('Create a new client account.')"
    >
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.users.all') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Clients')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <form wire:submit="save" class="mt-6">
        <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
            {{-- Main Form --}}
            <div class="lg:col-span-2 space-y-6">
                {{-- Personal Information --}}
                <x-admin.card :title="__('Personal Information')" :subtitle="__('Basic client details.')">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <x-admin.input
                            :label="__('First Name')"
                            wire:model="firstname"
                            :placeholder="__('Enter first name')"
                            required
                        />
                        <x-admin.input
                            :label="__('Last Name')"
                            wire:model="lastname"
                            :placeholder="__('Enter last name')"
                            required
                        />
                        <div class="relative">
                            <x-admin.input
                                :label="__('Username')"
                                wire:model.live.debounce.500ms="username"
                                :placeholder="__('Enter username')"
                                required
                                :disabled="$isEdit"
                            />
                            @if($usernameChecking)
                                <div class="absolute right-3 top-9">
                                    <i class="ph-duotone ph-spinner animate-spin text-slate-400"></i>
                                </div>
                            @elseif(!$isEdit && strlen($username) >= 3 && !$errors->has('username'))
                                <div class="absolute right-3 top-9">
                                    <i class="ph-duotone ph-check-circle text-emerald-400"></i>
                                </div>
                            @endif
                            @error('username')
                                <p class="mt-1 text-xs text-rose-400">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="relative">
                            <x-admin.input
                                :label="__('Email Address')"
                                type="email"
                                wire:model.live.debounce.500ms="email"
                                :placeholder="__('Enter email address')"
                                required
                            />
                            @if($emailChecking)
                                <div class="absolute right-3 top-9">
                                    <i class="ph-duotone ph-spinner animate-spin text-slate-400"></i>
                                </div>
                            @elseif(strlen($email) > 0 && filter_var($email, FILTER_VALIDATE_EMAIL) && !$errors->has('email'))
                                <div class="absolute right-3 top-9">
                                    <i class="ph-duotone ph-check-circle text-emerald-400"></i>
                                </div>
                            @endif
                            @error('email')
                                <p class="mt-1 text-xs text-rose-400">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="relative">
                            <x-admin.input
                                :label="__('Mobile Number')"
                                wire:model.live.debounce.500ms="mobile"
                                :placeholder="__('Enter mobile number')"
                            />
                            @if($mobileChecking)
                                <div class="absolute right-3 top-9">
                                    <i class="ph-duotone ph-spinner animate-spin text-slate-400"></i>
                                </div>
                            @elseif(strlen($mobile) >= 6 && !$errors->has('mobile'))
                                <div class="absolute right-3 top-9">
                                    <i class="ph-duotone ph-check-circle text-emerald-400"></i>
                                </div>
                            @endif
                            @error('mobile')
                                <p class="mt-1 text-xs text-rose-400">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </x-admin.card>

                {{-- Password --}}
                <x-admin.card :title="__('Password')" :subtitle="$isEdit ? __('Leave blank to keep current password.') : __('Set the client password.')">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <x-admin.input
                            :label="__('Password')"
                            type="password"
                            wire:model="password"
                            :placeholder="$isEdit ? __('Leave blank to keep current') : __('Enter password')"
                            :required="!$isEdit"
                        />
                        <x-admin.input
                            :label="__('Confirm Password')"
                            type="password"
                            wire:model="password_confirmation"
                            :placeholder="__('Confirm password')"
                            :required="!$isEdit"
                        />
                    </div>
                </x-admin.card>

                {{-- Address Information --}}
                <x-admin.card :title="__('Address Information')" :subtitle="__('Client address details.')">
                    <div class="space-y-4">
                        <x-admin.input
                            :label="__('Street Address')"
                            wire:model="address"
                            :placeholder="__('Enter street address')"
                        />
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input
                                :label="__('City')"
                                wire:model="city"
                                :placeholder="__('Enter city')"
                            />
                            <x-admin.input
                                :label="__('State / Province')"
                                wire:model="state"
                                :placeholder="__('Enter state')"
                            />
                            <x-admin.input
                                :label="__('ZIP / Postal Code')"
                                wire:model="zip"
                                :placeholder="__('Enter ZIP code')"
                            />
                            <x-admin.input
                                :label="__('Country')"
                                wire:model="country"
                                :placeholder="__('Enter country')"
                            />
                        </div>
                    </div>
                </x-admin.card>
            </div>

            {{-- Sidebar --}}
            <div class="lg:col-span-1 space-y-6">
                {{-- Account Status --}}
                <x-admin.card :title="__('Account Status')">
                    <div class="space-y-4">
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Account Active')</p>
                                <p class="text-xs text-slate-500">@lang('Allow user to access their account')</p>
                            </div>
                            <x-admin.toggle wire:model.live="status" />
                        </div>
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Email Verified')</p>
                                <p class="text-xs text-slate-500">@lang('Mark email as verified')</p>
                            </div>
                            <x-admin.toggle wire:model.live="ev" />
                        </div>
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Mobile Verified')</p>
                                <p class="text-xs text-slate-500">@lang('Mark mobile as verified')</p>
                            </div>
                            <x-admin.toggle wire:model.live="sv" />
                        </div>
                    </div>
                </x-admin.card>

                {{-- Actions --}}
                <x-admin.card>
                    <div class="space-y-3">
                        <x-admin.button type="submit" class="w-full" icon="ph-check">
                            {{ $isEdit ? __('Update Client') : __('Create Client') }}
                        </x-admin.button>
                        <x-admin.button type="button" variant="secondary" class="w-full" href="{{ route('admin.users.all') }}">
                            @lang('Cancel')
                        </x-admin.button>
                    </div>
                </x-admin.card>
            </div>
        </div>
    </form>
</div>

