<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Manage Clients')" :subtitle="__('View and manage all registered client accounts.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.users.create') }}" icon="ph-user-plus">
                <span class="hidden sm:inline">@lang('Add Client')</span>
                <span class="sm:hidden">@lang('Add')</span>
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-4 sm:mt-6">{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-2 gap-2 sm:gap-4 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-users-three"
            iconColor="primary"
            :label="__('Total Clients')"
            :value="number_format($totalUsers)"
        />
        <x-admin.stat-card
            icon="ph-user-check"
            iconColor="success"
            :label="__('Active Clients')"
            :value="number_format($activeUsers)"
            :href="route('admin.users.active')"
        />
        <x-admin.stat-card
            icon="ph-user-minus"
            iconColor="danger"
            :label="__('Banned Clients')"
            :value="number_format($bannedUsers)"
            :href="route('admin.users.banned')"
        />
        <x-admin.stat-card
            icon="ph-wallet"
            iconColor="info"
            :label="__('With Balance')"
            :value="number_format(\App\Models\User::where('balance', '>', 0)->count())"
        />
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-4 sm:mt-6">
        <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
            {{-- Search --}}
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="@lang('Search clients...')"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-3 sm:py-2.5 pl-10 pr-10 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white p-1 min-h-[44px] min-w-[44px] flex items-center justify-center -mr-2">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>

            {{-- Filter Dropdown --}}
            <div class="flex flex-wrap gap-2 w-full sm:w-auto">
                <select
                    wire:model.live="status"
                    class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Clients')</option>
                    <option value="active" class="bg-[#1a1a24]">@lang('Active')</option>
                    <option value="banned" class="bg-[#1a1a24]">@lang('Banned')</option>
                    <option value="email_verified" class="bg-[#1a1a24]">@lang('Email Verified')</option>
                    <option value="email_unverified" class="bg-[#1a1a24]">@lang('Email Unverified')</option>
                    <option value="mobile_verified" class="bg-[#1a1a24]">@lang('Mobile Verified')</option>
                    <option value="mobile_unverified" class="bg-[#1a1a24]">@lang('Mobile Unverified')</option>
                    <option value="kyc_verified" class="bg-[#1a1a24]">@lang('KYC Verified')</option>
                    <option value="kyc_pending" class="bg-[#1a1a24]">@lang('KYC Pending')</option>
                    <option value="kyc_unverified" class="bg-[#1a1a24]">@lang('KYC Unverified')</option>
                    <option value="with_balance" class="bg-[#1a1a24]">@lang('With Balance')</option>
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Users Table (Desktop) / Cards (Mobile) --}}
    <x-admin.card class="mt-4 sm:mt-6" :padding="false">
        {{-- Desktop Table View --}}
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/5">
                        <th class="px-4 lg:px-6 py-3 text-left">
                            <button wire:click="sortBy('username')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Client')
                                @if($sortField === 'username')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-left hidden lg:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Email / Phone')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-left">
                            <button wire:click="sortBy('balance')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Balance')
                                @if($sortField === 'balance')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-left hidden xl:table-cell">
                            <button wire:click="sortBy('created_at')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Joined')
                                @if($sortField === 'created_at')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($users as $user)
                        <tr class="group transition-all hover:bg-white/5" wire:key="user-{{ $user->id }}">
                            {{-- Client Info --}}
                            <td class="px-4 lg:px-6 py-3">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 font-semibold text-indigo-400 text-sm">
                                        {{ strtoupper(substr($user->firstname ?? $user->username ?? 'U', 0, 1)) }}
                                    </div>
                                    <div class="min-w-0">
                                        @if($user->username)
                                            <a href="{{ route('admin.users.detail', $user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400 truncate block">
                                                {{ $user->fullname ?: $user->username }}
                                            </a>
                                            <p class="text-xs text-slate-500 truncate">{{ '@' . $user->username }}</p>
                                        @else
                                            <span class="font-medium text-white truncate block">{{ $user->fullname ?: __('No Username') }}</span>
                                            <p class="text-xs text-amber-400">@lang('Username not set')</p>
                                        @endif
                                    </div>
                                </div>
                            </td>

                            {{-- Email / Phone (hidden on smaller screens) --}}
                            <td class="px-4 lg:px-6 py-3 hidden lg:table-cell">
                                <div class="flex flex-col gap-0.5">
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm text-slate-300 truncate max-w-[200px]">{{ $user->email }}</span>
                                        @if($user->ev)
                                            <i class="ph-fill ph-seal-check text-emerald-400 shrink-0" title="@lang('Email Verified')"></i>
                                        @else
                                            <i class="ph-fill ph-seal-warning text-amber-400 shrink-0" title="@lang('Email Unverified')"></i>
                                        @endif
                                    </div>
                                    @if($user->mobile)
                                        <div class="flex items-center gap-2">
                                            <span class="text-xs text-slate-500">{{ $user->mobile_number }}</span>
                                            @if($user->sv)
                                                <i class="ph-fill ph-seal-check text-emerald-400 text-xs shrink-0" title="@lang('Mobile Verified')"></i>
                                            @else
                                                <i class="ph-fill ph-seal-warning text-amber-400 text-xs shrink-0" title="@lang('Mobile Unverified')"></i>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </td>

                            {{-- Balance --}}
                            <td class="px-4 lg:px-6 py-3">
                                <span class="font-medium text-sm {{ $user->balance > 0 ? 'text-emerald-400' : 'text-slate-500' }}">
                                    {{ showAmount($user->balance) }}
                                </span>
                            </td>

                            {{-- Status --}}
                            <td class="px-4 lg:px-6 py-3">
                                <div class="flex flex-wrap items-center justify-center gap-1">
                                    @if($user->status)
                                        <x-admin.badge type="success" size="sm">@lang('Active')</x-admin.badge>
                                    @else
                                        <x-admin.badge type="danger" size="sm">@lang('Banned')</x-admin.badge>
                                    @endif

                                    @if($user->kv == \App\Constants\Status::KYC_VERIFIED)
                                        <x-admin.badge type="primary" size="sm">@lang('KYC')</x-admin.badge>
                                    @elseif($user->kv == \App\Constants\Status::KYC_PENDING)
                                        <x-admin.badge type="warning" size="sm">@lang('KYC Pending')</x-admin.badge>
                                    @endif
                                </div>
                            </td>

                            {{-- Joined (hidden on smaller screens) --}}
                            <td class="px-4 lg:px-6 py-3 hidden xl:table-cell">
                                <div class="flex flex-col">
                                    <span class="text-sm text-slate-300">{{ $user->created_at->format('M d, Y') }}</span>
                                    <span class="text-xs text-slate-500">{{ $user->created_at->diffForHumans() }}</span>
                                </div>
                            </td>

                            {{-- Actions --}}
                            <td class="px-4 lg:px-6 py-3 text-right">
                                <x-admin.action-menu>
                                    @if($user->username)
                                        <x-admin.action-menu-item href="{{ route('admin.users.detail', $user->username) }}" icon="ph-user">
                                            @lang('View Details')
                                        </x-admin.action-menu-item>
                                        <x-admin.action-menu-item href="{{ route('admin.users.edit', $user->username) }}" icon="ph-pencil">
                                            @lang('Edit Client')
                                        </x-admin.action-menu-item>
                                    @endif
                                    <x-admin.action-menu-item wire:click="loginAsUser({{ $user->id }})" icon="ph-sign-in">
                                        @lang('Login as Client')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    @if($user->status)
                                        <x-admin.action-menu-item wire:click="toggleStatus({{ $user->id }})" icon="ph-prohibit" :danger="true">
                                            @lang('Ban Client')
                                        </x-admin.action-menu-item>
                                    @else
                                        <x-admin.action-menu-item wire:click="toggleStatus({{ $user->id }})" icon="ph-check-circle">
                                            @lang('Activate Client')
                                        </x-admin.action-menu-item>
                                    @endif
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-users text-2xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-3 text-base font-medium text-white">@lang('No clients found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search)
                                            @lang('No clients match your search criteria.')
                                        @else
                                            @lang('Get started by adding your first client.')
                                        @endif
                                    </p>
                                    @if(!$search)
                                        <x-admin.button href="{{ route('admin.users.create') }}" icon="ph-user-plus" class="mt-3">
                                            @lang('Add Client')
                                        </x-admin.button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Mobile Card View --}}
        <div class="md:hidden divide-y divide-white/5">
            @forelse($users as $user)
                <div class="p-4 active:bg-white/5" wire:key="user-mobile-{{ $user->id }}">
                    <div class="flex items-start justify-between gap-3">
                        <div class="flex items-center gap-3 min-w-0 flex-1">
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 font-semibold text-indigo-400">
                                {{ strtoupper(substr($user->firstname ?? $user->username ?? 'U', 0, 1)) }}
                            </div>
                            <div class="min-w-0 flex-1">
                                @if($user->username)
                                    <a href="{{ route('admin.users.detail', $user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400 truncate block">
                                        {{ $user->fullname ?: $user->username }}
                                    </a>
                                    <p class="text-xs text-slate-500 truncate">{{ '@' . $user->username }}</p>
                                @else
                                    <span class="font-medium text-white truncate block">{{ $user->fullname ?: __('No Username') }}</span>
                                    <p class="text-xs text-amber-400">@lang('Username not set')</p>
                                @endif
                            </div>
                        </div>
                        <x-admin.action-menu>
                            @if($user->username)
                                <x-admin.action-menu-item href="{{ route('admin.users.detail', $user->username) }}" icon="ph-user">
                                    @lang('View Details')
                                </x-admin.action-menu-item>
                                <x-admin.action-menu-item href="{{ route('admin.users.edit', $user->username) }}" icon="ph-pencil">
                                    @lang('Edit Client')
                                </x-admin.action-menu-item>
                            @endif
                            <x-admin.action-menu-item wire:click="loginAsUser({{ $user->id }})" icon="ph-sign-in">
                                @lang('Login as Client')
                            </x-admin.action-menu-item>
                            <x-admin.action-menu-item :divider="true" />
                            @if($user->status)
                                <x-admin.action-menu-item wire:click="toggleStatus({{ $user->id }})" icon="ph-prohibit" :danger="true">
                                    @lang('Ban Client')
                                </x-admin.action-menu-item>
                            @else
                                <x-admin.action-menu-item wire:click="toggleStatus({{ $user->id }})" icon="ph-check-circle">
                                    @lang('Activate Client')
                                </x-admin.action-menu-item>
                            @endif
                        </x-admin.action-menu>
                    </div>

                    {{-- Mobile Details --}}
                    <div class="mt-3 grid grid-cols-2 gap-2 text-sm">
                        <div>
                            <p class="text-xs text-slate-500">@lang('Email')</p>
                            <div class="flex items-center gap-1.5 mt-0.5">
                                <span class="text-slate-300 truncate text-xs">{{ $user->email }}</span>
                                @if($user->ev)
                                    <i class="ph-fill ph-seal-check text-emerald-400 text-xs shrink-0"></i>
                                @else
                                    <i class="ph-fill ph-seal-warning text-amber-400 text-xs shrink-0"></i>
                                @endif
                            </div>
                        </div>
                        <div>
                            <p class="text-xs text-slate-500">@lang('Balance')</p>
                            <span class="font-medium text-sm {{ $user->balance > 0 ? 'text-emerald-400' : 'text-slate-400' }}">
                                {{ showAmount($user->balance) }}
                            </span>
                        </div>
                    </div>

                    {{-- Status & Date Row --}}
                    <div class="mt-3 flex items-center justify-between">
                        <div class="flex flex-wrap items-center gap-1">
                            @if($user->status)
                                <x-admin.badge type="success" size="sm">@lang('Active')</x-admin.badge>
                            @else
                                <x-admin.badge type="danger" size="sm">@lang('Banned')</x-admin.badge>
                            @endif
                            @if($user->kv == \App\Constants\Status::KYC_VERIFIED)
                                <x-admin.badge type="primary" size="sm">@lang('KYC')</x-admin.badge>
                            @elseif($user->kv == \App\Constants\Status::KYC_PENDING)
                                <x-admin.badge type="warning" size="sm">@lang('KYC')</x-admin.badge>
                            @endif
                        </div>
                        <span class="text-xs text-slate-500">{{ $user->created_at->diffForHumans() }}</span>
                    </div>
                </div>
            @empty
                <div class="px-4 py-12 text-center">
                    <div class="flex flex-col items-center">
                        <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                            <i class="ph-duotone ph-users text-2xl text-slate-500"></i>
                        </div>
                        <h3 class="mt-3 text-base font-medium text-white">@lang('No clients found')</h3>
                        <p class="mt-1 text-sm text-slate-500">
                            @if($search)
                                @lang('No clients match your search criteria.')
                            @else
                                @lang('Get started by adding your first client.')
                            @endif
                        </p>
                        @if(!$search)
                            <x-admin.button href="{{ route('admin.users.create') }}" icon="ph-user-plus" class="mt-3">
                                @lang('Add Client')
                            </x-admin.button>
                        @endif
                    </div>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        @if($users->hasPages())
            <div class="border-t border-white/5 px-4 sm:px-6 py-3 sm:py-4">
                {{ $users->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

