<div class="embedded-widget">
    @if($isLoading)
        {{-- Loading Skeleton --}}
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-6 animate-pulse">
            <div class="h-4 bg-gray-800 rounded w-1/3 mb-4"></div>
            <div class="space-y-3">
                <div class="h-3 bg-gray-800 rounded w-full"></div>
                <div class="h-3 bg-gray-800 rounded w-2/3"></div>
            </div>
        </div>
    @elseif($error)
        {{-- Error State --}}
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-6">
            <div class="flex items-center gap-3 text-gray-400">
                <i class="ph-duotone ph-warning-circle text-xl text-amber-400"></i>
                <span class="text-sm">{{ $error }}</span>
            </div>
            <button wire:click="refresh" class="mt-3 text-sm text-primary-400 hover:underline">
                Try again
            </button>
        </div>
    @elseif($widgetHtml)
        {{-- Widget Content --}}
        <div class="embedded-widget-content">
            {!! $widgetHtml !!}
        </div>
    @else
        {{-- Empty State --}}
        <div class="bg-gray-900 border border-gray-800 rounded-2xl p-6 text-center">
            <p class="text-gray-500 text-sm">Widget unavailable</p>
        </div>
    @endif
</div>

